unit uBitMask;

interface

uses    SysUtils, uUtilities, Math, uLog, uByteCache;

type    TBitMask = Class
                private
                        Cache : PByteArray;
                public
                        Breite, Hoehe : Word;
                        constructor Create;
                        destructor Free;
                        procedure Init32( BBreite, BHoehe : Word; Pixels : PByteArray ); overload;
                        procedure Init32( vByteCache : TByteCache ); overload;
                        procedure Init16( BBreite, BHoehe : Word; Pixels : PByteArray );
                        procedure InitEmpty( BBReite, BHoehe : Word );                        
                        procedure InitRadar( BBreite, BHoehe : Word; Pixels : PByteArray );
                        procedure AddBitMask( X, Y : Integer; BitMask : TBitMask );                        
                        function CheckPixel( X, Y : Integer ) : Boolean;
                end;

implementation

constructor TBitMask.Create;
begin
        Cache := nil;
        Breite := 0;
        Hoehe := 0;
end;

destructor TBitMask.Free;
begin
        if Cache <> nil then
                FreeMem( Cache );
end;

procedure TBitMask.Init32( BBreite, BHoehe : Word; Pixels : PByteArray );
var     X, Y, C : Integer;
        Pos : Integer;
        Count : Integer;
begin
        if Pixels = nil then
                exit;

        Breite := BBreite;
        Hoehe := BHoehe;

        Count := ( Breite*Hoehe + 7 ) div 8;
        GetMem( Cache, Count );
        for C := 0 to Count-1 do
                Cache^[ C ] := 0;

        Pos := 0;
        C := 0;
        for Y := 0 to Hoehe-1 do begin
                for X := 0 to Breite-1 do begin
                        if ( Pixels^[ (Y*GetNextBit( Breite ) + X)*4 + 3 ] <> 0 ) then begin
                                Cache^[ Pos ] := Cache^[ Pos ] + ( 1 shl C );
                        end;
                        if C = 7 then begin
                                Inc( Pos );
                                C := 0;
                        end
                        else
                                Inc( C );
                end;
        end;
end;

procedure TBitMask.Init32( vByteCache : TByteCache );
var     X, Y, C : Integer;
        Pos : Integer;
        Count : Integer;
begin
        Breite := vByteCache.RealWidth;
        Hoehe := vByteCache.RealHeight;

        Count := ( Breite*Hoehe + 7 ) div 8;
        GetMem( Cache, Count );
        for C := 0 to Count-1 do
                Cache^[ C ] := 0;

        Pos := 0;
        C := 0;
        for Y := 0 to Hoehe-1 do begin
                for X := 0 to Breite-1 do begin
                        if vByteCache.Pixels[ X, Y ].Alpha <> 0 then begin
                                Cache^[ Pos ] := Cache^[ Pos ] + ( 1 shl C );
                        end;
                        if C = 7 then begin
                                Inc( Pos );
                                C := 0;
                        end
                        else
                                Inc( C );
                end;
        end;
end;

procedure TBitMask.InitEmpty( BBReite, BHoehe : Word );
var     Count, C : Integer;
begin
        Breite := BBreite;
        Hoehe := BHoehe;

        Count := ( Breite*Hoehe + 7 ) div 8;
        GetMem( Cache, Count );
        for C := 0 to Count-1 do
                Cache^[ C ] := 0;
end;

procedure TBitMask.Init16( BBreite, BHoehe : Word; Pixels : PByteArray );
var     X, Y, C : Integer;
        Pos : Integer;
        Count : Integer;
begin
        exit;
        //da muss noch viel getan werden
        if Pixels = nil then
                exit;

        Breite := BBreite;
        Hoehe := BHoehe;

        Count := (Breite*Hoehe div 8) + 1;
        GetMem( Cache, Count );
        for C := 0 to Count-1 do
                Cache^[ C ] := 0;

        Pos := 0;
        C := 0;
        for Y := 0 to Hoehe-1 do begin
                for X := 0 to Breite-1 do begin
                        if ( Pixels^[ (Y*GetNextBit( Breite ) + X)*4 + 3 ] <> 0 ) then begin
                                Cache^[ Pos ] :=Cache^[ Pos ] + ( 1 shl C );
                        end;
                        if C = 7 then begin
                                Inc( Pos );
                                C := 0;
                        end
                        else
                                Inc( C );
                end;
        end;
end;

procedure TBitMask.InitRadar( BBreite, BHoehe : Word; Pixels : PByteArray );
var     X, Y, C : Integer;
        Pos : Integer;
        Count : Integer;
begin
        if Pixels = nil then
                exit;

        Breite := BBreite;
        Hoehe := BHoehe;

        Count := ( Breite*Hoehe + 7 ) div 8;
        GetMem( Cache, Count );
        for C := 0 to Count-1 do
                Cache^[ C ] := 0;

        Pos := 0;
        C := 0;
        for Y := 0 to Hoehe-1 do begin
                for X := 0 to Breite-1 do begin
                        if ( Pixels^[ (Y*Breite + X)*4 ] = 8 ) and ( Pixels^[ (Y*Breite + X)*4 + 1 ] = 8 ) and ( Pixels^[ (Y*Breite + X)*4 + 2 ] = 8 ) then begin
                                Cache^[ Pos ] := Cache^[ Pos ] + ( 1 shl C );
                        end;
                        if C = 7 then begin
                                Inc( Pos );
                                C := 0;
                        end
                        else
                                Inc( C );
                end;
        end;
end;

procedure TBitMask.AddBitMask( X, Y : Integer; BitMask : TBitMask );
var     PX, PY : Integer;
        MinX, MinY, MaxX, MaxY : Integer;
        Pos, PosByte : Integer;
        PosBit : Byte;
begin
        if (Cache = nil) or (BitMask = nil) or (BitMask.Cache = nil) then
                exit;

        MinX := Max( X, 0 );
        MinY := Max( Y, 0 );
        MaxX := Min( X + BitMask.Breite, Breite );
        MaxY := Min( Y + BitMask.Hoehe, Hoehe );

        for PX := MinX to MaxX do begin
                for PY := MinY to MaxY do begin
                        if BitMask.CheckPixel( PX - X, PY - Y ) then begin
                                Pos := PY*Breite + PX;
                                PosByte := Pos div 8;
                                PosBit := Pos mod 8;
                                Cache^[PosByte] := Cache^[PosByte] or (1 shl PosBit);
                        end;
                end;
        end;
end;

function TBitMask.CheckPixel( X, Y : Integer ) : Boolean;
var     Pos, PosByte : Integer;
        PosBit : Byte;
begin
        try
                if Cache = nil then begin
                        Result := False;
                        exit;
                end;

                if ( X < 0 ) or ( X >= Breite ) or ( Y < 0 ) or ( Y >= Hoehe ) then begin
                        Result := False;
                        exit;
                end;

                Pos := Y*Breite + X;
                PosByte := Pos div 8;
                PosBit := Pos mod 8;

                Result := ( (Cache^[ PosByte ] and ( 1 shl PosBit )) = ( 1 shl PosBit ) );
        except
                Log.Write( Format( 'Error in TBitmask.CheckPixel( %d %d )', [X,Y] ) );
                Result := False;
        end;
end;

end.
