unit uChar;

interface

uses    uUObject, uBasicTypedefs, uRecievePackets, Windows, uMovement, uPos,
        Dialogs, uItem, SysUtils, Math, uLoaderAnimations, uLoaderTiledata,
        uRenderer, Classes, uSecretUtility, uUtilities, uCounter, uTimer,
        uSendPackets, uLightManager, uPixelBuffer, dglOpenGL;

type    TChar = Class( TUObject )
                public
                        CustomMovingSpeed : Word;
                        CustomRunningSpeed : Word;
                        EnableCustomSpeed : Boolean;
                        Hitpoints, Stamina, Mana : Word;
                        MaxHitpoints, MaxStamina, MaxMana : Word;
                        SayColor, EmoteColor : Word;
                        Title : String;
                        Name : String;
                        Hidden, WarMode, Poisoned, StatusVisible : Boolean;
                        StatusPos : TPoint;
                        Walking, Running : Boolean;
                        ChairDirection : Byte;
                        PixelBuffer : TPixelBuffer;

                        AnimZoomX, AnimZoomY : Real;
                        AnimFrame : Integer;
                        AnimFrames : Word;
                        AnimNextTime : Integer;
                        AnimRepeatCount : Integer;
                        AnimReverse : Boolean;
                        AnimSpeed : Integer;
                        AnimStartFrame : Integer;
                        AnimId : Word;
                        AnimDeltaX, AnimDeltaY, AnimDeltaZ : Integer;
                        AnimMoveX, AnimMoveY, AnimMoveZ : Integer;
                        MovingStep : Byte;
                        EffPos : TPos;
                        SmoothWalking : Boolean;
                        Transparency : Byte;
                        WalkingResetTimer : LongWord;
                        WalkingStartTime, WalkingDoneTime : LongWord;
                        procedure UpdateTexture; override;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        function IsChar : Boolean; override;
                        function IsVisible : Boolean; override;
                        procedure ApplyFlag( Flag : Byte );
                        procedure Update( Packet : UpdatePlayer );
                        procedure DrawChar( Packet : DrawObject );
                        procedure DoAnimation( Packet : DoCharAnimation );
                        procedure ResetAnim;
                        function GetMoveAnim( Run : Boolean = False ) : Word;
                        procedure CalculateAnimMove( Run : Boolean = False );
                        function IsArmed : Boolean;
                        function OnMount : Boolean;

                        function GetAnim : Word;
                        function GetAnimId : Word;
                        function GetMountAnim( MountAnimId : Word ) : Word;
                        function PollAnim( Frames : Byte ) : Boolean; virtual;
                        function MoveTo( NewPos : TPos ) : Boolean; overload;
                        function MoveTo( X, Y : Word; Z : ShortInt ) : Boolean; overload; virtual;
                        procedure AddItem( Item : TItem );
                        procedure RemoveObjectFromCont( UObject : TUObject ); override;
                        function GetItemOnLayer( Layer : Byte ) : TItem;
                        procedure RequestPaperdoll; virtual;
                        
                        function GetMovingSpeed : Word;
                        function GetRunningSpeed : Word;
                        function GetMountMovingSpeed : Word;
                        function GetMountRunningSpeed : Word;
        end;

        P_Char = ^TChar;

        TCharDrawObject = Class
                public
                        PosX, PosY, ZPosX, ZPosY : Integer;
                        Texture : TAnimObject;
                        constructor Create( X, Y, ZX, ZY : Integer; Tex : TAnimObject );
                        destructor Free;
        end;

implementation

uses    uPlayer, uPalanthir;

procedure TChar.UpdateTexture;
begin
end;

constructor TChar.Create;
begin
        inherited Create;
        Typ := typ_char;
        Walking := False;
        Palanthir.AddChar( Self );
        AnimZoomX := 1;
        AnimZoomY := 1;
        EffPos := TPos.Create;
        ResetAnim;
        SmoothWalking := False;
        StatusVisible := False;
        StatusPos.X := 0;
        StatusPos.Y := 0;
        Name := '';
        EnableCustomSpeed := False;
        Transparency := 255;
        PixelBuffer := nil;

        Counter.IncCount( Count_Char );
end;

destructor TChar.Free;
begin
        if PixelBuffer <> nil then
                PixelBuffer.Destroy;

        Counter.DecCount( Count_Char );

        Palanthir.RemoveChar( Self );
        inherited Free;
end;

procedure TChar.Draw;
var     CharAnimTexture, MountTexture, ItemAnimTexture : TAnimObject;
        Gespiegelt : Boolean;
        TmpAnimID, AnimTexId, MountAnimID, CharAnimHoehe, CharAnimBreite : Word;
        OPosX, OPosY, CPosX, CPosY, PosX, PosY, ZPosX, ZPosY : Integer;
        I, J : Integer;
        MountItem, Item : TItem;
        ItemList : TList;
        Sitting, Equipment, Chicken : Boolean;
        TmpDirection : Byte;
        DrawObjects : TList;
        CharDrawObject : TCharDrawObject;
        ZoomX, ZoomY : Real;
        PWidth, PHeight, OWidth, OHeight : Integer;
        PXMin, PXMax, PYMin, PYMax : Integer;
begin
        if Palanthir.DebugMode and HasFlag( Flag_Debug ) then
                exit;

        if ( Pos.Z >= Palanthir.RoofHeight ) and ( Self <> Palanthir.Player ) then
                exit;

        if Palanthir.IsUnderMap then begin
                if Palanthir.UnderMapOsiMode and ( Pos.Z >= Palanthir.Player.Pos.Z+15 ) then begin
                        exit;
                end
                else if (not Palanthir.UnderMapOsiMode) and (Pos.Z+1 >= Palanthir.Data.GetMapHeight( Pos.X, Pos.Y )) then begin
                        exit;
                end;
        end;

        Timer.Continue( Timer_AllChars );
        Timer.Start( Timer_Chars );

        DrawObjects := TList.Create;

        Chicken := HasFlag( Flag_Chicken ) or Palanthir.TurnAllToChicken;
        if Chicken then begin
                ZoomX := 1;
                ZoomY := 1;
        end else begin
                ZoomX := AnimZoomX;
                ZoomY := AnimZoomY;
        end;

        Sitting := False;
        MountItem := GetItemOnLayer( Layer_Mount );

        if (not Walking) and (MountItem = nil) and (Palanthir.Shard.AnimDefs[ Id ].AnimTyp = aPeople) and (not Chicken) then begin
                ItemList := Palanthir.Data.WorldCache.GetStaticObjects( Pos.X, Pos.Y );
                for I := 0 to ItemList.Count-1 do
                        if (TStaticItem( ItemList.Items[ I ] ).Pos.Z >= Pos.Z-2) and
                           (TStaticItem( ItemList.Items[ I ] ).Pos.Z <= Pos.Z+2) and
                           (Palanthir.Shard.StuhlListe[ TStaticItem( ItemList.Items[ I ] ).ID ].Chair ) then begin
                                ChairDirection := Palanthir.Shard.GetChairDirection( TStaticItem( ItemList.Items[ I ] ).ID, ChairDirection );
                                Sitting := True;
                                break;
                        end;
                ItemList.Free;

                if not Sitting then begin
                        ItemList := Palanthir.Data.WorldCache.GetItems( Pos.X, Pos.Y );
                        for I := 0 to ItemList.Count-1 do
                                if (TItem( ItemList.Items[ I ] ).Pos.Z >= Pos.Z-2) and
                                   (TItem( ItemList.Items[ I ] ).Pos.Z <= Pos.Z+2) and
                                   (Palanthir.Shard.StuhlListe[ TItem( ItemList.Items[ I ] ).ID ].Chair ) then begin
                                        ChairDirection := Palanthir.Shard.GetChairDirection( TItem( ItemList.Items[ I ] ).ID, ChairDirection );
                                        Sitting := True;
                                        break;
                                end;
                        ItemList.Free;
                end;
        end;

        if Sitting then
                TmpDirection := ChairDirection and $F
        else
                TmpDirection := Direction and $F;

        if TmpDirection < 3 then begin
                Gespiegelt := True;
                TmpAnimId := 3 - TmpDirection;
        end
        else begin
                Gespiegelt := False;
                TmpAnimId := TmpDirection - 3;
        end;

        if Sitting then begin
                Case TmpDirection of
                        6, 0 : begin
                                CharAnimTexture := Palanthir.Data.GetAnimTexture( GetAnimId, 25*5 + TmpAnimId, Color, 0, Hidden );
                        end;
                        2, 4 : begin
                                CharAnimTexture := Palanthir.Data.GetAnimSitDownFrameObject( GetAnimId, Color, Hidden );
                        end;
                else
                        CharAnimTexture := nil;
                end;

                if CharAnimTexture = nil then begin
                        ResetAnim;
                        exit;
                end;
        end
        else begin
                if Chicken then
                        CharAnimTexture := Palanthir.Data.GetAnimTexture( $D0, AnimId*5 + TmpAnimId, 0, AnimFrame, Hidden )
                else
                        CharAnimTexture := Palanthir.Data.GetAnimTexture( GetAnimId, AnimId*5 + TmpAnimId, Color, AnimFrame, Hidden );
                if CharAnimTexture = nil then begin
                        ResetAnim;
                        exit;
                end;        
        end;
        CharAnimHoehe := CharAnimTexture.Hoehe;
        CharAnimBreite := CharAnimTexture.Breite;


        OPosX := Palanthir.RelDrawX + (Pos.X - Pos.Y) * 22 + AnimMoveX;
        OPosY := Palanthir.RelDrawY + (Pos.X + Pos.Y) * 22 - Pos.Z*4 +22 + AnimMoveY - AnimMoveZ*4;

        if Sitting then begin
                Case TmpDirection of
                        6, 0 : begin
                                OPosX := OPosX + 4;
                                OPosY := OPosY + 35;
                        end;
                        2, 4 : begin
                                OPosX := OPosX;
                                OPosY := OPosY + 16;
                        end;
                end;
        end;

        if not Gespiegelt then begin
                CPosX := OPosX - CharAnimTexture.CenterX;
                CPosY := OPosY - CharAnimTexture.CenterY - CharAnimTexture.Hoehe;
        end
        else begin
                CPosX := OPosX - CharAnimTexture.Breite + CharAnimTexture.CenterX;
                CPosY := OPosY - CharAnimTexture.CenterY - CharAnimTexture.Hoehe;
        end;

        if (MountItem <> nil) and (not Chicken) then begin
                MountAnimID := Palanthir.Shard.GetMountAnimId( MountItem.ID );
                MountTexture := Palanthir.Data.GetAnimTexture( MountAnimID, GetMountAnim( MountAnimID )*5 + TmpAnimId, MountItem.Color, AnimFrame, Hidden );
                if MountTexture <> nil then begin
                        if not Gespiegelt then begin
                                PosX := OPosX - MountTexture.CenterX;
                                PosY := OPosY - MountTexture.CenterY - MountTexture.Hoehe;
                        end else begin
                                PosX := OPosX - MountTexture.Breite + MountTexture.CenterX;
                                PosY := OPosY - MountTexture.CenterY - MountTexture.Hoehe;
                        end;
                        ZPosY := PosY + Round( ( 1 - ZoomY )*( CPosY + CharAnimHoehe - PosY - MountTexture.Hoehe ) );
                        ZPosX := PosX + Round( ( 1 - ZoomX )*( CPosX - PosX ) / 2 );

                        //Renderer.DrawPixelsZoom( PosX, PosY, MountTexture, Gespiegelt, ZoomX, ZoomY );
                        //Palanthir.Maus.CheckObject( PosX, PosY, Self, MountTexture, ZoomX, ZoomY );
                        DrawObjects.Add( TCharDrawObject.Create( PosX, PosY, ZPosX, ZPosY, MountTexture ) );
                end;
        end;

        DrawObjects.Add( TCharDrawObject.Create( CPosX, CPosY, CPosX, CPosY, CharAnimTexture ) );
        //Renderer.DrawPixelsZoom( CPosX, CPosY, CharAnimTexture, Gespiegelt, ZoomX, ZoomY );
        //Palanthir.Maus.CheckObject( CPosX, CPosY, Self, CharAnimTexture, ZoomX, ZoomY );

        if Speech <> nil then begin
                Speech.Visible := True;
                Speech.Y := CPosY + Round( CharAnimTexture.Hoehe*( 1 - ZoomY ) );
                Speech.X := CPosX + Round( CharAnimTexture.Breite*ZoomX / 2 );
        end;

        if Chicken then
                Equipment := False
        else if (Id = $190) and Palanthir.SU.GetFlag( Flag_NakedMan ) then
                Equipment := False
        else if (Id = $191) and Palanthir.SU.GetFlag( Flag_NakedWoman ) then
                Equipment := False
        else
                Equipment := True;

        SortContainer;
        if (Id = $190) or (Id = $191) or (Palanthir.EnabledME and (Id >= $24A) and (Id <= $257)) then begin
                for J := 0 to Content.Count-1 do begin
                        Item := TItem( Content.Items[ J ] );
                        if (not Chicken) and (Item.Layer > 0) and (Item.Layer < 25) and (Item.Layer <> 21) and ((Item.Layer = Layer_Hair) or (Item.Layer = Layer_FacialHair) or Equipment) then begin
                                AnimTexId := Palanthir.Data.Tiledata.GetStaticAnimId( Item.ID );
                                if Sitting then begin
                                        Case TmpDirection of
                                                6, 0 : begin
                                                        if Palanthir.Data.Tiledata.GetStaticFlag( Item.ID, dPARTIALHUE ) then
                                                                ItemAnimTexture := Palanthir.Data.GetAnimTexture( AnimTexId, 25*5 + TmpAnimId, Item.Color + $8000, 0, Hidden )
                                                        else
                                                                ItemAnimTexture := Palanthir.Data.GetAnimTexture( AnimTexId, 25*5 + TmpAnimId, Item.Color, 0, Hidden );
                                                end;
                                                2, 4 : begin
                                                        if Palanthir.Data.Tiledata.GetStaticFlag( Item.ID, dPARTIALHUE ) then
                                                                ItemAnimTexture := Palanthir.Data.GetAnimSitDownFrameObject( AnimTexId, Item.Color + $8000, Hidden )
                                                        else
                                                                ItemAnimTexture := Palanthir.Data.GetAnimSitDownFrameObject( AnimTexId, Item.Color, Hidden );
                                                end;
                                        else
                                                ItemAnimTexture := nil;
                                        end;
                                end
                                else begin
                                        if Palanthir.Data.Tiledata.GetStaticFlag( Item.ID, dPARTIALHUE ) then
                                                ItemAnimTexture := Palanthir.Data.GetAnimTexture( AnimTexId, AnimId*5 + TmpAnimId, Item.Color + $8000, AnimFrame, Hidden )
                                        else
                                                ItemAnimTexture := Palanthir.Data.GetAnimTexture( AnimTexId, AnimId*5 + TmpAnimId, Item.Color, AnimFrame, Hidden );
                                end;

                                if ItemAnimtexture <> nil then begin
                                        if not Gespiegelt then begin
                                                PosX := OPosX - ItemAnimTexture.CenterX;
                                                PosY := OPosY - ItemAnimTexture.CenterY - ItemAnimTexture.Hoehe;
                                        end
                                        else begin
                                                PosX := OPosX - ItemAnimTexture.Breite + ItemAnimTexture.CenterX;
                                                PosY := OPosY - ItemAnimTexture.CenterY - ItemAnimTexture.Hoehe;
                                        end;
                                        ZPosY := PosY + Round( ( 1 - ZoomY )*( CPosY + CharAnimHoehe - PosY - ItemAnimTexture.Hoehe ) );
                                        ZPosX := PosX + Round( ( 1 - ZoomX )*( CPosX + CharAnimBreite div 2 - PosX - ItemAnimTexture.Breite div 2) );
                                        DrawObjects.Add( TCharDrawObject.Create( PosX, PosY, ZPosX, ZPosY, ItemAnimTexture ) );
                                        //Renderer.DrawPixelsZoom( PosX, PosY, ItemAnimTexture, Gespiegelt, ZoomX, ZoomY );
                                        //Palanthir.Maus.CheckObject( PosX, PosY, Self, ItemAnimTexture, ZoomX, ZoomY );

                                        if Palanthir.Data.Tiledata.GetStaticFlag( Item.ID, dLIGHTSOURCE ) and Palanthir.LightManager.Enabled then begin
                                                PosX := PosX + ( ItemAnimTexture.Breite div 2 ) - Palanthir.GameWindow.X;
                                                PosY := PosY + ( ItemAnimTexture.Hoehe div 2 ) - Palanthir.GameWindow.Y;

                                                if Item.Light = nil then begin
                                                        Item.Light := TLight.Create( PosX, PosY, Palanthir.Data.Tiledata.GetStaticQuality( Item.Id ), Item.LightColor );
                                                        Item.Light.UODrawObject := Item;
                                                        Palanthir.LightManager.AddLight( Item.Light );
                                                end
                                                else begin
                                                        Item.Light.PosX := PosX;
                                                        Item.Light.PosY := PosY;
                                                        Item.Light.Id := Palanthir.Data.Tiledata.GetStaticQuality( Item.Id );
                                                        Item.Light.Color := Item.LightColor;
                                                end;
                                        end;
                                end;
                        end;
                end;
        end;

        if Transparency = 255 then begin
                for I := 0 to DrawObjects.Count-1 do begin
                        CharDrawObject := TCharDrawObject( DrawObjects.Items[ I ] );
                        Renderer.DrawPixelsZoom( CharDrawObject.ZPosX, CharDrawObject.ZPosY, CharDrawObject.Texture, Gespiegelt, ZoomX, ZoomY );
                        Palanthir.Maus.CheckObject( CharDrawObject.ZPosX, CharDrawObject.ZPosY, Self, CharDrawObject.Texture, ZoomX, ZoomY );
                end;
        end else begin
                PXMin := High( Integer );
                PXMax := Low( Integer );
                PYMin := High( Integer );
                PYMax := Low( Integer );

                for I := 0 to DrawObjects.Count-1 do begin
                        CharDrawObject := TCharDrawObject( DrawObjects.Items[ I ] );
                        if CharDrawObject.PosX < PXMin then
                                PXMin := CharDrawObject.PosX;
                        if CharDrawObject.PosX + CharDrawObject.Texture.Breite > PXMax then
                                PXMax := CharDrawObject.PosX + CharDrawObject.Texture.Breite;
                        if CharDrawObject.PosY < PYMin then
                                PYMin := CharDrawObject.PosY;
                        if CharDrawObject.PosY + CharDrawObject.Texture.Hoehe > PYMax then
                                PYMax := CharDrawObject.PosY + CharDrawObject.Texture.Hoehe;
                end;

                OWidth := PXMax - PXMin;
                OHeight := PYMax - PYMin;
                PWidth := GetNextBit( OWidth );
                PHeight := GetNextBit( OHeight );
                PXMax := PXMax - 1;
                PYMax := PYMax - 1;

                if (PixelBuffer <> nil) and ((PixelBuffer.Width < PWidth) or (PixelBuffer.Height < PHeight)) then begin
                        PixelBuffer.Destroy;
                        PixelBuffer := nil;
                end;

                if PixelBuffer = nil then begin
                        PixelBuffer := TPixelBuffer.Create( PWidth, PHeight, Renderer.DC, Renderer.RC, nil );
                        if PixelBuffer.Init then begin
                                wglShareLists( Renderer.RC, PixelBuffer.RC );
                        end else begin
                                PixelBuffer.Destroy;
                                PixelBuffer := nil;
                                Transparency := 255;
                        end;
                end;

                if PixelBuffer <> nil then begin
                        PixelBuffer.Enable;

                        glEnable( GL_TEXTURE_2D );

                        glMatrixMode( GL_PROJECTION );
                        glLoadIdentity;
                        glViewPort( 0, 0, PixelBuffer.Width, PixelBuffer.Height );

                        glMatrixMode( GL_MODELVIEW );
                        glLoadIdentity;
                        glOrtho( 0, PixelBuffer.Width, 0, PixelBuffer.Height, -1, 1 );

                        glClearColor( 0, 0, 0, 0 );
                        glClear( GL_COLOR_BUFFER_BIT or GL_STENCIL_BUFFER_BIT );

                        glEnable( GL_ALPHA_TEST );
                        glAlphaFunc( GL_GREATER, 0.1 );

                        glColor3f( 1, 1, 1 );

                        for I := 0 to DrawObjects.Count-1 do begin
                                CharDrawObject := TCharDrawObject( DrawObjects.Items[ I ] );
                                Renderer.DrawPixelsZoom( CharDrawObject.PosX-PXMin, CharDrawObject.PosY-PYMin, CharDrawObject.Texture, Gespiegelt );
                                Palanthir.Maus.CheckObject( CharDrawObject.ZPosX, CharDrawObject.ZPosY, Self, CharDrawObject.Texture, ZoomX, ZoomY );
                        end;

                        PixelBuffer.Disable;

                        PixelBuffer.Bind;

                        glEnable( GL_BLEND );
                        glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
                        glColor4f( 1, 1, 1, Transparency/255 );

                        if ZoomX <> 1 then begin
                                PXMin := PXMin + Round( PWidth * ( 1 - ZoomX ) / 2 );
                                PXMax := PXMax - Round( PWidth * ( 1 - ZoomX ) / 2 );
                        end;
                        if ZoomY <> 1 then begin
                                PYMin := PYMin + Round( PHeight * ( 1 - ZoomY ) );
                        end;

                        glBegin( gl_Quads );
                                glTexCoord2f( 0, 0 );
                                glVertex2f( PXMin, PYMin );
                                glTexCoord2f( 0, OHeight / PixelBuffer.Height );
                                glVertex2f( PXMin, PYMax );
                                glTexCoord2f( OWidth / PixelBuffer.Width, OHeight / PixelBuffer.Height );
                                glVertex2f( PXMax, PYMax );
                                glTexCoord2f( OWidth / PixelBuffer.Width, 0 );
                                glVertex2f( PXMax, PYMin );
                        glEnd;

                        glDisable( GL_BLEND );
                        
                        PixelBuffer.Release;
                end;
        end;

        for I := 0 to DrawObjects.Count-1 do begin
                TCharDrawObject( DrawObjects.Items[ I ] ).Free;
        end;
        DrawObjects.Free;        

        Timer.Stop( Timer_Chars );
        Timer.Pause( Timer_AllChars );
end;

function TChar.IsChar : Boolean;
begin
        Result := True;
end;

function TChar.IsVisible : Boolean;
begin
        Result := True;
end;

procedure TChar.ApplyFlag( Flag : Byte );
begin
        if ( Flag and $4 ) = $4 then
                Poisoned := True
        else
                Poisoned := False;
        if ( Flag and $40 ) = $40 then
                WarMode := True
        else
                WarMode := False;
        if ( Flag and $80 ) = $80 then
                Hidden := True
        else
                Hidden := False;
end;

procedure TChar.Update( Packet : UpdatePlayer );
var     DX, DY : Integer;
        OldDirection : Byte;
        OldPos : TPos;
        OldWarMode : Boolean;
        PacketDir : Byte;
begin
        ID := Packet.GetId;
        OldDirection := Direction;
        Direction := Packet.GetDirection mod 8;
        ChairDirection := Packet.GetDirection mod 8;
        Color := Packet.GetColor;
        OldWarMode := WarMode;        
        ApplyFlag( Packet.GetFlag );

        LastUpdated := CustomGetTickCount;

        if Palanthir.Player = Self then begin
                //Sometimes RunUO seems to send this packet also for the Playerchar
                Palanthir.Movement.Stop;
                Palanthir.Movement.MoveSequence := 0;
                Palanthir.Movement.ClearCache;
                Palanthir.Movement.SendCacheCount := 0;
                ResetAnim;
                if (Packet.getX <> Pos.X) or (Packet.getY <> Pos.Y) or (Packet.getZ <> Pos.Z) then begin
                        MoveTo( Packet.getX, Packet.getY, Packet.getZ );
                        Palanthir.Player.ResendWorld;
                end;
                Packet.Free;
                Exit;
        end;

        if OldWarMode <> WarMode then
                ResetAnim;

        DX := Pos.X - Packet.getX;
        DY := Pos.Y - Packet.getY;

        if (Abs( DX ) < 2) and (Abs( DY ) < 2) then begin
                if (DX <> 0) or (DY <> 0) then begin
                        if OldDirection <> Direction then begin
                                MoveTo( Packet.getX, Packet.getY, Packet.getZ );
                                ResetAnim;
                        end
                        else begin
                                OldPos := TPos.Create;
                                OldPos.SetPos( Pos );
                                EffPos.SetPos( Pos );
                                Case Direction of
                                        0 : begin
                                                AnimDeltaX := -22;
                                                AnimDeltaY := +22;
                                                end;
                                        1 : begin
                                                AnimDeltaX := -44;
                                                AnimDeltaY := 0;
                                                end;
                                        2 : begin
                                                AnimDeltaX := -22;
                                                AnimDeltaY := -22;
                                                end;
                                        3 : begin
                                                AnimDeltaX := 0;
                                                AnimDeltaY := -44;
                                                end;
                                        4 : begin
                                                AnimDeltaX := +22;
                                                AnimDeltaY := -22;
                                                end;
                                       5 : begin
                                                AnimDeltaX := +44;
                                                AnimDeltaY := 0;
                                                end;
                                        6 : begin
                                                AnimDeltaX := +22;
                                                AnimDeltaY := +22;
                                                end;
                                        7 : begin
                                                AnimDeltaX := 0;
                                                AnimDeltaY := +44;
                                                end;
                                end;
                                AnimDeltaZ := Pos.Z - ShortInt( Packet.GetZ );

                                MoveTo( Packet.getX, Packet.getY, Packet.getZ );
                                if Direction in [ 0, 6, 7 ] then
                                        EffPos.SetPos( OldPos );
                                OldPos.Free;

                                PacketDir := Packet.GetDirection;
                                Running := PacketDir > 128;

                                if not Walking then begin
                                        if (WalkingResetTimer = 0) or (GetMoveAnim( Running ) <> AnimId) then begin
                                                AnimFrame := 0;
                                                AnimId := GetMoveAnim( Running );
                                        end;

                                        AnimReverse := False;
                                        Walking := True;
                                        MovingStep := 1;

                                        if OnMount then begin
                                                if Running then
                                                        AnimNextTime := CustomGetTickCount + GetMountRunningSpeed div MountRunningStepsPerField
                                                else
                                                        AnimNextTime := CustomGetTickCount + GetMountMovingSpeed div MountMovingStepsPerField;
                                        end
                                        else begin
                                                if Running then
                                                        AnimNextTime := CustomGetTickCount + GetRunningSpeed div RunningStepsPerField
                                                else
                                                        AnimNextTime := CustomGetTickCount + GetMovingSpeed div MovingStepsPerField;
                                        end;
                                end
                                else begin
                                        MovingStep := 0;
                                        AnimNextTime := CustomGetTickCount;
                                end;

                                WalkingStartTime := CustomGetTickCount;
                                if OnMount then begin
                                        if Running then
                                                WalkingDoneTime := CustomGetTickCount + GetMountRunningSpeed
                                        else
                                        WalkingDoneTime := CustomGetTickCount + GetMountMovingSpeed;
                                end
                                else begin
                                        if Running then
                                                WalkingDoneTime := CustomGetTickCount + GetRunningSpeed
                                        else
                                                WalkingDoneTime := CustomGetTickCount + GetMovingSpeed;
                                end;

                                CalculateAnimMove( Running );
                        end;
                end;
        end
        else begin
                MoveTo( Packet.getX, Packet.getY, Packet.getZ );
        end;
end;

procedure TChar.DrawChar( Packet : DrawObject );
var     Item : TItem;
        Serial : LongWord;
        Model : Word;
        K : Word;
        ItemId : Word;
begin
        ID := Packet.getModel;
        Direction := Packet.getDirection mod 8;
        ChairDirection := Packet.getDirection mod 8;
        Color := Packet.getColor;
        ApplyFlag( Packet.getFlag );

        ResetAnim;

        if Palanthir.Player = Self then begin
                if MoveTo( Packet.getX, Packet.getY, Packet.getZ ) then begin
                        Palanthir.Player.ResendWorld( False );
                end else begin
                        Palanthir.Player.ResendWorld( True );
                end;
        end else begin
                MoveTo( Packet.getX, Packet.getY, Packet.getZ );
        end;

        K := 19;
        Serial := Packet.GetLongWord( K ) and $7FFFFFFF;
        while Serial <> 0 do begin
                Inc( K, 4 );
                Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( Serial ) );
                if Item = nil then begin
                        Item := TItem.Create;
                        Item.Serial := Serial;
                end;
                Model := Packet.GetWord( K );
                ItemId := Model mod $8000;
                Inc( K, 2 );
                Item.Layer := Packet.GetByte( K );
                Inc( K );
                if ( Model and $8000 ) = $8000 then begin
                        Item.Color := Packet.GetWord( K );
                        Inc( K, 2 );
                end;

                if Item.Container <> nil then
                        Item.RemoveFromCont;

                if Item.Registered then
                        Item.UnRegisterObject;

                Item.Container := Self;
                Item.ID := ItemId;

                Item.RegisterObject;

                AddItem( Item );                

                Serial := Packet.GetLongWord( K ) and $7FFFFFFF;
        end;

        LastUpdated := CustomGetTickCount;
end;

procedure TChar.DoAnimation( Packet : DoCharAnimation );
begin
        AnimId := Packet.GetAnimationID;
        if Packet.GetRepeatFlag > 0 then
                AnimRepeatCount := Packet.GetRepeat
        else
                AnimRepeatCount := 1;
        AnimReverse := ( Packet.GetBackward > 0 );
        if AnimReverse then
                AnimFrame := Packet.GetStartFrame
        else
                AnimFrame := 0;
        AnimSpeed := Packet.GetFrameDelay;
        AnimNextTime := CustomGetTickCount + 100 + AnimSpeed*50;

        AnimDeltaX := 0;
        AnimDeltaY := 0;
        AnimDeltaZ := 0;
end;

procedure TChar.ResetAnim;
begin
        AnimId := GetAnim;
        WalkingResetTimer := 0;
        AnimNextTime := -1;
        AnimFrame := 0;
        AnimDeltaX := 0;
        AnimDeltaY := 0;
        AnimDeltaZ := 0;
        AnimMoveX := 0;
        AnimMoveY := 0;
        AnimMoveZ := 0;
        EffPos.SetPos( Pos );
        Palanthir.WorldListSorted := False;
end;

function TChar.GetMoveAnim( Run : Boolean ) : Word;
begin
        if Palanthir.Shard.GetAnimRecord( Id ).AnimTyp = aHighDetailed then begin
                Result := 0;
        end
        else if Palanthir.Shard.GetAnimRecord( Id ).AnimTyp = aLowDetailed then begin
                if Running then
                        Result := 1
                else
                        Result := 0
        end
        else begin
                if OnMount then begin
                        if Run then
                                Result := 24
                        else
                                Result := 23;
                end
                else begin
                        if WarMode then
                                Result := 15
                        else begin
                                if IsArmed then begin
                                        if Run then
                                                Result := 3
                                        else
                                                Result := 1;
                                end
                                else begin
                                        if Run then
                                                Result := 2
                                        else
                                                Result := 0;
                                end;
                        end;
                end;
        end;
end;

function TChar.GetMountAnim( MountAnimId : Word ) : Word;
begin
        if Palanthir.Shard.GetAnimRecord( MountAnimId ).AnimTyp = aHighDetailed then begin
                if Walking then
                        Result := 0
                else
                        Result := 1;
        end
        else if Palanthir.Shard.GetAnimRecord( MountAnimId ).AnimTyp = aLowDetailed then begin
                if Walking and Running then
                        Result := 1
                else if Walking then
                        Result := 0
                else
                        Result := 2;
        end
        else
                Result := AnimId;
end;

function TChar.IsArmed : Boolean;
begin
        Result := ( GetItemOnLayer( Layer_SingleHandedWeapon ) <> nil ) or ( GetItemOnLayer( Layer_DualHandedWeapon ) <> nil );
end;

function TChar.OnMount : Boolean;
begin
        Result := GetItemOnLayer( Layer_Mount ) <> nil;
end;

function TChar.GetAnim : Word;
begin
        if Palanthir.Shard.GetAnimRecord( Id ).AnimTyp = aHighDetailed then begin
                Result := 1;
        end
        else if Palanthir.Shard.GetAnimRecord( Id ).AnimTyp = aLowDetailed then begin
                Result := 2;
        end
        else begin
                if OnMount then begin
                        Result := 25
                end
                else begin
                        if WarMode then begin
                                if Self.GetItemOnLayer( 2 ) <> nil then
                                        Result := 8
                                else
                                        Result := 7;
                        end
                        else begin
                                Result := 4;
                        end;
                end;
        end;
end;

function TChar.GetAnimId : Word;
begin
        Case Id of
                $192: Result := $190;
                $193: Result := $191;
        else
                Result := Id;
        end;
end;

procedure TChar.CalculateAnimMove( Run : Boolean );
begin
        if OnMount then begin
                if Run then begin
                        AnimMoveX := Round( AnimDeltaX * ( 1 - MovingStep / MountRunningStepsPerField ) );
                        AnimMoveY := Round( AnimDeltaY * ( 1 - MovingStep / MountRunningStepsPerField ) );
                        AnimMoveZ := Round( AnimDeltaZ * ( 1 - MovingStep / MountRunningStepsPerField ) );
                end
                else begin
                        AnimMoveX := Round( AnimDeltaX * ( 1 - MovingStep / MountMovingStepsPerField ) );
                        AnimMoveY := Round( AnimDeltaY * ( 1 - MovingStep / MountMovingStepsPerField ) );
                        AnimMoveZ := Round( AnimDeltaZ * ( 1 - MovingStep / MountMovingStepsPerField ) );
                end;
        end
        else begin
                if Run then begin
                        AnimMoveX := Round( AnimDeltaX * ( 1 - MovingStep / RunningStepsPerField ) );
                        AnimMoveY := Round( AnimDeltaY * ( 1 - MovingStep / RunningStepsPerField ) );
                        AnimMoveZ := Round( AnimDeltaZ * ( 1 - MovingStep / RunningStepsPerField ) );
                end
                else begin
                        AnimMoveX := Round( AnimDeltaX * ( 1 - MovingStep / MovingStepsPerField ) );
                        AnimMoveY := Round( AnimDeltaY * ( 1 - MovingStep / MovingStepsPerField ) );
                        AnimMoveZ := Round( AnimDeltaZ * ( 1 - MovingStep / MovingStepsPerField ) );
                end;
        end;
end;

function TChar.PollAnim( Frames : Byte ) : Boolean;
var     MaxStepsPerField : Byte;
begin
        if AnimNextTime <> -1 then
                if CustomGetTickCount > AnimNextTime then begin
                        if Walking then begin
                                if OnMount then begin
                                        if Running then
                                                MaxStepsPerField := MountRunningStepsPerField
                                        else
                                                MaxStepsPerField := MountMovingStepsPerField;
                                end
                                else begin
                                        if Running then
                                                MaxStepsPerField := RunningStepsPerField
                                        else
                                                MaxStepsPerField := MovingStepsPerField;
                                end;
                                if MovingStep < MaxStepsPerField then begin
                                        if MovingStep = 0 then begin
                                                AnimId := GetMoveAnim( Running );
                                        end;

                                        Inc( MovingStep );
                                        if AnimFrame < Frames-1 then
                                                Inc( AnimFrame )
                                        else
                                                AnimFrame := 0;

                                        while CustomGetTickCount > AnimNextTime do begin
                                                if OnMount then begin
                                                        if Running then
                                                                AnimNextTime := AnimNextTime + GetMountRunningSpeed div MountRunningStepsPerField
                                                        else
                                                                AnimNextTime := AnimNextTime + GetMountMovingSpeed div MountMovingStepsPerField;
                                                end
                                                else begin
                                                        if Running then
                                                                AnimNextTime := AnimNextTime + GetRunningSpeed div RunningStepsPerField
                                                        else
                                                                AnimNextTime := AnimNextTime + GetMovingSpeed div MovingStepsPerField;
                                                end;
                                        end;
                                        CalculateAnimMove( Running );
                                end
                                else begin
                                        WalkingResetTimer := CustomGetTickCount;
                                        AnimNextTime := -1;
                                        Walking := False;
                                end;
                        end
                        else begin
                                if not AnimReverse then begin
                                        if AnimFrame < Frames-1 then begin
                                                Inc( AnimFrame );
                                                AnimNextTime := CustomGetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else if AnimRepeatCount > 1 then begin
                                                Dec( AnimRepeatCount );
                                                AnimFrame := 0;
                                                AnimNextTime := CustomGetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else begin
                                                ResetAnim;
                                        end;
                                end
                                else begin
                                        if AnimFrame > 0 then begin
                                                Dec( AnimFrame );
                                                AnimNextTime := CustomGetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else if AnimRepeatCount > 1 then begin
                                                Dec( AnimRepeatCount );
                                                AnimFrame := Frames-1;
                                                AnimNextTime := CustomGetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else begin
                                                ResetAnim;
                                        end;
                                end;
                        end;
                end;

        if (WalkingResetTimer <> 0) and (CustomGetTickCount - WalkingResetTimer > WalkingResetTime) then begin
                WalkingResetTimer := 0;
                ResetAnim;
        end;

        Result := False;
end;

function TChar.MoveTo( NewPos : TPos ) : Boolean;
begin
        Result := MoveTo( NewPos.X, NewPos.Y, NewPos.Z );
end;

function TChar.MoveTo( X, Y : Word; Z : ShortInt ) : Boolean;
var     NewPos : TPos;
begin
        NewPos := TPos.Create( X, Y, Z );

        EffPos.SetPos( NewPos );
        if ( NewPos.GetBlockID <> Pos.GetBlockID ) then begin
                Result := True;
                if Registered then begin
                        UnRegisterObject;
                end;
        end
        else
                Result := False;

        Pos.SetPos( NewPos );
        NewPos.Free;

        if not Registered then
                RegisterObject;
        Palanthir.WorldListSorted := False;
end;

procedure TChar.AddItem( Item : TItem );
begin
        Content.Add( Item );

        if (Item.Layer = Layer_Mount) and (not Walking) then
                ResetAnim;

        Palanthir.ScriptManager.OnAddItemToChar( Self, Item );                
end;

procedure TChar.RemoveObjectFromCont( UObject : TUObject );
begin
        if UObject.IsItem and ( TItem( UObject ).Layer = Layer_Mount ) and (not Walking) then begin
                inherited RemoveObjectFromCont( UObject );
                ResetAnim;
        end
        else begin
                inherited RemoveObjectFromCont( UObject );
        end;
end;

function TChar.GetItemOnLayer( Layer : Byte ) : TItem;
var     I : Integer;
begin
        for I := 0 to Content.Count-1 do
                if TItem( Content.Items[ I ] ).Layer = Layer then begin
                        Result := TItem( Content.Items[ I ] );
                        exit;
                end;

        Result := nil;
end;

procedure TChar.RequestPaperdoll;
var     SendDoubleClick : TSendDoubleClick;
begin
        SendDoubleClick := TSendDoubleClick.Create;
        SendDoubleClick.SetSerial( Serial );
        Palanthir.SendPacket( SendDoubleClick );
end;

function TChar.GetMovingSpeed : Word;
begin
        if EnableCustomSpeed then begin
                Result := CustomMovingSpeed;
        end else begin
                Result := MovingSpeedConst;
        end;
end;

function TChar.GetRunningSpeed : Word;
begin
        if EnableCustomSpeed then begin
                Result := CustomRunningSpeed;
        end else begin
                Result := RunningSpeedConst;
        end;
end;

function TChar.GetMountMovingSpeed : Word;
begin
        if EnableCustomSpeed then begin
                Result := CustomMovingSpeed;
        end else begin
                Result := MountMovingSpeedConst;
        end;
end;

function TChar.GetMountRunningSpeed : Word;
begin
        if EnableCustomSpeed then begin
                Result := CustomRunningSpeed;
        end else begin
                Result := MountRunningSpeedConst;
        end;
end;

constructor TCharDrawObject.Create( X, Y, ZX, ZY : Integer; Tex : TAnimObject );
begin
        PosX := X;
        PosY := Y;
        ZPosX := ZX;
        ZPosY := ZY;
        Texture := Tex;
end;

destructor TCharDrawObject.Free;
begin
end;

end.
