unit uCounter;

interface

const   Count_Char = 0;
        Count_Item = 1;
        Count_Static = 2;
        Count_Map = 3;
        Count_WorldBlock = 4;
        Count_Gump = 5;
        Count_Packet = 6;
        Count_Vector = 7;
        Count_Pos = 8;
        Count_Light = 9;
        Count_Texture = 10;
        Count_TexArtMap = 11;
        Count_TexArtStatic = 12;
        Count_TexTexture = 13;
        Count_TexAscii = 14;
        Count_TexUnicode = 15;
        Count_TexGump = 16;
        Count_TexRadar = 17;
        Count_TexLight = 18;
        Count_TexAnim = 19;
        Count_WorldList = 20;
        TypeCount = 21;

        Names : Array[0..TypeCount-1] of String = ( 'Chars', 'Items', 'Statics',
                'MapItems', 'Worldblocks', 'Gumps', 'Packets', 'Vector', 'Pos',
                'Light', 'Textures', 'Textures (ArtMap)', 'Textures (ArtStatic)',
                'Textures (Textures)', 'Textures (Ascii)', 'Textures (Unicode)',
                'Textures (Gump)', 'Textures (Radar)', 'Texturs (Light)',
                'Textures (Animation)', 'WorldList' );

type    TCounter = Class
                private
                        Cache : Array[0..TypeCount-1] of LongWord;
                public
                        constructor Create;
                        destructor Free;
                        procedure IncCount( ObjectType : LongWord );
                        procedure DecCount( ObjectType : LongWord );
                        procedure ClearCount( ObjectType : LongWord );
                        procedure SetCount( ObjectType : LongWord; Value : LongWord );
                        function GetCount( ObjectType : LongWord ) : LongWord;
                        function GetTypeCount : LongWord;
                        function GetName( ObjectType : LongWord ) : String;
                        procedure Update;
        end;

var     Counter : TCounter;

implementation

uses    uPalanthir;

constructor TCounter.Create;
var     I : LongWord;
begin
        for I := 0 to TypeCount-1 do
                Cache[ I ] := 0;
end;

destructor TCounter.Free;
begin
end;

procedure TCounter.IncCount( ObjectType : LongWord );
begin
        if ObjectType < TypeCount then
                Inc( Cache[ ObjectType ] );
end;

procedure TCounter.DecCount( ObjectType : LongWord );
begin
        if ObjectType < TypeCount then
                Dec( Cache[ ObjectType ] );
end;

procedure TCounter.ClearCount( ObjectType : LongWord );
begin
        if ObjectType < TypeCount then
                Cache[ ObjectType ] := 0;
end;

procedure TCounter.SetCount( ObjectType : LongWord; Value : LongWord );
begin
        if ObjectType < TypeCount then
                Cache[ ObjectType ] := Value;
end;

function TCounter.GetCount( ObjectType : LongWord ) : LongWord;
begin
        if ObjectType < TypeCount then
                Result := Cache[ ObjectType ]
        else
                Result := 0;
end;

function TCounter.GetTypeCount : LongWord;
begin
        Result := TypeCount;
end;

function TCounter.GetName( ObjectType : LongWord ) : String;
begin
        if ObjectType < TypeCount then
                Result :=  Names[ ObjectType ]
        else
                Result := '';
end;

procedure TCounter.Update;
begin
        SetCount( Count_WorldList, Palanthir.GetWorldListCount );
end;

end.
