unit uCursors;

interface

uses    uTexCache, dglOpenGL, Classes;

const   crUOSpielNW = 0;
        crUOSpielN = 1;
        crUOSpielNE = 2;
        crUOSpielE = 3;
        crUOSpielSE = 4;
        crUOSpielS = 5;
        crUOSpielSW = 6;
        crUOSpielW = 7;
        crUOFaust = 8;
        crUOAuswahl = 9;
        crUOPickup = 10;
        crUOKnochenhand = 11;
        crUOTarget = 12;
        crUOWait = 13;
        crUOFeder = 14;
        crUONadel = 15;

        CursorCount = 16;
        CursorTypes = 2;

        CursorIds : array[0..CursorCount-1, 0..CursorTypes-1] of Word = (
                      ($2053, $206A),
                      ($2054, $206B),
                      ($2055, $206C),
                      ($2056, $206D),
                      ($2057, $206E),
                      ($2058, $206F),
                      ($2059, $2070),
                      ($205A, $2071),
                      ($205B, $2072),
                      ($205C, $2073),
                      ($205D, $2074),
                      ($205E, $2075),
                      ($205F, $2076),
                      ($2060, $2077),
                      ($2061, $2078),
                      ($2062, $2079) );



type    TCustomCursor = Class
                public
                        Texture : TTexObject;
                        SelX, SelY : Word;
                        Id : Word;
                        constructor Create;
                        destructor Free;
                        procedure Load( Id : Word );
        end;

        TCursors = Class
                public
                        CurrentCursor : Word;
                        CursorList : TList;
                        constructor Create;
                        destructor Free;
                        function GetCursor( Id : Word; Typ : Word = 1 ) : TCustomCursor;
        end;

implementation

uses    uPalanthir;

constructor TCustomCursor.Create;
begin
        Texture := nil;
        SelX := 0;
        SelY := 0;
        Id := 0;
end;

destructor TCustomCursor.Free;
begin
        if Texture <> nil then begin
                glDeleteTextures( 1, @Texture.TexID );
                Texture.Free;
        end;
end;

procedure TCustomCursor.Load( Id : Word );
begin
end;

constructor TCursors.Create;
var     I, J : Integer;
        Cursor : TCustomCursor;
begin
        CursorList := TList.Create;
        for I := 0 to CursorCount-1 do
                for J := 0 to CursorTypes-1 do begin
                        Cursor := Palanthir.Data.LoadCursor( CursorIds[I,J] );
                        CursorList.Add( Cursor );
                end;
end;

destructor TCursors.Free;
var     I, J : Integer;
begin
        for I := 0 to CursorCount-1 do
                for J := 0 to CursorTypes-1 do
                        TCustomCursor( CursorList.Items[ I*CursorTypes+J ] ).Free;
        CursorList.Free;
end;

function TCursors.GetCursor( Id, Typ : Word ) : TCustomCursor;
begin
        if (Id < CursorCount) and (Typ < CursorTypes) then begin
                Result := TCustomCursor( CursorList.Items[ Id*CursorTypes+Typ ] );
                exit;
        end;

        Result := nil;
end;


end.
