unit uEffect;

interface

uses    uBasicTypedefs, uUtilities, uRecievePackets, uPos, uUObject,
        uLoaderTiledata, uTexCache, uRenderer, uChar, Dialogs, SysUtils,
        dglOpenGL;

const   Effect_Moving = 0;
        Effect_Lightning = 1;
        Effect_StayAtPos = 2;
        Effect_StayAtSource = 3;

        EffectMaxSteps = 10;

type    TEffect = Class( TUODrawObject )
                public
                        SrcPos, TargPos : TPos;
                        SrcSerial, TargSerial : LongWord;
                        Speed, Duration, DirectionType : Byte;
                        FixedDirection, Explodes : Boolean;
                        RenderMode : LongWord;
                        Step : Integer;
                        AnimMoveX, AnimMoveY, AnimMoveZ : Integer;
                        DiffX, DiffY, DiffZ : Integer;
                        PlainDistance : Integer;
                        Created, NextStep : LongWord;
                        Alpha : Real;
                        constructor Create; override;
                        destructor Free; override;
                        procedure Draw; override;
                        function Poll : Boolean; 
                        procedure Init( Packet : Effect ); overload;
                        procedure Init( Packet : OldEffect ); overload;
                        function IsEffect : Boolean; override;
                        function IsVisible : Boolean; override;
        end;

implementation

uses    uPalanthir;

constructor TEffect.Create;
begin
        inherited Create;
        SrcPos := nil;
        TargPos := nil;
        Typ := typ_effect;
end;

destructor TEffect.Free;
begin
        if SrcPos <> nil then
                SrcPos.Free;
        if TargPos <> nil then
                TargPos.Free;

        if Texture <> nil then
                Palanthir.Data.DecStaticArt( Texture.ID-$4000, Texture.Hue );

        inherited Free;
end;

procedure TEffect.Draw;
var     PosXMin, PosYMin, PosXMax, PosYMax : Integer;
        MX, MY, X1, Y1, X2, Y2, X3, Y3, X4, Y4, TmpX, TmpY : Integer;
        DrawId : Integer;
begin
        if (Id = $1) or ( Pos.Z >= Palanthir.RoofHeight ) then
                exit;

        if DirectionType = Effect_Lightning then begin
        end
        else if DirectionType = Effect_Moving then begin
                if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        DrawId := Palanthir.ItemAnimCache.GetCurrentId( ID )
                else
                        DrawId := ID;

                if (Texture = nil) or (Texture.Id <> DrawId) or (Texture.Hue <> Color) then begin
                        if Texture <> nil then
                                Palanthir.Data.DecStaticArt( Texture.ID-$4000, Texture.Hue );

                        Texture := Palanthir.Data.GetStaticArt( DrawId, Color );

                        if Texture <> nil then
                                Palanthir.Data.IncStaticArt( Texture.ID-$4000, Texture.Hue );
                end;

                if Texture = nil then
                        exit;

                PosXMin := Palanthir.RelDrawX + (SrcPos.X - SrcPos.Y) * 22 - ( Texture.Breite div 2 ) + AnimMoveX;
                PosYMin := Palanthir.RelDrawY + (SrcPos.X + SrcPos.Y) * 22 - SrcPos.Z*4 - Texture.Hoehe +44 + AnimMoveY - AnimMoveZ - 10*4;
                PosXMax := PosXMin + Texture.Breite;
                PosYMax := PosYMin + Texture.Hoehe;

                MX := PosXMin + ( PosXMax - PosXMin ) div 2;
                MY := PosYMin + ( PosYMax - PosYMin ) div 2;

                TmpX := PosXMin - MX;
                TmpY := PosYMin - MY;
                X1 := MX + Round( TmpX * Cos( Alpha ) - TmpY * Sin( Alpha ) );
                Y1 := MY + Round( TmpX * Sin( Alpha ) + TmpY * Cos( Alpha ) );

                TmpX := PosXMax - MX;
                TmpY := PosYMin - MY;
                X2 := MX + Round( TmpX * Cos( Alpha ) - TmpY * Sin( Alpha ) );
                Y2 := MY + Round( TmpX * Sin( Alpha ) + TmpY * Cos( Alpha ) );

                TmpX := PosXMax - MX;
                TmpY := PosYMax - MY;
                X3 := MX + Round( TmpX * Cos( Alpha ) - TmpY * Sin( Alpha ) );
                Y3 := MY + Round( TmpX * Sin( Alpha ) + TmpY * Cos( Alpha ) );

                TmpX := PosXMin - MX;
                TmpY := PosYMax - MY;
                X4 := MX + Round( TmpX * Cos( Alpha ) - TmpY * Sin( Alpha ) );
                Y4 := MY + Round( TmpX * Sin( Alpha ) + TmpY * Cos( Alpha ) );

                if Renderer.CurrentTexID <> Texture.TexID then begin
                        glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                        Renderer.CurrentTexID := Texture.TexID;
                end;

                glBegin( gl_Quads );
                        gltexcoord2f( 0, 0 );
                        glvertex2f( X1, Y1 );
                        gltexcoord2f( 0, Texture.Hoehe / GetNextBit( Texture.Hoehe ) );
                        glvertex2f( X2, Y2 );
                        gltexcoord2f( Texture.Breite / GetNextBit( Texture.Breite ), Texture.Hoehe / GetNextBit( Texture.Hoehe ) );
                        glvertex2f( X3, Y3 );
                        gltexcoord2f( Texture.Breite / GetNextBit( Texture.Breite ), 0 );
                        glvertex2f( X4, Y4 );
                glEnd;
        end
        else begin
                if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        DrawId := Palanthir.ItemAnimCache.GetCurrentId( ID )
                else
                        DrawId := ID;

                if (Texture = nil) or (Texture.Id <> DrawId) or (Texture.Hue <> Color) then begin
                        if Texture <> nil then
                                Palanthir.Data.DecStaticArt( Texture.ID-$4000, Texture.Hue );

                        Texture := Palanthir.Data.GetStaticArt( DrawId, Color );

                        if Texture <> nil then
                                Palanthir.Data.IncStaticArt( Texture.ID-$4000, Texture.Hue );
                end;

                if Texture = nil then
                        exit;

                PosXMin := Palanthir.RelDrawX + (SrcPos.X - SrcPos.Y) * 22 - ( Texture.Breite div 2 );
                PosYMin := Palanthir.RelDrawY + (SrcPos.X + SrcPos.Y) * 22 - SrcPos.Z*4 - Texture.Hoehe +44;

                Renderer.DrawPixels( PosXMin, PosYMin, Texture );                        
        end;
end;

function TEffect.Poll : Boolean;
var     UObject : TUObject;
begin
        Case DirectionType of
                Effect_Moving : begin
                        if CustomGetTickCount > NextStep then begin
                                if Step = PlainDistance + 1 then begin
                                        Result := False;
                                        exit;
                                end
                                else begin
                                        Pos.X := SrcPos.X + Trunc( DiffX * Step / PlainDistance );
                                        //PX := DiffX * Step / PlainDistance - Trunc( DiffX * Step / PlainDistance );
                                        Pos.Y := SrcPos.Y + Trunc( DiffY * Step / PlainDistance );
                                        //PY := DiffY * Step / PlainDistance - Trunc( DiffY * Step / PlainDistance );
                                        Pos.Z := SrcPos.Z + Trunc( DiffZ * Step / PlainDistance );
                                        //PZ := DiffZ * Step / PlainDistance - Trunc( DiffZ * Step / PlainDistance );

                                        //AnimMoveX := Round( (PX + PY) * 44 );
                                        //AnimMoveY := Round( (PX - PY) * 44 );
                                        //AnimMoveZ := Round( PZ * 4 );

                                        AnimMoveX := Round( (DiffX - DiffY)*22*Step / PlainDistance );
                                        AnimMoveY := Round( (DiffX + DiffY)*22*Step / PlainDistance );
                                        AnimMoveZ := Round( DiffZ*4*Step / PlainDistance );
                                        NextStep := CustomGetTickCount + 120 - Speed*5;

                                        Inc( Step );                                        
                                        Palanthir.WorldListSorted := False;
                                end;
                        end;

                        end;
                Effect_Lightning : begin
                        end;
                Effect_StayAtPos : begin
                        if CustomGetTickCount > Duration + Created then begin
                                Result := False;
                                exit;
                        end;

                        end;
                Effect_StayAtSource : begin
                        UObject := Palanthir.Data.GlobalObjectList.GetObject( SrcSerial );
                        if UObject = nil then begin
                                Result := False;
                                exit;
                        end;

                        if UObject.IsChar then begin
                                AnimMoveX := TChar( UObject ).AnimMoveX;
                                AnimMoveY := TChar( UObject ).AnimMoveY;
                                AnimMoveZ := TChar( UObject ).AnimMoveZ;
                        end;

                        if not UObject.Pos.Equals( Pos ) then begin
                                Palanthir.WorldListSorted := False;
                                Pos.SetPos( UObject.Pos );
                        end;

                        if CustomGetTickCount > Duration + Created then begin
                                Result := False;
                                exit;
                        end;

                        end;
        end;

        Result := True;        
end;

procedure TEffect.Init( Packet : Effect );
var     PosX, PosY : Integer;
begin
        SrcSerial := Packet.GetSourceSerial;
        TargSerial := Packet.GetTargetSerial;
        SrcPos := TPos.Create( Packet.GetSrcX, Packet.GetSrcY, Packet.GetSrcZ );
        TargPos := TPos.Create( Packet.GetTargX, Packet.GetTargY, Packet.GetTargZ );
        Id := Packet.GetID;
        DirectionType := Packet.GetType;
        Speed := Packet.GetSpeed;
        Duration := Packet.GetDuration*50;
        FixedDirection := Packet.GetFixedDirection <> 0;
        Explodes := Packet.GetExplode <> 0;
        Color := Packet.GetHue;
        RenderMode := Packet.GetRenderMode;
        Created := CustomGetTickCount;

        if DirectionType = Effect_Moving then begin
                DiffX := TargPos.X - SrcPos.X;
                DiffY := TargPos.Y - SrcPos.Y;

                PosX := ( DiffX - DiffY )*44;
                PosY := ( DiffX + DiffY )*44 + DiffZ*4;

                if PosX = 0 then begin
                        Alpha := Pi / 2;
                end
                else begin
                        Alpha := ArcTan( PosY / PosX );
                end;

                if Alpha < 0 then
                        Alpha := Pi + Alpha;

                if (PosY > 0) or ( (PosX > 0) and (PosY = 0) ) then
                        Alpha := Pi + Alpha;

                Alpha := Alpha - Pi / 2;
                if Alpha < 0 then
                        Alpha := Alpha + 2*Pi;

                DiffZ := TargPos.Z - SrcPos.Z;
                PlainDistance := Round( sqrt( DiffX*DiffX + DiffY*DiffY ) )*2 + 1;

                Step := 0;
                NextStep := CustomGetTickCount + 120 - Speed*5;
                AnimMoveX := 0;
                AnimMoveY := 0;
                AnimMoveZ := 0;

                Pos.SetPos( SrcPos );
        end
        else if DirectionType = Effect_Lightning then begin
                Pos.SetPos( SrcPos );
        end
        else if DirectionType = Effect_StayAtPos then begin
                Pos.SetPos( SrcPos );
        end
        else if DirectionType = Effect_StayAtSource then begin
                Pos.SetPos( SrcPos );
        end;

        Palanthir.AddEffect( Self );
end;

procedure TEffect.Init( Packet : OldEffect );
var     PosX, PosY : Integer;
begin
        SrcSerial := Packet.GetSourceSerial;
        TargSerial := Packet.GetTargetSerial;
        SrcPos := TPos.Create( Packet.GetXSource, Packet.GetYSource, Packet.GetZSource );
        TargPos := TPos.Create( Packet.GetXTarget, Packet.GetYTarget, Packet.GetZTarget );
        Id := Packet.GetID;
        DirectionType := Packet.GetType;
        Speed := Packet.GetSpeed;
        Duration := Packet.GetDuration*50;
        FixedDirection := Packet.GetNotAdjust <> 0;
        Explodes := Packet.GetExplode <> 0;
        Color := 0;
        RenderMode := 0;
        Created := CustomGetTickCount;

        if DirectionType = Effect_Moving then begin
                DiffX := TargPos.X - SrcPos.X;
                DiffY := TargPos.Y - SrcPos.Y;

                PosX := ( DiffX - DiffY )*44;
                PosY := ( DiffX + DiffY )*44 + DiffZ*4;

                if PosX = 0 then begin
                        Alpha := Pi / 2;
                end
                else begin
                        Alpha := ArcTan( PosY / PosX );
                end;

                if Alpha < 0 then
                        Alpha := Pi + Alpha;

                if (PosY > 0) or ( (PosX > 0) and (PosY = 0) ) then
                        Alpha := Pi + Alpha;

                Alpha := Alpha - Pi / 2;
                if Alpha < 0 then
                        Alpha := Alpha + 2*Pi;

                DiffZ := TargPos.Z - SrcPos.Z;
                PlainDistance := Round( sqrt( DiffX*DiffX + DiffY*DiffY ) )*2 + 1;                

                Step := 0;
                NextStep := CustomGetTickCount + 120 - Speed*5;
                AnimMoveX := 0;
                AnimMoveY := 0;
                AnimMoveZ := 0;

                Pos.SetPos( SrcPos );                
        end
        else if DirectionType = Effect_Lightning then begin
                Pos.SetPos( SrcPos );
        end
        else if DirectionType = Effect_StayAtPos then begin
                Pos.SetPos( SrcPos );
        end
        else if DirectionType = Effect_StayAtSource then begin
                Pos.SetPos( SrcPos );
        end;

        Palanthir.AddEffect( Self );
end;

function TEffect.IsEffect : Boolean;
begin
        Result := True;
end;

function TEffect.IsVisible : Boolean;
begin
        Result := True;
end;

end.
