unit uFightGump;

interface

uses    uGumps, Classes, uSendPackets, uLoaderAnimations, Math, uUtilities,
        Dialogs, SysUtils;

const   TZ_Kopf = 0;
        TZ_Torso = 1;
        TZ_Beine = 2;
        TZ_ArmLinks = 3;
        TZ_ArmRechts = 4;
        TZ_HandLinks = 5;
        TZ_HandRechts = 6;
        TZ_Schild = $EF;
        TZ_Nichts = $FF;

type    TTreffer = Class
                public
                        TrefferZone : Byte;
                        Staerke : Byte;
                        DecayTime : LongWord;
                        constructor Create( TrefferZone : Byte; Staerke : Byte );
                        destructor Free;
        end;

        TFightGump = Class( TGump )
                private
                        TrefferListe : TList;
                        TargetSerial : LongWord;
                        TrefferZone : Byte;
                        IsPlayer : Boolean;
                        Image : TGImage;
                        KampfModus, KampfGeschwindigkeit, Ausweichen : TScrollBar;
                        Kopf, Torso, Beine, ArmLinks, ArmRechts, HandLinks, HandRechts, Nichts, Schild : TGumpButton;
                        TrefferZoneFixed : Boolean;
                public
                        constructor Create; override;
                        destructor Free; override;
                        procedure Update( TargetSerial : LongWord; TrefferZone, KampfModus, KampfGeschwindigkeit, Ausweichen : Byte; TrefferZoneFixed, KampfModusFixed, KampfGeschwindigkeitFixed, AusweichenFixed : Boolean; IsPlayer : Boolean );
                        function Draw : Boolean; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure OnScrollBarRelease( ScrollBar : TScrollBar ); override;
                        function GetTrefferZone : TGumpButton;
                        procedure UpdateToServer;
                        procedure AddDamage( TrefferZone : Byte; Staerke : Byte );
                        procedure CheckTreffer;
                        function GetDrawHue( TrefferZone : Byte ) : Integer;
                        function OnMove( GumpObject : TGumpObject ) : Boolean; override;
        end;

implementation

uses    uPalanthir, uChar, uRenderer;

constructor TTreffer.Create( TrefferZone : Byte; Staerke : Byte );
begin
        Self.TrefferZone := TrefferZone;
        Self.Staerke := Staerke;
        Self.DecayTime := CustomGetTickCount + 1000;
end;

destructor TTreffer.Free;
begin
end;

constructor TFightGump.Create;
begin
        inherited Create;

        Typ := GumpTyp_FightGump;
        TrefferListe := TList.Create;

        Image := AddImage( 0, 0, $B7, 0, 0 );

        Kopf := TGumpButton.Create( 0, 0, $B8, $B8, $B8, 1, 0 );
        Kopf.Gump := Self;
        Torso := TGumpButton.Create( 0, 0, $B9, $B9, $B9, 2, 0 );
        Torso.Gump := Self;
        Beine := TGumpButton.Create( 0, 0, $B2, $B2, $B2, 3, 0 );
        Beine.Gump := Self;
        ArmLinks := TGumpButton.Create( 0, 0, $B0, $B0, $B0, 4, 0 );
        ArmLinks.Gump := Self;
        ArmRechts := TGumpButton.Create( 0, 0, $B1, $B1, $B1, 5, 0 );
        ArmRechts.Gump := Self;
        HandLinks := TGumpButton.Create( 0, 0, $B5, $B5, $B5, 6, 0 );
        HandLinks.Gump := Self;
        HandRechts := TGumpButton.Create( 0, 0, $B6, $B6, $B6, 7, 0 );
        HandRechts.Gump := Self;
        Nichts := TGumpButton.Create( 0, 0, $B3, $B3, $B3, 8, 0 );
        Nichts.Gump := Self;
        Schild := AddButton( 0, 0, $B4, $B4, $B4, 9, 0 );

        KampfModus := AddScrollBar( 40, 262, True, 109, $BA, $BA, 1, 0 );
        Ausweichen := AddScrollBar( 40, 289, True, 109, $BA, $BA, 3, 0 );
        KampfGeschwindigkeit := AddScrollBar( 40, 316, True, 109, $BA, $BA, 2, 0 );

        if Palanthir.Player.CharConfig.GetInteger( 'FightGumpX' ) <> 0 then
                X := Max( 0, Min( Palanthir.Player.CharConfig.GetInteger( 'FightGumpX' ), Palanthir.GetWindowBreite - 100 ) );
        if Palanthir.Player.CharConfig.GetInteger( 'FightGumpY' ) <> 0 then
                Y := Max( 0, Min( Palanthir.Player.CharConfig.GetInteger( 'FightGumpY' ), Palanthir.GetWindowHoehe - 100 ) );
end;

destructor TFightGump.Free;
begin
        if (Palanthir.Player <> nil) and (Palanthir.Player.CharConfig <> nil) then begin
                if (Palanthir.State = State_Ending) or (Palanthir.State = State_ReturnToLogin) then begin
                        Palanthir.Player.CharConfig.SetBool( 'FightGumpOpen', True );
                end
                else begin
                        Palanthir.Player.CharConfig.SetBool( 'FightGumpOpen', False );
                end;
                Palanthir.Player.CharConfig.SetInteger( 'FightGumpX', X );
                Palanthir.Player.CharConfig.SetInteger( 'FightGumpY', Y );
        end;
        
        TrefferListe.Free;

        inherited Free;
end;

function TFightGump.Draw : Boolean;
var     Char : TChar;
        AnimTexture : TAnimObject;
        TmpDirection : Byte;
        TmpAnimID : Word;
        Hoehe, Breite : Word;
        Gespiegelt : Boolean;
        OldHue : Word;
        Hue : Integer;
begin
        CheckTreffer;

        Result := inherited Draw;

        if IsPlayer then begin
                OldHue := Kopf.Hue;
                Kopf.Hue := GetDrawHue( TZ_Kopf );
                Kopf.Draw;
                Kopf.Hue := OldHue;

                OldHue := Torso.Hue;
                Torso.Hue := GetDrawHue( TZ_Torso );
                Torso.Draw;
                Torso.Hue := OldHue;

                OldHue := Beine.Hue;
                Beine.Hue := GetDrawHue( TZ_Beine );
                Beine.Draw;
                Beine.Hue := OldHue;

                OldHue := ArmLinks.Hue;
                ArmLinks.Hue := GetDrawHue( TZ_ArmLinks );
                ArmLinks.Draw;
                ArmLinks.Hue := OldHue;

                OldHue := ArmRechts.Hue;
                ArmRechts.Hue := GetDrawHue( TZ_ArmRechts );
                ArmRechts.Draw;
                ArmRechts.Hue := OldHue;

                OldHue := HandLinks.Hue;
                HandLinks.Hue := GetDrawHue( TZ_HandLinks );
                HandLinks.Draw;
                HandLinks.Hue := OldHue;

                OldHue := HandRechts.Hue;
                HandRechts.Hue := GetDrawHue( TZ_HandRechts );
                HandRechts.Draw;
                HandRechts.Hue := OldHue;

                Nichts.Draw;                
        end
        else begin
                if TargetSerial <> Invalid_Serial then begin
                        Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( TargetSerial ) );
                        if Char <> nil then begin
                                TmpDirection := Char.Direction and $F;

                                if TmpDirection < 3 then begin
                                        TmpAnimId := 3 - TmpDirection;
                                        Gespiegelt := True;
                                end
                                else begin
                                        TmpAnimId := TmpDirection - 3;
                                        Gespiegelt := False;
                                end;

                                Hue := GetDrawHue( TZ_Nichts );
                                if Hue = -1 then
                                        Hue := Char.Color;

                                AnimTexture := Palanthir.Data.GetAnimTexture( Char.ID, Char.AnimId*5 + TmpAnimId, Hue, Char.AnimFrame );

                                if AnimTexture <> nil then begin
                                        Hoehe := Max( 0, Min( AnimTexture.Hoehe, 170 ) );
                                        Breite := Max( 0, Min( AnimTexture.Breite, 100 ) );

                                        Renderer.DrawPixelsHoeheBreite( X+90-(Breite div 2), Y+240-Hoehe, AnimTexture, Hoehe, Breite, Gespiegelt );
                                end;
                        end;
                end;
        end;
end;

procedure TFightGump.Update( TargetSerial : LongWord; TrefferZone, KampfModus, KampfGeschwindigkeit, Ausweichen : Byte; TrefferZoneFixed, KampfModusFixed, KampfGeschwindigkeitFixed, AusweichenFixed : Boolean; IsPlayer : Boolean );
begin
        if GetTrefferZone <> nil then
                GetTrefferZone.Hue := 0;

        Self.TargetSerial := TargetSerial;
        Self.TrefferZone := TrefferZone;
        Self.IsPlayer := IsPlayer;
        Self.KampfModus.Promille := KampfModus*10;
        Self.KampfGeschwindigkeit.Promille := KampfGeschwindigkeit*10;
        Self.Ausweichen.Promille := Ausweichen*10;

        Self.TrefferZoneFixed := TrefferZoneFixed;
        Self.KampfModus.Fixed := KampfModusFixed;
        Self.KampfGeschwindigkeit.Fixed := KampfGeschwindigkeitFixed;
        Self.Ausweichen.Fixed := AusweichenFixed;

        if GetTrefferZone <> nil then
                GetTrefferZone.Hue := $43;
end;

procedure TFightGump.OnButtonClick( ReturnNumber : Integer );
begin
        if not TrefferZoneFixed then begin
                if (ReturnNumber > 0) and (ReturnNumber < 8) then begin
                        if GetTrefferZone <> nil then
                                GetTrefferZone.Hue := 0;

                        TrefferZone := ReturnNumber-1;
                        UpdateToServer;

                        if GetTrefferZone <> nil then
                                GetTrefferZone.Hue := $43;
                end
                else if ReturnNumber = 8 then begin
                        if GetTrefferZone <> nil then
                                GetTrefferZone.Hue := 0;

                        TrefferZone := $FF;
                        UpdateToServer;

                        if GetTrefferZone <> nil then
                                GetTrefferZone.Hue := $43;
                end;
        end;

        inherited OnButtonClick( ReturnNumber );
end;

procedure TFightGump.OnScrollBarRelease( ScrollBar : TScrollBar );
begin
        UpdateToServer;
end;

function TFightGump.GetTrefferZone : TGumpButton;
begin
        Case TrefferZone of
                TZ_Kopf : Result := Kopf;
                TZ_Torso : Result := Torso;
                TZ_Beine : Result := Beine;
                TZ_ArmLinks : Result := ArmLinks;
                TZ_ArmRechts : Result := ArmRechts;
                TZ_HandLinks : Result := HandLinks;
                TZ_HandRechts : Result := HandRechts;
                TZ_Schild : Result := Schild;
                TZ_Nichts : Result := Nichts;
        else
                Result := nil;
        end;
end;

procedure TFightGump.UpdateToServer;
var     Response : MEFightGumpResponse;
begin
        Response := MEFightGumpResponse.Create;
        Response.SetTrefferZone( TrefferZone );
        Response.SetKampfModus( KampfModus.Promille div 10 );
        Response.SetKampfGeschwindigkeit( KampfGeschwindigkeit.Promille div 10 );
        Response.SetAusweichen( Ausweichen.Promille div 10 );
        Palanthir.SendPacket( Response );
end;

procedure TFightGump.AddDamage( TrefferZone : Byte; Staerke : Byte );
var     Treffer : TTreffer;
begin
        Treffer := TTreffer.Create( TrefferZone, Staerke );
        TrefferListe.Add( Treffer );
end;

procedure TFightGump.CheckTreffer;
var     I : Integer;
begin
        for I := TrefferListe.Count-1 downto 0 do begin
                if TTreffer( TrefferListe.Items[ I ] ).DecayTime <= CustomGetTickCount then begin
                        TTreffer( TrefferListe.Items[ I ] ).Free;
                        TrefferListe.Delete( I );
                end;
        end;
end;

function TFightGump.GetDrawHue( TrefferZone : Byte ) : Integer;
var     I : Integer;
        Staerke : Integer;
        Treffer : TTreffer;
begin
        Staerke := -1;
        for I := 0 to TrefferListe.Count-1 do begin
                Treffer := TTreffer( TrefferListe.Items[ I ] );
                if (Treffer.TrefferZone = TrefferZone) and (Treffer.Staerke > Staerke) then begin
                        Staerke := Treffer.Staerke;
                end;
        end;

        if Staerke = -1 then begin
                Case TrefferZone of
                        TZ_Kopf : Result := Kopf.Hue;
                        TZ_Torso : Result := Torso.Hue;
                        TZ_Beine : Result := Beine.Hue;
                        TZ_ArmLinks : Result := ArmLinks.Hue;
                        TZ_ArmRechts : Result := ArmRechts.Hue;
                        TZ_HandLinks : Result := HandLinks.Hue;
                        TZ_HandRechts : Result := HandRechts.Hue;
                        TZ_Schild : Result := Schild.Hue;
                else
                        Result := -1;
                end;
        end
        else begin
                Case Staerke of
                        0 : Result := $95;
                        1 : Result := $27;
                else
                        Result := -1;
                end;
        end;
end;

function TFightGump.OnMove( GumpObject : TGumpObject ) : Boolean;
var     GetCharStatus : TGetCharStatus;
        Char : TChar;
begin
        if (GumpObject = Image) and IsInRect( Palanthir.Maus.AktX, Palanthir.Maus.AktY, X+70, Y+80, X+140, Y+250 ) then begin
                Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( TargetSerial ) );
                if Char <> nil then begin
                        GetCharStatus := TGetCharStatus.Create;
                        GetCharStatus.SetPlayer( TargetSerial );
                        Palanthir.SendPacket( GetCharStatus );

                        Char.StatusVisible := True;
                        Char.StatusPos.X := Palanthir.Maus.AktX-30;
                        Char.StatusPos.Y := Palanthir.Maus.AktY-30;                        

                        Result := False;
                end
                else begin
                        Result := inherited OnMove( GumpObject );
                end;
        end
        else begin
                Result := inherited OnMove( GumpObject );
        end;
end;

end.
