unit uGeometry;

interface

type    TPoint2D = packed record
                X, Y : Integer;
        end;
        PPoint2D = ^TPoint2D;

        TPoint3D = packed record
                X, Y, Z : Integer;
        end;
        PPoint3D = ^TPoint3D;

        TRect2D = packed record
                case Points : Boolean of
                        True : (StartPoint, EndPoint : TPoint2D);
                        False : (X1, Y1, X2, Y2 : Integer);
        end;
        PRect2D = ^TRect2D;

        TRect3D = packed record
                case Points : Boolean of
                        True : (StartPoint, EndPoint : TPoint3D);
                        False : (X1, Y1, Z1, X2, Y2, Z2 : Integer);
        end;
        PRect3D = ^TRect3D;        

function Point2D( vX, vY : Integer ) : TPoint2D;
function Point3D( vX, vY, vZ : Integer ) : TPoint3D; overload;
function Point3D( vPoint2D : TPoint2D; vZ : Integer ) : TPoint3D; overload;

function Rect2D( vX1, vY1, vX2, vY2 : Integer ) : TRect2D; overload;
function Rect2D( vStartPoint, vEndPoint : TPoint2D ) : TRect2D; overload;
function Rect3D( vX1, vY1, vZ1, vX2, vY2, vZ2 : Integer ) : TRect3D; overload;
function Rect3D( vStartPoint, vEndPoint : TPoint3D ) : TRect3D; overload;

implementation

function Point2D( vX, vY : Integer ) : TPoint2D;
begin
        Result.X := vX;
        Result.Y := vY;
end;

function Point3D( vX, vY, vZ : Integer ) : TPoint3D;
begin
        Result.X := vX;
        Result.Y := vY;
        Result.Z := vZ;
end;

function Point3D( vPoint2D : TPoint2D; vZ : Integer ) : TPoint3D;
begin
        Result.X := vPoint2D.X;
        Result.Y := vPoint2D.Y;
        Result.Z := vZ;
end;

function Rect2D( vX1, vY1, vX2, vY2 : Integer ) : TRect2D;
begin
        Result.X1 := vX1;
        Result.Y1 := vY1;
        Result.X2 := vX2;
        Result.Y2 := vY2;
end;

function Rect2D( vStartPoint, vEndPoint : TPoint2D ) : TRect2D;
begin
        Result.StartPoint := vStartPoint;
        Result.EndPoint := vEndPoint;
end;

function Rect3D( vX1, vY1, vZ1, vX2, vY2, vZ2 : Integer ) : TRect3D;
begin
        Result.X1 := vX1;
        Result.Y1 := vY1;
        Result.Z1 := vZ1;
        Result.X2 := vX2;
        Result.Y2 := vY2;
        Result.Z2 := vZ2;
end;

function Rect3D( vStartPoint, vEndPoint : TPoint3D ) : TRect3D;
begin
        Result.StartPoint := vStartPoint;
        Result.EndPoint := vEndPoint;
end;

end.
