unit uItem;

interface

uses    uBasicTypedefs, uUObject, Classes, uRecievePackets, uLoaderTiledata,
        Dialogs, uSendPackets, uRenderer, uTexCache, uLoaderAnimations,
        SysUtils, uLoaderMultis, uPos, uSpeech, uUtilities, uLightManager,
        uConfig, uCounter, uTimer;

const   Layer_TradeWindow = 0;
        Layer_SingleHandedWeapon = 1;
        Layer_DualHandedWeapon = 2;
        Layer_Shoes = 3;
        Layer_Pants = 4;
        Layer_Shirt = 5;
        Layer_Hat = 6;
        Layer_Gloves = 7;
        Layer_Ring = 8;
        Layer_Neck = $A;
        Layer_Hair = $B;
        Layer_Waist = $C;
        Layer_InnerTorso = $D;
        Layer_Bracelet = $E;
        Layer_FacialHair = $10;
        Layer_MiddleTorso = $11;
        Layer_Earrings = $12;
        Layer_Arms = $13;
        Layer_Back = $14;
        Layer_Backpack = $15;
        Layer_OuterTorso = $16;
        Layer_OuterLegs = $17;
        Layer_InnerLegs = $18;
        Layer_Mount = $19;
        Layer_BuyRestockContainer = $1A;
        Layer_BuyNoRestockContainer = $1B;
        Layer_SellContainer = $1C;
        Layer_BankBox = $1D;
        Layer_Dragging = $1E;

type    TItem = Class( TUObject )
                protected
                        procedure SetID( NewID : Word ); override;
                        procedure SetColor( NewColor : Word ); override;
                public
                        Amount : Word;
                        Movable, Visible : Boolean;
                        Layer : Word;
                        DrawColor : Word;
                        MultiCache : TList;
                        constructor Create; override;
                        procedure GetTexture; override;
                        destructor Free; override;
                        procedure Draw; override;
                        function IsItem : Boolean; override;
                        function IsVisible : Boolean; override;
                        procedure Update( Packet : GetItem );
                        procedure RemoveFromCont;
                        procedure AddItem( Item : TItem );
                        procedure GrabItem;
                        function IsMulti : Boolean;
                        procedure AddMultiItems;
                        procedure RemoveMultiItems;
                        procedure MoveTo( X, Y : Word; Z : ShortInt; Map : Byte );
        end;

        P_Item = ^TItem;

        TMultiItem = Class( TUODrawObject )
                public
                        Owner : TItem;
                        constructor Create; override;
                        destructor Free; override;
                        procedure GetTexture; override;
                        procedure Draw; override;
                        procedure OnClick; override;
                        procedure OnDblClick; override;
                        function IsVisible : Boolean; override;
                        function IsMultiItem : Boolean; override;
        end;

implementation

uses    uPalanthir, uSpecialGumps, uGumps, uWorldCache;

procedure TItem.SetID( NewID : Word );
begin
        if _ID <> NewID then begin
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then begin
                        Palanthir.ItemAnimCache.RemoveAnim( Id, Color );
                        Palanthir.ItemAnimCache.RemoveAnim( Id, SelectionColor );
                end;

                _ID := NewID;
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then begin
                        Palanthir.ItemAnimCache.AddAnim( Id, Color );
                        Palanthir.ItemAnimCache.AddAnim( Id, SelectionColor );
                end;
        end;
end;

procedure TItem.SetColor( NewColor : Word );
begin
        if _Color <> NewColor then begin
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        Palanthir.ItemAnimCache.RemoveAnim( Id, Color );
                _Color := NewColor;
                if IsInDrawList and Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                        Palanthir.ItemAnimCache.AddAnim( Id, Color );
        end;
end;

constructor TItem.Create;
begin
        inherited Create;
        Typ := typ_item;
        Layer := 0;
        DrawColor := 0;
        MultiCache := TList.Create;

        Counter.IncCount( Count_Item );
end;

destructor TItem.Free;
begin
        Counter.DecCount( Count_Item );

        RemoveMultiItems;
        MultiCache.Free;

        if Texture <> nil then begin
                Palanthir.Data.DecStaticArt( Texture.ID - $4000, Texture.Hue );
        end;

        inherited Free;
end;

function TItem.IsVisible : Boolean;
var     PosX, PosY : Integer;
begin
        if (Id = CorpseID) then begin
                Result := True;
                exit;
        end;

        if (Id = $1) or (Id = $21BC) then begin
                Result := False;
                exit;
        end;

        if (Texture = nil) then begin
                DrawId := $0;
                GetTexture;

                if Texture = nil then begin
                        Result := False;
                        exit;
                end;
        end;

        PosX := ( Palanthir.GameWindow.Breite div 2 ) + (Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y) * 22 - ( Texture.Breite div 2 );
        PosY := ( Palanthir.GameWindow.Hoehe div 2 ) + (Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y) * 22 - Pos.Z*4 - Texture.Hoehe +44 + Palanthir.Player.Pos.Z*4;

        if (PosX - 44 >= Palanthir.GameWindow.Breite) or (PosY - 44 >= Palanthir.GameWindow.Hoehe) or (PosX + Texture.Breite + 44 < 0) or (PosY + Texture.Hoehe + 44 < 0) then
                Result := False
        else
                Result := True;
end;

procedure TItem.GetTexture;
begin
        if ID <> CorpseID then begin
                if (Texture = nil) or (Texture.ID <> DrawID) or (Texture.Hue <> DrawColor) then begin
                        if Texture <> nil then
                                Palanthir.Data.DecStaticArt( Texture.ID - $4000, Texture.Hue );
                        Texture := Palanthir.Data.GetStaticArt( DrawID, DrawColor );
                        if Texture <> nil then
                                Palanthir.Data.IncStaticArt( DrawID, DrawColor );
                end;
        end
        else begin
                Texture := nil;
        end;
end;

procedure TItem.Draw;
var     Dir, Nr : ShortInt;
        Gespiegelt, LichtZeichnen : Boolean;
        AnimId, AnimTexID, Hue, AmountId : Word;
        AnimTexture : TAnimObject;
        OPosX, OPosY, CPosX, CPosY, PosX, PosY : Integer;
        I, J : Integer;
        EquipItem : TItem;
        Transparenz : Word;
        ItemList : TList;
        Diff : Integer;
        TmpTexture : TTexObject;
begin
        if IsMulti then begin
                exit;
        end;

        if Palanthir.IsOnInvisList( Id ) or Palanthir.IsOnServerInvisList( Id ) then
                exit;

        if Palanthir.IsUnderMap then begin
                if Palanthir.UnderMapOsiMode and ( Pos.Z >= Palanthir.Player.Pos.Z+15 ) then begin
                        exit;
                end
                else if (not Palanthir.UnderMapOsiMode) and (Pos.Z+4 >= Palanthir.Data.GetMapHeight( Pos.X, Pos.Y )) then begin
                        exit;
                end;
        end;

        if Palanthir.DebugMode and HasFlag( Flag_Debug ) then
                exit;

        Timer.Continue( Timer_AllItems );
        Timer.Start( Timer_Items );

        if ID = CorpseID then begin
                Texture := nil;
                
                Dir := Direction;
                if Dir < 0 then begin
                        Dir := Dir + 128;
                        Nr := 1;
                end
                else begin
                        Dir := Dir;
                        Nr := 0;
                end;


                if Dir < 3 then begin
                        Gespiegelt := True;
                        AnimId := 3 - Dir;
                end
                else begin
                        Gespiegelt := False;
                        AnimId := Dir - 3;
                end;

                AnimId := AnimId + Palanthir.Data.GetCorpseID( Amount, Nr )*5;
                if Amount < 200 then
                        AnimTexture := Palanthir.Data.GetCorpseTexture( Amount, AnimId, Color, 3 )
                else if Amount < 400 then
                        AnimTexture := Palanthir.Data.GetCorpseTexture( Amount, AnimId, Color, 5 )
                else
                        AnimTexture := Palanthir.Data.GetCorpseTexture( Amount, AnimId, Color, 5 );
                                        
                if AnimTexture = nil then
                        exit;

                OPosX := Palanthir.RelDrawX + (Pos.X - Pos.Y) * 22;
                OPosY := Palanthir.RelDrawY + (Pos.X + Pos.Y) * 22 - Pos.Z*4 +22;

                if not Gespiegelt then begin
                        CPosX := OPosX - AnimTexture.CenterX;
                        CPosY := OPosY - AnimTexture.CenterY - AnimTexture.Hoehe;
                end
                else begin
                        CPosX := OPosX - AnimTexture.Breite + AnimTexture.CenterX;
                        CPosY := OPosY - AnimTexture.CenterY - AnimTexture.Hoehe;
                end;

                Renderer.DrawPixelsZoom( CPosX, CPosY, AnimTexture, Gespiegelt, 1, 1 );
                Palanthir.Maus.CheckObject( CPosX, CPosY, Self, AnimTexture );

                SortContainer;
                if Content.Count > 0 then begin
                        for J := 0 to Content.Count-1 do begin
                                EquipItem := TItem( Content.Items[ J ] );
                                if (EquipItem.Layer > 0) and (EquipItem.Layer < 25) and (EquipItem.Layer <> 21) then begin
                                        AnimTexId := Palanthir.Data.Tiledata.GetStaticAnimId( EquipItem.ID );
                                        if Palanthir.Data.Tiledata.GetStaticFlag( EquipItem.ID, dPARTIALHUE ) then
                                                AnimTexture := Palanthir.Data.GetCorpseTexture( AnimTexId, AnimId, EquipItem.Color + $8000, 5 )
                                        else
                                                AnimTexture := Palanthir.Data.GetCorpseTexture( AnimTexId, AnimId, EquipItem.Color, 5 );
                                        if Animtexture <> nil then begin
                                                if not Gespiegelt then begin
                                                        PosX := OPosX - AnimTexture.CenterX;
                                                        PosY := OPosY - AnimTexture.CenterY - AnimTexture.Hoehe;
                                                end
                                                else begin
                                                        PosX := OPosX - AnimTexture.Breite + AnimTexture.CenterX;
                                                        PosY := OPosY - AnimTexture.CenterY - AnimTexture.Hoehe;
                                                end;
                                                Renderer.DrawPixelsZoom( PosX, PosY, AnimTexture, Gespiegelt, 1, 1 );
                                                Palanthir.Maus.CheckObject( PosX, PosY, Self, AnimTexture );
                                        end;
                                end;
                        end;
                end;
                exit;
        end;

        if (Self = Palanthir.Maus.SelectedUObject) and (Config.GetBool( 'AlwaysHightlight' ) or (Movable and (Palanthir.Data.Tiledata.GetStaticWeight( Id ) <> 255)) ) then
                DrawColor := SelectionColor
        else
                DrawColor := Color;

        if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                DrawID := Palanthir.ItemAnimCache.GetCurrentId( ID )
        else
                DrawID := ID;

        if Amount > 1 then begin
                AmountId := Palanthir.Shard.GetAmountId( Id, Amount );
                if AmountId > 0 then
                        DrawId := AmountId;
        end;

        GetTexture;

        if Texture = nil then begin
                Timer.Stop( Timer_Items );
                Timer.Pause( Timer_AllItems );
                exit;
        end;

        if ( Pos.Z >= Palanthir.RoofHeight ) or ((Palanthir.RoofHeight <> $FFFF) and Palanthir.Data.Tiledata.GetStaticFlag( Id, dROOF )) then begin
                if Light <> nil then begin
                        Palanthir.LightManager.RemoveLight( Light );
                end;
                Timer.Stop( Timer_Items );
                Timer.Pause( Timer_AllItems );
                exit;
        end;

        if not Visible then begin
                DrawColor := $385;
        end;

        if Palanthir.Data.Tiledata.GetStaticFlag( ID, dTRANSLUCENT ) then begin
                Transparenz := ItemTransparenz;
        end
        else if Palanthir.Data.Tiledata.GetStaticFlag( Id, dFOLIAGE ) then begin
                Transparenz := 255;
                
                Diff := Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y;
                if (Diff > 0) and (Diff <= 6) then begin
                        Diff := Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y;
                        if (Diff <= 6) and (Diff >= -4) then
                                Transparenz := FoliageTransparenz;
                end;
        end
        else begin
                Transparenz := 255;
        end;

        PosX := Palanthir.RelDrawX + (Pos.X - Pos.Y) * 22 - ( Texture.Breite div 2 );
        PosY := Palanthir.RelDrawY + (Pos.X + Pos.Y) * 22 - Pos.Z*4 - Texture.Hoehe +44;

        if (Amount = 1) or (AmountId > 0) then begin
                Renderer.DrawPixelsTransp( PosX, PosY, Texture, Transparenz );
        end
        else begin
                Renderer.DrawPixelsTransp( PosX-2, PosY-5, Texture, Transparenz );
                Renderer.DrawPixelsTransp( PosX+3, PosY, Texture, Transparenz );
        end;

        if (Transparenz <> FoliageTransparenz) then begin         //Spter ev. wieder rausmachen
                Palanthir.Maus.CheckObject( PosX, PosY, Self, Texture );
        end;

        if Speech <> nil then begin
                Speech.Visible := True;
                if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then begin
                        TmpTexture := Palanthir.Data.GetStaticArt( Id, Color );
                        Speech.Y := PosY + TmpTexture.Hoehe div 2;
                        Speech.X := PosX + TmpTexture.Breite div 2;
                end
                else begin
                        Speech.Y := PosY + Texture.Hoehe div 2;
                        Speech.X := PosX + Texture.Breite div 2;
                end;
        end;

        if Palanthir.Data.Tiledata.GetStaticFlag( Id, dLIGHTSOURCE ) and Palanthir.LightManager.Enabled then begin
                LichtZeichnen := True;
                //lichter in husern sollen net leuchten wenn man draussen steht
                ItemList := Palanthir.Data.WorldCache.GetStaticObjects( Pos.X, Pos.Y );
                for I := 0 to ItemList.Count-1 do begin
                        if (TStaticItem( ItemList.Items[ I ] ).Pos.Z > Pos.Z+5) and
                           (TStaticItem( ItemList.Items[ I ] ).Pos.Z < Pos.Z+30) and
                           (TStaticItem( ItemList.Items[ I ] ).Pos.Z <= Palanthir.RoofHeight ) and
                           ((Palanthir.Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dSURFACE )) or
                           (Palanthir.Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dROOF ))) then begin
                                LichtZeichnen := False;
                                break;
                        end;
                end;
                ItemList.Free;

                if LichtZeichnen then begin
                        ItemList := Palanthir.Data.WorldCache.GetItems( Pos.X, Pos.Y );
                        for I := 0 to ItemList.Count-1 do
                                if (TUObject( ItemList.Items[ I ] ).Pos.Z < Pos.Z+30) and
                                (TUObject( ItemList.Items[ I ] ).Pos.Z > Pos.Z+5) and
                                (TUObject( ItemList.Items[ I ] ).Pos.Z <= Palanthir.RoofHeight ) and
                                ((Palanthir.Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dSURFACE )) or
                                (Palanthir.Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dROOF ))) then begin
                                        LichtZeichnen := False;
                                        break;
                                end;
                        ItemList.Free;
                end;

                if LichtZeichnen then begin
                        PosX := PosX + ( Texture.Breite div 2 ) - Palanthir.GameWindow.X;
                        PosY := PosY + ( Texture.Hoehe div 2 ) - Palanthir.GameWindow.Y;

                        if Light = nil then begin
                                Light := TLight.Create( PosX, PosY, Direction, GetLightColor );
                                Light.UODrawObject := Self;
                                Palanthir.LightManager.AddLight( Light );
                        end
                        else begin
                                Light.PosX := PosX;
                                Light.PosY := PosY;
                                Light.Id := Direction;
                                Light.Color := GetLightColor;
                        end;
                end else if Light <> nil then begin
                        Palanthir.LightManager.RemoveLight( Light );
                        Light := nil;
                end;
        end;
        
        Timer.Stop( Timer_Items );
        Timer.Pause( Timer_AllItems );
end;

function TItem.IsItem : Boolean;
begin
        Result := True;
end;

procedure TItem.Update( Packet : GetItem );
var     K : Word;
        X, Y : Integer;
        Flag : Byte;
        OldId : Word;
        Diff : ShortInt;
        OldPos, NewPos : TPos;
        WasMulti : Boolean;
begin
        OldId := Id;
        OldPos := TPos.Create;
        OldPos.SetPos( Pos );
        WasMulti := IsMulti;

        NewPos := TPos.Create;

        if Palanthir.UseItemUpdateIdFlag then
                ID := Packet.getId mod $8000
        else
                ID := Packet.getId;
        DrawId := Id;
        K := 9;
        if ( Packet.getSerial and $80000000 ) = $80000000 then begin
                Amount := Packet.GetWord( K );
                Inc( K, 2 );
        end
        else begin
                Amount := 1;
        end;

        if (( Packet.getId and $8000 ) = $8000) and Palanthir.UseItemUpdateIdFlag then begin
                Diff := Packet.GetByte( K );
                ID := ID + Diff;
                Inc( K, 1 );
        end;
        X := Packet.GetWord( K );
        Inc( K, 2 );
        Y := Packet.GetWord( K );
        Inc( K, 2 );

        NewPos.X := X mod $8000;
        NewPos.Y := Y mod $4000;

        if ( X and $8000 ) = $8000 then begin
                Direction := Packet.GetByte( K );
                inc( K );
        end
        else
                Direction := 0;

        NewPos.Z := Packet.GetByte( K );
        inc( K );
        if ( Y and $8000 ) = $8000 then begin
                Color := Packet.GetWord( K );
                inc( K, 2 );
        end
        else
                Color := 0;

        if ( Y and $4000 ) = $4000 then begin
                Flag := Packet.GetByte( K );

                if ( Flag and $20 ) = $20 then
                        Movable := True
                else
                        Movable := False;

                if ( Flag and $80 ) = $80 then
                        Visible := False
                else
                        Visible := True;
        end
        else begin
                Movable := False;
                Visible := True;
        end;

        if Container <> nil then
                RemoveFromCont;        

        if ( NewPos.GetBlockID <> Pos.GetBlockID ) or ( OldId <> Id ) then begin
                if Registered then begin
                        UnRegisterObject;
                end;
        end;

        Container := nil;

        Pos.SetPos( NewPos );
        NewPos.Free;

        if not Registered then
                RegisterObject;
        Palanthir.WorldListSorted := False;

        if WasMulti and (not IsMulti) then begin
                RemoveMultiItems;
        end;

        if IsMulti and ((not WasMulti) or (not OldPos.Equals( Pos )) or (Id <> OldId)) then begin
                if WasMulti then
                        RemoveMultiItems;
                AddMultiItems;
        end;

        OldPos.Free;

        LastUpdated := CustomGetTickCount;
end;

procedure TItem.MoveTo( X, Y : Word; Z : ShortInt; Map : Byte );
var     NewPos, OldPos : TPos;
begin
        OldPos := TPos.Create;
        OldPos.SetPos( Pos );
        NewPos := TPos.Create( X, Y, Z, Map );

        if Container <> nil then
                RemoveFromCont;

        if (NewPos.GetBlockID <> BlockID) and Registered then begin
                UnRegisterObject;
        end;

        Container := nil;
        Pos.SetPos( NewPos );
        if not Registered then begin
                RegisterObject;
        end;

        if IsMulti and (not OldPos.Equals( Pos )) then begin
                RemoveMultiItems;
                AddMultiItems;
        end;

        OldPos.Free;
        NewPos.Free;
end;

procedure TItem.RemoveFromCont;
begin
        Container.RemoveObjectFromCont( Self );
end;

procedure TItem.AddItem( Item : TItem );
begin
        Content.Add( Item );

        Palanthir.ScriptManager.OnAddItemToCont( Self, Item );        
end;

procedure TItem.GrabItem;
var     Request : TItemPickupRequest;
        GrabItemGump : TGrabItemGump;
        I : Integer;
begin
        if (Container <> nil) and Container.IsChar and ( (Layer = Layer_Hair) or (Layer = Layer_FacialHair) ) then
                exit;

        if (Amount > 1) and (ID <> CorpseID) then begin
                for I := Palanthir.GetGumpCount-1 downto 0 do
                        if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_GrabItem then
                                if TGrabItemGump( Palanthir.GetGump( I ) ).ItemSerial = Serial then begin
                                        Palanthir.DeleteGump( Palanthir.GetGump( I ) );
                                end;

                GrabItemGump := TGrabItemGump.Create;
                GrabItemGump.Init( Self );
                GrabItemGump.X := Palanthir.Maus.AktX - 20;
                GrabItemGump.Y := Palanthir.Maus.AktY - 20;
                GrabItemGump.noClose := False;
                Palanthir.AddGump( GrabItemGump );

                Palanthir.Keyboard.KeyboardMode := KB_Gump;
                Palanthir.Keyboard.SelectedGumpObject := GrabItemGump.InputField;
                GrabItemGump.InputField.SelectedPos := Length( GrabItemGump.InputField.Text ) + 1;
                GrabItemGump.InputField.DeleteTextOnNextChange := True;
                GrabItemGump.HasAlreadyChanged := False;

                Palanthir.Maus.SelectedGumpObject := GrabItemGump.InputField;
                Palanthir.Maus.SelectedDownLGumpObject := GrabItemGump.InputField;
                Palanthir.Maus.SelectedUObject := nil;
                Palanthir.Maus.SelectedDownLUObject := nil;
        end
        else begin
                Palanthir.Maus.DragSerial := Serial;
                Palanthir.Maus.DragId := Id;
                Palanthir.Maus.DragColor := Color;
                Palanthir.Maus.DragAmount := 1;
                Palanthir.Maus.DragLayer := Palanthir.Data.Tiledata.GetStaticQuality( Id );

                Request := TItemPickupRequest.Create;
                Request.SetSerial( Serial );
                Request.SetAmount( 1 );
                Palanthir.NetClient.Send( Request );
        end;
end;

function TItem.IsMulti : Boolean;
begin
        Result := ( Id >= Palanthir.FirstMultiId ) and ( Id <= Palanthir.LastMultiId );
end;

procedure TItem.AddMultiItems;
var     ItemListe : TList;
        I : Integer;
        BasicItem : TBasicMultiItem;
        MultiItem : TMultiItem;
        Block : TWorldBlock;
begin
        ItemListe := Palanthir.Data.GetMultiItems( Id - Palanthir.FirstMultiID );

        for I := 0 to ItemListe.Count-1 do begin
                BasicItem := TBasicMultiItem( ItemListe.Items[ I ] );

                if (BasicItem.Flag and $1 = $1) then begin
                        MultiItem := TMultiItem.Create;
                        MultiItem.ID := BasicItem.ID;
                        MultiItem.Pos.X := Pos.X + BasicItem.X;
                        MultiItem.Pos.Y := Pos.Y + BasicItem.Y;
                        MultiItem.Pos.Z := Pos.Z + BasicItem.Z;
                        MultiItem.Owner := Self;
                        MultiCache.Add( MultiItem );

                        Block := Palanthir.Data.WorldCache.GetObject( MultiItem.BlockID );
                        Block.MultiCache.Add( MultiItem );
                        if Block.Visible then
                                Palanthir.AddWorldItem( MultiItem );
                end;
        end;
        ItemListe.Free;
end;

procedure TItem.RemoveMultiItems;
var     I, J : Integer;
        MultiItem : TMultiItem;
        Block : TWorldBlock;
begin
        for I := MultiCache.Count-1 downto 0 do begin
                MultiItem := TMultiItem( MultiCache.Items[ I ] );
                MultiCache.Delete( I );
                
                Block := Palanthir.Data.WorldCache.GetObject( MultiItem.BlockID );

                if Block.Visible then
                        Palanthir.RemoveWorldItem( MultiItem );

                for J := 0 to Block.MultiCache.Count-1 do
                        if TMultiItem( Block.MultiCache.Items[ J ] ) = MultiItem then begin
                                Block.MultiCache.Delete( J );
                                Break;
                        end;
                MultiItem.Free;
        end;
end;

constructor TMultiItem.Create;
begin
        inherited Create;
        Owner := nil;
        Typ := typ_multiitem;
end;

destructor TMultiItem.Free;
begin
        if Texture <> nil then begin
                Palanthir.Data.DecStaticArt( Texture.ID - $4000, Texture.Hue );
        end;

        inherited Free;
end;

procedure TMultiItem.GetTexture;
begin
        if Texture <> nil then
                Palanthir.Data.DecStaticArt( Texture.ID - $4000, Texture.Hue );
        Texture := Palanthir.Data.GetStaticArt( DrawID, Color );

        if Texture <> nil then
                Palanthir.Data.IncStaticArt( DrawId, Color );
end;

procedure TMultiItem.Draw;
var     Transparenz : Word;
        PosX, PosY : Integer;
        Diff : Integer;
        TmpTexture : TTexObject;
begin
        if Palanthir.DebugMode and HasFlag( Flag_Debug ) then
                exit;

        if Palanthir.IsOnInvisList( Id ) or Palanthir.IsOnServerInvisList( Id ) then
                exit;

        if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then
                DrawID := Palanthir.ItemAnimCache.GetCurrentId( ID )
        else
                DrawID := ID;

        GetTexture;

        if Texture = nil then
                exit;

        if ( Pos.Z >= Palanthir.RoofHeight ) or ((Palanthir.RoofHeight <> $FFFF) and Palanthir.Data.Tiledata.GetStaticFlag( Id, dROOF )) then
                exit;

        if Palanthir.IsUnderMap then begin
                if Palanthir.UnderMapOsiMode and ( Pos.Z >= Palanthir.Player.Pos.Z+15 ) then begin
                        exit;
                end
                else if (not Palanthir.UnderMapOsiMode) and (Pos.Z+4 >= Palanthir.Data.GetMapHeight( Pos.X, Pos.Y )) then begin
                        exit;
                end;
        end;

        if Palanthir.Data.Tiledata.GetStaticFlag( ID, dTRANSLUCENT ) then begin
                Transparenz := ItemTransparenz;
        end
        else if Palanthir.Data.Tiledata.GetStaticFlag( Id, dFOLIAGE ) then begin
                Transparenz := 255;        
                Diff := Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y;
                if (Diff > 0) and (Diff <= 6) then begin
                        Diff := Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y;
                        if (Diff <= 6) and (Diff >= -4) then
                                Transparenz := FoliageTransparenz;
                end;
        end
        else begin
                Transparenz := 255;
        end;

        PosX := Palanthir.RelDrawX + (Pos.X - Pos.Y) * 22 - ( Texture.Breite div 2 );
        PosY := Palanthir.RelDrawY + (Pos.X + Pos.Y) * 22 - Pos.Z*4 - Texture.Hoehe +44;

        if Speech <> nil then begin
                Speech.Visible := True;
                if Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) then begin
                        TmpTexture := Palanthir.Data.GetStaticArt( Id, Color );
                        Speech.Y := PosY + TmpTexture.Hoehe div 2;
                        Speech.X := PosX + TmpTexture.Breite div 2;
                end
                else begin
                        Speech.Y := PosY + Texture.Hoehe div 2;
                        Speech.X := PosX + Texture.Breite div 2;
                end;
        end;

        Renderer.DrawPixelsTransp( PosX, PosY, Texture, Transparenz );
        if (Transparenz <> FoliageTransparenz) then
                Palanthir.Maus.CheckObject( PosX, PosY, Self, Texture );
end;

procedure TMultiItem.OnClick;
var     Text : TSpeechText;
        Zeile : String;
begin
        if (Owner <> nil) and Palanthir.ScriptManager.OnClick( Owner ) then begin
                Exit;
        end;

        Zeile := Palanthir.Data.GetClilocMessage( 1020000 + Id );
        if Zeile = '' then
                Zeile := Palanthir.Data.Tiledata.GetStaticName( Id );

        if Zeile = '' then
                exit;

        if Speech <> nil then begin
                Palanthir.RemoveSpeech( Speech );
                Speech.Free;
        end;

        Speech := TSpeech.Create;
        Speech.SetDrawObjectType;
        Speech.UObject := Self;
        Palanthir.AddSpeech( Speech );

        Text := TSpeechText.Create( 0, 0, Zeile, 200, 0, CustomGetTickCount + 15*1000 );
        Text.Speech := Speech;
        Speech.Add( Text );
end;

procedure TMultiItem.OnDblClick;
begin
        if Owner <> nil then
                Owner.OnDblClick;
end;

function TMultiItem.IsVisible : Boolean;
var     PosX, PosY : Integer;
begin
        if (Id = $1) or (Id = $21BC) then begin
                Result := False;
                exit;
        end;

        if (Texture = nil) then begin
                DrawId := $0;
                GetTexture;

                if Texture = nil then begin
                        Result := False;
                        exit;
                end;
        end;

        PosX := ( Palanthir.GameWindow.Breite div 2 ) + (Pos.X-Palanthir.Player.Pos.X - Pos.Y+Palanthir.Player.Pos.Y) * 22 - ( Texture.Breite div 2 );
        PosY := ( Palanthir.GameWindow.Hoehe div 2 ) + (Pos.X-Palanthir.Player.Pos.X + Pos.Y-Palanthir.Player.Pos.Y) * 22 - Pos.Z*4 - Texture.Hoehe +44 + Palanthir.Player.Pos.Z*4;

        if (PosX - 44 >= Palanthir.GameWindow.Breite) or (PosY - 44 >= Palanthir.GameWindow.Hoehe) or (PosX + Texture.Breite + 44 < 0) or (PosY + Texture.Hoehe + 44 < 0) then
                Result := False
        else
                Result := True;
end;

function TMultiItem.IsMultiItem : Boolean;
begin
        Result := True;
end;

end.
