unit uItemAnimCache;

interface

uses    Classes, SysUtils, Dialogs, uLoaderAnimdata, Windows, uLog;

type    TAnimIndex = packed record
                BaseId : Word;
                NextChange : Integer;
                CurrentCount : Word;
                CurrentId : Word;
                Count : Byte;
        end;

        PAnimIndex = ^TAnimIndex;

type    TItemAnimCache = Class
                private
                        Cache : TList;
                public
                        constructor Create;
                        destructor Free;
                        procedure AddAnim( Id, Hue : Word );
                        procedure RemoveAnim( Id, Hue : Word );
                        procedure Poll;
                        function GetCurrentId( Id : Word ) : Word;
                        procedure LoadAnim( Id, Hue : Word; Anim : PAnimIndex );
                        procedure UnloadAnim( Id, Hue : Word; Anim : PAnimIndex );
        end;

implementation

uses    uPalanthir;

constructor TItemAnimCache.Create;
begin
        Cache := TList.Create;
end;

destructor TItemAnimCache.Free;
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do
                Dispose( PAnimIndex( Cache.Items[ I ] ) );
        Cache.Free;
end;

procedure TItemAnimCache.AddAnim( Id, Hue : Word );
var     I : Integer;
        Anim : PAnimIndex;
        Gefunden : Boolean;
begin
        if not Palanthir.Data.Animdata.Exists( Id ) then begin
                exit;
        end;

        Gefunden := False;
        if Cache.Count > 0 then
                for I := 0 to Cache.Count-1 do
                        if PAnimIndex( Cache.Items[ I ] ).BaseId = Id then begin
                                Anim := PAnimIndex( Cache.Items[ I ] );
                                Inc( Anim.Count );
                                Gefunden := True;
                                Break;
                        end;

        if not Gefunden then begin
                new( Anim );
                Anim.BaseId := Id;
                Anim.NextChange := GetTickCount + Palanthir.Data.Animdata.GetStartTime( Id )*100;
                Anim.CurrentCount := 0;
                Anim.CurrentId := Id;
                Anim.Count := 1;
                Cache.Add( Anim );
        end;

        LoadAnim( Id, Hue, Anim );
end;

procedure TItemAnimCache.RemoveAnim( Id, Hue : Word );
var     I : Integer;
        Anim : PAnimIndex;
begin
        if Cache.Count > 0 then
                for I := 0 to Cache.Count-1 do
                        if PAnimIndex( Cache.Items[ I ] ).BaseId = Id then begin
                                Anim := PAnimIndex( Cache.Items[ I ] );
                                UnloadAnim( Id, Hue, Anim );
                                if Anim.Count > 1 then begin
                                        Dec( Anim.Count );
                                        exit;
                                end
                                else begin
                                        Dispose( Anim );
                                        Cache.Delete( I );
                                        exit;
                                end;
                        end;
end;

procedure TItemAnimCache.Poll;
var     I : Integer;
        Anim : PAnimIndex;
begin
        if Cache.Count > 0 then
                for I := 0 to Cache.Count-1 do begin
                        Anim := PAnimIndex( Cache.Items[ I ] );
                        if Anim.NextChange <= GetTickCount then begin
                                Anim.CurrentCount := Anim.CurrentCount + 1;
                                if Anim.CurrentCount >= Palanthir.Data.Animdata.GetCount( Anim.BaseId ) then
                                        Anim.CurrentCount := 0;
                                Anim.CurrentId := Palanthir.Data.Animdata.GetFrame( Anim.BaseId, Anim.CurrentCount );
                                if Anim.CurrentCount = 0 then
                                        Anim.NextChange := GetTickCount + ( Palanthir.Data.Animdata.GetStartTime( Anim.BaseId ) + Palanthir.Data.Animdata.GetDelay( Anim.BaseId ) )*100
                                else
                                        Anim.NextChange := GetTickCount + Palanthir.Data.Animdata.GetDelay( Anim.BaseId )*100;
                        end;
                end;
end;

function TItemAnimCache.GetCurrentId( Id : Word ) : Word;
var     I : Integer;
begin
        if Cache.Count > 0 then
                for I := 0 to Cache.Count-1 do begin
                        if PAnimIndex( Cache.Items[ I ] ).BaseId = Id then begin
                                Result := PAnimIndex( Cache.Items[ I ] ).CurrentId;
                                exit;
                        end;
                end;

        Result := Id;
end;

procedure TItemAnimCache.LoadAnim( Id, Hue : Word; Anim : PAnimIndex );
var     I : Integer;
begin
        for I := 0 to Palanthir.Data.Animdata.GetCount( Anim.BaseId )-1 do begin
                if Palanthir.Data.GetStaticArt( Palanthir.Data.Animdata.GetFrame( Anim.BaseId, I ), Hue ) <> nil then
                        Palanthir.Data.IncStaticArt( Palanthir.Data.Animdata.GetFrame( Anim.BaseId, I ), Hue )
        end;
end;

procedure TItemAnimCache.UnloadAnim( Id, Hue : Word; Anim : PAnimIndex );
var     I : Integer;
begin
        for I := 0 to Palanthir.Data.Animdata.GetCount( Anim.BaseId )-1 do begin
                if Palanthir.Data.GetStaticArt( Palanthir.Data.Animdata.GetFrame( Anim.BaseId, I ), Hue ) <> nil then
                        Palanthir.Data.DecStaticArt( Palanthir.Data.Animdata.GetFrame( Anim.BaseId, I ), Hue )
        end;
end;

end.
