unit uKeyboard;

interface

uses    uTexCache, uGumps, uRenderer, SysUtils, Classes, uUtilities, uConfig;

type    TKeyboard = Class
                private
                        _EmoteColor : Word;
                        _Font : Word;
                        _SpeechColor : Word;
                        _SpeechText : WideString;
                        _Typ : Byte;
                        _TempText : WideString;
                        _SelPos : Integer;
                        Texture : TTexObject;
                        Selected : Boolean;
                        LastTextNr : Integer;
                        procedure GetTexture;
                        procedure SetEmoteColor( Value : Word );
                        procedure SetFont( Value : Word );
                        procedure SetSpeechColor( Value : Word );
                        procedure SetSpeechText( Value : WideString );
                        procedure SetTyp( Value : Byte );
                        procedure SetSelPos( Value : Integer );
                public
                        KeyboardMode : Byte;
                        Language : String;
                        SelectedGumpObject : TGumpObject;
                        TextList : TList;
                        PlayerId, MessageId : LongWord;
                        property EmoteColor : Word read _EmoteColor write SetEmoteColor;
                        property Font : Word read _Font write SetFont;
                        property SpeechColor : Word read _SpeechColor write SetSpeechColor;
                        property SpeechText : WideString read _TempText write SetSpeechText;
                        property Typ : Byte read _Typ write SetTyp;
                        property SelPos : Integer read _SelPos write SetSelPos;
                        procedure AddText( Text : WideString; Typ : Byte );
                        procedure GetLastText;
                        procedure GetNextText;
                        constructor Create;
                        destructor Free;
                        procedure Draw;
        end;

        TTextEntry = Class
                public
                        Text : String;
                        Typ : Byte;
                        constructor Create( Text : WideString; Typ : Byte );
                        destructor Free;
        end;

implementation

uses    uPalanthir;

constructor TTextEntry.Create( Text : WideString; Typ : Byte );
begin
        Self.Text := Text;
        Self.Typ := Typ;
end;

destructor TTextEntry.Free;
begin
end;

procedure TKeyboard.GetTexture;
begin
        if Texture <> nil then begin
                Texture.Free;
                Texture := nil;
        end;

        if Typ = KB_Speech_Emote then begin
                if Selected then
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Emote: ' + SpeechText, EmoteColor, Palanthir.GameWindow.Breite, 1, SelPos + 8 )
                else
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Emote: ' + SpeechText, EmoteColor, Palanthir.GameWindow.Breite, 1 );
        end
        else if Typ = KB_Speech_Whisper then begin
                if Selected then
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Whisper: ' + SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1, SelPos + 10 )
                else
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Whisper: ' + SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1 );
        end
        else if Typ = KB_Speech_Yell then begin
                if Selected then
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Yell: ' + SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1, SelPos + 7 )
                else
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Yell: ' + SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1 );
        end
        else if Typ = KB_Speech_Party then begin
                if Palanthir.Player.Party.TalkToSerial = Invalid_Serial then begin
                        if Selected then
                                Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Party: ' + SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1, SelPos + 8 )
                        else
                                Texture := Palanthir.Data.GetUnicodeTexture( 3, 'Party: ' + SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1 );
                end
                else begin
                        if Selected then
                                Texture := Palanthir.Data.GetUnicodeTexture( 3, Format( 'Party [%s]: %s', [Palanthir.Player.Party.GetMemberName( Palanthir.Player.Party.TalkToSerial ),SpeechText] ), SpeechColor, Palanthir.GameWindow.Breite, 1, SelPos + 8 )
                        else
                                Texture := Palanthir.Data.GetUnicodeTexture( 3, Format( 'Party [%s]: %s', [Palanthir.Player.Party.GetMemberName( Palanthir.Player.Party.TalkToSerial ),SpeechText] ), SpeechColor, Palanthir.GameWindow.Breite, 1 );
                end;

        end
        else if ((SpeechText <> '') or Selected) and (Palanthir.GameWindow <> nil) then begin
                if Selected then
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1, SelPos +1 )
                else
                        Texture := Palanthir.Data.GetUnicodeTexture( 3, SpeechText, SpeechColor, Palanthir.GameWindow.Breite, 1 );
        end;
end;

procedure TKeyboard.SetEmoteColor( Value : Word );
begin
        if EmoteColor <> Value then begin
                _EmoteColor := Value;
                if Typ = KB_Speech_Emote then
                        if SpeechText <> '' then
                                GetTexture;
        end;
end;

procedure TKeyboard.SetFont( Value : Word );
begin
        if Font <> Value then begin
                _Font := Value;
                if SpeechText <> '' then
                        GetTexture;
        end;
end;

procedure TKeyboard.SetSpeechColor( Value : Word );
begin
        if SpeechColor <> Value then begin
                _SpeechColor := Value;
                if Typ <> KB_Speech_Emote then
                        if Speechtext <> '' then
                                GetTexture;
        end;
end;

procedure TKeyboard.SetSpeechText( Value : WideString );
begin
        if _TempText <> Value then begin
                _TempText := Value;
        end;
        LastTextNr := 0;
end;

procedure TKeyboard.SetTyp( Value : Byte );
begin
        if Typ <> Value then begin
                _Typ := Value;
                GetTexture;
        end;
end;

procedure TKeyboard.SetSelPos( Value : Integer );
begin
        if SelPos <> Value then begin
                _SelPos := Value;
                GetTexture;
        end;
end;

constructor TKeyboard.Create;
begin
        KeyboardMode := KB_None;
        SelectedGumpObject := nil;
        Selected := False;
        _SpeechText := '';
        _TempText := '';
        Typ := KB_Speech_Regular;
        SpeechColor := Config.GetInteger( 'SpeechColor' );
        EmoteColor := Config.GetInteger( 'EmoteColor' );
        Font := $6;
        SelPos := 0;
        Language := 'DEU';
        Texture := nil;
        TextList := TList.Create;
end;

destructor TKeyboard.Free;
begin
        if Texture <> nil then
                Texture.Free;

        while TextList.Count > 0 do begin
                TTextEntry( TextList.Items[ TextList.Count-1 ] ).Free;
                TextList.Delete( TextList.Count-1 );
        end;
        TextList.Free;
end;

procedure TKeyboard.Draw;
begin
        if (_TempText <> _SpeechText) then begin
                _SpeechText := _TempText;
                GetTexture;
        end;

        if Selected and (SelectedGumpObject <> nil) then begin
                Selected := False;
                GetTexture;
        end;
        if (not Selected) and (SelectedGumpObject = nil) then begin
                Selected := True;
                GetTexture;
        end;

        if Texture = nil then
                exit;

        Renderer.DrawPixels( Palanthir.GameWindow.X+5, Palanthir.GameWindow.Y+Palanthir.GameWindow.Hoehe-25, Texture );
end;

procedure TKeyboard.AddText( Text : WideString; Typ : Byte );
var     TextEntry : TTextEntry;
begin
        TextEntry := TTextEntry.Create( Text, Typ );
        TextList.Insert( 0, TextEntry );

        while TextList.Count > 50 do begin
                TTextEntry( TextList.Items[ TextList.Count-1 ] ).Free;
                TextList.Delete( TextList.Count-1 );
        end;
end;

procedure TKeyboard.GetLastText;
var     TextEntry : TTextEntry;
begin
        if LastTextNr < TextList.Count then begin
                TextEntry := TTextEntry( TextList.Items[ LastTextNr ] );
                _Typ := TextEntry.Typ;
                _TempText := TextEntry.Text;
                Inc( LastTextNr );
                SelPos := Length( SpeechText );
                GetTexture;
        end;
end;

procedure TKeyboard.GetNextText;
var     TextEntry : TTextEntry;
begin
        if LastTextNr > 1 then begin
                TextEntry := TTextEntry( TextList.Items[ LastTextNr-2 ] );
                _Typ := TextEntry.Typ;
                _TempText := TextEntry.Text;
                Dec( LastTextNr );
                SelPos := Length( SpeechText );
                GetTexture;
        end
        else if LastTextNr = 1 then begin
                _TempText := '';
                Dec( LastTextNr );
                SelPos := 0;
                GetTexture;
        end;
end;

end.
