unit uLoaderMP3;

interface

uses    Classes, SysUtils, uUtilities, Dialogs, SDL, SDL_Mixer, uLog;

type    TMusicRecord = Record
                ID : Word;
                FileName : String;
                Loop : Boolean;
        end;

        PMusicRecord = ^TMusicRecord;

        TMusic = Class
                private
                        Cache : TList;
                        basePath, shardPath : String;
                public
                        constructor Create( baseDir, shardDir : String );
                        destructor Free;
                        function GetMusic( Id : Word ) : PMusicRecord;
        end;

implementation

constructor TMusic.Create( baseDir, shardDir : String );
var     Liste : TStringList;
        I, P : Integer;
        MRecord : PMusicRecord;
        Zeile : String;
begin
        Cache := TList.Create;

        basePath := baseDir + 'music\digital\';
        shardPath := shardDir + 'music\';

        if not DirectoryExists( shardPath ) then
                ForceDirectories( shardPath );

        Liste := TStringList.Create;
        if (not FileExists( shardPath + 'Config.txt' )) and FileExists( basePath + 'Config.txt' ) then begin
                Liste.LoadFromFile( basePath + 'Config.txt' );
                Liste.SaveToFile( shardPath + 'Config.txt' );
        end
        else if FileExists( shardPath + 'Config.txt' ) then begin
                Liste.LoadFromFile( shardPath + 'Config.txt' );
        end
        else begin
                Liste.Free;
                exit;
        end;

        for I := 0 to Liste.Count-1 do begin
                Zeile := Liste.Strings[ I ];
                P := Pos( ' ', Zeile );
                if P > 0 then begin
                        New( MRecord );
                        MRecord.ID := StrToInt( Copy( Zeile, 1, P-1 ) );
                        Zeile := Copy( Zeile, P+1, Length( Zeile )-P );
                        P := Pos( ',', Zeile );
                        if P > 0 then begin
                                MRecord.FileName := Copy( Zeile, 1, P-1 ) + '.mp3';
                                MRecord.Loop := True;
                        end
                        else begin
                                MRecord.FileName := Zeile + '.mp3';
                                MRecord.Loop := False;
                        end;
                        if FileExists( shardPath + MRecord.FileName ) then
                                MRecord.FileName := shardPath + MRecord.FileName
                        else
                                MRecord.FileName := basePath + MRecord.FileName;
                        Cache.Add( MRecord );
                end;
        end;
        Liste.Free;
end;

destructor TMusic.Free;
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do
                Dispose( PMusicRecord( Cache.Items[ I ] ) );
        Cache.Free;
end;

function TMusic.GetMusic( Id : Word ) : PMusicRecord;
var     I : Integer;
begin
        Result := nil;
        for I := 0 to Cache.Count-1 do begin
                if PMusicRecord( Cache.Items[ I ] ).ID = Id then begin
                        Result := PMusicRecord( Cache.Items[ I ] );
                        break;
                end;
        end;
end;

end.
