unit uMausHandler;

interface

uses    uGumps, uUtilities, Controls, Windows, uUObject, dglOpenGL, Forms,
        Dialogs, SysUtils, uTexCache, uBasicTypedefs, uItem, uSendPackets, uLog,
        uSpecialGumps, uCursors, uLoaderTiledata, uChar, uRenderer,
        uBasicDrawObject, uSpeech, uTimer, Math, uBitMask, uPixelBuffer,
        uGestureHandler;

type    TMaus = Class
                private
                        GestureHandler : TGestureHandler;
                public
                        MX, MY : Integer;
                        AktX, AktY : Integer;
                        RDown, LDown : Boolean;
                        RClick, LClick : Boolean;
                        LDownTime, Uptime, RDownTime : Longword;
                        RXDown, RYDown, LXDown, LYDown : Word;
                        OnRClick, OnLClick, OnDblClick, OnMove, OnDown, OnUp : Boolean;
                        ButtonDown, ButtonUp : TMouseButton;
                        SelectedGumpObject, SelectedDownRGumpObject, SelectedDownLGumpObject : TGumpObject;
                        MObject : TBasicDrawObject;
                        SelectedUObject, SelectedDownRUObject, SelectedDownLUObject : TUODrawObject;
                        SelectedSpeech, SelectedDownRSpeech, SelectedDownLSpeech : TSpeechText;
                        Phi : Real;
                        IsInGameWindow : Boolean;
                        LastMObject : TBasicDrawObject;
                        LastMObjectChange : LongWord;

                        DragSerial : LongWord;
                        DragTexture : TTexObject;
                        DragMulti : TPixelBuffer;
                        DragId, DragColor, DragAmount : Word;
                        DragLayer : Word;
                        OldDragId, OldDragColor : Word;
                        constructor Create;
                        destructor Free;
                        procedure ResetEvents;
                        procedure DownEvent( CoordX, CoordY : Integer; Button : TMouseButton );
                        procedure MoveEvent( CoordX, CoordY : Integer );
                        procedure UpEvent( CoordX, CoordY : Integer; Button : TMouseButton );
                        procedure StartCheck;
                        procedure CheckGump( X, Y : Integer; Breite, Hoehe : Word; GumpObject : TGumpObject; Texture : TTexObject = nil; Always : Boolean = False; MaxX : Integer = -$80000000; MaxY : Integer = -$80000000 ); overload;
                        procedure CheckGump( X, Y : Integer; Breite, Hoehe : Word; GumpObject : TGumpObject; BitMask : TBitMask ); overload;
                        procedure CheckObject( X, Y : Integer; UObject : TUODrawObject; Texture : TTexObject; ZoomX : Real = 1; ZoomY : Real = 1 ); overload;
                        procedure CheckObject( PosX, PosY, X0, Y0, X1, Y1, X2, Y2, X3, Y3 : Integer; UObject : TUODrawObject ); overload;
                        procedure CheckSpeech( X, Y : Integer; SpeechText : TSpeechText; Texture : TTexObject );
                        procedure Poll;
        end;

implementation

uses    uPalanthir;

constructor TMaus.Create;
begin
        RDown := False;
        LDown := False;
        OnRClick := False;
        OnLClick := False;
        OnDblClick := False;
        OnMove := False;
        RClick := False;
        LClick := False;
        OnDown := False;
        OnUp := False;
        SelectedGumpObject := nil;
        SelectedDownRGumpObject := nil;
        SelectedDownLGumpObject := nil;
        SelectedUObject := nil;
        SelectedDownRUObject := nil;
        SelectedDownLUObject := nil;
        SelectedSpeech := nil;
        SelectedDownRSpeech := nil;
        SelectedDownLSpeech := nil;
        DragTexture := nil;
        DragSerial := Invalid_Serial;
        DragId := Invalid_Id;
        DragLayer := 0;
        DragColor := 0;
        OldDragId := Invalid_id;
        OldDragColor := 0;
        DragMulti := nil;
        LastMObject := nil;

        GestureHandler := TGestureHandler.Create;
end;

destructor TMaus.Free;
begin
        if DragMulti <> nil then
                DragMulti.Free;

        GestureHandler.Free;
end;

procedure TMaus.ResetEvents;
begin
        OnRClick := False;
        OnLClick := False;
        OnDblClick := False;
        OnMove := False;
        OnDown := False;
        OnUp := False;
end;

procedure TMaus.DownEvent( CoordX, CoordY : Integer; Button : TMouseButton );
begin
        if Button = mbRight then begin
                RXDown := CoordX;
                RYDown := CoordY;
                RDownTime := CustomGetTickCount;
                RDown := True;
        end
        else begin
                LXDown := CoordX;
                LYDown := CoordY;
                LDownTime := CustomGetTickCount;
                LDown := True;
        end;
        MX := CoordX;
        MY := CoordY;
        ButtonDown := Button;

        OnDown := True;
end;

procedure TMaus.MoveEvent( CoordX, CoordY : Integer );
begin
        if LDown and (DragSerial = Invalid_Serial) and ( not Palanthir.Target.Activated ) then begin
                OnMove := True;
        end
        else begin
                MX := CoordX;
                MY := CoordY;
        end;
        AktX := CoordX;
        AktY := CoordY;
end;

procedure TMaus.UpEvent( CoordX, CoordY : Integer; Button : TMouseButton );
begin
        if Button = mbRight then begin
                RDown := False;
        end else begin
                LDown := False;
        end;
        OnUp := True;
        ButtonUp := Button;

        UpTime := GetTickCount;
end;

procedure TMaus.StartCheck;
begin
        MObject := nil;
end;

procedure TMaus.CheckGump( X, Y : Integer; Breite, Hoehe : Word; GumpObject : TGumpObject; Texture : TTexObject; Always : Boolean; MaxX : Integer; MaxY : Integer );
begin
        Timer.Continue( Timer_MausCheck );

        if MaxX = -$80000000 then
                MaxX := X + Breite;
        if MaxY = -$80000000 then
                MaxY := Y + Hoehe;

        if ( AktX >= X ) and ( AktX < MaxX ) and ( AktY >= Y ) and ( AktY < MaxY ) then begin
                if Always then begin
                        MObject := GumpObject;
                end
                else begin
                        if Texture <> nil then begin
                                if Texture.CheckPixel( Round( (AktX - X)*(Texture.Breite/Breite) ), Round( (AktY - Y)*(Texture.Hoehe/Hoehe) ) ) then begin
                                        if GumpObject.Gump <> Palanthir.Tooltip.Gump then
                                                MObject := GumpObject;
                                end;
                        end;
                end;
        end;

        Timer.Pause( Timer_MausCheck );
end;

procedure TMaus.CheckGump( X, Y : Integer; Breite, Hoehe : Word; GumpObject : TGumpObject; BitMask : TBitMask );
begin
        Timer.Continue( Timer_MausCheck );

        if ( AktX >= X ) and ( AktX < X + Breite ) and ( AktY >= Y ) and ( AktY < Y + Hoehe ) then begin
                if BitMask <> nil then begin
                        if BitMask.CheckPixel( AktX - X, AktY - Y ) then begin
                                if GumpObject.Gump <> Palanthir.Tooltip.Gump then
                                        MObject := GumpObject;
                        end;
                end;
        end;

        Timer.Pause( Timer_MausCheck );
end;

procedure TMaus.CheckObject( X, Y : Integer; UObject : TUODrawObject; Texture : TTexObject; ZoomX, ZoomY : Real );
var     Breite, Hoehe : Word;
        PX, PY, DX, DY : Integer;
begin
        Timer.Continue( Timer_MausCheck );

        Breite := Texture.Breite;
        Hoehe := Texture.Hoehe;
        if (ZoomX = 1) and (ZoomY = 1) then begin
                if ( AktX >= X ) and ( AktX < X + Breite ) and ( AktY >= Y ) and ( AktY < Y + Hoehe ) then begin
                        if Texture <> nil then
                                if Texture.CheckPixel( AktX - X, AktY - Y ) then begin
                                        MObject := UObject;
                                end;
                end;
        end
        else begin
                if ( AktX >= X + (1-ZoomX)*(Breite div 2) ) and ( AktX < (X + Breite) - (1-ZoomX)*(Breite div 2) ) and ( AktY >= Y + (1-ZoomY)*Hoehe ) and ( AktY < Y + Hoehe ) then begin
                        if Texture <> nil then begin
                                DX := AktX - X;
                                DY := AktY - Y;
                                PX := Round( (DX + (Breite div 2)*(ZoomX-1))/ZoomX );
                                PY := Round( (DY + Hoehe*(ZoomY-1))/ZoomY );
                                if Texture.CheckPixel( PX, PY ) then begin
                                        MObject := UObject;
                                end;
                        end;
                end;
        end;

        Timer.Pause( Timer_MausCheck );
end;

procedure TMaus.CheckObject( PosX, PosY, X0, Y0, X1, Y1, X2, Y2, X3, Y3 : Integer; UObject : TUODrawObject );
begin
        Timer.Continue( Timer_MausCheck );

        if ( AktY >= (AktX - PosX+X0)*(Y1 - Y0)/(X1 - X0)+PosY+Y0 ) and
           ( AktY >= (AktX - PosX+X0)*(Y3 - Y0)/(X3 - X0)+PosY+Y0 ) and
           ( AktY <= (AktX - PosX+X2)*(Y3 - Y2)/(X3 - X2)+PosY+Y2 ) and
           ( AktY <= (AktX - PosX+X2)*(Y1 - Y2)/(X1 - X2)+PosY+Y2 ) then begin
                MObject := UObject;
        end;

        Timer.Pause( Timer_MausCheck );
end;

procedure TMaus.CheckSpeech( X, Y : Integer; SpeechText : TSpeechText; Texture : TTexObject );
var     Breite, Hoehe : Word;
begin
        Timer.Continue( Timer_MausCheck );
        
        Breite := Texture.Breite;
        Hoehe := Texture.Hoehe;
        if ( AktX >= X ) and ( AktX < X + Breite ) and ( AktY >= Y ) and ( AktY < Y + Hoehe ) then begin
                if Texture <> nil then
                        if Texture.CheckPixel( AktX - X, AktY - Y ) then begin
                                MObject := SpeechText;
                        end;
        end;

        Timer.Pause( Timer_MausCheck );
end;

procedure TMaus.Poll;
var     NewCursor : TCursor;
        DropItem : TDropItem;
        EquipItem : TEquipItem;
        Item : TItem;
        Char : TChar;
        Texture : TTexObject;
        TmpTexture : TTexObject;
        GetCharStatus : TGetCharStatus;
        AmountId : Word;
        TX, TY : Word;
        DropX, DropY : Integer;
        I : Integer;
begin
        if Palanthir.GameWindow <> nil then begin
                Phi := 90 + ( 360 / (2*Pi) )*ArcTan( ( AktY - Palanthir.GameWindow.Y - (Palanthir.GameWindow.Hoehe div 2) ) / ( AktX - Palanthir.GameWindow.X - (Palanthir.GameWindow.Breite div 2) ) );
                if AktX - Palanthir.GameWindow.X - (Palanthir.GameWindow.Breite div 2) < 0 then
                        Phi := Phi + 180;
        end
        else begin
                Phi := 0;
        end;

        if (Palanthir.GameWindow <> nil) and (AktX >= Palanthir.GameWindow.X) and (AktY >= Palanthir.GameWindow.Y) and (AktX < Palanthir.GameWindow.X+Palanthir.GameWindow.Breite) and (AktY < Palanthir.GameWindow.Y+Palanthir.GameWindow.Hoehe) then
                IsInGameWindow := True
        else
                IsInGameWindow := False;

        Palanthir.Tooltip.SetPos( AktX, AktY );

        if RDown then begin
                GestureHandler.AddPoint( AktX, AktY );
        end;

        if MObject <> nil then begin
                if MObject.IsUODrawObject and (MObject = LastMObject) then begin
                        if (LastMObjectChange <> $FFFFFFFF) and (CustomGetTickCount - LastMObjectChange > 3000) then begin
                                Palanthir.ScriptManager.OnMouseStayOver( TUODrawObject( MObject ) );
                                LastMObjectChange := $FFFFFFFF;
                        end;
                end else if MObject.IsGump and (TGumpObject( MObject ).Typ in [gt_GumpStaticItem, gt_GumpItem ]) then begin
                        if (LastMObjectChange <> $FFFFFFFF) and (CustomGetTickCount - LastMObjectChange > 3000) then begin
                                if TGumpObject( MObject ).Typ = gt_GumpItem then begin
                                        if TGumpItem( MObject ).GetSerial <> DragSerial then begin
                                                Palanthir.ScriptManager.OnMouseStayOver( Palanthir.Data.GlobalObjectList.GetObject( TGumpItem( MObject ).GetSerial ) )
                                        end;
                                end else begin
                                        if TGumpStaticItem( MObject ).ItemSerial <> DragSerial then begin
                                                Palanthir.ScriptManager.OnMouseStayOver( Palanthir.Data.GlobalObjectList.GetObject( TGumpStaticItem( MObject ).ItemSerial ) );
                                        end;
                                end;
                                LastMObjectChange := $FFFFFFFF;
                        end;
                end else begin
                        LastMObject := MObject;
                        LastMObjectChange := CustomGetTickCount;
                end;

                if (SelectedGumpObject <> MObject) and (SelectedGumpObject <> nil) then
                        SelectedGumpObject.SetOver( False );

                if MObject.IsGump then begin
                        if SelectedGumpObject <> MObject then
                                TGumpObject( MObject ).SetOver( True );
                        SelectedGumpObject := TGumpObject( MObject );
                        SelectedUObject := nil;
                        SelectedSpeech := nil;

                        if TGumpObject( MObject ).Gump <> nil then
                                TGumpObject( MObject ).Gump.CheckTooltip( TGumpObject( MObject ) );
                end
                else if MObject.IsUODrawObject then begin
                        SelectedGumpObject := nil;
                        SelectedUObject := TUODrawObject( MObject );
                        SelectedSpeech := nil;

                        Palanthir.Tooltip.SetTarget( MObject );
                end
                else if MObject.IsSpeech then begin
                        SelectedGumpObject := nil;
                        SelectedUObject := nil;
                        SelectedSpeech := TSpeechText( MObject );

                        Palanthir.Tooltip.SetTarget( nil );
                end
                else begin
                        SelectedGumpObject := nil;
                        SelectedUObject := nil;
                        SelectedSpeech := nil;

                        Palanthir.Tooltip.SetTarget( nil );                                                
                end;
        end
        else begin
                LastMObjectChange := $FFFFFFFF;
                Palanthir.Tooltip.SetTarget( nil );
        end;

        if OnUp and (ButtonUp = mbLeft) then begin
                if Palanthir.Player.Walking and (not Palanthir.Movement.DisablePermanentMovement) then
                        Palanthir.Movement.DoNotStopMovement := True;

                if (SelectedDownLGumpObject <> nil) and (MObject = SelectedDownLGumpObject) or
                   (SelectedDownLUObject <> nil) and (MObject = SelectedDownLUObject) or
                   (SelectedDownLSpeech <> nil) and (MObject = SelectedDownLSpeech) then begin
                        if LClick and ( not Palanthir.Target.Activated ) then begin
                                OnDblClick := True;
                                LClick := False;
                        end
                        else begin
                                LClick := True;
                        end;
                end;

                if MObject <> nil then begin
                        if MObject.IsGump then begin
                                if DragSerial <> Invalid_Serial then begin
                                        if TGumpObject( MObject ).Gump.Typ = GumpTyp_Container then begin
                                                if TGumpObject( MObject ).Typ = gt_GumpStaticItem then begin
                                                        DropItem := TDropItem.Create;
                                                        DropItem.SetSerial( DragSerial );
                                                        DropItem.SetX( $FFFF );
                                                        DropItem.SetY( $FFFF );
                                                        DropItem.SetZ( 0 );
                                                        DropItem.SetContSerial( TGumpStaticItem( MObject ).ItemSerial );
                                                        Palanthir.SendPacket( DropItem );
                                                        DragSerial := Invalid_Serial;
                                                end
                                                else begin
                                                        DropItem := TDropItem.Create;
                                                        DropItem.SetSerial( DragSerial );
                                                        if DragAmount > 1 then begin
                                                                AmountId := Palanthir.Shard.GetAmountId( DragId, DragAmount );
                                                                if AmountId > 0 then
                                                                        Texture := Palanthir.Data.GetStaticArt( AmountId, DragColor )
                                                                else
                                                                        Texture := Palanthir.Data.GetStaticArt( DragId, DragColor );
                                                        end
                                                        else
                                                                Texture := Palanthir.Data.GetStaticArt( DragId, DragColor );
                                                        if Texture <> nil then begin
                                                                DropX := AktX-TGumpObject( MObject ).Gump.X-(Texture.Breite div 2);
                                                                DropY := AktY-TGumpObject( MObject ).Gump.Y-Round(Texture.Hoehe*3/5);
                                                        end
                                                        else begin
                                                                DropX := AktX-TGumpObject( MObject ).Gump.X;
                                                                DropY := AktY-TGumpObject( MObject ).Gump.Y;
                                                        end;

                                                        TmpTexture := Palanthir.Data.GetGumpTexture( TGImage( TContainer( TGumpObject( MObject ).Gump ).GetObject( 0 ) ).Id, TGImage( TContainer( TGumpObject( MObject ).Gump ).GetObject( 0 ) ).Hue );
                                                        if TmpTexture <> nil then begin
                                                                DropX := Min( Max( DropX, 0 ), TmpTexture.Breite );
                                                                DropY := Min( Max( DropY, 0 ), TmpTexture.Hoehe );
                                                        end
                                                        else begin
                                                                DropX := Min( Max( DropX, 0 ), 200 );
                                                                DropY := Min( Max( DropY, 0 ), 200 );
                                                        end;

                                                        DropItem.SetX( DropX );
                                                        DropItem.SetY( DropY );
                                                        DropItem.SetZ( 0 );
                                                        DropItem.SetContSerial( TContainer( TGumpObject( MObject ).Gump ).ItemSerial );
                                                        Palanthir.SendPacket( DropItem );
                                                        DragSerial := Invalid_Serial;
                                                end;
                                        end
                                        else if TGumpObject( MObject ).Gump.Typ = GumpTyp_Paperdoll then begin
                                                if TGumpObject( MObject ).Typ in [ gt_Image, gt_GumpItem ] then begin
                                                        if (TGumpObject( MObject ).Typ = gt_GumpItem) and ( Palanthir.Data.GlobalObjectList.GetObject( TGumpItem( MObject ).GetSerial ) <> nil ) and ( TItem( Palanthir.Data.GlobalObjectList.GetObject( TGumpItem( MObject ).GetSerial ) ).Layer = 21) then begin
                                                                DropItem := TDropItem.Create;
                                                                DropItem.SetSerial( DragSerial );
                                                                DropItem.SetX( $FFFF );
                                                                DropItem.SetY( $FFFF );
                                                                DropItem.SetZ( 0 );
                                                                DropItem.SetContSerial( TGumpItem( MObject ).GetSerial );
                                                                Palanthir.SendPacket( DropItem );
                                                                DragSerial := Invalid_Serial;
                                                        end
                                                        else begin
                                                                EquipItem := TEquipItem.Create;
                                                                EquipItem.SetSerial( DragSerial );
                                                                EquipItem.SetLayer( Palanthir.Data.Tiledata.GetStaticQuality( DragId ) );
                                                                EquipItem.SetCharSerial( TPaperdoll( TGumpObject( MObject ).Gump ).CharSerial );
                                                                Palanthir.SendPacket( EquipItem );
                                                                DragSerial := Invalid_Serial;
                                                        end;
                                                end;
                                        end;
                                end;
                                if TGumpObject( MObject ).Gump <> nil then
                                        TGumpObject( MObject ).Gump.OnMouseUp( TGumpObject( MObject ) );
                        end
                        else if MObject.IsUODrawObject then begin
                                if DragSerial <> Invalid_Serial then begin
                                        if TUODrawObject( MObject ).IsChar or (TUODrawObject( MObject ).IsItem and (Palanthir.Data.Tiledata.GetStaticFlag( TUODrawObject( MObject ).ID, dCONTAINER ) or (TUODrawObject( MObject ).ID = DragId)) ) then begin
                                                DropItem := TDropItem.Create;
                                                DropItem.SetSerial( DragSerial );
                                                DropItem.SetX( $FFFF );
                                                DropItem.SetY( $FFFF );
                                                DropItem.SetZ( 0 );
                                                DropItem.SetContSerial( TUObject( MObject ).Serial );
                                                Palanthir.SendPacket( DropItem );
                                                DragSerial := Invalid_Serial;
                                        end
                                        else begin
                                                DropItem := TDropItem.Create;
                                                DropItem.SetSerial( DragSerial );
                                                DropItem.SetX( TUODrawObject( MObject ).Pos.X );
                                                DropItem.SetY( TUODrawObject( MObject ).Pos.Y );
                                                DropItem.SetZ( TUODrawObject( MObject ).Pos.Z );
                                                DropItem.SetContSerial( $FFFFFFFF );
                                                Palanthir.SendPacket( DropItem );
                                                DragSerial := Invalid_Serial;
                                        end;
                                end;
                        end;
                end;

                if SelectedDownLGumpObject <> nil then
                        SelectedDownLGumpObject.onUp;
                SelectedDownLGumpObject := nil;
                SelectedDownLUObject := nil;
                SelectedDownLSpeech := nil;
        end;

        if OnUp and (ButtonUp = mbRight) then begin
                if (SelectedDownRGumpObject <> nil) and (MObject = SelectedDownRGumpObject) or
                   (SelectedDownRUObject <> nil) and (MObject = SelectedDownRUObject) or
                   (SelectedDownRSpeech <> nil) and (MObject = SelectedDownRSpeech) then begin
                        OnRClick := True;
                end;

                GestureHandler.Check;
                GestureHandler.ClearPoints;

                if Palanthir.Movement.DoNotStopMovement then
                        Palanthir.Movement.DoNotStopMovement := False
                else
                        Palanthir.Movement.Stop;

                SelectedDownRGumpObject := nil;
                SelectedDownRUObject := nil;
                SelectedDownRSpeech := nil;

                if (MObject <> nil) and MObject.IsUODrawObject and (Palanthir.Movement.Timer = -1) and (CustomGetTickCount - RDowntime < 200) then begin
                        Palanthir.Movement.Turn;
                end;
        end;

        if OnDown and (ButtonDown = mbLeft) then begin
                if MObject <> nil then begin
                        if MObject.IsGump then begin
                                TGumpObject( MObject ).onDown;
                                SelectedDownLGumpObject := TGumpObject( MObject );
                                OnDown := False;
                                if TGumpObject( MObject ).Gump <> nil then
                                        TGumpObject( MObject ).Gump.OnMouseDown( TGumpObject( MObject ) );
                        end
                        else if MObject.IsUODrawObject then begin
                                SelectedDownLUObject := TUODrawObject( MObject );
                        end
                        else if MObject.IsSpeech then begin
                                SelectedDownLSpeech := TSpeechText( MObject );
                        end;
                end;
        end;

        if OnDown and (ButtonDown = mbRight) then begin
                if MObject <> nil then begin
                        if MObject.IsGump then begin
                                SelectedDownRGumpObject := TGumpObject( MObject );
                                OnDown := False;
                        end
                        else if MObject.IsUODrawObject then begin
                                SelectedDownRUObject := TUODrawObject( MObject );
                        end
                        else if MObject.IsSpeech then begin
                                SelectedDownRSpeech := TSpeechText( MObject );
                        end;

                        if not MObject.IsGump then
                                Palanthir.Movement.Start( CustomGetTickCount - 1 );
                end
                else begin
                        Palanthir.Movement.Start( CustomGetTickCount - 1 );
                end;
        end;

        if LClick and (( CustomGetTickCount - LDownTime ) > Palanthir.DClickTime) then begin
                OnLClick := True;
                LClick := False;
        end;

        if OnLClick then begin
                if MObject <> nil then begin
                        if MObject.IsGump then begin
                                if Palanthir.Target.Activated then begin
                                        if TGumpObject( MObject ).Typ in [ gt_GumpItem, gt_GumpStaticItem ] then begin
                                                if TGumpObject( MObject ).Typ = gt_GumpItem then
                                                        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( TGumpItem( MObject ).GetSerial ) )
                                                else
                                                        Item := TItem( Palanthir.Data.GlobalObjectList.GetObject( TGumpStaticItem( MObject ).ItemSerial ) );

                                                Palanthir.Target.Execute( Item );
                                        end
                                        else if TGumpObject( MObject ).Gump.Typ = GumpTyp_Status then begin
                                                Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( TStatusGump( TGumpObject( MObject ).Gump ).CharSerial ) );
                                                if Char <> nil then begin
                                                        Palanthir.Target.Execute( Char );
                                                end;
                                        end
                                        else if TGumpObject( MObject ).Gump.Typ = GumpTyp_Radar then begin
                                                if Palanthir.Target.AllowGround then begin
                                                        TX := Palanthir.Player.Radar.GetRealX( AktX-TGumpObject( MObject ).X-TGumpObject( MObject ).Gump.X, AktY-TGumpObject( MObject ).Y-TGumpObject( MObject ).Gump.Y );
                                                        TY := Palanthir.Player.Radar.GetRealY( AktX-TGumpObject( MObject ).X-TGumpObject( MObject ).Gump.X, AktY-TGumpObject( MObject ).Y-TGumpObject( MObject ).Gump.Y );

                                                        Palanthir.Target.Execute( nil, TX, TY );
                                                end;
                                        end;
                                end
                                else begin
                                        Palanthir.Keyboard.SelectedGumpObject := nil;
                                        Palanthir.Keyboard.KeyboardMode := KB_Speech;
                                        TGumpObject( MObject ).onClick( AktX-TGumpObject( MObject ).X-TGumpObject( MObject ).Gump.X, AktY-TGumpObject( MObject ).Y-TGumpObject( MObject ).Gump.Y );
                                end;
                        end
                        else if MObject.IsUODrawObject then begin
                                if Palanthir.Target.Activated then begin
                                        Palanthir.Target.Execute( TUODrawObject( MObject ) );
                                end
                                else begin
                                        TUODrawObject( MObject ).OnClick;
                                        Palanthir.Keyboard.SelectedGumpObject := nil;
                                        Palanthir.Keyboard.KeyboardMode := KB_Speech;
                                end;
                        end
                        else if MObject.IsSpeech then begin
                                if Palanthir.Target.Activated then begin
                                        if TSpeechText( MObject ).Speech.IsDrawObjectType then
                                                Palanthir.Target.Execute( TUODrawObject( TSpeechText( MObject ).Speech.UObject ) );
                                end
                                else begin
                                        TSpeechText( MObject ).OnClick;
                                end;
                        end;
                end;
        end;

        if OnRClick then begin
                if MObject <> nil then begin
                        if MObject.IsGump then begin
                                if not TGumpObject( MObject ).Gump.noClose then begin
                                        TGumpObject( MObject ).Gump.OnButtonClick( 0 );
                                end;
                        end;
                end;
        end;

        if OnDblClick then begin
                if MObject <> nil then begin
                        if MObject.IsGump then begin
                                TGumpObject( MObject ).OnDblClick( AktX-TGumpObject( MObject ).X-TGumpObject( MObject ).Gump.X, AktY-TGumpObject( MObject ).Y-TGumpObject( MObject ).Gump.Y );
                                OnDblClick := False;
                        end
                        else if MObject.IsUODrawObject then begin
                                TUODrawObject( MObject ).OnDblClick;
                                OnDblClick := False;
                        end
                        else if MObject.IsSpeech then begin
                                TSpeechText( MObject ).OnDblClick;
                                OnDblClick := False;
                        end;
                end;
        end;

        if OnMove then begin
                if (DragSerial = Invalid_Serial) and (SelectedDownLGumpObject <> nil) then begin
                        SelectedDownLGumpObject.OnMove;
                        if (SelectedDownLGumpObject <> nil) and (SelectedDownLGumpObject.Typ in [ gt_GumpItem, gt_GumpStaticItem ]) then begin
                                if SelectedDownLGumpObject.Typ = gt_GumpItem then begin
                                        if TGumpItem( SelectedDownLGumpObject ).GetSerial <> Invalid_Serial then
                                                TItem( Palanthir.Data.GlobalObjectList.GetObject( TGumpItem( SelectedDownLGumpObject ).GetSerial ) ).GrabItem;
                                end
                                else if SelectedDownLGumpObject.Typ = gt_GumpStaticItem then begin
                                        if TGumpStaticItem( SelectedDownLGumpObject ).ItemSerial <> Invalid_Serial then
                                                TItem( Palanthir.Data.GlobalObjectList.GetObject( TGumpStaticItem( SelectedDownLGumpObject ).ItemSerial ) ).GrabItem;
                                end;
                        end
                        else begin
                                if (SelectedDownLGumpObject <> nil) and (SelectedDownLGumpObject.Gump <> nil) and SelectedDownLGumpObject.Gump.OnMove( SelectedDownLGumpObject ) then begin
                                        if SelectedDownLGumpObject.Gump <> Palanthir.GameWindow then
                                                Palanthir.SetForeGroundGump( SelectedDownLGumpObject.Gump );
                                        if (not SelectedDownLGumpObject.Gump.noMove) and (AktX > 0) and (AktY > 0) and (AktX < Renderer.GetWindowBreite) and (AktY < Renderer.GetWindowHoehe) then begin
                                                SelectedDownLGumpObject.Gump.X := SelectedDownLGumpObject.Gump.X - ( MX - AktX );
                                                SelectedDownLGumpObject.Gump.Y := SelectedDownLGumpObject.Gump.Y - ( MY - AktY );
                                                MX := AktX;
                                                MY := AktY;
                                        end;
                                end;
                        end;
                end
                else if MObject <> nil then begin
                        if MObject.IsUODrawObject and (DragSerial = Invalid_Serial) then begin
                                if TUODrawObject( MObject ).IsItem and (DragSerial = Invalid_Serial) and (MObject = SelectedDownLUObject) then begin
                                        TItem( MObject ).GrabItem;
                                end;
                                if TUODrawObject( MObject ).IsChar and (MObject = SelectedDownLUObject) then begin
                                        GetCharStatus := TGetCharStatus.Create;
                                        GetCharStatus.SetPlayer( TChar( MObject ).Serial );
                                        Palanthir.SendPacket( GetCharStatus );
                                        TChar( MObject ).StatusVisible := True;
                                        TChar( MObject ).StatusPos.X := AktX-30;
                                        TChar( MObject ).StatusPos.Y := AktY-30;

                                        for I := 0 to Palanthir.GetGumpCount-1 do begin
                                                if (Palanthir.GetGump( I ).Typ = GumpTyp_Status) and (TStatusGump( Palanthir.GetGump( I ) ).CharSerial = TChar( MObject ).Serial) then begin
                                                        Palanthir.DeleteGump( I );
                                                        Break;
                                                end;
                                        end;
                                end;
                                if TUODrawObject( MObject ).IsMultiItem then begin
                                        if TMultiItem( MObject ).Owner <> nil then
                                                TMultiItem( MObject ).Owner.GrabItem;
                                end;
                        end;
                end;
        end;

        if ((MObject <> nil) and (not MObject.IsGump)) or LDown then begin
                if (MObject <> nil) and MObject.IsUODrawObject and (not TUODrawObject( MObject ).IsChar) then begin
                        if (Palanthir.GameWindow <> nil) and (Palanthir.CursorState = 0) then begin
                                if ( ( AktX > Palanthir.GameWindow.X ) and ( AktY > Palanthir.GameWindow.Y ) and ( AktX < Palanthir.GameWindow.X + Palanthir.GameWindow.Breite ) and ( AktY < Palanthir.GameWindow.Y + Palanthir.GameWindow.Hoehe ) ) then begin
                                        if ( Phi >= 337.5 ) or ( Phi < 22.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielNW
                                        else if ( Phi >= 22.5 ) and ( Phi < 67.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielN
                                        else if ( Phi >= 67.5 ) and ( Phi < 112.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielNE
                                        else if ( Phi >= 112.5 ) and ( Phi < 157.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielE
                                        else if ( Phi >= 157.5 ) and ( Phi < 202.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielSE
                                        else if ( Phi >= 202.5 ) and ( Phi < 247.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielS
                                        else if ( Phi >= 247.5 ) and ( Phi < 292.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielSW
                                        else if ( Phi >= 292.5 ) and ( Phi < 237.5 ) then
                                                Palanthir.Cursors.CurrentCursor := crUOSpielW
                                        else
                                                Palanthir.Cursors.CurrentCursor := crUOAuswahl;
                                end;
                        end
                        else if ( Palanthir.Cursorstate = Cursor_Standard ) then begin
                                Palanthir.Cursors.CurrentCursor := crUOAuswahl;
                        end;
                end
                else if ( Palanthir.Cursorstate = Cursor_Standard ) then begin
                        Palanthir.Cursors.CurrentCursor := crUOAuswahl;
                end;
        end
        else if ( Palanthir.Cursorstate = Cursor_Standard ) then begin
                Palanthir.Cursors.CurrentCursor := crUOAuswahl;
        end;
end;

end.
