unit uMovement;

interface

uses    Windows, uUtilities, uSendPackets, uLog, SysUtils, uCustomGumps,
        Classes, uPos, uBasicTypedefs, uItem, uLoaderTiledata, Math;

const   MovingSpeedConst = 370;
        RunningSpeedConst = 175;
        MountMovingSpeedConst = 185;
        MountRunningSpeedConst = 95;
        MovingStepsPerField = 5;
        RunningStepsPerField = 2;
        MountMovingStepsPerField = 2;
        MountRunningStepsPerField = 1;
        MaxZClimbMap = 19;
        MaxZClimb = 14;
        MaxZFall = 19;
        MaxBlock = 14;
        CharHeight = 15;

type    TMovement = Class
                public
                        Cache : TList;
                        MoveSequence : Byte;
                        FastwalkPreventionEnabled : Boolean;
                        Keys : Array[0..5] of LongWord;
                        Timer : Integer;
                        SendCacheCount : Byte;
                        DoNotStopMovement : Boolean;
                        DisablePermanentMovement : Boolean;
                        constructor Create;
                        destructor Free;
                        procedure Poll;
                        procedure Turn;                        
                        procedure Start( Timer: LongWord );
                        procedure Stop;
                        procedure ClearCache;
                        procedure AddCache( Direction : Byte; Run : Boolean; NewZ : ShortInt );
                        function GetNewPos( OrigPos : TPos; Direction : Byte ) : TPos;
                        function GetNewZ( OrigPos : TPos; Direction : Byte; var Allowed : Boolean ) : ShortInt;
                        function GetBlockingItems( Pos : TPos ) : TList;
                        procedure SendMove( Direction : Byte; Running : Boolean );
                        function FindPath( OrigPos, TargetPos : TPos ) : TList;
        end;

        TMovingCache = Class
                public
                       Direction : Byte;
                       Run : Boolean;
                       NewZ : ShortInt;
                       constructor Create;
                       destructor Free;
        end;

        TBlockingItem = Record
                Z : ShortInt;
                Height : Byte;
                Walkable : Boolean;
                MapTile : Boolean;

        end;
        PBlockingItem = ^TBlockingItem;

implementation

uses uPalanthir;

constructor TMovingCache.Create;
begin
end;

destructor TMovingCache.Free;
begin
end;

constructor TMovement.Create;
begin
        MoveSequence := 0;
        FastwalkPreventionEnabled := False;
        DisablePermanentMovement := False;
        DoNotStopMovement := False;
        Timer := -1;
        SendCacheCount := 0;

        Cache := TList.Create;
end;

destructor TMovement.Free;
begin
        while Cache.Count > 0 do begin
                TMovingCache( Cache.Items[ 0 ] ).Free;
                Cache.Delete( 0 );
        end;
        Cache.Free;
end;

procedure TMovement.ClearCache;
begin
        while Cache.Count > 0 do begin
                TMovingCache( Cache.Items[ 0 ] ).Free;
                Cache.Delete( 0 );
        end;
end;

procedure TMovement.AddCache( Direction : Byte; Run : Boolean; NewZ : ShortInt );
var     MC : TMovingCache;
begin
        MC := TMovingCache.Create;
        MC.Direction := Direction;
        MC.Run := Run;
        MC.NewZ := NewZ;
        Cache.Add( MC );
end;

procedure TMovement.Poll;
var     Phi : Real;
        Direction, OldDirection : Byte;
        GW : TGameWindow;
        Run : Boolean;
        NewZ : ShortInt;
        TestDirection : Byte;
        Allowed : Boolean;
        Diagonal : Boolean;
begin
        if Timer = -1 then
                exit;

        if GetTickCount > Timer then begin
                GW := Palanthir.GameWindow;
                if GW = nil then begin
                        Timer := -1;
                        exit;
                end;

                if ( SendCacheCount >= 4 ) or ( Cache.Count >= 1) then begin
                        Timer := GetTickCount + 10;
                        exit;
                end;

                Phi := Palanthir.Maus.Phi;
                if ( Phi >= 337.5 ) or ( Phi < 22.5 ) then
                        Direction := 7
                else if ( Phi >= 22.5 ) and ( Phi < 67.5 ) then
                        Direction := 0
                else if ( Phi >= 67.5 ) and ( Phi < 112.5 ) then
                        Direction := 1
                else if ( Phi >= 112.5 ) and ( Phi < 157.5 ) then
                        Direction := 2
                else if ( Phi >= 157.5 ) and ( Phi < 202.5 ) then
                        Direction := 3
                else if ( Phi >= 202.5 ) and ( Phi < 247.5 ) then
                        Direction := 4
                else if ( Phi >= 247.5 ) and ( Phi < 292.5 ) then
                        Direction := 5
                else //if ( Phi >= 292.5 ) and ( Phi < 237.5 ) then
                        Direction := 6;

                if (Palanthir.Maus.AktX < GW.X + GW.Breite/4) or (Palanthir.Maus.AktX > GW.X + GW.Breite*3/4) or
                   (Palanthir.Maus.AktY < GW.Y + GW.Hoehe/4) or (Palanthir.Maus.AktY > GW.Y + GW.Hoehe*3/4) then
                        Run := True
                else
                        Run := False;

                TestDirection := Direction;
                Allowed := True;
                NewZ := GetNewZ( Palanthir.Player.Pos, TestDirection, Allowed );

                if not Allowed then begin
                        if Direction = 0 then
                                TestDirection := 7
                        else
                                TestDirection := Direction - 1;
                        Allowed := True;
                        NewZ := GetNewZ( Palanthir.Player.Pos, TestDirection, Allowed );
                end;

                if not Allowed then begin
                        TestDirection := (Direction + 1) mod 8;
                        Allowed := True;
                        NewZ := GetNewZ( Palanthir.Player.Pos, TestDirection, Allowed );
                end;

                if Allowed then begin
                        Diagonal := TestDirection mod 2 = 1;

                        if Diagonal then begin
                                GetNewZ( Palanthir.Player.Pos, (TestDirection + 1) mod 8, Allowed );
                                if not Allowed then begin
                                        Allowed := True;
                                        GetNewZ( Palanthir.Player.Pos, (TestDirection + 7) mod 8, Allowed );                                        
                                end;
                        end;
                end;

                OldDirection := Palanthir.Player.Direction;

                if Allowed then begin
                        Palanthir.Player.AddMove( TestDirection, Run, NewZ );
                end;

                if OldDirection <> Direction then begin
                        Timer := GetTickCount + 100;
                end
                else begin
                        if Palanthir.Player.OnMount then begin
                                if Run then
                                        Timer := GetTickCount + Palanthir.Player.GetMountRunningSpeed
                                else
                                        Timer := GetTickCount + Palanthir.Player.GetMountMovingSpeed;
                        end
                        else begin
                                if Run then
                                        Timer := GetTickCount + Palanthir.Player.GetRunningSpeed
                                else
                                        Timer := GetTickCount + Palanthir.Player.GetMovingSpeed;
                        end;
                end;
        end;
end;

procedure TMovement.Turn;
var     Phi : Real;
        Direction : Byte;
        GW : TGameWindow;
begin
        GW := Palanthir.GameWindow;
        if GW = nil then begin
                exit;
        end;

        Phi := Palanthir.Maus.Phi;
        if ( Phi >= 337.5 ) or ( Phi < 22.5 ) then
                Direction := 7
        else if ( Phi >= 22.5 ) and ( Phi < 67.5 ) then
                Direction := 0
        else if ( Phi >= 67.5 ) and ( Phi < 112.5 ) then
                Direction := 1
        else if ( Phi >= 112.5 ) and ( Phi < 157.5 ) then
                Direction := 2
        else if ( Phi >= 157.5 ) and ( Phi < 202.5 ) then
                Direction := 3
        else if ( Phi >= 202.5 ) and ( Phi < 247.5 ) then
                Direction := 4
        else if ( Phi >= 247.5 ) and ( Phi < 292.5 ) then
                Direction := 5
        else //if ( Phi >= 292.5 ) and ( Phi < 237.5 ) then
                Direction := 6;

        if Palanthir.Player.Direction <> Direction then begin
                Palanthir.Player.AddMove( Direction, False, Palanthir.Player.Pos.Z );
        end;
end;

function TMovement.GetNewPos( OrigPos : TPos; Direction : Byte ) : TPos;
var     NewX, NewY : Word;
begin
        Case Direction of
                0 : begin
                        NewX := OrigPos.X;
                        NewY := OrigPos.Y -1;
                        end;
                1 : begin
                        NewX := OrigPos.X +1;
                        NewY := OrigPos.Y -1;
                        end;
                2 : begin
                        NewX := OrigPos.X +1;
                        NewY := OrigPos.Y;
                        end;
                3 : begin
                        NewX := OrigPos.X +1;
                        NewY := OrigPos.Y +1;
                        end;
                4 : begin
                        NewX := OrigPos.X;
                        NewY := OrigPos.Y +1;
                        end;
                5 : begin
                        NewX := OrigPos.X -1;
                        NewY := OrigPos.Y +1;
                        end;
                6 : begin
                        NewX := OrigPos.X -1;
                        NewY := OrigPos.Y;
                        end;
                7 : begin
                        NewX := OrigPos.X -1;
                        NewY := OrigPos.Y -1;
                        end;
                else begin
                        NewX := OrigPos.X;
                        NewY := OrigPos.Y;
                end;
        end;

        Result := TPos.Create( NewX, NewY, OrigPos.Z );
end;

function TMovement.GetNewZ( OrigPos : TPos; Direction : Byte; var Allowed : Boolean ) : ShortInt;
        procedure FreeBlockingList( Pos : TPos; BlockingList : TList );
        var     I : Integer;
        begin
                Pos.Free;
                for I := BlockingList.Count-1 downto 0 do begin
                        FreeMem( BlockingList.Items[ I ] );
                end;
                BlockingList.Free;
        end;
var     BlockingList : TList;
        I : Integer;
        ItemTop : Integer;
        Item : PBlockingItem;
        Pos : TPos;
        Found : Boolean;
begin
        Pos := GetNewPos( OrigPos, Direction );
        Result := Pos.Z;

        BlockingList := GetBlockingItems( Pos );
        
        Found := False;

        for I := BlockingList.Count-1 downto 0 do begin
                Item := PBlockingItem( BlockingList.Items[ I ] );
                ItemTop := Item.Z + Item.Height;

                if Found and ( (ItemTop > Result - MaxBlock) or (not Item.Walkable) ) then begin
			break;
		end;

                if (not Item.Walkable) and (ItemTop <= Result) then begin
                        FreeBlockingList( Pos, BlockingList );
                        Allowed := False;
                        exit;
                end;

                if Item.Walkable then begin
                        if ( ItemTop <= Result + MaxZClimb ) and ( ItemTop >= Result - MaxZFall ) then begin
                                if Found and ( Abs( Pos.Z - Result ) < Abs( Pos.Z - ItemTop ) ) then begin
					break;
				end;

                                Result := ItemTop;
                                Found := True;

                                if (Item.Height > 1) then begin
                                        break;        
                                end;
                        end
                        else if Item.Maptile and ( ItemTop <= Result + MaxZClimbMap ) and ( ItemTop >= Result - MaxZFall ) then begin
                                if Found and ( Abs( Pos.Z - Result ) < Abs( Pos.Z - ItemTop ) ) then begin
					break;
				end;

                                Result := ItemTop;
                                Found := True;
                        end
                        else if ItemTop < Result then begin
                                if Found and ( Abs( Pos.Z - Result ) < Abs( Pos.Z - ItemTop ) ) then begin
					break;
				end;

                                Result := ItemTop;
                                Found := True;

                                break;
                        end;
                end;
        end;

        if not Found then begin
                FreeBlockingList( Pos, BlockingList );
                Allowed := False;
                exit;
        end;

        for I := BlockingList.Count-1 downto 0 do begin
                Item := PBlockingItem( BlockingList.Items[ I ] );
                ItemTop := Item.Z + Item.Height;

		if ( ItemTop <= Result ) then begin
			continue;
                end;

		if ( ItemTop > Result ) and ( ItemTop < Result + MaxBlock ) then begin
                        FreeBlockingList( Pos, BlockingList );
                        Allowed := False;
                        exit;
                end;

		if ( Item.Z >= Pos.Z ) and ( Item.z < Pos.Z + MaxBlock / 2 ) then begin
                        FreeBlockingList( Pos, BlockingList );
                        Allowed := False;
                        exit;
                end;

		if ( Item.Z <= Pos.Z ) and ( ItemTop >= Pos.Z + MaxBlock / 2 ) then begin
                        FreeBlockingList( Pos, BlockingList );
                        Allowed := False;
                        exit;
                end;

		if ( Item.Z >= Result ) and ( Item.Z < Result + MaxBlock ) then begin
                        FreeBlockingList( Pos, BlockingList );
                        Allowed := False;
                        exit;
                end;
        end;

        FreeBlockingList( Pos, BlockingList );
        Allowed := True;
end;

function TMovement.GetBlockingItems( Pos : TPos ) : TList;
        function SortItems( Item1, Item2 : Pointer ) : Integer;
        begin
                if PBlockingItem( Item1 ).Z+PBlockingItem( Item1 ).Height > PBLockingItem( Item2 ).Z+PBLockingItem( Item2 ).Height then
                        Result := 1
                else if PBlockingItem( Item1 ).Z+PBlockingItem( Item1 ).Height < PBLockingItem( Item2 ).Z+PBLockingItem( Item2 ).Height then
                        Result := -1
                else if PBlockingItem( Item1 ).Walkable and (not PBlockingItem( Item2 ).Walkable) then
                        Result := 1
                else if PBlockingItem( Item2 ).Walkable and (not PBlockingItem( Item1 ).Walkable) then
                        Result := -1
                else
                        Result := 0;
        end;
var     BlockingItem : PBlockingItem;
        MapItem : TMapItem;
        StaticItem : TStaticItem;
        Item : TItem;
        Tiledata : TTiledata;
        MultiItem : TMultiItem;
        StaticList, ItemList, MultiList : TList;
        I : Integer;
begin
        Result := TList.Create;
        Tiledata := Palanthir.Data.Tiledata;

        MapItem := Palanthir.Data.WorldCache.GetMapItem( Pos.X, Pos.Y );
        if MapItem <> nil then begin
                new( BlockingItem );
                if Abs( MapItem.Pos.Z - MapItem.Z4 ) <= Abs( MapItem.Z2 - MapItem.Z3 ) then
                        BlockingItem.Z := Floor( ( MapItem.Pos.Z + MapItem.Z4 ) / 2 )
                else
                        BlockingItem.Z := Floor( ( MapItem.Z2 + MapItem.Z3 ) / 2 );
                BlockingItem.Height := 0;
                BlockingItem.MapTile := True;

                if Tiledata.GetLandFlag( MapItem.ID, dIMPASSABLE ) then
                        BlockingItem.Walkable := False
                else
                        BlockingItem.Walkable := True;

                if MapItem.ID <> $2 then
                        Result.Add( BlockingItem )
                else
                        FreeMem( BlockingItem );
        end;

        StaticList := Palanthir.Data.WorldCache.GetStaticObjects( Pos.X, Pos.Y );
        for I := 0 to StaticList.Count-1 do begin
                StaticItem := TStaticItem( StaticList.Items[ I ] );

                if not ( Tiledata.GetStaticFlag( StaticItem.ID, dIMPASSABLE ) or Tiledata.GetStaticFlag( StaticItem.ID, dSURFACE )  or Tiledata.GetStaticFlag( StaticItem.ID, dBRIDGE ) ) then
                        continue;

                new( BlockingItem );
                BlockingItem.Z := StaticItem.Pos.Z;
                BlockingItem.MapTile := False;

                if Tiledata.GetStaticFlag( StaticItem.ID, dBRIDGE ) then
                        BlockingItem.Height := Tiledata.GetStaticHeight( StaticItem.ID ) div 2
                else
                        BlockingItem.Height := Tiledata.GetStaticHeight( StaticItem.ID );

                if Tiledata.GetStaticFlag( StaticItem.ID, dSURFACE ) and ( not Tiledata.GetStaticFlag( StaticItem.ID, dIMPASSABLE ) ) then
                        BlockingItem.Walkable := True
                else
                        BlockingItem.Walkable := False;

                if StaticItem.Id <> $1 then
                        Result.Add( BlockingItem )
                else
                        FreeMem( BlockingItem );
        end;
        StaticList.Free;

        ItemList := Palanthir.Data.WorldCache.GetItems( Pos.X, Pos.Y );
        for I := 0 to ItemList.Count-1 do begin
                Item := TItem( ItemList.Items[ I ] );

                if not ( Tiledata.GetStaticFlag( Item.ID, dIMPASSABLE ) or Tiledata.GetStaticFlag( Item.ID, dSURFACE )  or Tiledata.GetStaticFlag( Item.ID, dBRIDGE ) ) then
                        continue;

                new( BlockingItem );
                BlockingItem.Z := Item.Pos.Z;
                BlockingItem.MapTile := False;

                if Tiledata.GetStaticFlag( Item.ID, dBRIDGE ) then
                        BlockingItem.Height := Tiledata.GetStaticHeight( Item.ID ) div 2
                else
                        BlockingItem.Height := Tiledata.GetStaticHeight( Item.ID );

                if Tiledata.GetStaticFlag( Item.ID, dSURFACE ) and ( not Tiledata.GetStaticFlag( Item.ID, dIMPASSABLE ) ) then
                        BlockingItem.Walkable := True
                else
                        BlockingItem.Walkable := False;

                if Item.Id <> $1 then
                        Result.Add( BlockingItem )
                else
                        FreeMem( BlockingItem );
        end;
        ItemList.Free;

        MultiList := Palanthir.Data.WorldCache.GetMultiItems( Pos.X, Pos.Y );
        for I := 0 to MultiList.Count-1 do begin
                MultiItem := TMultiItem( MultiList.Items[ I ] );

                if not ( Tiledata.GetStaticFlag( MultiItem.ID, dIMPASSABLE ) or Tiledata.GetStaticFlag( MultiItem.ID, dSURFACE )  or Tiledata.GetStaticFlag( MultiItem.ID, dBRIDGE ) ) then
                        continue;

                new( BlockingItem );
                BlockingItem.Z := MultiItem.Pos.Z;
                BlockingItem.MapTile := False;

                if Tiledata.GetStaticFlag( MultiItem.ID, dBRIDGE ) then
                        BlockingItem.Height := Tiledata.GetStaticHeight( MultiItem.ID ) div 2
                else
                        BlockingItem.Height := Tiledata.GetStaticHeight( MultiItem.ID );

                if Tiledata.GetStaticFlag( MultiItem.ID, dSURFACE ) and ( not Tiledata.GetStaticFlag( MultiItem.ID, dIMPASSABLE ) ) then
                        BlockingItem.Walkable := True
                else
                        BlockingItem.Walkable := False;

                if MultiItem.Id <> $1 then
                        Result.Add( BlockingItem )
                else
                        FreeMem( BlockingItem );
        end;
        MultiList.Free;

        Result.Sort( @SortItems );
end;

procedure TMovement.SendMove( Direction : Byte; Running : Boolean );
var     WalkRequest : TWalkRequest;
        I : Integer;
begin
        if Palanthir.ScriptManager.OnMove( Direction ) then begin
                Exit;
        end;

        WalkRequest := TWalkRequest.Create;
        if Running then
                WalkRequest.SetDirection( Direction or 128 )
        else
                WalkRequest.SetDirection( Direction );
        WalkRequest.SetMoveSequence( MoveSequence );
        WalkRequest.SetFastWalkKey( Keys[ 0 ] );
        Palanthir.SendPacket( WalkRequest );
        Inc( SendCacheCount );

        for I := 4 downto 0 do
                Keys[ I ] := Keys[ I+1 ];
        Keys[ 5 ] := 0;

        if MoveSequence = 255 then
                MoveSequence := 1
        else
                Inc( MoveSequence );
end;

procedure TMovement.Start( Timer : LongWord );
begin
        Self.Timer := Timer;
end;

procedure TMovement.Stop;
begin
        Timer := -1;
        Palanthir.Movement.ClearCache;
end;

function TMovement.FindPath( OrigPos, TargetPos : TPos ) : TList;
begin
end;

end.
