unit uObjectListe;

interface

uses    uUObject, Dialogs, SysUtils;

type    TUObjectListe = array[0..1] of TUObject;

        PUObjectListe = ^TUObjectListe;

        TObjectCache = Class
                private
                        Cache : PUObjectListe;
                        Count : Integer;
                public
                        constructor Create;
                        destructor Free;
                        function GetCount : Integer;
                        procedure AddObject( UObject : TUObject );
                        function GetObject( Serial : LongWord ) : TUObject;
                        function GetObjectByIndex( Index : Integer ) : TUObject;
                        procedure DeleteObject( Serial : LongWord ); overload;
                        procedure DeleteObject( UObject : TUObject ); overload;
        end;

implementation

constructor TObjectCache.Create;
begin
        Count := 0;
end;

destructor TObjectCache.Free;
begin
        if Count > 0 then
                FreeMem( Cache );
end;

function TObjectCache.GetCount : Integer;
begin
        Result := Count;
end;

procedure TObjectCache.AddObject( UObject : TUObject );
var     Max, Min, Pos : Integer;
        NewCache : PUObjectListe;
begin
        Min := 0;
        Max := Count;
        
        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].Serial > UObject.Serial then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].Serial < UObject.Serial then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].Serial = UObject.Serial then begin
                                exit;
                        end;
                end;
        end
        else
                Max := 0;
        
        GetMem( NewCache, (Count+1)*sizeof( TUObject ) );
        if Max > 0 then
                Move( Cache^[ 0 ], NewCache^[ 0 ], Max*sizeof( TUObject ) );
        NewCache^[ Max ] := UObject;
        if Count > Max then
                Move( Cache^[ Max ], NewCache^[ Max+1 ], (Count-Max)*sizeof( TUObject ) );
        if Count > 0 then
                FreeMem( Cache );
        GetMem( Cache, (Count+1)*sizeof( TUObject ) );
        Move( NewCache^[ 0 ], Cache^[ 0 ], (Count+1)*sizeof( TUObject ) );
        FreeMem( NewCache );
        Inc( Count );
end;

function TObjectCache.GetObject( Serial : LongWord ) : TUObject;
var     Max, Min, Pos : Integer;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].Serial > Serial then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].Serial < Serial then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].Serial = Serial then begin
                                Result := Cache^[ Pos ];
                                exit;
                        end;
                end;
        end;
        Result := nil;
end;

function TObjectCache.GetObjectByIndex( Index : Integer ) : TUObject;
begin
        if Index >= Count then begin
                Result := nil;
                exit;
        end;
        Result := Cache^[ Index ];
end;

procedure TObjectCache.DeleteObject( Serial : LongWord );
var     Max, Min, Pos : Integer;
        NewCache : PUObjectListe;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].Serial > Serial then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].Serial < Serial then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].Serial = Serial then begin
                                if Count > 1 then begin
                                        GetMem( NewCache, (Count-1)*sizeof( TUObject ) );
                                        if Pos > 0 then
                                                Move( Cache^[ 0 ], NewCache^[ 0 ], Pos*sizeof( TUObject ) );
                                        if ( Count > Pos+1 ) then
                                                Move( Cache^[ Pos+1 ], NewCache^[ Pos ], (Count-Pos-1)*sizeof( TUObject ) );
                                        FreeMem( Cache );
                                        GetMem( Cache, (Count-1)*sizeof( TUObject ) );
                                        Move( NewCache^[ 0 ], Cache^[ 0 ], (Count-1)*sizeof( TUObject ) );
                                        FreeMem( NewCache );
                                        Dec( Count );
                                end
                                else if Count > 0 then begin
                                        FreeMem( Cache );
                                        Count := 0;
                                end;
                                exit;
                        end;
                end;
        end;
end;

procedure TObjectCache.DeleteObject( UObject : TUObject );
begin
        DeleteObject( UObject.Serial );
end;

end.
