unit uPalanthir;

interface

{
        Changelog

        Version 276:
                fixed bug in MapLoader causing strange z-level values sometimes

        Version 275:
                fixed bug about resend after teleporting
                fixed bug in profile

        Version 274:
                really support for Body.def now

        Version 273:
                fixed bug loading Anim3.mul
                fixed bug in TPalanthir.addspeech not showing sysmessages
                fixed crashbug loading sitdown textures
                added support for Body.def

        Version 272:
                fixed contextmenues on multis

        Version 271:
                update

        Version 270:
                fixed bug in UnicodeLoader
                now one can directly type the number in grabitemgump
                changed OnMouseStayOver time to 3000ms
                changed default dclicktime to 250ms
                added char transparency
                added security check to animloader

        Version 269:
                two additional bugfixed

        Version 268:
                fixed bug removing items from container

        Version 267:
                some gump options added
                bytecache implemented

        Version 266:
                added gumpobject.domousecheck

        Version 265:
                fixed bug in Renderer

        Version 264:
                update

        Version 263:
                added pythonfunction inputfield.textlines

        Version 262:
                added progressfile support

        Version 261:
                security checks for some mulfiles
                fixed some bugs in container handling

        Version 260:
                fixed memory leak in loading of worldblocks
                fixed that the playerchar was not drawn when dead

        Version 259:
                fixed Crashbug
                fixed bug that worldblocks were not unloaded when the player was walking

        Version 258:
                removed check from AnimLoader that was added in last version
                added access to skill-files to source and python
                changed Worldcache Gargabe distance from 64 to 24

        Version 257:
                added plausibility check to AnimLoader

        Version 256:
                fixed Bug saving Gump positions
                added saving positions for Fightgump

        Version 255:
                changed OnMouseStayOver triggertime to 1000
                fixed python tiledata routines

        Version 254:
                fixed OnMouseStayOver does not fire on dragged items anymore

        Version 253:
                fixed default Configvalue ContextMenuButtonNone

        Version 252:
                Added optional additional key for contextmenu
                Added python tiledatasupport
                Added GarbageCollection to AnimationHandler (oO)

        Version 251:
                fixed bug that new chars automatically opened their contextmenu

        Version 250:
                fixed bug in IntlocLoader

        Version 249:
                added Configfile access to python
                added contextmenues
                added some pythonevents
                added intlocloader
                moded some gumps to python

        Version 248:
                implemented Lights for Static items
                implemented Lights for Items that are equipped by Chars

        Version 247:
                random logingumps for ME

        Version 246:
                dragged equipable items are shown over the paperdoll
                changed keyboard text type from string to widestring
                partytext does not need an empty space after backspace anymore

        Version 245:
                added packet to close containers

        Version 244:
                no changes

        Version 243:
                fixed Bug in ShardList

        Version 242:
                fixed bug in loading macros
                readded asciifonts

        Version 241:
                now includes changes of Version 240 ;)

        Version 240:
                changed delay in PollAnims from 100
                to 50 ms
                implemented multifunctional macros
                changed mountlist
                implemented version to control mountlist and macros
                fixed max Items in Cont Bug

        Version 239:
                SAY makro now also can call clientfunctions

        Version 238:
                added specialoptions drawmap
                added specialoptions drawstatics                

        Version 237:
                fixed Bug in CharSpeed
                added Option to Journal to get all text in a custom color

        Version 236:
                implemented Encrypted Passwords

        Version 235:
                fixed Bug in GetCharSpeed

        Version 234:
                added CustomCharSpeed
                added Option to enable borders for journaltext

        Version 233:
                fixed Bug in UnicodeLoader
                fixed Bug regarding Containerhandling
                added small statusgump for player

        Version 232:
                fixed Bug in uCharCreation
                added Logging to uLoaderUnicodeFonts
                added some python functions

        Version 231:
                AllNames implemented
                fixed Bug in MulEncryption
                fixed Bug in Profile and MEProfile
                Added CustomVars to Palanthir module

        Version 230:
                fixed Ping Packet
                added Option to UnicodeTexture
                changed MapItem.Update

        Version 229:
                Small Python Additions
                Moved SpeechColor Saving from Config to Charconfig

        Version 228:
                Fixed Crashbug in Tooltip

        Version 227:
                GumpTooltip for Python
                Fixed Bug in Tooltip

        Version 226:
                Bugfix for Buttons in dynamic Gumps
                Bugfix for MEFightGump
                Implemented Tooltips
                Implemented Tooltips for BuyWindow

        Version 225:
                Bugfix in uLoaderMap II

        Version 224:
                Bugfix in uLoaderMap

        Version 223:
                fix for LoadStaticsMapFromMuls

        Version 222:
                started PyChar
                added possibility to send map/statics from the server instead of reading
                 it from the mulfiles

        Version 221:
                implemented Buttons for Scrollbar in Journal, Profile and MEProfile
                noAutoClose for Gumps on Buttonclick
                changed OpenBuyWindow Packet
                implemented GumpObjects for Python
                
        Version 220:
                fixed PacketsToConsole
                added Logmessages to TPalanthir.Free

        Version 219:
                quick fix in ScriptManager

        Version 218:
                first Version of ScriptManager
                pyPackets
                startet pyGump
                option to log incoming packets to console

        Version 217:
                fixed MEProfile
                fixed Name/Title in Paperdoll
                changed Colors for Names of Statics and Sphere-Sysmessages
                implemented TGumpStaticItem also works with Multis
                implemented Grabbing Multis
                implemented Drag&Drop for Multis

        Version 216:
                fixed Crashbug in DrawCursors

        Version 215:
                fixed heavy performancebug

        Version 214:
                automatically selected text in inputfield of grabitem
                implemented debugconsole

        Version 213:
                removed region screenshot renderer
                implemented dragging statuswindow from fightgump

        Version 212:
                fixed wrong coordinates in TGumpObject.OnDblClick
                fixed massive Bug in TRenderer

        Version 211:
                fixed MEProfile

        Version 210:
                fixed Target on Multis
                added DirectionArrow

        Version 209:
                first parts of region screenshot renderer
                fixed target on multis
                fixed some MulCrypt Bugs
                fixed OpenContainer not working on Layers > 30
                changed some textmessages

        Version 208:
                2 additional Checks for Mittelerde-Mulencryption

        Version 207:
                fixed missing ^ in TexCache
                renamed TPacket.GetName to TPacket.GetInternalName
                removed Gumps.GetTexId
                rewrote TStatusGump
                added security check in GumpLoader

        Version 206:
                fixed Crash for all TEffect

        Version 205:
                fixed GarbageCollection for TTilePic und TLandTilePic (caused problems in buy/sell-gumps)
                fixed GarbageCollection for TEffect
                fixed GarbageCollection for TItemAnimCache
                fixed OpenBoxArt-Gump (Packet 0x7C) not showing Items
}

{
        ME Modifikationen:
}

{
        \packet OpenBuyWindow
        \id 0x74
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint32 VendorBuyPacketSerial
        \param uint8 ItemCount
        
        foreach Item:
        \param uint32 Value
        \param uint8 DescriptionLength
        \param uint8[DescriptionLength] Description (Utf8)

        if VendorBuyPackSerial & 0x80000000
        \param uint8 TooltipLength
        \param uint8[TooltipLength] Tooltip (Utf8)
        endif
        endfor
        
        \notes ServerPacket
        \description Opens a buy window.
}

{
        \packet OpenSellWindow
        \id 0x9E
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint32 VendorSellSerial
        \param uint8 ItemCount

        foreach Item:
        \param uint32 serial
        \param uint16 ItemId
        \param uint16 Hue
        \param uint16 Amount
        \param uint16 Value
        \param uint8 DescriptionLength
        \param uint8[DescriptionLength] Description (Utf8)

        if VendorSellPackSerial & 0x80000000
        \param uint8 TooltipLength
        \param uint8[TooltipLength] Tooltip (Utf8)
        endif
        endfor

        \notes ServerPacket
        \description Opens a sell window.
}
{
        \packet GetCharSize
        \id 0xF5 sub 0x01
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial
        \param uint16 Width (default 1000)
        \param uint16 Height (default 1000)

        \notes ServerPacket
        \description Changes the size of a character.
}
{
        \packet GetFirstMultiId
        \id 0xF5 sub 0x02
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint16 FirstMultiId

        \notes ServerPacket
        \description Changes the area of ids that are interpreted as multis.
        Multis always range from FirstMultiId to FirstMultiId + 0x0FFF.
        Default FirstMultiId is 0x4000.
}
{
        \packet GetMEProfile
        \id 0xF5 sub 0x03
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial
        \param uint16 HeaderLength
        \param uint16[HeaderLength] Header (Unicode)
        \param uint16 DynamicTextLength
        \param uint16[DynamicTextLength] DynamicText (Unicode)
        \param unit16 StaticTextLength
        \param unit16[StaticTextLength] StaticText (Unicode)

        \notes ServerPacket
        \description Opens the ME profile gump.
}
{
        \packet MacAddressRequest
        \id 0xF5 sub 0x04
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId

        \notes ServerPacket
        \description Requests the MacAdress of the client.
}
{
        \packet SendMacAddress
        \id 0xF5 sub 0x05
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8[6] MacAddress

        \notes ClientPacket
        \description Send as answer to the MacAdressRequest packet.
}
{
        \packet RequestVersion
        \id 0xF5 sub 0x06
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId

        \notes ServerPacket
        \description Requests the version number of the client.
}
{
        \packet SendVersion
        \id 0xF5 sub 0x07
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Version

        \notes ClientPacket
        \description Send as answer to the RequestVersion packet.
}
{
        \packet MEFlags
        \id 0xF5 sub 0x08
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Flags (0x1 : RadarDisabled)

        \notes ServerMessage
        \description Send by the server to enable or disable some clientflags.
}
{
        \packet OpenFightGump
        \id 0xF5 sub 0x09 subsub 0x01
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8 SubSubPacketId
        \param uint32 OpponentSerial (Serial == 0xFFFFFFFF => no image)
        \param uint8 IsPlayer (1 == True, 0 == False)
        \param uint8 CurrentHitZone ( 0xFF = None, 0 = Head, 1 = Torso, 2 = Legs, 3 = left Arm, 4 = right Arm, 5 = left Hand, 6 = right Hand )
        \param uint8 Mode
        \param uint8 Speed
        \param uint8 Parrying
        \param uint8 TrefferZoneIsFixed
        \param uint8 ModeIsFixed
        \param uint8 SpeedIsFixed
        \param uint8 ParryingIsFixed

        \notes ServerPacket
        \description Send by the server to open the fighting gump.
}
{
        \packet FightGumpResponse
        \id 0xF5 sub 0x09 subsub 0x02
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8 SubSubPacketId
        \param uint8 HitZone ( 0xFF = None, 0 = Head, 1 = Torso, 2 = Legs, 3 = left Arm, 4 = right Arm, 5 = left Hand, 6 = right Hand )
        \param uint8 Mode
        \param uint8 Speed
        \param uint8 Parrying

        \notes ClientPacket
        \description Send by the client every time the settings in the fighting gump are changed.
}
{
        \packet DoDamage
        \id 0xF5 sub 0x09 subsub 0x03
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8 SubSubPacketId
        \param uint8 HitZone
        \param uint8 Strength (0 == normal hit, 1 = hitzone wounded)

        \notes ServerPacket
        \description Send by the server every time one is damaged.
}
{
        \packet OpenFightGumpRequest
        \id 0xF5 sub 0x09 subsub 0x04
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8 SubSubPacketId

        \notes ClientPacket
        \description Send by the client to open the fighting gump.
}
{
        \packet UpdateWounds
        \id 0xF5 sub 0x0A
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8[7] Wounds per HitZone

        \notes ServerPacket
        \description Sets the number of wounds for the HitZones.
}
{
        \packet AddToInvisList
        \id 0xF5 sub 0x0B
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint16 Count
        \param uint16[Count] Ids

        \notes ServerPacket
        \description All static art ids send this way are not drawn by the client.
}
{
        \packet RemoveFromInvisList
        \id 0xF5 sub 0x0C
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint16 Count
        \param uint16[Count] Ids

        \notes ServerPacket
        \description Removes static art ids from the list of ids that are not drawn.
}
{
        \packet SendDirectionArrow
        \id 0xF5 sub 0x0D
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint16 X
        \param uint16 Y

        \notes ServerPacket
        \description Send py the server to create an arrow that points to the given coordinates.
}
{
        \packet StopLoadStaticsMapFromMuls (experimental)
        \id 0xF5 sub 0x0E
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8 StopLoading (1 == True, 0 == False)

        \notes ServerPacket
        \description Stops loading static and map items from the mulfiles.
        Use this to send them by the server instead of using the client files.
}
{
        \packet SendMapBlock (experimental)
        \id 0xF5 sub 0x0F
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 BlockID

        foreach MapItem (total 64)
        \param uint16 Id
        \param sint8 Z
        endfor

        \notes ServerPacket
        \description Sends a map block.
}
{
        \packet SendStaticBlock (experimental)
        \id 0xF5 sub 0x10
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 BlockID
        \param uint16 StaticCount

        foreach StaticItem
        \param uint16 Id
        \param uint8 X
        \param uint8 Y
        \param sint8 Z
        \param uint16 Color
        endfor

        \notes ServerPacket
        \description Sends a static block.
}
{
        \packet SetWalkingSpeed
        \id 0xF5 sub 0x11
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial
        \param uint16 WalkingDelay (ms)
        \param uint16 RunningDelay (ms)

        \notes ServerPacket
        \description Sets the minimum delay between two walkrequest packets from the server.
}
{
        \packet CloseContainer
        \id 0xF5 sub 0x12
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial

        \notes ServerPacket
        \description Sets the minimum delay between two walkrequest packets from the server.
}

{
        \packet MEInfoRequest
        \id 0xF5 sub 0x13
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial
}

{
        \packet MECharInfo
        \id 0xF5 sub 0x14
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial
        \param uint8 NameLength
        \param uint8[NameLength] Name
        \param uint8 RaceLength
        \param uint8[RaceLength] Race
        \param uint16 ProfileLength
        \param uint8[ProfileLength] Profile
        \param uint8 HitsPercentage
}

{
        \packet MEItemInfo
        \id 0xF5 sub 0x15
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial
        \param uint32 ClilocID
        if ClilocID == 0xFFFFFFFF
                \param uint8 NameLength
                \param uint8[NameLength] Name
        endif
        \param uint16 Amount
        \param uint16 Weight
        \param uint16 Volumen
        \param uint16 IdentificationLength
        \param uint8[IdentificationLength] Identification
}

{
        \packet MEWeather
        \id 0xF5 sub 0x16
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint8 WeatherType
        (Sunshine = 0, Rain = 1, Snow = 2, Fog = 3, Cloudy = 4)
        \param uint8 Intensity
        \param uint8 Wind
}

{
        \packet MECharTransparency
        \id 0xF5 sub 0x17
        \param uint8 PacketId
        \param uint16 PacketLength
        \param uint8 SubPacketId
        \param uint32 Serial
        \param uint8 Transparency
}

{       \packet DisplayContextMenu
        \id 0xBF sub 0x14
        \param uint16 Unknown (Usually 00 01)
        \param uint32 Serial
        \param uint8 EntryCount

        foreach Entry
        \param uint16 Entry Tag
        \param uint16 TextID (intloc)
        \param uint16 Flags (0x01 locked, 0x02 arrow, 0x20 color, 0x200 text, 0x400 subentries)
        if Flags & 0x20
        \param uint16 Color
        endif Flags
        if Flags & 0x200
        \param uint8 TextLength
        \param uint8[TextLength] Text
        endif Flags
        if Flags & 0x400
        \param uint8 SubEntryCount
        foreach SubEntry
        \param uint16 Entry Tag
        \param uint16 TextID (intloc)
        \param uint16 Flags (0x01 locked, 0x02 arrow, 0x20 color, 0x200 text)
        if Flags & 0x20
        \param uint16 Color
        endif Flags
        if Flags & 0x200
        \param uint8 TextLength
        \param uint8[TextLength] Text
        endif Flags
        endfor SubEntry
        endfor Entry
}

{
        Server (part of SendGump Packet)
        GumpPacket: 0xB0
         textbutton <x> <y> <Hoehe> <Breite> <ReturnNumber> <Text> <Font>
        <UpHue> <DownHue> <MoveOverHue> <BackgroundUpId> <BackgroundDownId> <BackgroundMoveOverId>
        <BackgroundUpHue> <BackgroundDownHue> <BackgroundMoveOverHue> <GumpButtonType> <Seitennummer>
}

uses    SysUtils, Messages, Classes, Math, Dialogs, uData, Variants, Forms, Windows,
        ExtCtrls, dglOpenGL, Controls, uLoaderGump, uConfig, uGumps, uCustomGumps,
        uLoaderFonts, uNetwork, uChar, uPlayer, uClient, uLog, uLoaderArt, uUObject,
        uLoaderMap, uWorldCache, uTexCache, uUtilities, uBasicTypeDefs,
        uObjectListe, uLoaderTiledata, uItemAnimCache, uItem, uLoaderAnimations,
        uMausHandler, uMovement, uCursors, uKeyboard, uLoaderUnicodeFonts,
        uSpecialGumps, uShard, uSecretUtility, uTooltip,
        uPacket, uSendPackets, uRecievePackets, uEffect, uScreenShot, uRenderer,
        uSoundManager, uLightManager, rmBrowseFor, uSpeech, StrLib, uPixelBuffer,
        uLoaderMultis, uBasicDrawObject, uParty, uTimer, uJournal, Python,
        uScriptManager, uPos;

const   KB_None = 0;
        KB_Speech = 1;
        KB_Gump = 2;

        KB_Speech_Regular = 0;
        KB_Speech_Emote = 2;
        KB_Speech_Whisper = 3;
        KB_Speech_Yell = 4;
        KB_Speech_Party = 10;
        KB_Speech_UnicodeEntry = 20;
        KB_Speech_Entry = 21;

        Speech_Typ_Regular = 0;
        Speech_Typ_BroadCast = 1;
        Speech_Typ_Emote = 2;
        Speech_Typ_System = 6;
        Speech_Typ_Emphasis = 7;
        Speech_Typ_Whisper = 8;
        Speech_Typ_Yell = 9;

        State_LoggingIn = 0;
        State_EnterGame = 1;
        State_Playing = 2;
        State_Ending = 3;
        State_Disconnect = 4;
        State_CannotReachServer = 5;
        State_ReturnToLogin = 6;
        State_Screenshot = 7;

        Cursor_Standard = 0;
        Cursor_Standard_Fixed = 1;        
        Cursor_Target = 2;

        ItemTransparenz = 256;
        FoliageTransparenz = 257;
        LichtTransparenz = 258;

        Invalid_Serial = $FFFFFFFF;
        Invalid_Texture = $FFFFFFFF;
        Invalid_ID = $FFFF;

        Version = 276;

        CorpseID = $2006;
        JournalFont = 1;

        Color_Grayify = -1;

        Encrypt_None = 0;
        Encrypt_Login = 1;
        Encrypt_Twofish = 2;

        aHighDetailed = 0;
        aLowDetailed = 1;
        aPeople = 2;

        TypTargetExternal = 0;
        TypTargetDebug = 1;
        TypTargetInvisId = 2;
        TypTargetChicken = 3;
        TypTargetInfo = 4;
        TypTargetLOS = 5;

        SelectionColor = $9A;

        WalkingResetTime = 200;

        Sphere_Default_Textcolor = $3B2;

type    TTarget = Class
                public
                        Activated : Boolean;
                        AllowGround : Boolean;
                        Serial : LongWord;
                        Multi : TPixelBuffer;
                        MX, MY : Integer;
                        Typ : Byte;
                        XOffset, YOffset, ZOffset : SmallInt;
                        constructor Create;
                        destructor Free;
                        procedure SetMultiId( MultiId : Word );
                        procedure Execute( UObject : TUODrawObject; TX : Word = 0; TY : Word = 0 );
        end;

        TPalanthir = Class
                private
                        AnimTimer : LongWord;
                        Application : TApplication;
                        GarbageTime : LongWord;
                        Frames : Integer;
                        GumpIdCount : LongWord;
                        GumpObjectIdCount : LongWord;
                        InLoop : Boolean;
                        CharList, EffectList, GumpList, SpeechList, WorldList : TList;
                        ShardName : String;                        
                        StartTick : LongWord;
                        StartTimer : TTimer;
                        SystemSpeech : TSpeech;
                        WaitInMainloop : LongWord;

                        function CheckConfig : Boolean;
                        procedure StartClient( Sender : TObject );
                        procedure MainLoop;
                        procedure BeendeClient;
                        procedure GarbageCollection;
                        //Keyboard
                        procedure OnMessage( var Msg : TMsg; var Handled : Boolean );
                        procedure KeyPress( Sender: TObject; var Key: Char );
                        function CheckForKeyMacros( Key : Integer; Alt, Strg, Shift : Boolean ) : Boolean;
                        //Handling
                        procedure PollAnims;
                        procedure PollEffects;
                public
                        CurrentMap : Word;
                        Cursors : TCursors;
                        CursorState : Byte;
                        CustomVars : PPyObject;
                        Data : TData;
                        DClickTime : LongWord;
                        DebugMode : Boolean;
                        DebugList : TList;
                        DisableRadar : Boolean;
                        DoResendWorld : Boolean;
                        DrawStatics, DrawMap : Boolean;
                        EnabledME : Boolean;
                        FadeGumps : Boolean;
                        FPS : Single;
                        GameWindow : TGameWindow;
                        GlobalLight : Byte;
                        GlobalGumpList, GlobalGumpObjectList : TList;
                        GumpDefaultX, GumpDefaultY : Integer;
                        InvisList : TList;
                        ItemAnimCache : TItemAnimCache;
                        IsUnderMap : Boolean;
                        Keyboard : TKeyboard;
                        LightManager : TLightManager;
                        LoadMapStatics : Boolean;
                        Maus : TMaus;
                        Movement : TMovement;
                        MulEncryption : Boolean;
                        Name : String;
                        NetClient : TClient;
                        Network : TNetwork;
                        Player : TPlayer;
                        RelDrawX, RelDrawY : Integer;
                        ResetTimer : Boolean;
                        RoofHeight : Integer;
                        ScriptManager : TScriptManager;
                        ServerInvisList : TList;
                        Shard : TShard;
                        ShowFPS : Boolean;
                        ShowNames : Boolean;
                        ShowSerials : Boolean;
                        ShowSpeechCount : Boolean;
                        SoundManager : TSoundManager;
                        State : Byte;
                        SU : TSecretUtility;
                        Target : TTarget;
                        Tooltip : TTooltip;
                        TurnAllToChicken : Boolean;
                        UnderMapOsiMode : Boolean; 
                        UseItemUpdateIdFlag : Boolean;
                        WaitInNetworkloop : LongWord;
                        Walkingsounds : Boolean;
                        WorldListSorted : Boolean;

                        FirstMultiID : Word;
                        LastMultiID : Word;

                        constructor Create( SetApplication : TApplication );
                        destructor Free;
                        procedure Init;
                        //Gumps
                        function GetNewGumpId : LongWord;
                        function GetNewGumpObjectId : LongWord;                        
                        procedure AddGump( Gump : TGump );
                        procedure RemoveGump( Gump : TGump ); overload;
                        procedure RemoveGump( Index : Integer ); overload;
                        procedure DeleteGump( Gump : TGump ); overload;
                        procedure DeleteGump( Index : Integer ); overload;
                        function GetGumpCount : Integer;
                        function GetGump( GumpNr : Integer ) : TGump;
                        procedure SetForeGroundGump( Gump : TGump );
                        procedure SendGumpBack( Gump : TGump );
                        //Effects
                        procedure AddEffect( Effect : TEffect );
                        procedure RemoveEffect( Effect : TEffect );
                        //Chars
                        procedure AddChar( Char : TChar );
                        procedure RemoveChar( Char : TChar );
                        //WorldItems
                        procedure AddWorldItem( Item : Pointer );
                        procedure RemoveWorldItem( Item : Pointer );
                        procedure RemoveWorldBlock( BlockID : Integer );
                        procedure ClearWorldCache;
                        procedure SortItemListe( Liste : TList );
                        procedure SortMultiItemListe( Liste : TList );
                        //Speech
                        procedure AddSpeech( Packet : GetSpeech ); overload;
                        procedure AddSysMessage( Text : String; Color : Word = 0 );                        
                        procedure AddTooltip( Packet : GetAttachTooltip );
                        procedure AddUnicodeSpeech( Packet : GetUnicodeMessage );
                        procedure AddClilocSpeech( Packet : GetClilocMessage );
                        procedure AddClilocAffixSpeech( Packet : GetClilocAffix );
                        procedure AddSpeech( Speech : TSpeech ); overload;
                        procedure RemoveSpeech( Speech : TSpeech );
                        procedure BringToFront( Speech : TSpeech );
                        //Drawing
                        procedure DrawGumps;
                        procedure DrawWorld;
                        procedure DrawSpeech;
                        procedure DrawCursor;
                        //InvisList
                        procedure AddToInvisList( Id : Integer );
                        procedure RemoveFromInvisList( Id : Integer );
                        procedure RemoveFromInvisListByNumber( Number : Integer );
                        procedure ClearInvisList;
                        function GetInvisListCount : Integer;
                        function GetInvisListId( Number : Integer ) : Integer;
                        function IsOnInvisList( Id : Integer ) : Boolean;
                        //InvisList
                        procedure AddToServerInvisList( Id : Integer );
                        procedure RemoveFromServerInvisList( Id : Integer );
                        procedure RemoveFromServerInvisListByNumber( Number : Integer );
                        procedure ClearServerInvisList;
                        function GetServerInvisListCount : Integer;
                        function GetServerInvisListId( Number : Integer ) : Integer;
                        function IsOnServerInvisList( Id : Integer ) : Boolean;
                        //Global
                        function GetWindowBreite : Word;
                        function GetWindowHoehe : Word;
                        function GetShardName : String;
                        procedure SetShardName( Text : String );
                        procedure SendPacket( Packet : UOPacket );
                        procedure ChangeMap( NewMap : Word );
                        function GetLightLevel : Byte;
                        procedure ReturnToLoginGump;
                        procedure RemoveFromDebugList( Item : TUODrawObject );
                        procedure ClearDebugList;
                        function GetWorldListCount : Word;
                        procedure EnableME;
                        function CheckForMacros( Text : String ) : Boolean;                        
        end;

var     Palanthir : TPalanthir;

implementation

uses    uClientForm;

constructor TTarget.Create;
begin
        Multi := nil;
end;

destructor TTarget.Free;
begin
        if Multi <> nil then
                Multi.Destroy;
end;

procedure TTarget.SetMultiId( MultiId : Word );
var     Liste : TList;
        I : Integer;
        MinX, MaxX, MinY, MaxY : Integer;
        PX, PY : Integer;
        Item : TBasicMultiItem;
        Texture : TTexObject;
        Breite, Hoehe : Word;
        PosXMin, PosXMax, PosYMin, PosYMax : Integer;
        XMin, XMax, YMin, YMax : Integer;
begin
        if Multi <> nil then begin
                Multi.Destroy;
                Multi := nil;
        end;

        if MultiId = 0 then
                exit;

        Liste := Palanthir.Data.GetMultiItems( MultiId );

        MinX := 0;
        MinY := 0;
        MaxX := 0;
        MaxY := 0;

        for I := 0 to Liste.Count-1 do begin
                Item := TBasicMultiItem( Liste.Items[ I ] );
                Texture := Palanthir.Data.GetStaticArt( Item.ID, 0, True );

                if Texture = nil then
                        continue;
                
                PX := (Item.X - Item.Y) * 22 - ( Texture.Breite div 2 );
                PY := (Item.X + Item.Y) * 22 - Item.Z*4 - Texture.Hoehe +44;
                if PX < MinX then
                        MinX := PX;
                if PX + Texture.Breite > MaxX then
                        MaxX := PX + Texture.Breite;
                if PY < MinY then
                        MinY := PY;
                if PY + Texture.Hoehe > MaxY then
                        MaxY := PY + Texture.Hoehe;
        end;

        MinX := Max( MinX, -Palanthir.GameWindow.Breite );
        MinY := Max( MinY, -Palanthir.GameWindow.Hoehe );
        MaxX := Min( MaxX, Palanthir.GameWindow.Breite );
        MaxY := Min( MaxY, Palanthir.GameWindow.Hoehe );        

        Breite := GetNextBit( MaxX - MinX );
        Hoehe := GetNextBit( MaxY - MinY );

        MX := MinX;
        MY := MinY;

        Multi := TPixelBuffer.Create( Breite, Hoehe, Renderer.DC, Renderer.RC, nil );
        if Multi.Init then begin
                wglShareLists( Renderer.RC, Multi.RC );
        end
        else begin
                Multi.Destroy;
                Multi := nil;
                exit;
        end;

        Multi.Enable;

        glEnable( GL_TEXTURE_2D );

        glMatrixMode( GL_PROJECTION );
        glLoadIdentity;
        glViewPort( 0, 0, Multi.Width, Multi.Height );

        glMatrixMode( GL_MODELVIEW );
        glLoadIdentity;
        glOrtho( 0, Multi.Width, 0, Multi.Height, -1, 1 );

        glClearColor( 0, 0, 0, 0 );
        glClear( GL_COLOR_BUFFER_BIT );

        glEnable( GL_ALPHA_TEST );
        glAlphaFunc( GL_GREATER, 0.1 );

        glColor3f( 1, 1, 1 );

        Palanthir.SortMultiItemListe( Liste );

        for I := Liste.Count-1 downto 0 do begin
                Item := TBasicMultiItem( Liste.Items[ I ] );
                Texture := Palanthir.Data.GetStaticArt( Item.ID, 0, True );
                if Texture = nil then
                        continue;

                if Renderer.CurrentTexID <> Texture.TexID then begin
                        glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                        Renderer.CurrentTexID := Texture.TexID;
                end;
                
                PX := -MX + (Item.X - Item.Y) * 22 - ( Texture.Breite div 2 );
                PY := -MY + (Item.X + Item.Y) * 22 - Item.Z*4 - Texture.Hoehe +44;

                if ( PX >= Multi.Width ) or ( PX + Texture.Breite < 0 ) or ( PY >= Multi.Height ) or ( PY + Texture.Hoehe < 0 ) then
                        continue;

                XMin := Max( PX, 0 );
                PosXMin := XMin - PX;

                YMin := Max( PY, 0 );
                PosYMin := YMin - PY;

                XMax := Min( PX + Texture.Breite, Multi.Width );
                PosXMax := XMax - PX;

                YMax := Min( PY + Texture.Hoehe, Multi.Height );
                PosYMax := YMax - PY;

                glBegin( gl_Quads );
                        gltexcoord2f( PosXMin / GetNextBit( Texture.Breite ), PosYMin / GetNextBit( Texture.Hoehe ) );
                        glvertex2f( XMin, YMin );
                        gltexcoord2f( PosXMin / GetNextBit( Texture.Breite ), PosYMax / GetNextBit( Texture.Hoehe ) );
                        glvertex2f( XMin, YMax );
                        gltexcoord2f( PosXMax / GetNextBit( Texture.Breite ), PosYMax / GetNextBit( Texture.Hoehe ) );
                        glvertex2f( XMax, YMax );
                        gltexcoord2f( PosXMax / GetNextBit( Texture.Breite ), PosYMin / GetNextBit( Texture.Hoehe ) );
                        glvertex2f( XMax, YMin );
                glEnd;

                Item.Free;
        end;
        Liste.Free;
        
        Multi.Disable;
end;

procedure TTarget.Execute( UObject : TUODrawObject; TX, TY : Word );
var     ChooseTarget : TChooseTarget;
        MapInfoGump : TMapInfoGump;
        StaticInfoGump : TStaticInfoGump;
        Pos : TPos;
begin
        if Typ = TypTargetExternal then begin
                if (TX = $FFFF) and (TY = $FFFF) and (UObject = nil) then begin
                        ChooseTarget := TChooseTarget.Create;
                        ChooseTarget.SetType( 0 );
                        ChooseTarget.SetSerial( Palanthir.Target.Serial );
                        ChooseTarget.SetCursorType( 0 );
                        ChooseTarget.SetTargetSerial( 0 );

                        ChooseTarget.SetX( TX );
                        ChooseTarget.SetY( TY );
                        ChooseTarget.SetZ( 0 );
                        ChooseTarget.SetId( 0 );
                        Palanthir.SendPacket( ChooseTarget );
                        Palanthir.Target.Activated := False;
                        Palanthir.CursorState := Cursor_Standard;
                        exit;
                end;

                if UObject = nil then begin
                        if Palanthir.Target.AllowGround then begin
                                ChooseTarget := TChooseTarget.Create;
                                ChooseTarget.SetType( 1 );
                                ChooseTarget.SetSerial( Palanthir.Target.Serial );
                                ChooseTarget.SetCursorType( 0 );
                                ChooseTarget.SetTargetSerial( 0 );

                                ChooseTarget.SetX( TX );
                                ChooseTarget.SetY( TY );
                                ChooseTarget.SetZ( Palanthir.Data.GetMapHeight( TX, TY ) );
                                ChooseTarget.SetId( 0 );
                                Palanthir.SendPacket( ChooseTarget );
                                Palanthir.Target.Activated := False;
                                Palanthir.CursorState := Cursor_Standard;
                        end;
                        exit;
                end;

                if UObject.IsMultiItem and (TMultiItem( UObject ).Owner <> nil) then begin
                        ChooseTarget := TChooseTarget.Create;
                        ChooseTarget.SetType( 0 );
                        ChooseTarget.SetSerial( Palanthir.Target.Serial );
                        ChooseTarget.SetCursorType( 0 );
                        ChooseTarget.SetTargetSerial( TMultiItem( UObject ).Owner.Serial );
                        ChooseTarget.SetX( TMultiItem( UObject ).Owner.Pos.X );
                        ChooseTarget.SetY( TMultiItem( UObject ).Owner.Pos.Y );
                        ChooseTarget.SetZ( TMultiItem( UObject ).Owner.Pos.Z );
                        ChooseTarget.SetId( TMultiItem( UObject ).Owner.ID );
                        Palanthir.SendPacket( ChooseTarget );
                        Palanthir.Target.Activated := False;
                        Palanthir.CursorState := Cursor_Standard;
                end;

                if UObject.IsUObject then begin
                        ChooseTarget := TChooseTarget.Create;
                        ChooseTarget.SetType( 0 );
                        ChooseTarget.SetSerial( Palanthir.Target.Serial );
                        ChooseTarget.SetCursorType( 0 );
                        ChooseTarget.SetTargetSerial( TUObject( UObject ).Serial );
                        ChooseTarget.SetX( UObject.Pos.X );
                        ChooseTarget.SetY( UObject.Pos.Y );
                        ChooseTarget.SetZ( UObject.Pos.Z );
                        ChooseTarget.SetId( UObject.ID );
                        Palanthir.SendPacket( ChooseTarget );
                        Palanthir.Target.Activated := False;
                        Palanthir.CursorState := Cursor_Standard;
                end
                else if Palanthir.Target.AllowGround or (not UObject.IsMap) then begin
                        ChooseTarget := TChooseTarget.Create;
                        ChooseTarget.SetType( 1 );
                        ChooseTarget.SetSerial( Palanthir.Target.Serial );
                        ChooseTarget.SetCursorType( 0 );
                        ChooseTarget.SetTargetSerial( 0 );
                        ChooseTarget.SetX( UObject.Pos.X );
                        ChooseTarget.SetY( UObject.Pos.Y );
                        ChooseTarget.SetZ( UObject.Pos.Z );
                        if UObject.IsMap then
                                ChooseTarget.SetId( 0 )
                        else begin
                                ChooseTarget.SetId( UObject.ID );
                        end;
                        Palanthir.SendPacket( ChooseTarget );
                        Palanthir.Target.Activated := False;
                        Palanthir.CursorState := Cursor_Standard;
                end;
        end
        else if Typ = TypTargetDebug then begin
                if Palanthir.DebugMode and (UObject <> nil) then begin
                        if not UObject.HasFlag( Flag_Debug ) then begin
                                UObject.SetFlag( Flag_Debug );
                                Palanthir.DebugList.Add( UObject );
                        end;
                end;
                Palanthir.Target.Activated := False;
                Palanthir.CursorState := Cursor_Standard;
        end
        else if Typ = TypTargetInvisId then begin
                if (UObject <> nil) and (UObject.IsItem or UObject.IsStatic) then
                        Palanthir.AddToInvisList( UObject.ID );

                Palanthir.Target.Activated := False;
                Palanthir.CursorState := Cursor_Standard;
        end
        else if Typ = TypTargetChicken then begin
                if (UObject <> nil) and UObject.IsChar then
                        if UObject.HasFlag( Flag_Chicken ) then
                                UObject.RemoveFlag( Flag_Chicken )
                        else
                                UObject.SetFlag( Flag_Chicken );
                Palanthir.Target.Activated := False;
                Palanthir.CursorState := Cursor_Standard;
        end
        else if Typ = TypTargetInfo then begin
                if (UObject <> nil) then begin
                        if UObject.IsMap then begin
                                MapInfoGump := TMapInfoGump.Create( UObject.ID, UObject.Pos.X, UObject.Pos.Y, UObject.Pos.Z, TMapItem( UObject ).Z2, TMapItem( UObject ).Z3, TMapItem( UObject ).Z4 );
                                Palanthir.AddGump( MapInfoGump );
                        end
                        else if UObject.IsChar then begin
                                Palanthir.AddSysMessage( 'Info does not work on chars.' );
                        end
                        else begin
                                StaticInfoGump := TStaticInfoGump.Create( UObject.ID, UObject.Color, UObject.Pos.X, UObject.Pos.Y, UObject.Pos.Z );
                                Palanthir.AddGump( StaticInfoGump );
                        end;
                end;
                Palanthir.Target.Activated := False;
                Palanthir.CursorState := Cursor_Standard;
        end
        else if Typ = TypTargetLOS then begin
                if UObject <> nil then begin
                        Pos := TPos.Create( Palanthir.Player.Pos );
                        Inc( Pos.Z, 15 );
                        if Pos.LineOfSight( UObject.Pos ) then begin
                                Palanthir.AddSysMessage( Format( 'LOS von (%d, %d, %d) nach (%d, %d, %d) vorhanden.', [Pos.X,Pos.Y,Pos.Z,UObject.Pos.X,UObject.Pos.Y,UObject.Pos.Z] ) );
                        end else begin
                                Palanthir.AddSysMessage( Format( 'LOS von (%d, %d, %d) nach (%d, %d, %d) nicht vorhanden.', [Pos.X,Pos.Y,Pos.Z,UObject.Pos.X,UObject.Pos.Y,UObject.Pos.Z] ) );
                        end;
                end;
                Palanthir.Target.Activated := False;
                Palanthir.CursorState := Cursor_Standard;
        end;
end;

function TPalanthir.CheckConfig : Boolean;
var     VerzDialog : TrmBrowseForFolder;
begin
        Result := True;

        Log.Write( 'Checking Config' );

        if Config.GetString( 'NotFadeGumps' ) = '' then
                Config.SetBool( 'NotFadeGumps', True );

        if Config.GetString( 'JournalTextBorder' ) = '' then
                Config.SetBool( 'JournalTextBorder', False );
        if Config.GetString( 'JournalEnableCustomColor' ) = '' then
                Config.SetBool( 'JournalEnableCustomColor', False );
        if Config.GetString( 'JournalDefaultCustomColor' ) = '' then
                Config.SetInteger( 'JournalDefaultCustomColor', 2 );

        if Config.GetInteger( 'WaitInMainloop' ) = 0 then
                Config.SetInteger( 'WaitInMainloop', 1 );
        if Config.GetInteger( 'WaitInNetworkloop' ) = 0 then
                Config.SetInteger( 'WaitInNetworkloop', 20 );
        if Config.GetInteger( 'Viewrange' ) = 0 then
                Config.SetInteger( 'Viewrange', 19 );

        WaitInMainloop := Config.GetInteger( 'WaitInMainloop' );
        WaitInNetworkloop := Config.GetInteger( 'WaitInNetworkloop' );

        if Config.GetInteger( 'ScreenWidth' ) = 0 then
                Config.SetInteger( 'ScreenWidth', 800 );
        if Config.GetInteger( 'ScreenHeight' ) = 0 then
                Config.SetInteger( 'ScreenHeight', 600 );
        if Config.GetInteger( 'GameWindowWidth' ) = 0 then
                Config.SetInteger( 'GameWindowWidth', 640 );
        if Config.GetInteger( 'GameWindowHeight' ) = 0 then
                Config.SetInteger( 'GameWindowHeight', 480 );

        if Config.GetString( 'DClickTime' ) = '' then
                Config.SetInteger( 'DClickTime', 250 );

        if Config.GetString( 'ShowSpeechCount' ) = '' then
                Config.SetBool( 'ShowSpeechCount', False );

        if Config.GetString( 'Language' ) = '' then
                Config.SetString( 'Language', 'enu' );

        if Config.GetString( 'SoundVolume' ) = '' then
                Config.SetInteger( 'SoundVolume', 128 );
        if Config.GetString( 'MusicVolume' ) = '' then
                Config.SetInteger( 'MusicVolume', 40 );
        if Config.GetString( 'Walkingsounds' ) = '' then
                Config.SetBool( 'Walkingsounds', True );

        if Config.GetString( 'ContextMenuButtonNone' ) = '' then
                Config.SetBool( 'ContextMenuButtonNone', True );

        if ( Config.GetString( 'UOPath' ) = '' ) or ( not DirectoryExists( Config.GetString( 'UOPath' ) ) ) then begin
                VerzDialog := TrmBrowseForFolder.create( nil );
                VerzDialog.Title := 'Choose your UO Directory';

                if VerzDialog.Execute then begin
                        Config.SetString( 'UOPath', VerzDialog.Folder + '\' );
                end
                else begin
                        Result := False;
                end;

                VerzDialog.Free;
        end;

        if ( Config.GetString( 'UOPath' ) = '' ) or ( not DirectoryExists( Config.GetString( 'UOPath' ) ) ) then begin
                Showmessage( 'Not able to find your Ultima Online directory.' );
                Result := False;
        end;
end;

procedure TPalanthir.StartClient( Sender : TObject );
begin
        StartTimer.Free;

        if not CheckConfig then begin
                Application.Terminate;
                exit;
        end;

        if ( Config.GetString( 'Shardname' ) = '' ) or ( not DirectoryExists( ExtractFilePath( Application.ExeName ) + 'shards\' + Config.GetString( 'Shardname' ) ) ) then begin
                showmessage( 'Choose a correct shard... (Shard directory does not exist)' );
                BeendeClient;
                exit;
        end;

        Shard := TShard.Create( Config.GetString( 'UOPath' ), ExtractFilePath( Application.ExeName ) + 'shards\' + Config.GetString( 'Shardname' ) + '\' );
        Log.Write( 'Initializing SoundManager' );
        SoundManager.SetSound( Config.GetBool( 'Sound' ) );
        SoundManager.SetMusic( Config.GetBool( 'Music' ) );
        ShowNames := Config.GetBool( 'ShowNames' );
        Walkingsounds := Config.GetBool( 'Walkingsounds' );

        DClickTime := Config.GetInteger( 'DClickTime' );
        ShowSpeechCount := Config.GetBool( 'ShowSpeechCount' );
        MulEncryption := Shard.ShardConfig.GetInteger( 'MCrypt' ) > 0;

        if MulEncryption then begin
                Palanthir.EnableME;
                Config.SetString( 'Language', 'deu' );
        end;

        Keyboard.Language := Config.GetString( 'Language' );

        State := State_LoggingIn;

        StartTick := CustomGetTickCount;

        Log.Write( 'Loading Renderer' );
        Renderer := TRenderer.Create( ClientForm.Handle );
        Renderer.SetSize( 640, 480 );
        //Renderer.SetSize( Config.GetInteger( 'ScreenWidth' ), Config.GetInteger( 'ScreenHeight' ) );

        Log.Write( 'Loading Datafiles' );
        Data := TData.Create;
        if Shard.ShardConfig.GetString( 'DataPath' ) <> '' then
                Data.Load( Config.GetString( 'UOPath' ), Shard.ShardConfig.GetString( 'DataPath' ) )
        else
                Data.Load( Config.GetString( 'UOPath' ), ExtractFilePath( Application.ExeName ) + 'shards\' + Config.GetString( 'Shardname' ) + '\data\' );

        ShowSerials := False;

        GlobalLight := 0;
        GarbageTime := CustomGetTickCount;

        Log.Write( 'Loading Cursors' );
        Cursors := TCursors.Create;
        CursorState := Cursor_Standard;
        ClientForm.Cursor := crNone;

        Log.Write( 'Creating Player' );
        Player := TPlayer.Create;

        Log.Write( 'Starting ScriptManager' );
        ScriptManager := TScriptManager.Create;
        Log.Write( 'Starting Python' );
        ScriptManager.StartPython( Application.ExeName, ExtractFilePath( Application.ExeName ) + 'shards\' + Config.GetString( 'Shardname' ) + '\script\' );
        Log.Write( 'Loading Scripts' );
        ScriptManager.LoadScripts;

        if ParamStr( 1 ) = '-start' then begin
                ScriptManager.OnClientReady;
        end;

        Application.OnMessage := OnMessage;
        ClientForm.OnKeyPress := KeyPress;

        Log.Write( 'Show Window' );
        ClientForm.Show;
        ClientForm.BringToFront;

        MainLoop;
end;

procedure TPalanthir.GarbageCollection;
var     I : Integer;
        UObject : TUObject;
begin
        if State <> State_Screenshot then begin
                I := Data.GlobalObjectList.GetCount-1;
                while I >= 0 do begin
                        if I < Data.GlobalObjectList.GetCount then begin
                                UObject := Data.GlobalObjectList.GetObjectByIndex( I );
                                if (UObject.Container = nil) and (not UObject.Pos.IsInRechteckRange( Player.Pos, Player.VisRange ) ) then begin
                                        UObject.Free;
                                end;
                                Dec( I );
                        end
                        else begin
                                I := Data.GlobalObjectList.GetCount-1;
                        end;
                end;
                Data.WorldCache.GarbageCollection;
        end;
end;

procedure TPalanthir.Mainloop;
var     DisconnectMessageGump : TDisconnectMessageGump;
begin
        while State <> State_Ending do begin
                if State = State_Disconnect then begin
                        DisconnectMessageGump := TDisconnectMessageGump.Create( 'You have been disconnected.' );
                        AddGump( DisconnectMessageGump );
                        State := State_LoggingIn;
                end
                else if State = State_CannotReachServer then begin
                        DisconnectMessageGump := TDisconnectMessageGump.Create( 'Not able to reach the Server.' );
                        AddGump( DisconnectMessageGump );
                        State := State_LoggingIn;                        
                end;

                if (State = State_Playing) and (not NetClient.Active) then begin
                        Log.Write( 'ReturnToLoginGump: Client disconnected' );
                        ReturnToLoginGump;
                        Continue;
                end;

                try
                        Timer.Start( Timer_MainLoop );

                        Timer.Start( Timer_Renderer2 );
                        Renderer.StartZeichnen;
                        Timer.Pause( Timer_Renderer2 );

                        Timer.Start( Timer_Network );
                        Network.Poll( NetClient );
                        Timer.Stop( Timer_Network );

                        Data.Poll;

                        Timer.Start( Timer_Movement );
                        Movement.Poll;
                        Timer.Stop( Timer_Movement );

                        Timer.Start( Timer_Maus );
                        Maus.StartCheck;
                        Timer.Pause( Timer_Maus );

                        Timer.Start( Timer_ItemAnim );
                        ItemAnimCache.Poll;
                        Timer.Stop( Timer_ItemAnim );

                        Timer.Start( Timer_Anim );
                        PollAnims;
                        Timer.Stop( Timer_Anim );

                        Timer.Start( Timer_Effects );
                        PollEffects;
                        Timer.Stop( Timer_Effects );

                        Timer.Start( Timer_DrawWorld );
                        DrawWorld;
                        Timer.Stop( Timer_DrawWorld );

                        Timer.Start( Timer_DrawSpeech );
                        DrawSpeech;
                        Timer.Stop( Timer_DrawSpeech );

                        Timer.Start( Timer_DrawGumps );
                        DrawGumps;
                        Timer.Stop( Timer_DrawGumps );

                        Timer.Start( Timer_DrawCursor );
                        DrawCursor;
                        Timer.Stop( Timer_DrawCursor );

                        Timer.Continue( Timer_Maus );
                        Maus.Poll;
                        Maus.ResetEvents;
                        Timer.Stop( Timer_MausCheck );
                        Timer.Stop( Timer_Maus );

                        Timer.Continue( Timer_Renderer2 );
                        Renderer.FinishZeichnen;
                        Timer.Stop( Timer_Renderer2 );
                        Timer.Stop( Timer_Draw );
                        Timer.Stop( Timer_Renderer );
                        Timer.Stop( Timer_RendererCalc );

                        Timer.Start( Timer_SSU );
                        ScreenShotUtility.Poll;
                        Timer.Stop( Timer_SSU );

                        Timer.Start( Timer_Garbage );
                        if CustomGetTickCount > GarbageTime + 5000 then begin
                                GarbageCollection;
                                GarbageTime := CustomGetTickCount;
                        end;
                        Timer.Stop( Timer_Garbage );
                except
                        Timer.Stop( Timer_MainLoop );
                        Application.HandleException( Self );
                end;

                Timer.Start( Timer_Frames );
                Inc( Frames );
                if CustomGetTickCount - StartTick >= 500 then begin
                        FPS       := Frames*1000/( CustomGetTickCount-StartTick );
                        Frames    := 0;
                        StartTick := CustomGetTickCount;
                        if ShowFPS then begin
                                if State = State_Playing then
                                        ClientForm.SetCaption( Format( 'Ultima Online - %s (%s) (%d FPS)', [Name,ShardName,Trunc( FPS )] ) )
                                else
                                        ClientForm.SetCaption( Format( 'Ultima Online (%d FPS)', [Trunc( FPS )] ) );
                        end else begin
                                if State = State_Playing then
                                        ClientForm.SetCaption( Format( 'Ultima Online - %s (%s)', [Name,ShardName] ) )
                                else
                                        ClientForm.SetCaption( Format( 'Ultima Online', [] ) );
                        end;
                end;
                Timer.Stop( Timer_Frames );
                Timer.Stop( Timer_MainLoop );

                if ResetTimer then begin
                        Timer.ResetAll;
                        ResetTimer := False;
                end;

                Application.ProcessMessages;

                if Frames < 40 then
                        Sleep( 1 )
                else
                        Sleep( WaitInMainloop );
        end;

        BeendeClient;
end;

procedure TPalanthir.BeendeClient;
var     Logout : TLogout;
begin
        if GameWindow <> nil then begin
                ScriptManager.OnGameLeave;
        end;
        
        if (NetClient <> nil) and NetClient.Active and (Palanthir.GameWindow <> nil) then begin
                Logout := TLogout.Create;
                SendPacket( Logout );
                Sleep( 100 );
        end;
        ClientForm.Close;
end;

procedure TPalanthir.OnMessage( var Msg: TMsg; var Handled: Boolean );
var     SendWarMode : TSendWarMode;
        Key : Integer;
        Alt, Strg, Shift : Boolean;
        ConsoleTextEntryResponse : TConsoleTextEntryResponse;
        SendUnicodePrompt : TSendUnicodePrompt;
        TmpString : String;
begin
        if (Msg.message = WM_KEYDOWN) or (Msg.message = WM_SYSKEYDOWN) then begin
                Key := Msg.wParam;

                Strg := GetKeyState( VK_CONTROL ) < 0;

                if Strg then begin
                        Case Key of
                                Ord('d'), Ord('D') : begin
                                        if State = State_Playing then begin
                                                Keyboard.SpeechText := '';
                                                Keyboard.Typ := KB_Speech_Regular;
                                                Keyboard.SelPos := 0;
                                                Handled := True;
                                                exit;
                                        end;
                                end;
                                Ord('v'), Ord('V') : begin
                                        if Keyboard.KeyboardMode = KB_Speech then begin
                                                Keyboard.SpeechText := Keyboard.SpeechText + GetPasteString;
                                                Keyboard.SelPos := Length( Keyboard.SpeechText );
                                        end
                                        else if Keyboard.KeyboardMode = KB_Gump then begin
                                                if TInputField( Keyboard.SelectedGumpObject ).DeleteTextOnNextChange then begin
                                                        TInputField( Keyboard.SelectedGumpObject ).Text := GetPasteString;
                                                        TInputField( Keyboard.SelectedGumpObject ).DeleteTextOnNextChange := False;
                                                end
                                                else begin
                                                        TInputField( Keyboard.SelectedGumpObject ).Text := TInputField( Keyboard.SelectedGumpObject ).Text + GetPasteString;
                                                end;
                                                TInputField( Keyboard.SelectedGumpObject ).SelectedPos := Length( TInputField( Keyboard.SelectedGumpObject ).Text );
                                        end;
                                        Handled := True;
                                        exit;
                                end;
                                Ord('c'), Ord('C') : begin
                                        if Maus.SelectedSpeech <> nil then begin
                                                SetPasteString( Maus.SelectedSpeech.Text );
                                        end;
                                end;
                                Ord('w'), Ord('W') : begin
                                        if Maus.MObject <> nil then begin
                                                if Maus.MObject.IsGump and (TGumpObject( Maus.MObject ).Gump <> nil) then begin
                                                        TGumpObject( Maus.MObject ).onDblClick( 0, 0 );
                                                end
                                                else if Maus.MObject.IsUODrawObject then begin
                                                        TUODrawObject( Maus.MObject ).OnDblClick;
                                                end;
                                        end;
                                end;
                        end;
                end;

                case Key of
                        VK_TAB : begin
                                if Maus.SelectedGumpObject <> nil then
                                        if Maus.SelectedGumpObject.onKeyTab then begin
                                                Handled := True;
                                                exit;
                                        end;
                        end;
                        VK_RETURN : begin
                                if Keyboard.SelectedGumpObject <> nil then begin
                                        if Keyboard.SelectedGumpObject.onKeyReturn then begin
                                                Handled := True;
                                                exit;
                                        end;
                                end
                                else if Maus.SelectedGumpObject <> nil then begin
                                        if Maus.SelectedGumpObject.onKeyReturn then begin
                                                Handled := True;
                                                exit;
                                        end;
                                end;
                        end;
                end;

                if State = State_Playing then begin
                        Alt := GetKeyState( VK_MENU ) < 0;
                        Shift := GetKeyState( VK_SHIFT ) < 0;

                        if CheckForKeyMacros( Key, Alt, Strg, Shift ) then begin
                                Handled := True;
                        end
                        else begin
                                case Key of
                                        VK_TAB : begin
                                                SendWarMode := TSendWarMode.Create( True );
                                                NetClient.Send( SendWarMode );
                                                Handled := True;
                                        end;
                                        VK_ESCAPE : begin
                                                if Target.Activated then begin
                                                        Target.Execute( nil, $FFFF, $FFFF );
                                                        Handled := True;
                                                end
                                                else if Keyboard.Typ = KB_Speech_UnicodeEntry then begin
                                                        SendUnicodePrompt := TSendUnicodePrompt.Create;
                                                        SendUnicodePrompt.SetMessageId( Keyboard.MessageId );
                                                        SendUnicodePrompt.SetPlayerId( Keyboard.PlayerId );
                                                        SendUnicodePrompt.SetLanguage( Keyboard.Language );
                                                        SendUnicodePrompt.SetText( '' );
                                                        Palanthir.SendPacket( SendUnicodePrompt );
                                                        Keyboard.SpeechText := '';
                                                        Keyboard.SelPos := 0;
                                                        Keyboard.Typ := KB_Speech_Regular;
                                                        Handled := True;
                                                end
                                                else if Keyboard.Typ = KB_Speech_Entry then begin
                                                        ConsoleTextEntryResponse := TConsoleTextEntryResponse.Create;
                                                        ConsoleTextEntryResponse.SetObjectID( Keyboard.PlayerId );
                                                        ConsoleTextEntryResponse.SetPrompt( Keyboard.MessageId );
                                                        ConsoleTextEntryResponse.SetRequest( 0 );
                                                        Palanthir.SendPacket( ConsoleTextEntryResponse );
                                                        Keyboard.SpeechText := '';
                                                        Keyboard.SelPos := 0;                                                        
                                                        Keyboard.Typ := KB_Speech_Regular;
                                                        Handled := True;
                                                end;
                                        end;
                                        VK_F12 : begin
                                                ScreenShotUtility.Shot;
                                        end;
                                        Ord('Q'), Ord('q') : begin
                                                if Strg then begin
                                                        Keyboard.GetLastText;
                                                        Handled := True;
                                                end;
                                        end;
                                        VK_UP : begin
                                                Keyboard.GetLastText;
                                                Handled := True;
                                        end;
                                        VK_DOWN : begin
                                                Keyboard.GetNextText;
                                                Handled := True;
                                        end;
                                        VK_LEFT : begin
                                                if Keyboard.SelPos > 0 then begin
                                                        Keyboard.SelPos := Keyboard.SelPos - 1;
                                                        Handled := True;
                                                end;
                                        end;
                                        VK_RIGHT : begin
                                                if Keyboard.SelPos < Length( Keyboard.SpeechText ) then begin
                                                        Keyboard.SelPos := Keyboard.SelPos + 1;
                                                        Handled := True;
                                                end;
                                        end;
                                        VK_DELETE : begin
                                                if Keyboard.KeyboardMode = KB_Speech then begin
                                                        if (Length( Keyboard.SpeechText ) > 0) and (Keyboard.SelPos < Length( Keyboard.SpeechText ) ) then begin
                                                                TmpString := Keyboard.SpeechText;
                                                                Delete( TmpString, Keyboard.SelPos+1, 1 );
                                                                Keyboard.SpeechText := TmpString;
                                                        end;
                                                        if Length( Keyboard.SpeechText ) = 0 then begin
                                                                Keyboard.Typ := KB_Speech_Regular;
                                                                Palanthir.Player.Party.TalkToSerial := Invalid_Serial;
                                                        end;
                                                end;
                                        end;
                                        VK_HOME : begin
                                                Keyboard.SelPos := 0;
                                        end;
                                        VK_END : begin
                                                Keyboard.SelPos := Length( Keyboard.SpeechText );
                                        end;
                                end;
                        end;
                end;
        end
        else if (Msg.message = WM_KEYUP) or (Msg.message = WM_SYSKEYUP) then begin
                Key := Msg.wParam;
                if State = State_Playing then begin
                        //Alt := GetKeyState( VK_MENU ) < 0;
                        //Strg := GetKeyState( VK_CONTROL ) < 0;
                        //Shift := GetKeyState( VK_SHIFT ) < 0;

                        case Key of
                                VK_TAB : begin
                                        SendWarMode := TSendWarMode.Create( False );
                                        NetClient.Send( SendWarMode );
                                        Handled := True;
                                end;
                        end;
                end;
        end;
end;

procedure TPalanthir.KeyPress( Sender: TObject; var Key: Char );
var     SpeechRequest : TSendSpeechRequest;
        SendUnicodePrompt : TSendUnicodePrompt;
        TmpString : String;
        SendAddPartyMember : TSendAddPartyMember;
        SendRemovePartyMember : TSendRemovePartyMember;
        SendPartyAccept : TSendPartyAccept;
        SendPartyDecline : TSendPartyDecline;
        SendPartyCanLoot : TSendPartyCanLoot;
        ConsoleTextEntryResponse : TConsoleTextEntryResponse;
begin
        if Keyboard.KeyboardMode = KB_Speech then begin
                if Key = Chr( 8 ) then begin
                        if (Length( Keyboard.SpeechText ) > 0) and (Keyboard.SelPos > 0) then begin
                                TmpString := Keyboard.SpeechText;
                                Delete( TmpString, Keyboard.SelPos, 1 );
                                Keyboard.SelPos := Keyboard.SelPos - 1;
                                Keyboard.SpeechText := TmpString;
                        end;
                        if Length( Keyboard.SpeechText ) = 0 then begin
                                Keyboard.Typ := KB_Speech_Regular;
                                Palanthir.Player.Party.TalkToSerial := Invalid_Serial;
                        end;
                end
                else if Ord( Key ) > 31 then begin
                        TmpString := Keyboard.SpeechText;
                        Insert( Key, TmpString, Keyboard.SelPos+1 );
                        Keyboard.SelPos := Keyboard.SelPos + 1;
                        Keyboard.SpeechText := TmpString;
                        if Length( Keyboard.SpeechText ) = 1 then begin
                                if Keyboard.SpeechText[ 1 ] = '/' then begin
                                        Keyboard.Typ := KB_Speech_Party;
                                        Keyboard.SpeechText := '';
                                        Keyboard.SelPos := 0;
                                end;
                        end
                        else if Length( Keyboard.SpeechText ) = 2 then begin
                                if Keyboard.SpeechText[ 2 ] = ' ' then begin
                                        if Keyboard.SpeechText[ 1 ] = ':' then begin
                                                Keyboard.Typ := KB_Speech_Emote;
                                                Keyboard.SpeechText := '';
                                                Keyboard.SelPos := 0;
                                        end
                                        else if Keyboard.SpeechText[ 1 ] = ';' then begin
                                                Keyboard.Typ := KB_Speech_Whisper;
                                                Keyboard.SpeechText := '';
                                                Keyboard.SelPos := 0;
                                        end
                                        else if Keyboard.SpeechText[ 1 ] = '!' then begin
                                                Keyboard.Typ := KB_Speech_Yell;
                                                Keyboard.SpeechText := '';
                                                Keyboard.SelPos := 0;                                                
                                        end;
                                end;
                        end;
                end
                else if (( Ord( Key ) = VK_RETURN ) or ( Ord( Key ) = VK_EXECUTE )) then begin
                        if (Keyboard.SpeechText <> '') then begin
                                if Keyboard.Typ = KB_Speech_Party then begin
                                        if LowerCase( Keyboard.SpeechText ) = 'add' then begin
                                                if Player.Party.Status <> PartyStatus_Invitation then begin
                                                        SendAddPartyMember := TSendAddPartyMember.Create;
                                                        SendAddPartyMember.SetSerial( 0 );
                                                        SendPacket( SendAddPartyMember );

                                                        SendPartyCanLoot := TSendPartyCanLoot.Create;
                                                        SendPartyCanLoot.SetCanLoot( Player.Party.CanLoot );
                                                        SendPacket( SendPartyCanLoot );
                                                end;
                                        end
                                        else if LowerCase( Keyboard.SpeechText ) = 'remove' then begin
                                                if Player.Party.Status = PartyStatus_Established then begin
                                                        SendRemovePartyMember := TSendRemovePartyMember.Create;
                                                        SendRemovePartyMember.SetSerial( 0 );
                                                        SendPacket( SendRemovePartyMember );
                                                end;
                                        end
                                        else if LowerCase( Keyboard.SpeechText ) = 'accept' then begin
                                                if Player.Party.Status = PartyStatus_Invitation then begin
                                                        SendPartyAccept := TSendPartyAccept.Create;
                                                        SendPartyAccept.SetLeaderSerial( Palanthir.Player.Party.PartyLeaderSerial );
                                                        SendPacket( SendPartyAccept );
                                                end
                                                else begin
                                                        AddSysMessage( 'No one has invited you to be in a party.' );
                                                end;
                                        end
                                        else if LowerCase( Keyboard.SpeechText ) = 'decline' then begin
                                                if Player.Party.Status = PartyStatus_Invitation then begin
                                                        SendPartyDecline := TSendPartyDecline.Create;
                                                        SendPartyDecline.SetLeaderSerial( Palanthir.Player.Party.PartyLeaderSerial );
                                                        SendPacket( SendPartyDecline );
                                                end
                                                else begin
                                                        AddSysMessage( 'No one has invited you to be in a party.' );
                                                end;                                                
                                        end
                                        else begin
                                                if Player.Party.Status = PartyStatus_Established then begin
                                                        Player.Party.SendMessage( Keyboard.SpeechText );
                                                end
                                                else begin
                                                        AddSysMessage( Format( 'Note to self: %s', [Keyboard.SpeechText] ) );
                                                end;
                                        end;
                                        Keyboard.SpeechText := '';
                                        Keyboard.SelPos := 0;
                                        Keyboard.Typ := KB_Speech_Regular;
                                end
                                else if Keyboard.Typ = KB_Speech_UnicodeEntry then begin
                                        SendUnicodePrompt := TSendUnicodePrompt.Create;
                                        SendUnicodePrompt.SetMessageId( Keyboard.MessageId );
                                        SendUnicodePrompt.SetPlayerId( Keyboard.PlayerId );
                                        SendUnicodePrompt.SetLanguage( Keyboard.Language );
                                        SendUnicodePrompt.SetText( Keyboard.SpeechText );
                                        Palanthir.SendPacket( SendUnicodePrompt );
                                        Keyboard.SpeechText := '';
                                        Keyboard.SelPos := 0;
                                        Keyboard.Typ := KB_Speech_Regular;
                                end
                                else if Keyboard.Typ = KB_Speech_Entry then begin
                                        ConsoleTextEntryResponse := TConsoleTextEntryResponse.Create;
                                        ConsoleTextEntryResponse.SetObjectID( Keyboard.PlayerId );
                                        ConsoleTextEntryResponse.SetPrompt( Keyboard.MessageId );
                                        ConsoleTextEntryResponse.SetRequest( 1 );
                                        ConsoleTextEntryResponse.SetText( Keyboard.SpeechText );
                                        Palanthir.SendPacket( ConsoleTextEntryResponse );
                                        Keyboard.SpeechText := '';
                                        Keyboard.SelPos := 0;
                                        Keyboard.Typ := KB_Speech_Regular;
                                end
                                else begin
                                        if (not CheckForMacros( Keyboard.SpeechText )) and (not ScriptManager.OnSpeech( Keyboard.SpeechText )) then begin
                                                SpeechRequest := TSendSpeechRequest.Create;
                                                SpeechRequest.SetType( Keyboard.Typ );
                                                if Keyboard.Typ = KB_Speech_Emote then begin
                                                        SpeechRequest.SetColor( Keyboard.EmoteColor );
                                                        SpeechRequest.SetMsg( '*' + Keyboard.SpeechText + '*' );
                                                end
                                                else begin
                                                        SpeechRequest.SetColor( Keyboard.SpeechColor );
                                                        SpeechRequest.SetMsg( Keyboard.SpeechText );
                                                end;
                                                SpeechRequest.SetFont( 3 );
                                                SpeechRequest.SetLanguage( Keyboard.Language );
                                                NetClient.Send( SpeechRequest );
                                        end;
                                        Keyboard.AddText( Keyboard.SpeechText, Keyboard.Typ );
                                        Keyboard.SpeechText := '';
                                        Keyboard.SelPos := 0;
                                        Keyboard.Typ := KB_Speech_Regular;
                                end;
                        end
                        else begin
                                Keyboard.Typ := KB_Speech_Regular;
                        end;
                end;
        end
        else if Keyboard.KeyboardMode = KB_Gump then begin
                if Key = Chr( 8 ) then begin
                        if (Length( TInputField( Keyboard.SelectedGumpObject ).Text ) > 0) and (TInputField( Keyboard.SelectedGumpObject ).SelectedPos > 1) then begin
                                TmpString := TInputField( Keyboard.SelectedGumpObject ).Text;
                                Delete( TmpString, TInputField( Keyboard.SelectedGumpObject ).SelectedPos-1, 1 );
                                TInputField( Keyboard.SelectedGumpObject ).SelectedPos := TInputField( Keyboard.SelectedGumpObject ).SelectedPos - 1;
                                TInputField( Keyboard.SelectedGumpObject ).Text := TmpString;
                        end;
                end
                else if Ord( Key ) > 31 then begin
                        if TInputField( Keyboard.SelectedGumpObject ).AllowOnlyNumbers and ( not (Key in ['0'..'9']) ) then
                                exit;
                        if TInputField( Keyboard.SelectedGumpObject ).SelectedPos < Length( TInputField( Keyboard.SelectedGumpObject ).Text ) then begin
                                if TInputField( Keyboard.SelectedGumpObject ).DeleteTextOnNextChange then begin
                                        TInputField( Keyboard.SelectedGumpObject ).Text := Key;
                                        TInputField( Keyboard.SelectedGumpObject ).DeleteTextOnNextChange := False;
                                        TInputField( Keyboard.SelectedGumpObject ).SelectedPos := 1;
                                end
                                else begin
                                        TmpString := TInputField( Keyboard.SelectedGumpObject ).Text;
                                        Insert( Key, TmpString, TInputField( Keyboard.SelectedGumpObject ).SelectedPos );
                                        TInputField( Keyboard.SelectedGumpObject ).Text := TmpString;
                                        TInputField( Keyboard.SelectedGumpObject ).SelectedPos := TInputField( Keyboard.SelectedGumpObject ).SelectedPos+1;
                                end;
                        end
                        else begin
                                if TInputField( Keyboard.SelectedGumpObject ).DeleteTextOnNextChange then begin
                                        TInputField( Keyboard.SelectedGumpObject ).Text := Key;
                                        TInputField( Keyboard.SelectedGumpObject ).DeleteTextOnNextChange := False;
                                        TInputField( Keyboard.SelectedGumpObject ).SelectedPos := 1;
                                end
                                else begin
                                        TInputField( Keyboard.SelectedGumpObject ).Text := TInputField( Keyboard.SelectedGumpObject ).Text + Key;
                                        TInputField( Keyboard.SelectedGumpObject ).SelectedPos := TInputField( Keyboard.SelectedGumpObject ).SelectedPos+1;
                                end;
                        end;
                end;
        end;
end;

function TPalanthir.CheckForMacros( Text : String ) : Boolean;
var     Command : String;
        ClientStatus : TClientStatus;
        InvisListStatus : TInvisListStatus;
        ResyncRequest : TResyncRequest;
        TimerGump : TTimerGump;
        AboutGump : TAboutGump;
begin
        Result := SU.Check( Text );

        if (not Result) and (Text <> '') and (Text[1] = '?') then begin
                Command := UpperCase( Copy( Text, 2, Length( Text )-1 ) );
                {
                        \command Help
                        \description Returns a list of all available commands.
                }
                if (Command = 'HELP') or (Command = '') then begin
                        AddSysMessage( 'Commands: Debug, Info, InvisList, Los, Resync, ReloadScripts, Status, Timer, Where' );
                        Result := True;
                end
                {
                        \command Status
                        \description Returns a list of all some client values.
                }
                else if Command = 'STATUS' then begin
                        ClientStatus := TClientStatus.Create;
                        ClientStatus.Init;
                        AddGump( ClientStatus );
                        Result := True;
                end
                {
                        \command Debug
                        \description A command to hide single ingame objects.
                        \usage
                        - <code>debug enable</code>
                        Enables debug mode.
                        - <code>debug disable</code>
                        Disables debug mode.
                        - <code>debug clear</code>
                        Clears the debuglist.
                        - <code>debug add</code>
                        Creates a target cursor to add an object to the debuglist.
                        \notes All objects that are on the debuglist are not drawn when debug mode is enabled.
                }
                else if Copy( Command, 1, 6 ) = 'DEBUG ' then begin
                        Command := Copy( Command, 7, Length( Command )-6 );

                        if Command = '' then
                                DebugMode := not DebugMode
                        else if Command = 'ENABLE' then
                                DebugMode := True
                        else if Command = 'DISABLE' then begin
                                DebugMode := False;
                                ClearDebugList;
                        end
                        else if Command = 'CLEAR' then
                                ClearDebugList
                        else if Command = 'ADD' then begin
                                if DebugMode then begin
                                        Target.AllowGround := True;
                                        Target.Serial := 0;
                                        Target.Activated := True;
                                        Target.SetMultiId( 0 );
                                        Target.Typ := TypTargetDebug;
                                        CursorState := Cursor_Target;
                                        Cursors.CurrentCursor := crUOTarget;
                                end;
                        end
                        else if Command = '?' then begin
                                AddSysMessage( 'Options: Add, Clear, Disable, Enable' );
                        end;
                        Result := True;
                        exit;
                end
                {
                        \command Invislist
                        \description A command to hide all objects with a specific art id.
                        \usage
                        - <code>invislist clear</code>
                        Clears the debuglist.
                        - <code>debug add [id]</code>
                        If id is present then this id is added to the inivislist.
                        Otherwise a target cursor is created to add an object to the invislist.
                        - <code>invislist remove id</code>
                        Removes the given id from the invislist.
                        - <code>invislist show</code>
                        Opens a gump where all ids are shown that are on the invislist.
                        \notes All objects that have an id that is on the invislist are not drawn.
                }
                else if Copy( Command, 1, 10 ) = 'INVISLIST ' then begin
                        Command := Copy( Command, 11, Length( Command )-10 );

                        if Command = 'CLEAR' then begin
                                ClearInvisList;
                        end
                        else if Command = 'ADD' then begin
                                if Length( Command ) > 4 then
                                        Command := Copy( Command, 5, Length( Command )-4 )
                                else
                                        Command := '';

                                if Command <> '' then begin
                                        try
                                                AddToInvisList( StrToInt( Command ) );
                                        except
                                        end;
                                end
                                else begin
                                        Target.AllowGround := False;
                                        Target.Serial := 0;
                                        Target.Activated := True;
                                        Target.SetMultiId( 0 );
                                        Target.Typ := TypTargetInvisId;
                                        CursorState := Cursor_Target;
                                        Cursors.CurrentCursor := crUOTarget;
                                end;
                        end
                        else if Command = 'REMOVE' then begin
                                if Length( Command ) > 7 then
                                        Command := Copy( Command, 8, Length( Command )-7 )
                                else
                                        Command := '';

                                if Command <> '' then begin
                                        try
                                                RemoveFromInvisList( StrToInt( Command ) );
                                        except
                                        end;
                                end;
                        end
                        else if Command = 'SHOW' then begin
                                InvisListStatus := TInvisListStatus.Create;
                                InvisListStatus.Init;
                                AddGump( InvisListStatus );
                        end
                        else if Command = '?' then begin
                                AddSysMessage( 'Options: Add, Clear, Remove, Show' );
                        end;
                        Result := True;
                        exit;
                end
                {
                        \command Resync
                        \description Sends a resync request to the server.
                }
                else if Copy( Command, 1, 6 ) = 'RESYNC' then begin
                        ResyncRequest := TResyncRequest.Create;
                        SendPacket( ResyncRequest );
                        Result := True;
                        exit; 
                end
                {
                        \command Timer
                        \description Shows information about some internal timing.
                        \usage
                        - <code>timer show</timer>
                        Opens a gump with all timers and their values.
                        - <code>timer rest</timer>
                        Resets the timers.
                        - <code>timer log</timer>
                        Writes the timers to the logfile.
                }
                else if Copy( Command, 1, 6 ) = 'TIMER ' then begin
                        Command := Copy( Command, 7, Length( Command ) - 6 );

                        if Command = 'SHOW' then begin
                                TimerGump := TTimerGump.Create;
                                TimerGump.Init;
                                AddGump( TimerGump );
                        end
                        else if Command = 'RESET' then begin
                                ResetTimer := True;
                        end
                        else if Command = 'LOG' then begin
                                Timer.Log;
                        end
                        else if Command = '?' then begin
                                AddSysMessage( 'Options: Log, Reset, Show' );
                        end;
                        Result := True;
                        exit;
                end
                {
                        \command Where
                        \description Returns your current position.
                }
                else if Copy( Command, 1, 5 ) = 'WHERE' then begin
                        AddSysMessage( Format( 'Your position is: %d %d %d %d', [Player.Pos.X,Player.Pos.Y,Player.Pos.Z,Player.Pos.Map] ) );
                        Result := True;
                        exit;
                end
                else if Copy( Command, 1, 5 ) = 'ABOUT' then begin
                        AboutGump := TAboutGump.Create;
                        AddGump( AboutGump );
                        Result := True;
                        exit;
                end
                {
                        \command Info
                        \description Creates a cursor that opens a gump with information about the targetted ingame object.
                }
                else if Copy( Command, 1, 4 ) = 'INFO' then begin
                        Target.AllowGround := True;
                        Target.Serial := 0;
                        Target.Activated := True;
                        Target.SetMultiId( 0 );
                        Target.Typ := TypTargetInfo;
                        CursorState := Cursor_Target;
                        Cursors.CurrentCursor := crUOTarget;
                        Result := True;
                        exit;                        
                end
                {
                        \command LOS
                        \description Shows if there is a line of sight to a target point.
                }
                else if Copy( Command, 1, 3 ) = 'LOS' then begin
                        Target.AllowGround := True;
                        Target.Serial := 0;
                        Target.Activated := True;
                        Target.SetMultiId( 0 );
                        Target.Typ := TypTargetLOS;
                        CursorState := Cursor_Target;
                        Cursors.CurrentCursor := crUOTarget;
                        Result := True;
                        exit;
                end
                {
                        \command Version
                        \description Returns the versionnumber of the client.
                }
                else if Copy( Command, 1, 7 ) = 'VERSION' then begin
                        AddSysMessage( Format( 'Clientversion: %d', [Version] ) );
                        Result := True;
                        exit;
                end
                {
                        \command Reloadscripts
                        \description Reloads all pythonscripts.
                }
                else if Copy( Command, 1, 13 ) = 'RELOADSCRIPTS' then begin
                        ScriptManager.ReloadScripts;
                        Result := True;
                        exit;
                end;
        end;
end;

function TPalanthir.CheckForKeyMacros( Key : Integer; Alt, Strg, Shift : Boolean ) : Boolean;
begin
        Result := Shard.CheckForKeyMacros( Key, Alt, Strg, Shift );
end;

procedure TPalanthir.PollAnims;
var     I : Integer;
        Char : TChar;
        AnimTexture : TAnimObject;
        AnimId : Byte;
        DoPoll : Boolean;
begin
        if CustomGetTickCount > AnimTimer + 50 then begin
                DoPoll := True;
                AnimTimer := CustomGetTickCount;
        end
        else begin
                DoPoll := False;
        end;

        if CharList.Count > 0 then begin
                for I := CharList.Count-1 downto 0 do begin
                        Char := TChar( CharList.Items[ I ] );
                        if DoPoll or Char.SmoothWalking then begin
                                if Char.Direction < 3 then begin
                                        AnimId := 3 - Char.Direction;
                                end
                                else begin
                                        AnimId := Char.Direction - 3;
                                end;
                                AnimTexture := Data.GetAnimTexture( Char.GetAnimId, Char.AnimId*5 + AnimId, Char.Color, Char.AnimFrame );
                                if AnimTexture = nil then begin
                                        Char.ResetAnim;
                                        Continue;
                                end;

                                Char.PollAnim( AnimTexture.Frames );
                        end;
                end;
        end;

        if DoResendWorld then begin
                Player.ResendWorld( False );
                DoResendWorld := False;
        end;
end;

procedure TPalanthir.PollEffects;
var     I : Integer;
        Effect : TEffect;
begin
        for I := EffectList.Count-1 downto 0 do begin
                Effect := TEffect( EffectList.Items[ I ] );
                if not Effect.Poll then
                        RemoveEffect( Effect );
        end;
end;

constructor TPalanthir.Create( SetApplication : TApplication );
begin
        Application := SetApplication;
end;

procedure TPalanthir.Init;
begin
        Randomize;

        try
                Log.Write( 'Init directories and constants' );

                if not DirectoryExists( ExtractFilePath( Application.ExeName ) + 'screens' ) then
                        CreateDir( ExtractFilePath( Application.ExeName ) + 'screens' );

                if Config.GetBool( 'PacketLog' ) then
                        Log.EnableLog( LOG_PACKET );
                if Config.GetBool( 'SpeechLog' ) then
                        Log.EnableLog( LOG_SPEECH );

                if Config.GetInteger( 'GumpDefaultX' ) = 0 then begin
                        Config.SetInteger( 'GumpDefaultX', 100 );
                        GumpDefaultX := 100;
                end
                else begin
                        GumpDefaultX := Config.GetInteger( 'GumpDefaultX' );
                end;
                if Config.GetInteger( 'GumpDefaultY' ) = 0 then begin
                        Config.SetInteger( 'GumpDefaultY', 100 );
                        GumpDefaultY := 100;
                end
                else begin
                        GumpDefaultY := Config.GetInteger( 'GumpDefaultY' );
                end;

                FadeGumps := not Config.GetBool( 'NotFadeGumps' );

                ShardName := '';

                ShowFPS := False;

                Renderer.SetResizable( False );
                GumpIdCount := 0;
                GumpObjectIdCount := 0;

                Log.Write( 'Starting Network' );
                Network := TNetwork.Create;
                Log.Write( 'Starting SoundManager' );
                SoundManager := TSoundManager.Create( Config.GetInteger( 'MusicVolume' ), Config.GetInteger( 'SoundVolume' ) );

                CurrentMap := 0;
                ItemAnimCache := TItemAnimCache.Create;
                GumpList := TList.Create;
                CharList := TList.Create;
                WorldList := TList.Create;
                WorldListSorted := True;
                DoResendWorld := False;
                SpeechList := TList.Create;
                SystemSpeech := TSpeech.Create;
                EffectList := TList.Create;
                LightManager := TLightManager.Create;
                InvisList := TList.Create;
                ServerInvisList := TList.Create;
                Tooltip := TTooltip.Create;
                GlobalGumpList := TList.Create;
                GlobalGumpObjectList := TList.Create;

                CustomVars := nil;

                LoadMapStatics := True;
                DrawStatics := True;
                DrawMap := True;

                Log.Write( 'Loading Mouse- and Keyboardhandlers' );
                Maus := TMaus.Create;

                Keyboard := TKeyboard.Create;

                GameWindow := nil;

                DisableRadar := False;
                EnabledME := False;
                MulEncryption := False;
                ResetTimer := False;
                TurnAllToChicken := False;    
                DebugMode := False;
                DebugList := TList.Create;

                Target := TTarget.Create;
                Target.Activated := False;

                Movement := TMovement.Create;
                Movement.DisablePermanentMovement := Config.GetBool( 'DisablePermanentMovement' );

                InLoop := False;

                Player := nil;

                AnimTimer := CustomGetTickCount;

                UseItemUpdateIdFlag := True;
                FirstMultiID := $4000;
                LastMultiID := $4FFF;

                UnderMapOsiMode := True;

                Log.Write( 'Loading ScreenshotUtility' );
                ScreenShotUtility := TScreenShotUtility.Create( ExtractFilePath( Application.ExeName ) + 'screens\' );
                SU := TSecretUtility.Create;

                StartTimer := TTimer.Create( nil );
                StartTimer.OnTimer := StartClient;
                StartTimer.Interval := 1000;
                StartTimer.Enabled := True;
        except
                Application.HandleException( Self );
        end;
end;

destructor TPalanthir.Free;
var     I : Integer;
begin
        if NetClient <> nil then begin
                Log.Write( Format( 'Traffic send: %d', [NetClient.GetTrafficSend] ) );
                Log.Write( Format( 'Traffic recieved: %d', [NetClient.GetTrafficRecieved] ) );
                NetClient.Terminate;
                Sleep( 500 );
        end;

        Tooltip.FreeGump;

        if EffectList <> nil then begin
                Log.Write( 'Freeing Effects' );
                while EffectList.Count > 0 do begin
                        RemoveEffect( TEffect( EffectList.Items[ 0 ] ) );
                end;
                EffectList.Free;
        end;
        if GumpList <> nil then begin
                Log.Write( 'Freeing Gumps' );
                for I := GumpList.Count-1 downto 0 do begin
                        if (I < GumpList.Count) and (TGump( GumpList.Items[ I ] ) <> Player.Radar) and (TGump( GumpList.Items[ I ] ) <> Player.Journal) then
                                DeleteGump( TGump( GumpList.Items[ I ] ) );
                end;
        end;

        if Player <> nil then begin
                Log.Write( 'Freeing Player' );
                Player.UnRegisterObject;
                while Data.GlobalObjectList.GetCount > 0 do
                        Data.GlobalObjectList.GetObjectByIndex( 0 ).Free;
                Player.RegisterObject;
                Player.Free;
        end;

        if GumpList <> nil then begin
                Log.Write( 'Freeing GumpList' );        
                while GumpList.Count > 0 do
                        DeleteGump( TGump( GumpList.Items[ 0 ] ) );
                GumpList.Free;
        end;

        if CustomVars <> nil then begin
                Py_XDECREF( CustomVars );
                CustomVars := nil;
        end;

        if ScriptManager <> nil then begin
                Log.Write( 'Unloading ScriptManager' );
                ScriptManager.UnLoadScripts;
                Log.Write( 'Stopping Python' );
                ScriptManager.StopPython;
                Log.Write( 'Freeing ScriptManager' );
                ScriptManager.Free;
        end;        

        Log.Write( 'Freeing Sockets' );
        if NetClient <> nil then
                NetClient.Free;

        Log.Write( 'Freeing Speech' );
        if SpeechList <> nil then
                SpeechList.Free;
        if SystemSpeech <> nil then
                SystemSpeech.Free;

        Log.Write( 'Freeing Movement' );
        if Movement <> nil then
                Movement.Free;

        Log.Write( 'Freeing Keyboard' );
        if Keyboard <> nil then
                Keyboard.Free;

        Log.Write( 'Freeing Mouse' );
        if Maus <> nil then
                Maus.Free;

        Log.Write( 'Freeing Network' );
        if Network <> nil then
                Network.Free;

        Log.Write( 'Freeing Shard' );
        if Shard <> nil then
                Shard.Free;

        Log.Write( 'Freeing Data' );
        if Data <> nil then
                Data.Free;

        Log.Write( 'Freeing WorldList' );
        if WorldList <> nil then
                WorldList.Free;

        Log.Write( 'Freeing CharList' );                
        if CharList <> nil then
                CharList.Free;
        if ItemAnimCache <> nil then
                ItemAnimCache.Free;
        if ScreenShotUtility <> nil then
                ScreenShotUtility.Free;

        Log.Write( 'Freeing SoundManager' );
        if SoundManager <> nil then
                SoundManager.Free;

        Log.Write( 'Freeing LightManager' );
        if LightManager <> nil then
                LightManager.Free;
        if SU <> nil then
                SU.Free;

        Log.Write( 'Freeing Renderer' );
        if Renderer <> nil then
                Renderer.Free;

        Log.Write( 'Freeing Tooltip' );
        if Tooltip <> nil then begin
                Tooltip.Free;
                Tooltip := nil;
        end;                

        DebugList.Free;
        InvisList.Free;
        ServerInvisList.Free;
        GlobalGumpList.Free;
        GlobalGumpObjectList.Free;

        Log.Write( 'Freeing done.' );        
end;

function TPalanthir.GetNewGumpId : LongWord;
begin
        Result := GumpIdCount;
        Inc( GumpIdCount );
end;

function TPalanthir.GetNewGumpObjectId : LongWord;
begin
        Result := GumpObjectIdCount;
        Inc( GumpObjectIdCount );
end;

procedure TPalanthir.AddGump( Gump : TGump );
begin
        if Gump.Typ = GumpTyp_PythonGump then begin
                if ScriptManager.OnAddGump( Gump ) then begin
                        Exit;
                end;
        end;

        GumpList.Add( Gump );
end;

procedure TPalanthir.RemoveGump( Gump : TGump );
begin
        if FadeGumps then
                Gump.StartDecay
        else
                DeleteGump( Gump );
end;

procedure TPalanthir.RemoveGump( Index : Integer );
var     Gump : TGump;
begin
        Gump := TGump( GumpList.Items[ Index ] );
        RemoveGump( Gump );
end;

procedure TPalanthir.DeleteGump( Gump : TGump );
var     I : Integer;
begin
        for I := 0 to GumpList.Count-1 do
                if GumpList.Items[I] = Gump then begin
                        DeleteGump( I );
                        break;
                end;
end;

procedure TPalanthir.DeleteGump( Index : Integer );
var     Gump : TGump;
        I : Integer;
begin
        Gump := TGump( GumpList.Items[ Index ] );

        if Gump.Typ = GumpTyp_PythonGump then begin
                if ScriptManager.OnRemoveGump( Gump ) then begin
                        Exit;
                end;
        end;

        Gump.OnDelete;

        GumpList.Delete( Index );

        for I := 0 to Gump.GetObjectCount-1 do begin
                if Gump.GetObject( I ) = Keyboard.SelectedGumpObject then begin
                        Keyboard.SelectedGumpObject := nil;
                        if GameWindow <> nil then
                                Keyboard.KeyboardMode := KB_Speech
                        else
                                Keyboard.KeyboardMode := KB_None;
                end;
        end;
        Gump.Free;
end;

function TPalanthir.GetGumpCount : Integer;
begin
        Result := GumpList.Count;
end;

function TPalanthir.GetGump( GumpNr : Integer ) : TGump;
begin
        if GumpNr < GumpList.Count then
                Result := TGump( GumpList.Items[ GumpNr ] )
        else
                Result := nil;
end;

procedure TPalanthir.SetForeGroundGump( Gump : TGump );
var     I : Integer;
begin
        for I := 0 to GumpList.Count-1 do
                if GumpList.Items[I] = Gump then begin
                        GumpList.Delete( I );
                        AddGump( Gump );
                        break;
                end;
end;

procedure TPalanthir.SendGumpBack( Gump : TGump );
var     I : Integer;
begin
        for I := 0 to GumpList.Count-1 do
                if GumpList.Items[I] = Gump then begin
                        GumpList.Delete( I );
                        GumpList.Insert( 0, Gump );
                        break;
                end;
end;

procedure TPalanthir.AddEffect( Effect : TEffect );
begin
        EffectList.Add( Effect );
        AddWorldItem( Effect );
end;

procedure TPalanthir.RemoveEffect( Effect : TEffect );
var     I : Integer;
begin
        for I := 0 to EffectList.Count-1 do begin
                if TEffect( EffectList.Items[ I ] ) = Effect then begin
                        RemoveWorldItem( Effect );
                        EffectList.Delete( I );
                        Effect.Free;
                        Break;
                end;
        end;
end;

procedure TPalanthir.AddChar( Char : TChar );
begin
        CharList.Add( Char );
end;

procedure TPalanthir.RemoveChar( Char : TChar );
var     I : Integer;
begin
        if CharList.Count > 0 then
                for I := 0 to CharList.Count-1 do
                        if Char = TChar( CharList.Items[ I ] ) then begin
                                CharList.Delete( I );
                                Break;
                        end;
end;

procedure TPalanthir.AddWorldItem( Item : Pointer );
begin
        if TUODrawObject( Item ).IsVisible then begin
                if TUODrawObject( Item ).IsInDrawList then
                        exit;
        end
        else begin
                if TUODrawObject( Item ).IsInDrawList then
                        RemoveWorldItem( Item );
                exit;
        end;

        if ( TUODrawObject( Item ).IsStatic ) or ( TUODrawObject( Item ).IsItem ) or ( TUODrawObject( Item ).IsEffect ) then
                if Data.Tiledata.GetStaticFlag( TUODrawObject( Item ).Id, dANIMATION ) then
                        if Data.Animdata.Exists( TUODrawObject( Item ).Id ) then begin
                                ItemAnimCache.AddAnim( TUODrawObject( Item ).Id, TUODrawObject( Item ).Color );
                                if TUODrawObject( Item ).IsItem then begin
                                        ItemAnimCache.AddAnim( TUODrawObject( Item ).Id, SelectionColor );
                                end;
                        end;
        TUODrawObject( Item ).IsInDrawList := True;                        
        TUODrawObject( Item ).NumberInList := WorldList.Count;
        WorldList.Add( Item );
        WorldListSorted := False;
end;

procedure TPalanthir.RemoveWorldItem( Item : Pointer );
var     I, Index : Integer;
begin
        if (not TUODrawObject( Item ).IsInDrawList ) then
                exit;

        if ( TUODrawObject( Item ).IsStatic ) or ( TUODrawObject( Item ).IsItem ) or ( TUODrawObject( Item ).IsEffect ) then
                if Data.Tiledata.GetStaticFlag( TUODrawObject( Item ).Id, dANIMATION ) then
                        if Data.Animdata.Exists( TUODrawObject( Item ).Id ) then begin
                                ItemAnimCache.RemoveAnim( TUODrawObject( Item ).Id, TUODrawObject( Item ).Color );
                                if TUODrawObject( Item ).IsItem then begin
                                        ItemAnimCache.RemoveAnim( TUODrawObject( Item ).Id, SelectionColor );
                                end;
                        end;

        if Maus.SelectedUObject = Item then
                Maus.SelectedUObject := nil;

        if Maus.SelectedDownLUObject = Item then
                Maus.SelectedDownLUObject := nil;
        if Maus.SelectedDownRUObject = Item then
                Maus.SelectedDownRUObject := nil;

        if TUODrawObject( Item ).Light <> nil then begin
                LightManager.RemoveLight( TUODrawObject( Item ).Light );
        end;

        Index := TUODrawObject( Item ).NumberInList;
        if Index >= WorldList.Count then begin
                Log.Write( Format( 'Bug deleting Item from WorldList. Number: %d, Count: %d', [Index,WorldList.Count] ) );
                Exit;
        end;

        if WorldList.Items[ Index ] = Item then
                WorldList.Delete( Index )
        else
                for I := 0 to WorldList.Count-1 do
                        if WorldList.Items[ I ] = Item then begin
                                if TUODrawObject( WorldList.Items[ I ] ).Light <> nil then begin
                                        LightManager.RemoveLight( TUODrawObject( WorldList.Items[ I ] ).Light );
                                end;
                                WorldList.Delete( I );
                                break;
                        end;

        TUODrawObject( Item ).IsInDrawList := False;

        for I := 0 to WorldList.Count-1 do
                TUODrawObject( WorldList.Items[ I ] ).NumberInList := I;
end;

procedure TPalanthir.RemoveWorldBlock( BlockID : Integer );
var     I : Integer;
begin
        for I := WorldList.Count-1 downto 0 do
                if TUODrawObject( WorldList.Items[ I ] ).BlockID = BlockID then begin
                        if TUODrawObject( WorldList.Items[ I ] ).Light <> nil then begin
                                LightManager.RemoveLight( TUODrawObject( WorldList.Items[ I ] ).Light );
                        end;
                        TUODrawObject( WorldList.Items[ I ] ).IsInDrawList := False;                                
                        WorldList.Delete( I );
                end;

        for I := 0 to WorldList.Count-1 do
                TUODrawObject( WorldList.Items[ I ] ).NumberInList := I;
end;

procedure TPalanthir.ClearWorldCache;
var     I : Integer;
begin
        for I := 0 to WorldList.Count-1 do
                TUODrawObject( WorldList.Items[ I ] ).IsInDrawList := False;

        WorldList.Clear;
        LightManager.Clear;

        Maus.SelectedUObject := nil;
        Maus.SelectedDownLUObject := nil;
        Maus.SelectedDownRUObject := nil;
end;

procedure TPalanthir.SortItemListe( Liste : TList );
        function SortItems( Item1, Item2 : Pointer ) : Integer;
        var     DrawObject1, DrawObject2 : TUODrawObject;
                Bonus1, Bonus2 : Byte;
                PosZ1, PosZ2 : ShortInt;
                PosX1, PosX2, PosY1, PosY2 : Word;
                MapItem : TMapItem;
        begin
                if Item1 = Item2 then begin
                        Result := 0;
                        exit;
                end;

                DrawObject1 := TUODrawObject( Item1 );
                DrawObject2 := TUODrawObject( Item2 );

                if DrawObject1.IsChar then begin
                        PosX1 := TChar( DrawObject1 ).EffPos.X;
                        PosY1 := TChar( DrawObject1 ).EffPos.Y;
                end
                else if ( DrawObject1.IsItem and (DrawObject1.ID = CorpseID) ) then begin
                        PosX1 := DrawObject1.Pos.X;
                        PosY1 := DrawObject1.Pos.Y;
                end
                else begin
                        PosX1 := DrawObject1.Pos.X;
                        PosY1 := DrawObject1.Pos.Y;
                end;

                if DrawObject2.IsChar then begin
                        PosX2 := TChar( DrawObject2 ).EffPos.X;
                        PosY2 := TChar( DrawObject2 ).EffPos.Y;
                end
                else if ( DrawObject2.IsItem and (DrawObject2.ID = CorpseID) ) then begin
                        PosX2 := DrawObject2.Pos.X;
                        PosY2 := DrawObject2.Pos.Y;
                end
                else begin
                        PosX2 := DrawObject2.Pos.X;
                        PosY2 := DrawObject2.Pos.Y;
                end;

                if (PosX1+PosY1 > PosX2+PosY2) then begin
                        Result := -1;
                        exit;
                end
                else if (PosX1+PosY1 < PosX2+PosY2) then begin
                        Result := 1;
                        exit;
                end
                else begin
                        if DrawObject1.IsEffect then
                                Bonus1 := 8
                        else if DrawObject1.IsChar or ( DrawObject1.IsItem and (DrawObject1.ID = CorpseID) ) then
                                Bonus1 := 7
                        else if ( not DrawObject1.IsItem ) and ( not DrawObject1.IsStatic ) and ( not DrawObject1.IsMultiItem ) then
                                Bonus1 := 0
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject1.ID, dBACKGROUND ) and Palanthir.Data.Tiledata.GetStaticFlag( DrawObject1.ID, dSURFACE ) then
                                Bonus1 := 2
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject1.ID, dBACKGROUND ) then
                                Bonus1 := 3
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject1.ID, dSURFACE ) then
                                Bonus1 := 4
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject1.ID, dWALL ) then
                                Bonus1 := 6
                        else
                                Bonus1 := 6;
                        if DrawObject1.IsItem then
                                Inc( Bonus1 );

                        if DrawObject2.IsEffect then
                                Bonus2 := 8
                        else if DrawObject2.IsChar or ( DrawObject2.IsItem and (DrawObject2.ID = CorpseID) ) then
                                Bonus2 := 7
                        else if ( not DrawObject2.IsItem ) and ( not DrawObject2.IsStatic ) and ( not DrawObject2.IsMultiItem ) then
                                Bonus2 := 0
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject2.ID, dBACKGROUND ) and Palanthir.Data.Tiledata.GetStaticFlag( DrawObject2.ID, dSURFACE ) then
                                Bonus2 := 2
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject2.ID, dBACKGROUND ) then
                                Bonus2 := 3
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject2.ID, dSURFACE ) then
                                Bonus2 := 4
                        else if Palanthir.Data.Tiledata.GetStaticFlag( DrawObject2.ID, dWALL ) then
                                Bonus2 := 6
                        else
                                Bonus2 := 6;
                        if DrawObject2.IsItem then
                                Inc( Bonus2 );

                        if DrawObject1.IsMap and TMapItem( DrawObject1 ).IsStretched then begin
                                MapItem := TMapItem( DrawObject1 );
                                PosZ1 := ( MapItem.Pos.Z + MapItem.Z2 + MapItem.Z3 + MapItem.Z4 ) div 4;
                        end
                        else
                                PosZ1 := DrawObject1.Pos.Z;

                        if DrawObject2.IsMap and TMapItem( DrawObject2 ).IsStretched then begin
                                MapItem := TMapItem( DrawObject2 );
                                PosZ2 := ( MapItem.Pos.Z + MapItem.Z2 + MapItem.Z3 + MapItem.Z4 ) div 4;
                        end
                        else
                                PosZ2 := DrawObject2.Pos.Z;

                        if (PosZ1+Bonus1 > PosZ2+Bonus2) then begin
                                Result := -1;
                                exit;
                        end
                        else if (PosZ1+Bonus1 < PosZ2+Bonus2) then begin
                                Result := 1;
                                exit;
                        end
                        else if ( Bonus1 = 0 ) and ( Bonus2 > 0 ) then begin
                                Result := 1;
                                exit;
                        end
                        else if ( Bonus1 > 0 ) and ( Bonus2 = 0 ) then begin
                                Result := -1;
                                exit;
                        end
                        else if ( Bonus1 > 0 ) and ( Bonus2 > 0 ) then begin
                                if Palanthir.Data.Tiledata.GetStaticHeight( DrawObject1.ID ) > Palanthir.Data.Tiledata.GetStaticHeight( DrawObject2.ID ) then begin
                                        Result := -1;
                                        exit;
                                end
                                else if Palanthir.Data.Tiledata.GetStaticHeight( DrawObject1.ID ) < Palanthir.Data.Tiledata.GetStaticHeight( DrawObject2.ID ) then begin
                                        Result := 1;
                                        exit;
                                end
                                else begin
                                        if ( DrawObject1.Color > 0 ) and ( DrawObject2.Color = 0 ) then begin
                                                Result := -1;
                                                exit;
                                        end
                                        else if ( DrawObject1.Color = 0 ) and ( DrawObject2.Color > 0 ) then begin
                                                Result := 1;
                                                exit;
                                        end
                                        else if ( DrawObject1.Typ <> DrawObject2.Typ ) then begin
                                                if DrawObject1.Typ > DrawObject2.Typ then begin
                                                        Result := -1;
                                                        exit;
                                                end
                                                else begin
                                                        Result := 1;
                                                        exit;
                                                end;
                                        end
                                        else if DrawObject1.IsUObject then begin
                                                if TUObject( DrawObject1 ).LastUpdated > TUObject( DrawObject2 ).LastUpdated then begin
                                                        Result := -1;
                                                        exit;
                                                end
                                                else if TUObject( DrawObject1 ).LastUpdated < TUObject( DrawObject2 ).LastUpdated then begin
                                                        Result := 1;
                                                        exit;
                                                end
                                                else begin
                                                        if TUObject( DrawObject1 ).Serial > TUObject( DrawObject2 ).Serial then begin
                                                                Result := -1;
                                                                exit;
                                                        end
                                                        else if TUObject( DrawObject1 ).Serial < TUObject( DrawObject2 ).Serial then begin
                                                                Result := 1;
                                                                exit;
                                                        end
                                                        else begin
                                                                Result := 0;
                                                                exit;
                                                        end;
                                                end;
                                        end
                                        else if DrawObject1.IsStatic then begin
                                                if TStaticItem( DrawObject1 ).Index > TStaticItem( DrawObject2 ).Index then begin
                                                        Result := -1;
                                                        exit;
                                                end
                                                else if TStaticItem( DrawObject1 ).Index < TStaticItem( DrawObject2 ).Index then begin
                                                        Result := 1;
                                                        exit;
                                                end
                                                else if DrawObject1.Pos.X > DrawObject2.Pos.X then begin
                                                        Result := -1;
                                                        exit;
                                                end
                                                else if DrawObject1.Pos.X < DrawObject2.Pos.X then begin
                                                        Result := 1;
                                                        exit;
                                                end
                                                else begin
                                                        Result := 0;
                                                        exit;
                                                end;
                                        end
                                        else begin
                                                Result := 0;
                                                exit;
                                        end;
                                end;
                        end
                        else begin
                                Result := 0;
                                exit;
                        end;
                end;
        end;
begin
        Liste.Sort( @SortItems );
end;

procedure TPalanthir.SortMultiItemListe( Liste : TList );
        function SortItems( Item1, Item2 : Pointer ) : Integer;
        var     MItem1, MItem2 : TBasicMultiItem;
                Bonus1, Bonus2 : Byte;
                PosZ1, PosZ2 : ShortInt;
                PosX1, PosX2, PosY1, PosY2 : Integer;
        begin
                if Item1 = Item2 then begin
                        Result := 0;
                        exit;
                end;

                MItem1 := TBasicMultiItem( Item1 );
                MItem2 := TBasicMultiItem( Item2 );

                PosX1 := MItem1.X;
                PosY1 := MItem1.Y;

                PosX2 := MItem2.X;
                PosY2 := MItem2.Y;

                if (PosX1+PosY1 > PosX2+PosY2) then begin
                        Result := -1;
                        exit;
                end
                else if (PosX1+PosY1 < PosX2+PosY2) then begin
                        Result := 1;
                        exit;
                end
                else begin
                        if Palanthir.Data.Tiledata.GetStaticFlag( MItem1.ID, dSURFACE ) then
                                Bonus1 := 3                                
                        else if Palanthir.Data.Tiledata.GetStaticFlag( MItem1.ID, dBACKGROUND ) then
                                Bonus1 := 2
                        else if Palanthir.Data.Tiledata.GetStaticFlag( MItem1.ID, dWALL ) then
                                Bonus1 := 4
                        else
                                Bonus1 := 5;

                        if Palanthir.Data.Tiledata.GetStaticFlag( MItem2.ID, dSURFACE ) then
                                Bonus2 := 3
                        else if Palanthir.Data.Tiledata.GetStaticFlag( MItem2.ID, dBACKGROUND ) then
                                Bonus2 := 2
                        else if Palanthir.Data.Tiledata.GetStaticFlag( MItem2.ID, dWALL ) then
                                Bonus2 := 4
                        else
                                Bonus2 := 5;

                        PosZ1 := MItem1.Z;
                        PosZ2 := MItem2.Z;

                        if (PosZ1+Bonus1 > PosZ2+Bonus2) then begin
                                Result := -1;
                                exit;
                        end
                        else if (PosZ1+Bonus1 < PosZ2+Bonus2) then begin
                                Result := 1;
                                exit;
                        end
                        else if ( Bonus1 = 0 ) and ( Bonus2 > 0 ) then begin
                                Result := 1;
                                exit;
                        end
                        else if ( Bonus1 > 0 ) and ( Bonus2 = 0 ) then begin
                                Result := -1;
                                exit;
                        end
                        else if ( Bonus1 > 0 ) and ( Bonus2 > 0 ) then begin
                                if Palanthir.Data.Tiledata.GetStaticHeight( MItem1.ID ) > Palanthir.Data.Tiledata.GetStaticHeight( MItem2.ID ) then begin
                                        Result := -1;
                                        exit;
                                end
                                else if Palanthir.Data.Tiledata.GetStaticHeight( MItem1.ID ) < Palanthir.Data.Tiledata.GetStaticHeight( MItem2.ID ) then begin
                                        Result := 1;
                                        exit;
                                end
                                else begin
                                        Result := 0;
                                        exit;
                                end;
                        end
                        else begin
                                Result := 0;
                                exit;
                        end;
                end;
        end;
begin
        Timer.Continue( Timer_Sort );
        Liste.Sort( @SortItems );
        Timer.Pause( Timer_Sort );
end;


procedure TPalanthir.AddSpeech( Packet : GetSpeech );
var     SystemTest : Boolean;
        MaxLength : Word;
        Speech : TSpeech;
        NewText : TSpeechText;
        UObject : TUObject;
        Text : String;
        Color : Word;
begin
        if Packet.getMessage = '' then
                exit;

        SystemTest := (Packet.GetSerial = $FFFFFFFF) or (Packet.GetSerial = 0) or (Packet.getSerial = $01010101);

        if SystemTest then
                MaxLength := 300
        else begin
                MaxLength := 200;
                UObject := Data.GlobalObjectList.GetObject( Packet.GetSerial );

                if UObject = nil then
                        exit;

                if UObject.Speech = nil then begin
                        Speech := TSpeech.Create;
                        Speech.SetDrawObjectType;
                        Speech.UObject := UObject;
                        UObject.Speech := Speech;
                        SpeechList.Add( Speech );
                end
                else
                        Speech := UObject.Speech;
        end;

        Text := Packet.getMessage;
        Color := Packet.getTextColor+1;
        if ShowSerials and (Not SystemTest) then
                Text := Format( '%s (0x%x)', [Packet.getMessage,UObject.Serial] );
        if Packet.getTextColor = Sphere_Default_Textcolor then
                Color := $481;

        if SystemTest then begin
                SystemSpeech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getSpeechType, 10*1000, False );
        end
        else begin
                Speech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getSpeechType, 10*1000, False );
        end;

        if SystemTest then
                Player.Journal.AddText( JournalFont, Packet.getTextColor+1, Packet.getMessage, True )
        else if Packet.getName = '' then
                Player.Journal.AddText( JournalFont, Packet.getTextColor+1, Packet.getMessage )
        else if Packet.getMessage = '' then
                Player.Journal.AddText( JournalFont, Packet.getTextColor+1, Packet.GetName )
        else
                Player.Journal.AddText( JournalFont, Packet.getTextColor+1, Packet.getName + ': ' + Packet.getMessage );
end;

procedure TPalanthir.AddSysMessage( Text : String; Color : Word );
var     NewText : TSpeechText;
begin
        NewText := TSpeechText.Create( 0, Color, Text, 300, 0, CustomGetTickCount + 15*1000 );
        NewText.Speech := SystemSpeech;
        SystemSpeech.Add( NewText );

        Player.Journal.AddText( JournalFont, Color, Text, True );
end;

procedure TPalanthir.AddTooltip( Packet : GetAttachTooltip );
var     Speech : TSpeech;
        NewText : TSpeechText;
        UObject : TUObject;
        Hersteller, Eigenschaften, Text : String;
        Key, K, I : Integer;
        Laenge : Word;
        Charges : Word;
        ChargesList : TStringList;
        Id : LongWord;
        Color : Word;
begin
        UObject := Data.GlobalObjectList.GetObject( Packet.GetSerial );

        if UObject = nil then
                exit;

        if UObject.Speech = nil then begin
                Speech := TSpeech.Create;
                Speech.SetDrawObjectType;
                Speech.UObject := UObject;
                UObject.Speech := Speech;
                SpeechList.Add( Speech );
        end
        else
                Speech := UObject.Speech;

        Id := Packet.GetListID;
        if (Id and $40000000 = $40000000) then begin
                //New Osi Tooltiphandling
                exit;
        end;

        Text := Data.GetClilocMessage( Id );

        if Text <> '' then begin
                if ShowSerials then
                        Text := Format( '%s (0x%x)', [Text,UObject.Serial] );
                Speech.Queue.AddSpeech( 0, $481, Text, 200, 0, 3000 );
                Player.Journal.AddText( JournalFont, 0, Text );
        end;

        if Packet.getLength = 13 then begin
                exit;
        end;

        K := 13;
        Key := Packet.GetLongWord( K );
        K := K + 4;

        Hersteller := '';
        Eigenschaften := '';
        ChargesList := TStringList.Create;

        while Key <> -1 do begin
                Case Key of
                        -3 : begin
                                Laenge := Packet.GetWord( K );
                                K := K + 2;
                                Hersteller := Data.GetClilocMessage( 1037009 ) + ' ' + Packet.GetAsciiString( K, Laenge );
                                K := K + Laenge;
                        end;
                        -4 : begin
                                //Unidentified
                        end;
                else
                        Charges := Packet.GetWord( K );
                        K := K + 2;

                        if Charges = $FFFF then begin
                                if Eigenschaften <> '' then
                                        Eigenschaften := Eigenschaften + '/';
                                Eigenschaften := Format( '%s%s', [Eigenschaften,Data.GetClilocMessage( Key )] );
                        end
                        else begin
                                ChargesList.Add( Format( '%d %s', [Charges,Data.GetClilocMessage( Key )] ) );
                        end;
                end;
                Key := Packet.GetLongWord( K );
                K := K + 4;
        end;

        if Eigenschaften <> '' then begin
                Hersteller := Format( '%s [%s]', [Hersteller,Eigenschaften] );
        end;

        if Hersteller <> '' then begin
                Speech.Queue.AddSpeech( 0, $481, Hersteller, 200, 0, 3000 );
                Player.Journal.AddText( JournalFont, $481, Hersteller );
        end;

        for I := 0 to ChargesList.Count-1 do begin
                Speech.Queue.AddSpeech( 0, $481, ChargesList.Strings[I], 200, 0, 3000 );
                Player.Journal.AddText( JournalFont, $481, ChargesList.Strings[I] );
        end;

        ChargesList.Free;
end;

procedure TPalanthir.AddUnicodeSpeech( Packet : GetUnicodeMessage );
var     SystemTest : Boolean;
        MaxLength : Word;
        Speech : TSpeech;
        NewText : TSpeechText;
        UObject : TUObject;
        Text : String;
        Color : Word;
begin
        if Packet.getMessage = '' then
                exit;
        
        SystemTest := (Packet.GetSerial = $FFFFFFFF) or (Packet.GetSerial = 0);

        if SystemTest then
                MaxLength := 300
        else begin
                MaxLength := 200;
                UObject := Data.GlobalObjectList.GetObject( Packet.GetSerial );

                if UObject = nil then
                        exit;

                if UObject.Speech = nil then begin
                        Speech := TSpeech.Create;
                        Speech.SetDrawObjectType;
                        Speech.UObject := UObject;
                        UObject.Speech := Speech;
                        SpeechList.Add( Speech );
                end
                else
                        Speech := UObject.Speech;
        end;

        Text := Packet.getMessage;
        Color := Packet.getColor+1;
        if ShowSerials and (Not SystemTest) then
                Text := Format( '%s (0x%x)', [Packet.getMessage,UObject.Serial] );
        if Packet.GetColor = Sphere_Default_Textcolor then
                Color := $481;

        if SystemTest then begin
                SystemSpeech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getSpeechType, 10*1000 );
        end
        else begin
                Speech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getSpeechType, 10*1000 );
        end;

        if SystemTest then
                Player.Journal.AddText( JournalFont, Packet.getColor+1, Packet.getMessage, True )
        else if Packet.getName = '' then
                Player.Journal.AddText( JournalFont, Packet.GetColor+1, Packet.getMessage )
        else if Packet.GetMessage = '' then
                Player.Journal.AddText( JournalFont, Packet.getColor+1, Packet.GetName )
        else
                Player.Journal.AddText( JournalFont, Packet.getColor+1, Packet.getName + ': ' + Packet.getMessage );
end;

procedure TPalanthir.AddClilocSpeech( Packet : GetClilocMessage );
var     SystemTest : Boolean;
        MaxLength : Word;
        Speech : TSpeech;
        NewText : TSpeechText;
        UObject : TUObject;
        Text, Arguments, TmpText : String;
        ArgListe : TStringList;
        Pos1, Pos2, I, TmpId : Integer;
        Color : Word;
begin
        Text := Data.GetClilocMessage( Packet.GetMessageNumber );
        if Text = '' then
                exit;

        SystemTest := (Packet.GetSerial = $FFFFFFFF) or (Packet.GetSerial = 0);

        if SystemTest then
                MaxLength := 300
        else begin
                MaxLength := 200;
                UObject := Data.GlobalObjectList.GetObject( Packet.GetSerial );

                if UObject = nil then
                        exit;

                if UObject.Speech = nil then begin
                        Speech := TSpeech.Create;
                        Speech.SetDrawObjectType;
                        Speech.UObject := UObject;
                        UObject.Speech := Speech;
                        SpeechList.Add( Speech );
                end
                else
                        Speech := UObject.Speech;
        end;

        Arguments := Packet.GetArguments;
        if Arguments <> '' then begin
                ArgListe := TStringList.Create;
                if Pos( '\t', Arguments ) > 0 then
                        StrLib.Split( Arguments, '\t', ArgListe )
                else if Pos( #9, Arguments ) > 0 then
                        StrLib.Split( Arguments, #9, ArgListe )
                else
                        ArgListe.Add( Arguments );

                for I := 0 to ArgListe.Count-1 do begin
                        Pos1 := StrLib.PosAfter( '~', Text, 1 );
                        Pos2 := StrLib.PosAfter( '~', Text, Pos1+1 );

                        if ArgListe.Strings[ I ][ 1 ] = '#' then begin
                                try
                                        TmpId := StrToInt( Copy( ArgListe.Strings[ I ], 2, Length( ArgListe.Strings[ I ] )-1 ) );
                                        TmpText := Data.GetClilocMessage( TmpId );
                                except
                                        TmpText := ArgListe.Strings[ I ];
                                end;
                        end
                        else begin
                                TmpText := ArgListe.Strings[ I ];
                        end;

                        Text := Replace( Text, Copy( Text, Pos1, Pos2-Pos1+1 ), TmpText );
                end;
                ArgListe.Free;
        end;

        Color := Packet.getHue+1;
        if ShowSerials and (Not SystemTest) then
                Text := Format( '%s (0x%x)', [Text,UObject.Serial] );
        if Packet.GetHue = Sphere_Default_Textcolor then
                Color := $481;

        if SystemTest then begin
                SystemSpeech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getType, 10*1000 );
        end
        else begin
                Speech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getType, 10*1000 );
        end;

        if SystemTest then
                Player.Journal.AddText( JournalFont, Packet.getHue, Text, True )
        else if Packet.getName = '' then
                Player.Journal.AddText( JournalFont, Packet.getHue+1, Text )
        else if Text = '' then
                Player.Journal.AddText( JournalFont, Packet.getHue+1, Packet.GetName )
        else
                Player.Journal.AddText( JournalFont, Packet.getHue+1, Packet.getName + ': ' + Text );
end;

procedure TPalanthir.AddClilocAffixSpeech( Packet : GetClilocAffix );
var     SystemTest : Boolean;
        MaxLength : Word;
        Speech : TSpeech;
        NewText : TSpeechText;
        UObject : TUObject;
        Text, Arguments, Affix : String;
        ArgListe : TStringList;
        Pos1, Pos2, I : Integer;
        Color : Word;
begin
        Text := Data.GetClilocMessage( Packet.GetMessageID );
        if Text = '' then
                exit;

        SystemTest := (Packet.GetSerial = $FFFFFFFF) or (Packet.GetSerial = 0);

        if SystemTest then
                MaxLength := 300
        else begin
                MaxLength := 200;
                UObject := Data.GlobalObjectList.GetObject( Packet.GetSerial );

                if UObject = nil then
                        exit;

                if UObject.Speech = nil then begin
                        Speech := TSpeech.Create;
                        Speech.SetDrawObjectType;
                        Speech.UObject := UObject;
                        UObject.Speech := Speech;
                        SpeechList.Add( Speech );
                end
                else
                        Speech := UObject.Speech;
        end;

        Affix := Packet.GetAsciiString( 49, Packet.getLength-49 );

        Arguments := Packet.GetUnicodeString( 49 + Length( Affix )+1, Packet.getLength - (49 + Length( Affix )+1) );
        if Arguments <> '' then begin
                ArgListe := TStringList.Create;
                StrLib.Split( Arguments, '\t', ArgListe );

                Pos2 := 0;
                for I := 0 to ArgListe.Count-1 do begin
                        Pos1 := StrLib.PosAfter( '~', Text, Pos2+1 );
                        Pos2 := StrLib.PosAfter( '~', Text, Pos1+1 );

                        Text := Replace( Text, Copy( Text, Pos1, Pos2-Pos1+1 ), ArgListe.Strings[ I ] );
                end;
                ArgListe.Free;
        end;

        if (Packet.GetFlag and $1) = 0 then begin
                Text := Format( '%s %s', [Text,Affix] );
        end
        else begin      // (Packet.GetAffix and $1) = $1
                Text := Format( '%s %s', [Affix,Text] );
        end;

        Color := Packet.getHue+1;
        if ShowSerials and (Not SystemTest) then
                Text := Format( '%s (0x%x)', [Text,UObject.Serial] );
        if Packet.GetHue = Sphere_Default_Textcolor then
                Color := $481;

        if SystemTest then begin
                SystemSpeech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getType, 10*1000, False );
        end
        else begin
                Speech.Queue.AddSpeech( Packet.getFont, Color, Text, MaxLength, Packet.getType, 10*1000, False );
        end;

        if SystemTest then
                Player.Journal.AddText( JournalFont, Packet.getHue, Text, True )
        else if Packet.getName = '' then
                Player.Journal.AddText( JournalFont, Packet.getHue+1, Text )
        else if Text = '' then
                Player.Journal.AddText( JournalFont, Packet.getHue+1, Packet.GetName )
        else
                Player.Journal.AddText( JournalFont, Packet.getHue+1, Packet.getName + ': ' + Text );
end;

procedure TPalanthir.AddSpeech( Speech : TSpeech );
begin
        SpeechList.Add( Speech );
end;

procedure TPalanthir.RemoveSpeech( Speech : TSpeech );
var     I : Integer;
begin
        for I := 0 to SpeechList.Count-1 do begin
                if TSpeech( SpeechList.Items[ I ] ) = Speech then begin
                        SpeechList.Delete( I );
                        break;
                end;
        end;
end;

procedure TPalanthir.BringToFront( Speech : TSpeech );
var     I : Integer;
begin
        for I := 0 to SpeechList.Count-1 do begin
                if TSpeech( SpeechList.Items[ I ] ) = Speech then begin
                        SpeechList.Delete( I );
                        SpeechList.Insert( 0, Speech );
                        break;
                end;
        end;
end;

procedure TPalanthir.DrawGumps;
var     Count, I : Integer;
begin
        for I := GumpList.Count-1 downto 0 do begin
                TGump( GumpList.Items[ I ] ).OnBeforeDraw;
        end;

        Count := 0;
        while Count < GumpList.Count do begin
                if TGump( GumpList.Items[ Count ] ).Draw then
                        Inc( Count )
                else
                        DeleteGump( Count );
        end;

        for I := GumpList.Count-1 downto 0 do begin
                TGump( GumpList.Items[ I ] ).OnAfterDraw;
        end;

        Tooltip.Draw;
end;

procedure TPalanthir.AddToInvisList( Id : Integer );
begin
        InvisList.Add( Pointer( Id ) );
end;

procedure TPalanthir.RemoveFromInvisList( Id : Integer );
var     I : Integer;
begin
        for I := 0 to InvisList.Count-1 do
                if Integer( InvisList.Items[ I ] ) = Id then begin
                        InvisList.Delete( I );
                        break;
                end;
end;

procedure TPalanthir.RemoveFromInvisListByNumber( Number : Integer );
begin
        if Number < InvisList.Count then
                InvisList.Delete( Number );
end;

procedure TPalanthir.ClearInvisList;
begin
        InvisList.Clear;
end;

function TPalanthir.GetInvisListCount : Integer;
begin
        Result := InvisList.Count;
end;

function TPalanthir.GetInvisListId( Number : Integer ) : Integer;
begin
        if Number < InvisList.Count then
                Result := Integer( InvisList.Items[ Number ] )
        else
                Result := 0;
end;

function TPalanthir.IsOnInvisList( Id : Integer ) : Boolean;
var     I : Integer;
begin
        for I := 0 to InvisList.Count-1 do
                if Integer( InvisList.Items[ I ] ) = Id then begin
                        Result := True;
                        exit;
                end;

        Result := False;
end;

procedure TPalanthir.AddToServerInvisList( Id : Integer );
begin
        ServerInvisList.Add( Pointer( Id ) );
end;

procedure TPalanthir.RemoveFromServerInvisList( Id : Integer );
var     I : Integer;
begin
        for I := 0 to ServerInvisList.Count-1 do
                if Integer( ServerInvisList.Items[ I ] ) = Id then begin
                        ServerInvisList.Delete( I );
                        break;
                end;
end;

procedure TPalanthir.RemoveFromServerInvisListByNumber( Number : Integer );
begin
        if Number < ServerInvisList.Count then
                ServerInvisList.Delete( Number );
end;

procedure TPalanthir.ClearServerInvisList;
begin
        ServerInvisList.Clear;
end;

function TPalanthir.GetServerInvisListCount : Integer;
begin
        Result := ServerInvisList.Count;
end;

function TPalanthir.GetServerInvisListId( Number : Integer ) : Integer;
begin
        if Number < ServerInvisList.Count then
                Result := Integer( ServerInvisList.Items[ Number ] )
        else
                Result := 0;
end;

function TPalanthir.IsOnServerInvisList( Id : Integer ) : Boolean;
var     I : Integer;
begin
        for I := 0 to ServerInvisList.Count-1 do
                if Integer( ServerInvisList.Items[ I ] ) = Id then begin
                        Result := True;
                        exit;
                end;

        Result := False;
end;

procedure TPalanthir.DrawWorld;
var     I : Integer;
        ItemList : TList;
begin
        if GameWindow = nil then
                exit;

        if not WorldListSorted then begin
                SortItemListe( WorldList );
                WorldListSorted := True;
        end;

        for I := 0 to WorldList.Count-1 do
                TUODrawObject( WorldList.Items[ I ] ).NumberInList := I;

        if (Data.GetMapHeight( Player.Pos.X, Player.Pos.Y ) >= Player.Pos.Z + 15) and
           (Data.GetMapHeight( Player.Pos.X+1, Player.Pos.Y ) >= Player.Pos.Z + 15) and
           (Data.GetMapHeight( Player.Pos.X+1, Player.Pos.Y+1 ) >= Player.Pos.Z + 15) and
           (Data.GetMapHeight( Player.Pos.X, Player.Pos.Y+1 ) >= Player.Pos.Z + 15) then
                IsUnderMap := True
        else
                IsUnderMap := False;

        if IsUnderMap then
                RoofHeight := Player.Pos.Z+15
        else begin
                RoofHeight := $FFFF;
                ItemList := Data.WorldCache.GetStaticObjects( Player.Pos.X, Player.Pos.Y );
                for I := 0 to ItemList.Count-1 do
                        if (TStaticItem( ItemList.Items[ I ] ).Pos.Z >= Player.Pos.Z+15) and
                           (not Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dROOF )) and
                           ((Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dSURFACE )) or
                           (Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dIMPASSABLE )) ) then begin
                                if RoofHeight > TStaticItem( ItemList.Items[ I ] ).Pos.Z then
                                        RoofHeight := TStaticItem( ItemList.Items[ I ] ).Pos.Z;
                        end;
                ItemList.Free;

                ItemList := Data.WorldCache.GetStaticObjects( Player.Pos.X+1, Player.Pos.Y+1 );
                for I := 0 to ItemList.Count-1 do
                        if (TStaticItem( ItemList.Items[ I ] ).Pos.Z >= Player.Pos.Z+15) and
                           (Data.Tiledata.GetStaticFlag( TStaticItem( ItemList.Items[ I ] ).ID, dROOF )) then begin
                                if RoofHeight > TStaticItem( ItemList.Items[ I ] ).Pos.Z then
                                        RoofHeight := TStaticItem( ItemList.Items[ I ] ).Pos.Z;
                        end;
                ItemList.Free;

                ItemList := Data.WorldCache.GetItems( Player.Pos.X, Player.Pos.Y );
                for I := 0 to ItemList.Count-1 do
                        if (TItem( ItemList.Items[ I ] ).Pos.Z >= Player.Pos.Z+15) and
                           (not Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dROOF )) and
                           ((Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dSURFACE )) or
                           (Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dIMPASSABLE )) ) then begin
                                if RoofHeight > TItem( ItemList.Items[ I ] ).Pos.Z then
                                        RoofHeight := TItem( ItemList.Items[ I ] ).Pos.Z;
                        end;
                ItemList.Free;

                ItemList := Data.WorldCache.GetItems( Player.Pos.X+1, Player.Pos.Y+1 );
                for I := 0 to ItemList.Count-1 do
                        if (TItem( ItemList.Items[ I ] ).Pos.Z >= Player.Pos.Z+15) and
                           (Data.Tiledata.GetStaticFlag( TItem( ItemList.Items[ I ] ).ID, dROOF )) then begin
                                if RoofHeight > TItem( ItemList.Items[ I ] ).Pos.Z then
                                        RoofHeight := TItem( ItemList.Items[ I ] ).Pos.Z;
                        end;
                ItemList.Free;

                ItemList := Data.WorldCache.GetMultiItems( Player.Pos.X, Player.Pos.Y );
                for I := 0 to ItemList.Count-1 do
                        if (TMultiItem( ItemList.Items[ I ] ).Pos.Z >= Player.Pos.Z+15) and
                           (not Data.Tiledata.GetStaticFlag( TMultiItem( ItemList.Items[ I ] ).ID, dROOF )) and
                           ((Data.Tiledata.GetStaticFlag( TMultiItem( ItemList.Items[ I ] ).ID, dSURFACE )) or
                           (Data.Tiledata.GetStaticFlag( TMultiItem( ItemList.Items[ I ] ).ID, dIMPASSABLE )) ) then begin
                                if RoofHeight > TMultiItem( ItemList.Items[ I ] ).Pos.Z then
                                        RoofHeight := TMultiItem( ItemList.Items[ I ] ).Pos.Z;
                        end;
                ItemList.Free;

                ItemList := Data.WorldCache.GetMultiItems( Player.Pos.X+1, Player.Pos.Y+1 );
                for I := 0 to ItemList.Count-1 do
                        if (TMultiItem( ItemList.Items[ I ] ).Pos.Z >= Player.Pos.Z+15) and
                           (Data.Tiledata.GetStaticFlag( TMultiItem( ItemList.Items[ I ] ).ID, dROOF )) then begin
                                if RoofHeight > TMultiItem( ItemList.Items[ I ] ).Pos.Z then
                                        RoofHeight := TMultiItem( ItemList.Items[ I ] ).Pos.Z;
                        end;
                ItemList.Free;
        end;
        
        glEnable( GL_SCISSOR_TEST );
        glScissor( GameWindow.X, Renderer.GetWindowHoehe-GameWindow.Y-GameWindow.Hoehe, GameWindow.Breite, GameWindow.Hoehe );

        RelDrawX := Palanthir.GameWindow.X + ( Palanthir.GameWindow.Breite div 2 ) + ( - Palanthir.Player.Pos.X + Palanthir.Player.Pos.Y ) * 22 - Palanthir.Player.AnimMoveX;
        RelDrawY := Palanthir.GameWindow.Y + ( Palanthir.GameWindow.Hoehe div 2 ) + ( - Palanthir.Player.Pos.X - Palanthir.Player.Pos.Y ) * 22 + Palanthir.Player.Pos.Z*4 - Palanthir.Player.AnimMoveY + Palanthir.Player.AnimMoveZ*4;


        Timer.Start( Timer_DrawWorldList );
        for I := WorldList.Count-1 downto 0 do
                TUODrawObject( WorldList.Items[ I ] ).Draw;
        Timer.Stop( Timer_AllChars );
        Timer.Stop( Timer_AllItems );
        Timer.Stop( Timer_AllStatics );
        Timer.Stop( Timer_AllMap );
        Timer.Stop( Timer_DrawWorldList );

        glDisable( GL_SCISSOR_TEST );

        Timer.Start( Timer_Light );
        LightManager.Draw;
        Timer.Stop( Timer_Light );

        Timer.Start( Timer_Keyboard );
        Keyboard.Draw;
        Timer.Stop( Timer_Keyboard );
end;

procedure TPalanthir.DrawSpeech;
var     X, Y, I, J : Integer;
        Text : TSpeechText;
begin
        if GameWindow = nil then
                exit;
        
        glEnable( GL_SCISSOR_TEST );
        glScissor( GameWindow.X, Renderer.GetWindowHoehe-GameWindow.Y-GameWindow.Hoehe, GameWindow.Breite, GameWindow.Hoehe );

        for I := SpeechList.Count-1 downto 0 do begin
                if not TSpeech( SpeechList.Items[ I ] ).Draw then begin
                        TSpeech( SpeechList.Items[ I ] ).Free;
                        SpeechList.Delete( I );
                end;
        end;

        SystemSpeech.Queue.Poll;
        if SystemSpeech.GetCacheCount > 0 then begin
                Y := GameWindow.Y + GameWindow.Hoehe - 30;
                X := GameWindow.X + 5;
                for J := SystemSpeech.GetCacheCount-1 downto 0 do begin
                        Text := SystemSpeech.GetSpeechText( J );
                        if Text <> nil then begin
                                if GetTickCount > Text.Timer then begin
                                        SystemSpeech.Delete( J );
                                end
                                else begin
                                        Y := Y - Text.Texture.Hoehe;
                                        Text.Draw( X, Y );
                                end;
                        end;
                end;
        end;

        glDisable( GL_SCISSOR_TEST );
end;

procedure TPalanthir.DrawCursor;
var     Cursor : TCustomCursor;
        AmountId : Word;
        PosX, PosY : Integer;
begin
        if Player.WarMode then
                Cursor := Cursors.GetCursor( Cursors.CurrentCursor, 0 )
        else
                Cursor := Cursors.GetCursor( Cursors.CurrentCursor, 1 );

        if Maus.DragSerial <> Invalid_Serial then begin
                if (Maus.DragId >= FirstMultiId) and (Maus.DragId <= LastMultiId) then begin
                        if (Maus.DragMulti = nil) or (Maus.DragId <> Maus.OldDragId) or (Maus.DragColor <> Maus.OldDragColor) then begin
                                if Maus.DragMulti <> nil then begin
                                        Maus.DragMulti.Destroy;
                                        Maus.DragMulti := nil;
                                end;

                                Maus.DragMulti := Data.GetMultiAsPixelBuffer( Maus.DragId-FirstMultiId, Maus.DragColor );

                                Maus.OldDragId := Maus.DragId;
                                Maus.OldDragColor := Maus.DragColor;
                        end;

                        if Maus.DragMulti <> nil then begin
                                Maus.DragMulti.Bind;

                                glColor3f( 1, 1, 1 );

                                PosX := Maus.AktX + Maus.DragMulti.RelX;
                                PosY := Maus.AktY + Maus.DragMulti.RelY;

                                glBegin( gl_Quads );
                                        glTexCoord2f( 0, 0 );
                                        glVertex2f( PosX, PosY );
                                        glTexCoord2f( 0, 1 );
                                        glVertex2f( PosX, PosY + Maus.DragMulti.Height );
                                        glTexCoord2f( 1, 1 );
                                        glVertex2f( PosX + Maus.DragMulti.Width, PosY + Maus.DragMulti.Height );
                                        glTexCoord2f( 1, 0 );
                                        glVertex2f( PosX + Maus.DragMulti.Width, PosY );
                                glEnd;

                                Maus.DragMulti.Release;
                        end;
                end
                else begin
                        if Maus.DragAmount = 1 then begin
                                if (Maus.DragTexture = nil) or (Maus.DragId <> Maus.DragTexture.ID) or (Maus.DragColor <> Maus.DragTexture.Hue) then begin
                                        if Maus.DragTexture <> nil then
                                                Data.DecStaticArt( Maus.DragTexture.ID-$4000, Maus.DragTexture.Hue );

                                        Maus.DragTexture := Data.GetStaticArt( Maus.DragId, Maus.DragColor );

                                        if Maus.DragTexture <> nil then
                                                Data.IncStaticArt( Maus.DragTexture.ID-$4000, Maus.DragTexture.Hue );
                                end;

                                if Maus.DragTexture <> nil then begin
                                        Renderer.DrawPixels( Maus.AktX-( Maus.DragTexture.Breite div 2 ), Maus.AktY-Round( Maus.DragTexture.Hoehe*3/5 ), Maus.DragTexture );
                                end;
                        end
                        else begin
                                AmountId := Palanthir.Shard.GetAmountId( Maus.DragId, Maus.DragAmount );
                                if AmountId > 0 then begin
                                        if (Maus.DragTexture = nil) or (Maus.DragId <> Maus.DragTexture.ID) or (Maus.DragColor <> Maus.DragTexture.Hue) then begin
                                                if Maus.DragTexture <> nil then
                                                        Data.DecStaticArt( Maus.DragTexture.ID-$4000, Maus.DragTexture.Hue );

                                                Maus.DragTexture := Data.GetStaticArt( AmountId, Maus.DragColor );

                                                if Maus.DragTexture <> nil then
                                                        Data.IncStaticArt( Maus.DragTexture.ID-$4000, Maus.DragTexture.Hue );
                                        end;

                                        if Maus.DragTexture <> nil then begin
                                                Renderer.DrawPixels( Maus.AktX-( Maus.DragTexture.Breite div 2 ), Maus.AktY-Round( Maus.DragTexture.Hoehe*3/5 ), Maus.DragTexture );
                                        end;
                                end
                                else begin
                                        if (Maus.DragTexture = nil) or (Maus.DragId <> Maus.DragTexture.ID) or (Maus.DragColor <> Maus.DragTexture.Hue) then begin
                                                if Maus.DragTexture <> nil then
                                                        Data.DecStaticArt( Maus.DragTexture.ID-$4000, Maus.DragTexture.Hue );

                                                Maus.DragTexture := Data.GetStaticArt( Maus.DragId, Maus.DragColor );

                                                if Maus.DragTexture <> nil then
                                                        Data.IncStaticArt( Maus.DragTexture.ID-$4000, Maus.DragTexture.Hue );
                                        end;

                                        if Maus.DragTexture <> nil then begin
                                                Renderer.DrawPixels( Maus.AktX-( Maus.DragTexture.Breite div 2 )-2, Maus.AktY-Round( Maus.DragTexture.Hoehe*3/5 )-5, Maus.DragTexture );
                                                Renderer.DrawPixels( Maus.AktX-( Maus.DragTexture.Breite div 2 )+3, Maus.AktY-Round( Maus.DragTexture.Hoehe*3/5 ), Maus.DragTexture );
                                        end;
                                end;
                        end;
                end;
        end;

        if Target.Activated and (Target.Multi <> nil) then begin
                if (Maus.SelectedUObject <> nil) and Maus.IsInGameWindow then begin
                        glEnable( GL_SCISSOR_TEST );
                        glScissor( GameWindow.X+4, Renderer.GetWindowHoehe-GameWindow.Y-GameWindow.Hoehe+4, GameWindow.Breite-8, GameWindow.Hoehe-8 );

                        PosX := GameWindow.X + ( GameWindow.Breite div 2 ) + (Maus.SelectedUObject.Pos.X-Target.XOffset-Player.Pos.X - Maus.SelectedUObject.Pos.Y+Target.YOffset+Player.Pos.Y) * 22 - Player.AnimMoveX;
                        PosY := GameWindow.Y + ( GameWindow.Hoehe div 2 )  + (Maus.SelectedUObject.Pos.X-Target.XOffset-Player.Pos.X + Maus.SelectedUObject.Pos.Y-Target.YOffset-Player.Pos.Y) * 22 - Maus.SelectedUObject.Pos.Z*4 + Target.ZOffset*4 + Player.Pos.Z*4 - Player.AnimMoveY + Player.AnimMoveZ*4;

                        PosX := PosX + Target.MX;
                        PosY := PosY + Target.MY;

                        Target.Multi.Bind;

                        glColor3f( 1, 1, 1 );

                        glBegin( gl_Quads );
                                glTexCoord2f( 0, 0 );
                                glVertex2f( PosX, PosY );
                                glTexCoord2f( 0, 1 );
                                glVertex2f( PosX, PosY + Target.Multi.Height );
                                glTexCoord2f( 1, 1 );
                                glVertex2f( PosX + Target.Multi.Width, PosY + Target.Multi.Height );
                                glTexCoord2f( 1, 0 );
                                glVertex2f( PosX + Target.Multi.Width, PosY );
                        glEnd;

                        Target.Multi.Release;

                        glDisable( GL_SCISSOR_TEST );
                end;
        end;

        if Cursor <> nil then begin
                if Cursor.Texture <> nil then
                        Renderer.DrawPixels( Maus.AktX - Cursor.SelX, Maus.AktY - Cursor.SelY, Cursor.Texture );
        end;        
end;

function TPalanthir.GetWindowBreite : Word;
begin
        Result := Renderer.GetWindowBreite;
end;

function TPalanthir.GetWindowHoehe : Word;
begin
        Result := Renderer.GetWindowHoehe;
end;

function TPalanthir.GetShardName : String;
begin
        Result := ShardName;
end;

procedure TPalanthir.SetShardName( Text : String );
begin
        ShardName := Text;
end;

procedure TPalanthir.SendPacket( Packet : UOPacket );
begin
        NetClient.Send( Packet );
        Network.SetActionDone;
end;

procedure TPalanthir.ChangeMap( NewMap : Word );
begin
        if CurrentMap <> NewMap then begin
                if State = State_Playing then begin
                        Player.Pos.Map := NewMap;
                        Player.UnRegisterObject;

                        while Data.GlobalObjectList.GetCount > 0 do
                                Data.GlobalObjectList.GetObjectByIndex( 0 ).Free;

                        ClearWorldCache;
                        Data.Clear;

                        Palanthir.Movement.Stop;
                        Palanthir.Movement.MoveSequence := 0;
                        Palanthir.Movement.ClearCache;
                        Palanthir.Movement.SendCacheCount := 0;

                        CurrentMap := NewMap;

                        Player.RegisterObject;
                        Player.ResendWorld;
                        Player.Radar.Clear;
                end
                else begin
                        Player.Pos.Map := NewMap;
                        CurrentMap := NewMap;
                end;
        end;
end;

function TPalanthir.GetLightLevel : Byte;
begin
        Result := GlobalLight;
end;

procedure TPalanthir.ReturnToLoginGump;
var     I : Integer;
begin
        State := State_ReturnToLogin;

        ScriptManager.OnGameLeave;

        GumpIdCount := 0;
        CurrentMap := 0;

        for I := GumpList.Count-1 downto 0 do begin
                if (I < GumpList.Count) and (TGump( GumpList.Items[ I ] ) <> GameWindow) and (TGump( GumpList.Items[ I ] ) <> Player.Radar) and (TGump( GumpList.Items[ I ] ) <> Player.Journal) then
                        DeleteGump( TGump( GumpList.Items[ I ] ) );
        end;

        Player.UnRegisterObject;
        while Data.GlobalObjectList.GetCount > 0 do
                Data.GlobalObjectList.GetObjectByIndex( 0 ).Free;

        ClearWorldCache;

        Data.Clear;

        DeleteGump( GameWindow );
        GameWindow := nil;

        if (Player.CharConfig <> nil) then begin
                Player.CharConfig.SetInteger( 'JournalX', Player.Journal.X );
                Player.CharConfig.SetInteger( 'JournalY', Player.Journal.Y );
                Player.CharConfig.SetBool( 'JournalOpen', Player.Journal.Visible );
        end;
        DeleteGump( Player.Journal );
        Player.Journal := TJournal.Create;

        if (Player.CharConfig <> nil) and (Player.Radar <> nil) then begin
                Player.CharConfig.SetInteger( 'RadarX', Player.Radar.X );
                Player.CharConfig.SetInteger( 'RadarY', Player.Radar.Y );
                Player.CharConfig.SetBool( 'RadarLarge', Player.Radar.Large );
                Player.CharConfig.SetBool( 'RadarOpen', Player.Radar.Visible );
        end;
        DeleteGump( Player.Radar );
        Player.Radar := nil;

        Player.Initialized := False;
        Player.RegisterObject;

        InLoop := False;

        DoResendWorld := False;
        Target.Activated := False;

        UseItemUpdateIdFlag := True;
        FirstMultiID := $4000;
        LastMultiID := $4FFF;

        StartTick := CustomGetTickCount;

        State := State_LoggingIn;
        Renderer.SetSize( 640, 480 );

        ScriptManager.OnClientReady;
end;

procedure TPalanthir.RemoveFromDebugList( Item : TUODrawObject );
var     I : Integer;
begin
        for I := 0 to DebugList.Count-1 do begin
                if TUODrawObject( DebugList.Items[ I ] ) = Item then begin
                        DebugList.Delete( I );
                        break;
                end;
        end;
end;

procedure TPalanthir.ClearDebugList;
var     I : Integer;
begin
        for I := DebugList.Count-1 downto 0 do begin
                TUODrawObject( DebugList.Items[ I ] ).RemoveFlag( Flag_Debug );
                DebugList.Delete( I );
        end;
end;

function TPalanthir.GetWorldListCount : Word;
begin
        Result := WorldList.Count;
end;

procedure TPalanthir.EnableME;
begin
        EnabledME := True;
        UnderMapOsiMode := False;
end;

end.
