unit uParty;

interface

uses    uRecievePackets, SysUtils, Classes, uPartyGump, uSendPackets, uChar;

const   PartyStatus_None = 0;
        PartyStatus_Invitation = 1;
        PartyStatus_Established = 2;

type    TParty = Class
                private
                        Members : TList;
                public
                        Gump : TPartyGump;
                        PartyLeaderSerial : LongWord;
                        Status : Byte;
                        TalkToSerial : LongWord;
                        CanLoot : Boolean;
                        constructor Create;
                        destructor Free;
                        procedure ClearMembers;
                        procedure AddMember( Packet : TPartyAddMember );
                        procedure RemoveMember( Packet : TPartyRemoveMember );
                        procedure GetPersonalMessage( Packet : TPartyPersonalMessage );
                        procedure GetMessage( Packet : TPartyMessage );
                        procedure Update;
                        procedure GetInvitation( Packet : TPartyInvitation );
                        procedure SendMessage( Text : String );
                        function GetMemberName( Serial : LongWord ) : String;
                        function GetMemberNameByIndex( Index : Integer ) : String;
                        procedure CheckName( Serial : LongWord; Name : String );
                        function GetMemberCount : Integer;
                        procedure DeleteMember( Index : Integer );
                        procedure TalkTo( Index : Integer );
        end;

        TPartyMember = Class
                public
                        Name : String;
                        Serial : LongWord;
                        constructor Create( Serial : LongWord );
                        destructor Free;
        end;

implementation

uses    uPalanthir;

constructor TPartyMember.Create( Serial : LongWord );
begin
        Self.Serial := Serial;
end;

destructor TPartyMember.Free;
begin
end;

constructor TParty.Create;
begin
        TalkToSerial := Invalid_Serial;
        PartyLeaderSerial := Invalid_Serial;
        Members := TList.Create;
        Gump := TPartyGump.Create;
        Palanthir.AddGump( Gump );
        Status := PartyStatus_None;
        CanLoot := True;      
end;

destructor TParty.Free;
begin
        while Members.Count > 0 do begin
                TPartyMember( Members.Items[ 0 ] ).Free;
                Members.Delete( 0 );
        end;
        Members.Free;
        if Gump <> nil then
                Palanthir.DeleteGump( Gump );
end;

procedure TParty.ClearMembers;
begin
        while Members.Count > 0 do begin
                TPartyMember( Members.Items[ 0 ] ).Free;
                Members.Delete( 0 );
        end;
end;

procedure TParty.AddMember( Packet : TPartyAddMember );
var     I : Integer;
        Member : TPartyMember;
        TmpList : TList;
begin
        Status := PartyStatus_Established;

        if PartyLeaderSerial = Invalid_Serial then
                PartyLeaderSerial := Palanthir.Player.Serial;

        TmpList := TList.Create;
        for I := 0 to Packet.GetMemberCount-1 do begin
                Member := TPartyMember.Create( Packet.GetMemberSerial( I ) );
                Member.Name := GetMemberName( Member.Serial );
                TmpList.Add( Member );
        end;

        ClearMembers;
        for I := 0 to TmpList.Count-1 do
                Members.Add( TmpList.Items[I] );
        
        TmpList.Free;

        Update;
end;

procedure TParty.RemoveMember( Packet : TPartyRemoveMember );
var     I : Integer;
        Member : TPartyMember;
        TmpList : TList;        
begin
        if Packet.GetMemberCount = 0 then begin
                Status := PartyStatus_None;
                PartyLeaderSerial := Invalid_Serial;
                ClearMembers;
        end
        else begin
                TmpList := TList.Create;
                for I := 0 to Packet.GetMemberCount-1 do begin
                        Member := TPartyMember.Create( Packet.GetMemberSerial( I ) );
                        Member.Name := GetMemberName( Member.Serial );
                        TmpList.Add( Member );
                end;

                ClearMembers;
                for I := 0 to TmpList.Count-1 do
                        Members.Add( TmpList.Items[I] );

                TmpList.Free;
        end;
        Update;
end;

procedure TParty.GetPersonalMessage( Packet : TPartyPersonalMessage );
begin
        Palanthir.AddSysMessage( Format( '[%s]: %s', [GetMemberName( Packet.GetSourceSerial ), Packet.GetMessage] ), $41 );
end;

procedure TParty.GetMessage( Packet : TPartyMessage );
begin
        Palanthir.AddSysMessage( Format( '[%s]: %s', [GetMemberName( Packet.GetSourceSerial ), Packet.GetMessage] ), $41 );
end;

procedure TParty.Update;
begin
        if Gump <> nil then
                Gump.Update;
end;

procedure TParty.GetInvitation( Packet : TPartyInvitation );
begin
        Status := PartyStatus_Invitation;
        PartyLeaderSerial := Packet.GetLeaderSerial;
end;

procedure TParty.SendMessage( Text : String );
var     SendPartyMemberMessage : TSendPartyMemberMessage;
        SendPartyMessage : TSendPartyMessage;
begin
        if TalkToSerial = Invalid_Serial then begin
                SendPartyMessage := TSendPartyMessage.Create;
                SendPartyMessage.SetText( Text );
                Palanthir.SendPacket( SendPartyMessage );
        end
        else begin
                SendPartyMemberMessage := TSendPartyMemberMessage.Create;
                SendPartyMemberMessage.SetTargetSerial( TalkToSerial );
                SendPartyMemberMessage.SetText( Text );
                Palanthir.SendPacket( SendPartyMemberMessage );
                TalkToSerial := Invalid_Serial;
        end;
end;

function TParty.GetMemberName( Serial : LongWord ) : String;
var     I : Integer;
        Char : TChar;
begin
        if Serial = Palanthir.Player.Serial then begin
                Result := Palanthir.Player.Name;
        end
        else begin
                Char := TChar( Palanthir.Data.GlobalObjectList.GetObject( Serial ) );
                if Char <> nil then begin
                        Result := Char.Name;
                end
                else begin
                        for I := 0 to Members.Count-1 do begin
                                if TPartyMember( Members.Items[ I ] ).Serial = Serial then begin
                                        Result := TPartyMember( Members.Items[ I ] ).Name;
                                        exit;
                                end;
                        end;
                end;
        end;
end;

function TParty.GetMemberNameByIndex( Index : Integer ) : String;
begin
        if Index < Members.Count then
                Result := TPartyMember( Members.Items[ Index ] ).Name
        else
                Result := '';
end;

procedure TParty.CheckName( Serial : LongWord; Name : String );
var     I : Integer;
begin
        for I := 0 to Members.Count-1 do begin
                if TPartyMember( Members.Items[ I ] ).Serial = Serial then begin
                        TPartyMember( Members.Items[ I ] ).Name := Name;
                        exit;
                end;
        end;
end;

function TParty.GetMemberCount : Integer;
begin
        Result := Members.Count;
end;

procedure TParty.DeleteMember( Index : Integer );
var     SendRemovePartyMember : TSendRemovePartyMember;
begin
        if Index < Members.Count then begin
                SendRemovePartyMember := TSendRemovePartyMember.Create;
                SendRemovePartyMember.SetSerial( TPartyMember( Members.Items[ Index ] ).Serial );
                Palanthir.SendPacket( SendRemovePartyMember );
        end;
end;

procedure TParty.TalkTo( Index : Integer );
begin
        if Index < Members.Count then begin
                TalkToSerial := TPartyMember( Members.Items[ Index ] ).Serial;
                Palanthir.Keyboard.SpeechText := '';
                Palanthir.Keyboard.Typ := KB_Speech_Party;
        end;
end;

end.
 