unit uPlayer;

interface

uses uChar, uRecievePackets, uPos, uConfig, uCustomGumps, Math, uGumps, dglOpenGL,
        uBasicTypedefs, Dialogs, SysUtils, uLog, Windows, uMovement, uLoaderTiledata,
        Classes, uItem, uUtilities, uSpecialGumps, uJournal, uSecureTrading, uRadar,
        uParty, uSendPackets, uTimer;

type    TPlayer = Class( TChar )
                public
                        CharConfig : TConfig;
                        Login, Password : String;
                        Journal : TJournal;
                        Radar : TRadar;
                        VisRange : Integer;
                        Initialized : Boolean;
                        Gold : LongWord;
                        Party : TParty;
                        LastStepHadSound : Boolean;
                        Wounds : Array[0..6] of Word;
                        constructor Create; override;
                        destructor Free; override;                   
                        function IsPlayer : Boolean; override;
                        procedure Init( Packet : GetCharLocation );
                        procedure ResendWorld( ClearAll : Boolean = True );
                        procedure Update( Packet : DrawGamePlayer );
                        procedure DenyMove( Packet : DenyMove );
                        procedure AcceptMove( Packet : AcceptMove );
                        procedure AddMove( NewDirection : Byte; Run : Boolean; NewZ : ShortInt );
                        function PollAnim( Frames : Byte ) : Boolean; override;
                        procedure ChangeWarMode( Packet : GetChangeWarMode );
                        procedure SecureTrading( Packet : GetSecureTrading );
                        procedure RequestPaperdoll; override;
                        procedure RequestFightGump;
                        procedure SendChangeWarModeRequest( WarMode : Boolean );
                end;

implementation

uses    uPalanthir, uRenderer;

constructor TPlayer.Create;
var     I : Integer;
begin
        inherited Create;
        Typ := typ_player;
        AnimZoomX := 1;
        AnimZoomY := 1;
        VisRange := Config.GetInteger( 'Viewrange' );
        Gold := 0;
        Initialized := False;
        Radar := nil;
        Journal := TJournal.Create;
        CharConfig := nil;
        Party := TParty.Create;
        LastStepHadSound := False;

        for I := 0 to 6 do
                Wounds[ I ] := 0;
end;

destructor TPlayer.Free;
begin
        if (Journal <> nil) and Initialized then begin
                if CharConfig <> nil then begin
                        CharConfig.SetInteger( 'JournalX', Journal.X );
                        CharConfig.SetInteger( 'JournalY', Journal.Y );
                        CharConfig.SetBool( 'JournalOpen', Journal.Visible );
                end;
                Palanthir.DeleteGump( Journal );
        end;
        if Radar <> nil then begin
                if CharConfig <> nil then begin
                        CharConfig.SetInteger( 'RadarX', Radar.X );
                        CharConfig.SetInteger( 'RadarY', Radar.Y );
                        CharConfig.SetBool( 'RadarLarge', Radar.Large );
                        CharConfig.SetBool( 'RadarOpen', Radar.Visible );
                end;
                Palanthir.DeleteGump( Radar );
        end;
        Party.Free;

        if CharConfig <> nil then
                CharConfig.Free;
end;

function TPlayer.IsPlayer : Boolean;
begin
        Result := True;
end;

procedure TPlayer.Init( Packet : GetCharLocation );
var     GW : TGameWindow;
        GetCharStatus : TGetCharStatus;
        SendClientVersion : TSendClientVersion;
begin
        Log.Write( 'Initializing Player' );
        Name := Palanthir.Name;

        if Initialized then begin
                Serial := Packet.getPlayerID;
                Id := Packet.getBody;
                Direction := Packet.getDirection;
                ChairDirection := Packet.getDirection;
                ApplyFlag( Packet.getFlags );
                ResetAnim;

                if MoveTo( Packet.getX, Packet.getY, Packet.getZ ) then begin
                        ResendWorld( False );
                end else begin
                        ResendWorld( True );
                end;
                Exit;
        end;

        if CharConfig = nil then begin
                CharConfig := TConfig.Create;
                CharConfig.Load( Palanthir.Shard.Dir + Name + '.xml' );
        end;

        if CharConfig.GetInteger( 'SpeechColor' ) = 0 then
                CharConfig.SetInteger( 'SpeechColor', $189 );
        if CharConfig.GetInteger( 'EmoteColor' ) = 0 then
                CharConfig.SetInteger( 'EmoteColor', $35 );

        Palanthir.Keyboard.SpeechColor := CharConfig.GetInteger( 'SpeechColor' );
        Palanthir.Keyboard.EmoteColor := CharConfig.GetInteger( 'EmoteColor' );

        Log.Write( 'Resizing Renderer' );
        Renderer.SetSize( Config.GetInteger( 'ScreenWidth' ), Config.GetInteger( 'ScreenHeight' ) );
        Renderer.SetResizable( True );

        Log.Write( 'GameWindow' );
        if Palanthir.GameWindow <> nil then
                Palanthir.GameWindow.Free;
        Palanthir.GameWindow := TGameWindow.Create;
        GW := Palanthir.GameWindow;
        if CharConfig.GetString( 'GameWindowX' ) <> '' then
                GW.X := Max( 10, Min( CharConfig.GetInteger( 'GameWindowX' ), Config.GetInteger( 'ScreenWidth' )-Config.GetInteger( 'GameWindowWidth' ) ) )
        else
                GW.X := Min( 50, Config.GetInteger( 'ScreenWidth' )-Config.GetInteger( 'GameWindowWidth' ) );
        if CharConfig.GetString( 'GameWindowY' ) <> '' then
                GW.Y := Max( 10, Min( CharConfig.GetInteger( 'GameWindowY' ), Config.GetInteger( 'ScreenWidth' )-Config.GetInteger( 'GameWindowWidth' ) ) )
        else
                GW.Y := Min( 50, Config.GetInteger( 'ScreenHeight' )-Config.GetInteger( 'GameWindowHeight' ) );
        GW.Breite := Config.GetInteger( 'GameWindowWidth' );
        GW.Hoehe := Config.GetInteger( 'GameWindowHeight' );
        GW.noClose := True;

        GW.AddTiledImage( 0, 0, 4, GW.Breite, $A8C, 0, 0 );
        GW.AddTiledImage( 0, GW.Hoehe-4, 4, GW.Breite, $A8C, 0, 0 );
        GW.AddTiledImage( 0, 0, GW.Hoehe, 4, $A8D, 0, 0 );
        GW.AddTiledImage( GW.Breite-4, 0, GW.Hoehe, 4, $A8D, 0, 0 );
        {GW.AddTiledImage( -GW.X, -GW.Y, GW.Y, Palanthir.GetWindowBreite - Max( Palanthir.GetWindowBreite - GW.X - GW.Breite, 0 ), $A8E, 1, 0 );
        GW.AddTiledImage( -GW.X, Max( 0, GW.Y )-GW.Y, Palanthir.GetWindowHoehe - Max( 0, GW.Y ), GW.X, $A8E, 1, 0 );
        GW.AddTiledImage( Max( 0, -GW.X ), GW.Hoehe, Palanthir.GetWindowHoehe - GW.Hoehe - GW.Y, Palanthir.GetWindowBreite - Max( 0, GW.X ), $A8E, 1, 0 );
        GW.AddTiledImage( GW.Breite, Min( -GW.Y, 0 ), GW.Hoehe + Max( 0, GW.Y ), Palanthir.GetWindowBreite - Min( 0, GW.X ) - GW.Breite, $A8E, 1, 0 );}
        GW.OnMove( GW.GetObject( 0 ) );
        Palanthir.AddGump( GW );

        Log.Write( 'Creating Journal' );
        Palanthir.AddGump( Journal );
        if CharConfig.GetInteger( 'JournalX' ) <> 0 then
                Journal.X := Max( 0, Min( CharConfig.GetInteger( 'JournalX' ), Config.GetInteger( 'ScreenWidth' ) - 10 ) );
        if CharConfig.GetInteger( 'JournalY' ) <> 0 then
                Journal.Y := Max( 0, Min( CharConfig.GetInteger( 'JournalY' ), Config.GetInteger( 'ScreenHeight' ) - 10 ) );
        if CharConfig.GetString( 'JournalOpen' ) <> '' then
                Journal.Visible := CharConfig.GetBool( 'JournalOpen' );

        Log.Write( 'Creating Radar' );
        Radar := TRadar.Create;
        Log.Write( 'Initializing Radar' );
        Palanthir.AddGump( Radar );
        if CharConfig.GetInteger( 'RadarX' ) <> 0 then
                Radar.X := Max( 0, Min( CharConfig.GetInteger( 'RadarX' ), Config.GetInteger( 'ScreenWidth' ) - 10 ) );
        if CharConfig.GetInteger( 'RadarY' ) <> 0 then
                Radar.Y := Max( 0, Min( CharConfig.GetInteger( 'RadarY' ), Config.GetInteger( 'ScreenHeight' ) - 10 ) );
        if CharConfig.GetString( 'RadarLarge' ) <> '' then
                Radar.SetSize( CharConfig.GetBool( 'RadarLarge' ) );
        if CharConfig.GetString( 'RadarOpen' ) <> '' then
                Radar.Visible := CharConfig.GetBool( 'RadarOpen' );

        Log.Write( 'Initializing Char values' );
        Serial := Packet.getPlayerID;
        Id := Packet.getBody;
        Direction := Packet.getDirection;
        ChairDirection := Packet.getDirection;
        ApplyFlag( Packet.getFlags );
        ResetAnim;

        MoveTo( Packet.getX, Packet.getY, Packet.getZ );

        Palanthir.Keyboard.KeyboardMode := KB_Speech;

        Log.Write( 'Updating World' );
        Palanthir.Data.WorldCache.Reload;
        ResendWorld;
        Palanthir.State := State_Playing;

        Initialized := True;

        Log.Write( 'Player initialized' );

        Palanthir.ResetTimer := True;

        Palanthir.ScriptManager.OnGameEnter;

        if CharConfig.GetString( 'PaperdollOpen' ) <> '' then begin
                if CharConfig.GetBool( 'PaperdollOpen' ) then begin
                        RequestPaperdoll;
                end;
        end;

        if CharConfig.GetString( 'FightGumpOpen' ) <> '' then begin
                if CharConfig.GetBool( 'FightGumpOpen' ) then begin
                        RequestFightGump;
                end;
        end;

        if CharConfig.GetInteger( 'StatusX' ) <> 0 then
                StatusPos.X := Max( 0, Min( CharConfig.GetInteger( 'StatusX' ), Config.GetInteger( 'ScreenWidth' ) - 10 ) );;
        if CharConfig.GetInteger( 'StatusY' ) <> 0 then
                StatusPos.Y := Max( 0, Min( CharConfig.GetInteger( 'StatusY' ), Config.GetInteger( 'ScreenHeight' ) - 10 ) );;

        if Palanthir.Player.CharConfig.GetString( 'StatusOpen' ) <> '' then begin
                if Palanthir.Player.CharConfig.GetBool( 'StatusOpen' ) then begin
                        GetCharStatus := TGetCharStatus.Create;
                        GetCharStatus.SetPlayer( Serial );
                        Palanthir.SendPacket( GetCharStatus );
                        StatusVisible := True;
                end;
        end;

        SendClientVersion := TSendClientVersion.Create;
        if Palanthir.Shard.ShardConfig.GetString( 'LoginString' ) <> '' then
                SendClientVersion.SetVersion( Palanthir.Shard.ShardConfig.GetString( 'LoginString' ) )
        else
                SendClientVersion.SetVersion( 'Custom' );
        Palanthir.SendPacket( SendClientVersion );

        //wait until data is loaded
        Sleep( 1000 );

        LastUpdated := CustomGetTickCount;
end;

procedure TPlayer.ResendWorld( ClearAll : Boolean );
var     X, Y : Integer;
        BlockID : LongWord;
        PX, PY : Integer;
        Diff : Byte;
begin
        if ClearAll then begin
                Palanthir.ClearWorldCache;
                Palanthir.Data.WorldCache.SetAllInvis;
        end;

        PX := Pos.X div 8;
        PY := Pos.Y div 8;

        //frher war das ne 4, aber ne 2 scheint auch zu reichen ?!?
        Diff := 4;

        for X := PX-Diff to PX+Diff do begin
                for Y := PY-Diff to PY+Diff do begin
                        BlockID := X * GetMapHoehe + Y;

                        if (X >= PX-3) and (X <= PX+3) and (Y >= PY-3) and (Y <= PY+3) then begin
                                Palanthir.Data.WorldCache.ShowBlock( BlockID );
                        end
                        else begin
                                Palanthir.Data.WorldCache.HideBlock( BlockID );
                                Palanthir.Data.WorldCache.CheckObjectDistances( BlockID, Pos );
                        end;
                end;
        end;

        Palanthir.WorldListSorted := False;
end;

procedure TPlayer.Update( Packet : DrawGamePlayer );
begin
        Id := Packet.getBody;
        Color := Packet.getSkin;
        Direction := Packet.getDirection;
        ChairDirection := Packet.getDirection;
        ApplyFlag( Packet.getFlag );
        ResetAnim;        

        Palanthir.Movement.Stop;
        Palanthir.Movement.MoveSequence := 0;
        Palanthir.Movement.ClearCache;
        Palanthir.Movement.SendCacheCount := 0;
        Walking := False;

        if (Packet.getX <> Pos.X) or (Packet.getY <> Pos.Y) or (Packet.getZ <> Pos.Z) then begin
                MoveTo( Packet.getX, Packet.getY, Packet.getZ );
                ResendWorld;
        end;

        LastUpdated := CustomGetTickCount;
end;

procedure TPlayer.ChangeWarMode( Packet : GetChangeWarMode );
var     Gump : TGump;
        I : Integer;
begin
        WarMode := Packet.getFlag = 1;
        Palanthir.ScriptManager.OnWarModeChange( WarMode );
        for I := 0 to Palanthir.GetGumpCount-1 do begin
                Gump := Palanthir.GetGump( I );
                if (Gump.Typ = GumpTyp_Paperdoll) and (TPaperdoll( Gump ).CharSerial = Serial) then begin
                        TPaperdoll( Gump ).SetWarMode( WarMode );
                        break;
                end;
        end;
        if not Walking then
                ResetAnim;
end;

procedure TPlayer.DenyMove( Packet : DenyMove );
begin
        Direction := Packet.getDirection;
        ChairDirection := Packet.getDirection;
        ResetAnim;
        Palanthir.Movement.MoveSequence := 0;
        Palanthir.Movement.ClearCache;
        Palanthir.Movement.SendCacheCount := 0;
        Palanthir.Movement.Timer := CustomGetTickCount + 200;
        Walking := False;

        if MoveTo( Packet.getX, Packet.getY, Packet.getZ ) then
                ResendWorld;
end;

procedure TPlayer.AcceptMove( Packet : AcceptMove );
begin
        if Palanthir.Movement.SendCacheCount > 0 then
                Dec( Palanthir.Movement.SendCacheCount );
end;

procedure TPlayer.AddMove( NewDirection : Byte; Run : Boolean; NewZ : ShortInt );
var     OldPos : TPos;
        TmpPos : TPos;
begin
        if not Walking then begin
                if NewDirection <> Direction then begin
                        Direction := NewDirection;
                        ChairDirection := Direction;

                        Palanthir.Movement.SendMove( Direction, Run );
                        exit;
                end;

                if Palanthir.Walkingsounds then begin
                        if OnMount then begin
                                Palanthir.SoundManager.PlaySound( $122, 0, Pos.X, Pos.Y, Pos.Z );
                        end
                        else if Running then begin
                                if LastStepHadSound then begin
                                        LastStepHadSound := False;
                                end
                                else begin
                                        Palanthir.SoundManager.PlaySound( $12C, 0, Pos.X, Pos.Y, Pos.Z );
                                        LastStepHadSound := True;
                                end;
                        end
                        else begin
                                Palanthir.SoundManager.PlaySound( $12C, 0, Pos.X, Pos.Y, Pos.Z );
                        end;
                end;

                OldPos := TPos.Create;
                OldPos.SetPos( Pos );
                EffPos.SetPos( Pos );

                TmpPos := Palanthir.Movement.GetNewPos( Pos, Direction );

                case Direction of
                        0 : begin
                                AnimDeltaX := -22;
                                AnimDeltaY := +22;
                                end;
                        1 : begin
                                AnimDeltaX := -44;
                                AnimDeltaY := 0;
                                end;
                        2 : begin
                                AnimDeltaX := -22;
                                AnimDeltaY := -22;
                                end;
                        3 : begin
                                AnimDeltaX := 0;
                                AnimDeltaY := -44;
                                end;
                        4 : begin
                                AnimDeltaX := +22;
                                AnimDeltaY := -22;
                                end;
                        5 : begin
                                AnimDeltaX := +44;
                                AnimDeltaY := 0;
                                end;
                        6 : begin
                                AnimDeltaX := +22;
                                AnimDeltaY := +22;
                                end;
                        7 : begin
                                AnimDeltaX := 0;
                                AnimDeltaY := +44;
                                end;
                        else begin
                                AnimDeltaX := 0;
                                AnimDeltaY := 0;
                        end;
                end;

                AnimDeltaZ := Pos.Z - NewZ;

                MoveTo( TmpPos.X, TmpPos.Y, NewZ );
                TmpPos.Free;
                
                //die Richtungen nach oben gehen gesondert
                if Direction in [ 0, 6, 7 ] then
                        EffPos.SetPos( OldPos );
                OldPos.Free;

                ResendWorld( False );

                Running := Run;

                MovingStep := 1;
                AnimReverse := False;
                AnimId := GetMoveAnim( Running );
                if WalkingResetTimer = 0 then
                        AnimFrame := 0;
                if OnMount then begin
                        if Running then
                                AnimNextTime := CustomGetTickCount + GetMountRunningSpeed div MountRunningStepsPerField
                        else
                                AnimNextTime := CustomGetTickCount + GetMountMovingSpeed div MountMovingStepsPerField;
                end
                else begin
                        if Running then
                                AnimNextTime := CustomGetTickCount + GetRunningSpeed div RunningStepsPerField
                        else
                                AnimNextTime := CustomGetTickCount + GetMovingSpeed div MovingStepsPerField;
                end;
                Walking := True;

                Palanthir.Movement.SendMove( Direction, Running );
                CalculateAnimMove( Running );

                WalkingStartTime := CustomGetTickCount;
                if OnMount then begin
                        if Running then
                                WalkingDoneTime := CustomGetTickCount + GetMountRunningSpeed
                        else
                                WalkingDoneTime := CustomGetTickCount + GetMountMovingSpeed;
                end
                else begin
                        if Running then
                                WalkingDoneTime := CustomGetTickCount + GetRunningSpeed
                        else
                                WalkingDoneTime := CustomGetTickCount + GetMovingSpeed;
                end;
        end
        else begin
                Palanthir.Movement.AddCache( NewDirection, Run, NewZ );
        end;
end;

function TPlayer.PollAnim( Frames : Byte ) : Boolean;
var     NewDirection : Byte;
        MaxStepsPerField : Byte;
        OldPos, TmpPos : TPos;
        NewZ : ShortInt;
begin
        if AnimNextTime <> -1 then
                if GetTickCount > AnimNextTime then begin
                        if Walking then begin
                                if OnMount then begin
                                        if Running then
                                                MaxStepsPerField := MountRunningStepsPerField
                                        else
                                                MaxStepsPerField := MountMovingStepsPerField;
                                end
                                else begin
                                        if Running then
                                                MaxStepsPerField := RunningStepsPerField
                                        else
                                                MaxStepsPerField := MovingStepsPerField;
                                end;
                                if MovingStep < MaxStepsPerField then begin
                                        Inc( MovingStep );
                                        if AnimFrame < Frames-1 then
                                                Inc( AnimFrame )
                                        else
                                                AnimFrame := 0;

                                        while CustomGetTickCount > AnimNextTime do begin
                                                if OnMount then begin
                                                        if Running then
                                                                AnimNextTime := AnimNextTime + GetMountRunningSpeed div MountRunningStepsPerField
                                                        else
                                                                AnimNextTime := AnimNextTime + GetMountMovingSpeed div MountMovingStepsPerField;
                                                end
                                                else begin
                                                        if Running then
                                                                AnimNextTime := AnimNextTime + GetRunningSpeed div RunningStepsPerField
                                                        else
                                                                AnimNextTime := AnimNextTime + GetMovingSpeed div MovingStepsPerField;
                                                end;
                                        end;
                                        CalculateAnimMove( Running );
                                end
                                else begin
                                        if Palanthir.Movement.Cache.Count = 0 then begin
                                                WalkingResetTimer := CustomGetTickCount;
                                                AnimNextTime := -1;
                                                Walking := False;
                                        end
                                        else begin
                                                NewDirection := TMovingCache( Palanthir.Movement.Cache.Items[ 0 ] ).Direction;
                                                Running := TMovingCache( Palanthir.Movement.Cache.Items[ 0 ] ).Run;
                                                NewZ := TMovingCache( Palanthir.Movement.Cache.Items[ 0 ] ).NewZ;
                                                TMovingCache( Palanthir.Movement.Cache.Items[ 0 ] ).Free;
                                                Palanthir.Movement.Cache.Delete( 0 );

                                                if NewDirection <> Direction then begin
                                                        Direction := NewDirection;
                                                        ChairDirection := Direction;
                                                        if Palanthir.Movement.Cache.Count = 0 then begin
                                                                WalkingResetTimer := CustomGetTickCount;
                                                                AnimNextTime := -1;
                                                                Walking := False;
                                                        end
                                                        else begin
                                                                if OnMount then begin
                                                                        if Running then begin
                                                                                MovingStep := MountRunningStepsPerField;
                                                                        end
                                                                        else begin
                                                                                MovingStep := MountMovingStepsPerField;
                                                                        end;
                                                                end
                                                                else begin
                                                                        if Running then begin
                                                                                MovingStep := RunningStepsPerField;
                                                                        end
                                                                        else begin
                                                                                MovingStep := MovingStepsPerField;
                                                                        end;
                                                                end;

                                                                while CustomGetTickCount > AnimNextTime do begin
                                                                        if OnMount then begin
                                                                                if Running then
                                                                                        AnimNextTime := AnimNextTime + GetMountRunningSpeed div MountRunningStepsPerField
                                                                                else
                                                                                        AnimNextTime := AnimNextTime + GetMountMovingSpeed div MountMovingStepsPerField;
                                                                        end
                                                                        else begin
                                                                                if Running then
                                                                                        AnimNextTime := AnimNextTime + GetRunningSpeed div RunningStepsPerField
                                                                                else
                                                                                        AnimNextTime := AnimNextTime + GetMovingSpeed div MovingStepsPerField;
                                                                        end;
                                                                end;

                                                                AnimId := GetMoveAnim( Running );
                                                        end;
                                                end
                                                else begin
                                                        if Palanthir.Walkingsounds then begin
                                                                if OnMount then begin
                                                                        Palanthir.SoundManager.PlaySound( $122, 0, Pos.X, Pos.Y, Pos.Z );
                                                                end
                                                                else if Running then begin
                                                                        if LastStepHadSound then begin
                                                                                LastStepHadSound := False;
                                                                        end
                                                                        else begin
                                                                                Palanthir.SoundManager.PlaySound( $12C, 0, Pos.X, Pos.Y, Pos.Z );
                                                                                LastStepHadSound := True;
                                                                        end;
                                                                end
                                                                else begin
                                                                        Palanthir.SoundManager.PlaySound( $12C, 0, Pos.X, Pos.Y, Pos.Z );
                                                                end;
                                                        end;

                                                        OldPos := TPos.Create;
                                                        OldPos.SetPos( Pos );
                                                        EffPos.SetPos( Pos );

                                                        TmpPos := Palanthir.Movement.GetNewPos( Pos, Direction );

                                                        case Direction of
                                                                0 : begin
                                                                        AnimDeltaX := -22;
                                                                        AnimDeltaY := +22;
                                                                        end;
                                                                1 : begin
                                                                        AnimDeltaX := -44;
                                                                        AnimDeltaY := 0;
                                                                        end;
                                                                2 : begin
                                                                        AnimDeltaX := -22;
                                                                        AnimDeltaY := -22;
                                                                        end;
                                                                3 : begin
                                                                        AnimDeltaX := 0;
                                                                        AnimDeltaY := -44;
                                                                        end;
                                                                4 : begin
                                                                        AnimDeltaX := +22;
                                                                        AnimDeltaY := -22;
                                                                        end;
                                                                5 : begin
                                                                        AnimDeltaX := +44;
                                                                        AnimDeltaY := 0;
                                                                        end;
                                                                6 : begin
                                                                        AnimDeltaX := +22;
                                                                        AnimDeltaY := +22;
                                                                        end;
                                                                7 : begin
                                                                        AnimDeltaX := 0;
                                                                        AnimDeltaY := +44;
                                                                        end;
                                                                else begin
                                                                        AnimDeltaX := 0;
                                                                        AnimDeltaY := 0;
                                                                end;
                                                        end;

                                                        AnimDeltaZ := Pos.Z - NewZ;

                                                        MoveTo( TmpPos.X, TmpPos.Y, NewZ );
                                                        TmpPos.Free;

                                                        //die Richtungen nach oben gehen gesondert
                                                        if Direction in [ 0, 6, 7 ] then
                                                                EffPos.SetPos( OldPos );
                                                        OldPos.Free;

                                                        MovingStep := 1;
                                                        if AnimFrame < Frames-1 then
                                                                Inc( AnimFrame )
                                                        else
                                                                AnimFrame := 0;

                                                        while CustomGetTickCount > AnimNextTime do begin
                                                                if OnMount then begin
                                                                        if Running then
                                                                                AnimNextTime := AnimNextTime + GetMountRunningSpeed div MountRunningStepsPerField
                                                                        else
                                                                                AnimNextTime := AnimNextTime + GetMountMovingSpeed div MountMovingStepsPerField;
                                                                end
                                                                else begin
                                                                        if Running then
                                                                                AnimNextTime := AnimNextTime + GetRunningSpeed div RunningStepsPerField
                                                                        else
                                                                                AnimNextTime := AnimNextTime + GetMovingSpeed div MovingStepsPerField;
                                                                end;
                                                        end;
                                                        
                                                        AnimId := GetMoveAnim( Running );

                                                        ResendWorld( False );
                                                        CalculateAnimMove( Running );

                                                        WalkingStartTime := CustomGetTickCount;
                                                        if OnMount then begin
                                                                if Running then
                                                                        WalkingDoneTime := CustomGetTickCount + GetMountRunningSpeed
                                                                else
                                                                        WalkingDoneTime := CustomGetTickCount + GetMountMovingSpeed;
                                                        end
                                                        else begin
                                                                if Running then
                                                                        WalkingDoneTime := CustomGetTickCount + GetRunningSpeed
                                                                else
                                                                        WalkingDoneTime := CustomGetTickCount + GetMovingSpeed;
                                                        end;
                                                end;

                                                Palanthir.Movement.SendMove( Direction, Running );
                                        end;
                                end;
                        end
                        else begin
                                if not AnimReverse then begin
                                        if AnimFrame < Frames-1 then begin
                                                Inc( AnimFrame );
                                                AnimNextTime := GetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else if AnimRepeatCount > 1 then begin
                                                Dec( AnimRepeatCount );
                                                AnimFrame := 0;
                                                AnimNextTime := GetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else begin
                                                ResetAnim;
                                        end;
                                end
                                else begin
                                        if AnimFrame > 0 then begin
                                                Dec( AnimFrame );
                                                AnimNextTime := GetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else if AnimRepeatCount > 1 then begin
                                                Dec( AnimRepeatCount );
                                                AnimFrame := Frames-1;
                                                AnimNextTime := GetTickCount + 250 + AnimSpeed*50;
                                        end
                                        else begin
                                                ResetAnim;
                                        end;
                                end;
                        end;
                end;

        if (WalkingResetTimer <> 0) and (CustomGetTickCount - WalkingResetTimer > WalkingResetTime) then begin
                WalkingResetTimer := 0;
                if not Walking then
                        ResetAnim;
        end;

        Result := False;
end;

procedure TPlayer.SecureTrading( Packet : GetSecureTrading );
var     SecureTradingGump : TSecureTradingGump;
        I : Integer;
begin
        case Packet.GetAction of
                0 : begin
                        SecureTradingGump := nil;
                        for I := 0 to Palanthir.GetGumpCount-1 do
                                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_SecureTrading then
                                        if TSecureTradingGump( Palanthir.GetGump( I ) ).PartnerSerial = Packet.GetSerial1 then begin
                                                SecureTradingGump := TSecureTradingGump( Palanthir.GetGump( I ) );
                                                break;
                                        end;

                        if SecureTradingGump = nil then begin
                                SecureTradingGump := TSecureTradingGump.Create;
                                Palanthir.AddGump( SecureTradingGump );
                        end;
                        SecureTradingGump.PartnerSerial := Packet.GetSerial1;
                        SecureTradingGump.Cont1.ItemSerial := Packet.GetSerial2;
                        SecureTradingGump.Cont2.ItemSerial := Packet.GetSerial3;

                        if Packet.NameFollowing <> 0 then
                                SecureTradingGump.PartnerName := Packet.GetName;
                    end;
                1 : begin
                        for I := 0 to Palanthir.GetGumpCount-1 do
                                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_SecureTrading then
                                        if TSecureTradingGump( Palanthir.GetGump( I ) ).Cont1.ItemSerial = Packet.GetSerial1 then begin
                                                Palanthir.DeleteGump( TSecureTradingGump( Palanthir.GetGump( I ) ) );
                                                break;
                                        end;
                    end;
                2 : begin
                        for I := 0 to Palanthir.GetGumpCount-1 do
                                if TGump( Palanthir.GetGump( I ) ).Typ = GumpTyp_SecureTrading then
                                        if TSecureTradingGump( Palanthir.GetGump( I ) ).Cont1.ItemSerial = Packet.GetSerial1 then begin
                                                TSecureTradingGump( Palanthir.GetGump( I ) ).SetButton2( Packet.GetSerial2 <> 0 );
                                                TSecureTradingGump( Palanthir.GetGump( I ) ).SetButton1( Packet.GetSerial3 <> 0 );
                                                break;
                                        end;
                    end;
        end;
end;

procedure TPlayer.RequestPaperdoll;
var     SendDoubleClick : TSendDoubleClick;
begin
        SendDoubleClick := TSendDoubleClick.Create;
        SendDoubleClick.SetSerial( $80000000 or Serial );
        Palanthir.SendPacket( SendDoubleClick );
end;

procedure TPlayer.RequestFightGump;
var     Request : MEOpenFightGumpRequest;
begin
        Request := MEOpenFightGumpRequest.Create;
        Palanthir.SendPacket( Request );
end;

procedure TPlayer.SendChangeWarModeRequest( WarMode : Boolean );
var     SendWarMode : TSendWarMode;
begin
        SendWarMode := TSendWarMode.Create( WarMode );
        Palanthir.SendPacket( SendWarMode );
end;

end.

