unit uPythonFunction;

interface

uses    Python;

type    TPythonFunction = Class
                private
                        FunctionName, ModuleName : String;
                        pyFunction : PPyObject;
                public
                        constructor Create( FObject : PPyObject );
                        destructor Free;
                        procedure Reload;
                        function CallFunction( Args : PPyObject ) : Boolean;
        end;

implementation

uses    uPalanthir;

constructor TPythonFunction.Create( FObject : PPyObject );
var     pyModuleName, pyFunctionName : PPyObject;
begin
        ModuleName := '';
        FunctionName := '';
        pyFunction := nil;

        if FObject <> nil then begin
                pyModuleName := PyObject_GetAttrString( FObject, '__module__' );
                pyFunctionName := PyObject_GetAttrString( FObject, '__name__' );

                if (pyModuleName <> nil) and (pyFunctionName <> nil) then begin
                        ModuleName := PyString_AsString( pyModuleName );
                        FunctionName := PyString_AsString( pyFunctionName );
                        pyFunction := FObject;

                        Py_XINCREF( pyFunction );
                end;
        end;

        Palanthir.ScriptManager.AddFunction( Self );
end;

destructor TPythonFunction.Free;
begin
        Py_XDECREF( pyFunction );
        pyFunction := nil;

        Palanthir.ScriptManager.RemoveFunction( Self );
end;

procedure TPythonFunction.Reload;
var     pyModule : PPyObject;
begin
        Py_XDECREF( pyFunction );
        pyFunction := nil;

        if ModuleName <> '' then begin
                pyModule := PyImport_ImportModule( PChar( ModuleName ) );

                if (pyModule <> nil) and (FunctionName <> '') then begin
                        pyFunction := PyObject_GetAttrString( pyModule, PChar( FunctionName ) );
                end;

                Py_XDECREF( pyModule );
        end;
end;

function TPythonFunction.CallFunction( Args : PPyObject ) : Boolean;
var     PyResult : PPyObject;
begin
        Py_XINCREF( Args );

        Result := False;
        if (pyFunction <> nil) and (PyCallable_Check( pyFunction ) > 0) then begin
                PyResult := PyEval_CallObject( pyFunction, Args );

                if (PyResult <> nil) and (PyObject_IsTrue( PyResult ) <> 0) then
                        Result := True;
        end;

        Palanthir.ScriptManager.GetError;
        Py_XDECREF( Args );
end;

end.
