unit uPythonScript;

interface

uses    Python;

type    TPythonScript = Class
                private
                        Name : String;
                        Loaded : Boolean;
                        PyModule : PPyObject;
                public
                        constructor Create;
                        destructor Free;
                        function Load( Name : String ) : Boolean;
                        procedure UnLoad;
                        function HandleEvent( Event : String; Args : PPyObject = nil ) : Boolean;
        end;

implementation

uses    uPalanthir;

constructor TPythonScript.Create;
begin
        Name := '';
        Loaded := False;
        PyModule := nil;
end;

destructor TPythonScript.Free;
begin
        if Loaded then
                UnLoad;
end;

function TPythonScript.Load( Name : String ) : Boolean;
begin
        Self.Name := Name;

        PyModule := PyImport_ImportModule( PChar( Name ) );

        if PyModule = nil then begin
                Palanthir.ScriptManager.GetError( Name );
                Result := False;
                Exit;
        end;

        Result := True;
end;

procedure TPythonScript.UnLoad;
begin
        Loaded := False;
        
        Py_XDECREF( PyModule );
        PyModule := nil;
end;

function TPythonScript.HandleEvent( Event : String; Args : PPyObject = nil ) : Boolean;
var     PyEvent, PyResult : PPyObject;
begin
        Result := False;

        if PyObject_HasAttrString( PyModule, PChar( Event ) ) > 0 then begin
                PyEvent := PyObject_GetAttrString( PyModule, PChar( Event ) );

                if PyCallable_Check( PyEvent ) > 0 then begin
                        PyResult := PyEval_CallObject( PyEvent, Args );
                        if (PyResult <> nil) and (PyObject_IsTrue( PyResult ) <> 0) then
                                Result := True;
                        Py_XDECREF( PyResult );
                end;

                Py_XDECREF( PyEvent );
        end;

        Palanthir.ScriptManager.GetError( Name );
end;

end.
