unit uRadar;

interface

uses    uGumps, Dialogs, SysUtils, uSendPackets, Classes, Math, StrLib, uChar,
        uItem, uTexCache, uRenderer, dglOpenGL, uUtilities, uPixelBuffer, uLog,
        uRadarCache;

type    TRadar = Class( TGump )
                private
                        BackGround : TGImage;
                        ObjectCache : TList;
                        LargeRadar, SmallRadar : TTexObject;
                        RadarCache : TRadarCache;
                public
                        Visible, Large : Boolean;
                        constructor Create; override;
                        destructor Free; override;
                        function Draw : Boolean; override;
                        procedure OnButtonClick( ReturnNumber : Integer ); override;
                        procedure SetSize( Value : Boolean );
                        function GetRealX( X, Y : Integer ) : Word;
                        function GetRealY( X, Y : Integer ) : Word;
                        procedure Clear;
        end;

implementation

uses    uPalanthir;

constructor TRadar.Create;
begin
        inherited Create;
        Typ := GumpTyp_Radar;
        Visible := False;
        Large := False;

        ObjectCache := TList.Create;

        Log.Write( 'Radar: Creating RadarCache' );
        RadarCache := TRadarCache.Create;

        X := 150;
        Y := 150;

        Log.Write( 'Radar: Creating BackGround' );
        BackGround := TGImage.Create;
        BackGround.X := 0;
        BackGround.Y := 0;
        BackGround.Hue := 0;
        BackGround.Typ := gt_Image;
        BackGround.Page := 0;
        BackGround.Gump := Self;
        BackGround.Id := $1392;

        SmallRadar := Palanthir.Data.GetRadarcolTexture( $1392 );
        LargeRadar := Palanthir.Data.GetRadarcolTexture( $1393 );
end;

destructor TRadar.Free;
begin
        ObjectCache.Free;
        RadarCache.Free;

        if BackGround <> nil then
                BackGround.Free;

        if SmallRadar <> nil then
                SmallRadar.Free;
        if LargeRadar <> nil then
                LargeRadar.Free;
        
        inherited Free;
end;

function TRadar.Draw;
var     PX, PY, PosX, PosY : Integer;
        X0, Y0 : Integer;
        Texture : TTexObject;
        BlockID : LongWord;
        DX, DY, MX, MY : Integer;
        BBreite, BHoehe : Word;
        StencilTest : Boolean;
begin
        Result := True;

        if Palanthir.DisableRadar then
                exit;

        if not Visible then
                exit;

        BackGround.Draw;

        glClear( GL_STENCIL_BUFFER_BIT );     

        GLGetBooleanv( GL_STENCIL_TEST, @StencilTest );
        if not StencilTest then
                glEnable( GL_STENCIL_TEST );

        glColorMask( False, False, False, False );

        glStencilFunc( GL_ALWAYS, 1, 1 );
	glStencilOp( GL_KEEP, GL_KEEP, GL_REPLACE );

        if Large then begin
                BBreite := LargeRadar.Breite;
                BHoehe := LargeRadar.Hoehe;
                Renderer.DrawPixels( X, Y, LargeRadar );
        end
        else begin
                BBreite := SmallRadar.Breite;
                BHoehe := SmallRadar.Hoehe;        
                Renderer.DrawPixels( X, Y, SmallRadar );
        end;

        glColorMask( True, True, True, True );
	glStencilOp( GL_KEEP, GL_KEEP, GL_KEEP );
        glStencilFunc( GL_EQUAL, 1, 1 );

        DX := Palanthir.Player.Pos.X div 64;
        DY := Palanthir.Player.Pos.Y div 64;
        MX := Palanthir.Player.Pos.X mod 64;
        MY := Palanthir.Player.Pos.Y mod 64;

        PX := BBreite div 2;
        PY := BHoehe div 2;

        glColor3f( 1, 1, 1 );

        for Y0 := 0 to 4 do begin
                for X0 := 0 to 4 do begin
                        BlockID := (DX - 2 + X0) * GetMapHoehe + (DY - 2 + Y0);

                        PosX := X + PX + (X0-Y0)*64 + (MY-MX);
                        PosY := Y + PY - 256 + (X0+Y0)*64 - (MX+MY);

                        Texture := RadarCache.GetObject( BlockID ).Radar;

                        if Texture = nil then
                                Continue;

                        glBindTexture( GL_TEXTURE_2D, Texture.TexID );
                        Renderer.CurrentTexID := Texture.TexID;

                        glBegin( gl_Quads );
                                glTexCoord2f( 0, 0 );
                                glVertex2f( PosX, PosY );
                                glTexCoord2f( 1, 0 );
                                glVertex2f( PosX + 64, PosY + 64 );
                                glTexCoord2f( 1, 1 );
                                glVertex2f( PosX, PosY + 128 );
                                glTexCoord2f( 0, 1 );
                                glVertex2f( PosX - 64, PosY + 64 );
                        glEnd;
                end;
        end;

        if not StencilTest then
                glDisable( GL_STENCIL_TEST );

        glDisable( GL_TEXTURE_2D );
        glBegin( gl_Points );
                glVertex2f( X + BBreite / 2, Y + BHoehe / 2 );
        glEnd;
        glEnable( GL_TEXTURE_2D );

        //Standard Value for Gumps
        glStencilFunc( GL_NOTEQUAL, 1, 1 );

        glClear( GL_STENCIL_BUFFER_BIT );
end;

procedure TRadar.OnButtonClick( ReturnNumber : Integer );
begin
        case ReturnNumber of
                0 : Visible := False;
        end;
end;

procedure TRadar.SetSize( Value : Boolean );
begin
        Large := Value;
        if Large then
                BackGround.Id := $1393
        else
                BackGround.Id := $1392;
end;

function TRadar.GetRealX( X, Y : Integer ) : Word;
var     BBreite, BHoehe : Integer;
begin
        if Large then begin
                BBreite := LargeRadar.Breite;
                BHoehe := LargeRadar.Hoehe;
        end
        else begin
                BBreite := SmallRadar.Breite;
                BHoehe := SmallRadar.Hoehe;
        end;

        X := X - (BBreite div 2);
        Y := Y - (BHoehe div 2);

        Result := Palanthir.Player.Pos.X + Round( ( X + Y ) / 2 );
end;

function TRadar.GetRealY( X, Y : Integer ) : Word;
var     BBreite, BHoehe : Integer;
begin
        if Large then begin
                BBreite := LargeRadar.Breite;
                BHoehe := LargeRadar.Hoehe;
        end
        else begin
                BBreite := SmallRadar.Breite;
                BHoehe := SmallRadar.Hoehe;
        end;

        X := X - (BBreite div 2);
        Y := Y - (BHoehe div 2);

        Result := Palanthir.Player.Pos.Y - Round( ( X - Y ) / 2 );
end;

procedure TRadar.Clear;
begin
        RadarCache.Free;
        RadarCache := TRadarCache.Create;
end;

end.
