unit uRadarCache;

interface

uses    uTexCache;

type    TRadarMap = Class
                public
                        BlockID : LongWord;
                        Radar : TTexObject;
                        constructor Create( BlockID : LongWord );
                        destructor Free;
        end;

        TRadarListe = array[0..1] of TRadarMap;

        PRadarListe = ^TRadarListe;

        TRadarCache = Class
                private
                        Cache : PRadarListe;
                        Count : Integer;
                public
                        constructor Create;
                        destructor Free;
                        procedure AddObject( Block : TRadarMap );
                        function GetObject( BlockID : LongWord ) : TRadarMap;
                        procedure DeleteObject( BlockID : LongWord );
        end;

implementation

uses    uPalanthir;

constructor TRadarMap.Create( BlockID : LongWord );
begin
        Self.BlockID := BlockID;
        Radar := Palanthir.Data.GetRadarTexture( BlockID );
end;

destructor TRadarMap.Free;
begin
        if Radar <> nil then
                Radar.Free;
end;

constructor TRadarCache.Create;
begin
        Count := 0;
end;

destructor TRadarCache.Free;
var     I : Integer;
begin
        if Count > 0 then begin
                for I := 0 to Count-1 do begin
                        Cache^[ I ].Free;
                end;
                FreeMem( Cache );
        end;
end;

procedure TRadarCache.AddObject( Block : TRadarMap );
var     Max, Min, Pos : Integer;
        NewCache : PRadarListe;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].BlockID > Block.BlockID then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].BlockID < Block.BlockID then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].BlockID = Block.BlockID then begin
                                break;
                        end;
                end;
        end
        else
                Max := 0;

        GetMem( NewCache, (Count+1)*sizeof( TRadarMap ) );
        if Max > 0 then
                Move( Cache^[ 0 ], NewCache^[ 0 ], Max*sizeof( TRadarMap ) );
        NewCache^[ Max ] := Block;
        if Count > Max then
                Move( Cache^[ Max ], NewCache^[ Max+1 ], (Count-Max)*sizeof( TRadarMap ) );
        if Count > 0 then
                FreeMem( Cache );
        GetMem( Cache, (Count+1)*sizeof( TRadarMap ) );
        Move( NewCache^[ 0 ], Cache^[ 0 ], (Count+1)*sizeof( TRadarMap ) );
        FreeMem( NewCache );
        inc( Count );
end;

function TRadarCache.GetObject( BlockID : LongWord ) : TRadarMap;
var     Max, Min, Pos : Integer;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].BlockID > BlockID then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].BlockID < BlockID then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].BlockID = BlockID then begin
                                Result := Cache^[ Pos ];
                                exit;
                        end;
                end;
        end;

        Result := TRadarMap.Create( BlockID );
        AddObject( Result );
end;

procedure TRadarCache.DeleteObject( BlockID : LongWord );
var     Max, Min, Pos : Integer;
        NewCache : PRadarListe;
        Block : TRadarMap;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].BlockID > BlockID then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].BlockID < BlockID then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].BlockID = BlockID then begin
                                Block := Cache^[ Pos ];
                                if Count > 1 then begin
                                        GetMem( NewCache, (Count-1)*sizeof( TRadarMap ) );
                                        if Pos > 0 then
                                                Move( Cache^[ 0 ], NewCache^[ 0 ], Pos*sizeof( TRadarMap ) );
                                        if ( Count > Pos+1 ) then
                                                Move( Cache^[ Pos+1 ], NewCache^[ Pos ], (Count-Pos-1)*sizeof( TRadarMap ) );
                                        FreeMem( Cache );
                                        GetMem( Cache, (Count-1)*sizeof( TRadarMap ) );
                                        Move( NewCache^[ 0 ], Cache^[ 0 ], (Count-1)*sizeof( TRadarMap ) );
                                        FreeMem( NewCache );
                                        Dec( Count );
                                end
                                else if Count > 0 then begin
                                        FreeMem( Cache );
                                        Count := 0;
                                end;
                                Block.Free;
                                exit;
                        end;
                end;
        end;
end;

end.
