unit uScreenShot;

interface

uses    Windows, Classes, Graphics, dglOpenGL, ExtCtrls, Math, uTexCache,
        JPEG, SysUtils, StrUtils;

type    TScreenShotUtility = Class
                private
                        MakeScreenShot : Boolean;
                        DirPath : String;
                        function ScreenShot : TBitmap;
                public
                        constructor Create( Dir : String );
                        destructor Free;
                        procedure Shot;
                        procedure Poll;
        end;
        

var     ScreenShotUtility : TScreenShotUtility;

implementation

uses    uPalanthir;

constructor TScreenShotUtility.Create( Dir : String );
begin
        MakeScreenShot := False;
        DirPath := Dir;
end;

destructor TScreenShotUtility.Free;
begin
end;

procedure TScreenShotUtility.Shot;
begin
        MakeScreenShot := True;
end;

function TScreenShotUtility.ScreenShot : TBitmap;
var     Pixel : PByteArray;
        X, Y : Integer;
        Temp : Byte;
        Header : PBitmapInfo;
begin
        Result := TBitmap.Create;
        Result.PixelFormat := pf32Bit;
        Result.Width := Palanthir.GetWindowBreite;
        Result.Height := Palanthir.GetWindowHoehe;

        GetMem( Pixel, Result.Width*Result.Height*4 );
        glReadPixels( 0, 0, Result.Width, Result.Height, GL_RGBA, GL_UNSIGNED_BYTE, Pixel );

        for Y := 0 to Result.Height-1 do
                for X := 0 to Result.Width-1 do begin
                        Temp := Pixel^[(Y*Result.Width+X)*4+2];
                        Pixel^[(Y*Result.Width+X)*4+2] := Pixel^[(Y*Result.Width+X)*4];
                        Pixel^[(Y*Result.Width+X)*4] := Temp;
                end;

        GetMem( Header, SizeOf( TBitmapInfoHeader ) );
        with Header^.bmiHeader do begin
                biSize := SizeOf( TBitmapInfoHeader );
                biWidth := Result.Width;
                biHeight := Result.Height;
                biPlanes := 1;
                biBitCount := 32;
                biCompression := BI_RGB;
                biSizeImage := Result.Width*Result.Height*4;
        end;

        SetDIBits( Result.Canvas.Handle, Result.Handle, 0, Result.Height, Pixel, TBitmapInfo( Header^ ), DIB_RGB_COLORS );

        FreeMem( Pixel );
        FreeMem( Header );
end;

procedure TScreenShotUtility.Poll;
var     Bitmap : TBitmap;
        JPG : TJPEGImage;
        FileName : String;
begin
        if MakeScreenShot then begin
                MakeScreenShot := False;
                Bitmap := ScreenShot;
                JPG := TJPEGImage.Create;
                JPG.CompressionQuality := 100;
                JPG.Assign( Bitmap );
                FileName := Palanthir.GetShardName + '_' + DateToStr( Date ) + '_' + TimeToStr( Time );
                FileName := AnsiReplaceStr( FileName, ':', '_' );
                FileName := AnsiReplaceStr( FileName, '.', '_' );
                FileName := AnsiReplaceStr( Filename, ' ', '_' );
                JPG.SaveToFile( DirPath +  '_' + FileName + '.jpg' );
                JPG.Free;
                Bitmap.Free;
        end;
end;

end.
