unit uSecretUtility;

interface

uses    Md5, SysUtils, uSpecialRadar, uCursors;

const   Flag_NakedMan = $0001;
        Flag_NakedWoman = $0002;

type    TSecretUtility = Class
                private
                        Flags : LongWord;
                public
                        constructor Create;
                        destructor Free;
                        function Check( Zeile : String ) : Boolean;
                        function GetFlag( TestFlag : LongWord ) : Boolean;
        end;

implementation

uses    uPalanthir;

constructor TSecretUtility.Create;
begin
        Flags := 0;
end;

destructor TSecretUtility.Free;
begin
end;

function TSecretUtility.Check( Zeile : String ) : Boolean;
var     Radar : TSpecialRadar;
begin
        //specialoptions
        if LowerCase( MD5DigestToStr( Md5String( LowerCase( Copy( Zeile, 1, 14 ) ) ) ) ) = 'e2aa84ef3b0655c1389df77a131c3b7c' then begin
                Zeile := LowerCase( Copy( Zeile, 15, Length( Zeile )-14 ) );

                if Copy( Zeile, 1, 10 ) = ' --enable ' then begin
                        Zeile := Copy( Zeile, 11, Length( Zeile )-10 );

                        if Zeile = 'naked men' then
                                Flags := Flags or Flag_NakedMan
                        else if Zeile = 'naked women' then
                                Flags := Flags or Flag_NakedWoman
                        else if Zeile = 'showserials' then
                                Palanthir.ShowSerials := True
                        else if Zeile = 'showfps' then
                                Palanthir.ShowFPS := True;

                        Result := True;
                        exit;
                end
                else if Copy( Zeile, 1, 11 ) = ' --disable ' then begin
                        Zeile := Copy( Zeile, 12, Length( Zeile )-11 );

                        if Zeile = 'naked men' then
                                Flags := Flags and not Flag_NakedMan
                        else if Zeile = 'naked women' then
                                Flags := Flags and not Flag_NakedWoman
                        else if Zeile = 'showserials' then
                                Palanthir.ShowSerials := False
                        else if Zeile = 'showfps' then
                                Palanthir.ShowFPS := False;

                        Result := True;
                        exit;
                end
                else if Copy( Zeile, 1, 8 ) = ' --open ' then begin
                        Zeile := Copy( Zeile, 9, Length( Zeile )-8 );

                        if Zeile = 'worldmap' then begin
                                Radar := TSpecialRadar.Create;
                                if Radar.Map = nil then
                                        Radar.Free
                                else
                                        Palanthir.AddGump( Radar );
                        end;
                        Result := True;
                        exit;
                end
                else if Copy( Zeile, 1, 14 ) = ' turntochicken' then begin
                        Palanthir.Target.AllowGround := False;
                        Palanthir.Target.Serial := 0;
                        Palanthir.Target.Activated := True;
                        Palanthir.Target.SetMultiId( 0 );
                        Palanthir.Target.Typ := TypTargetChicken;
                        Palanthir.CursorState := Cursor_Target;
                        Palanthir.Cursors.CurrentCursor := crUOTarget;

                        Result := True;
                        exit;
                end
                else if Copy( Zeile, 1, 8 ) = ' drawmap' then begin
                        Palanthir.DrawMap := not Palanthir.DrawMap;
                        if Palanthir.DrawMap then
                                Palanthir.AddSysMessage( 'Map will now be drawn.' )
                        else
                                Palanthir.AddSysMessage( 'Map will now not be drawn.' );

                        Result := True;
                        exit;
                end
                else if Copy( Zeile, 1, 12 ) = ' drawstatics' then begin
                        Palanthir.DrawStatics := not Palanthir.DrawStatics;
                        if Palanthir.DrawStatics then
                                Palanthir.AddSysMessage( 'Statics will now be drawn.' )
                        else
                                Palanthir.AddSysMessage( 'Statics will now not be drawn.' );

                        Result := True;
                        exit;
                end
                else if Copy( Zeile, 1, 17 ) = ' turnalltochicken' then begin
                        Palanthir.TurnAllToChicken := not Palanthir.TurnAllToChicken;
                        Result := True;
                        exit;
                end;
        end;

        Result := False;
end;

function TSecretUtility.GetFlag( TestFlag : LongWord ) : Boolean;
begin
        Result := (Flags and TestFlag) = TestFlag;
end;

end.
 