unit uSoundManager;

interface

uses    SDL, SDL_Mixer, uLog, SMpeg, uLoaderMP3, SysUtils, Dialogs;

type    TSoundManager = Class
                private
                        Loaded : Boolean;
                        SoundVolume, MusicVolume : Integer;
                        Sound : PMix_Chunk;
                        Music : PSMPEG;
                        CurrentMusicID : Integer;
                public
                        RunMusic, RunSound : Boolean;                
                        constructor Create( MVolume : Integer = 40; SVolume : Integer = 128 );
                        destructor Free;
                        procedure PlaySound( Id : Integer; Flags : Byte; X, Y, Z : Word );
                        procedure PlayMidi( Id : Integer );
                        procedure SetMusic( Run : Boolean );
                        procedure SetSound( Run : Boolean );
                        procedure SetSoundVolume( SVolume : Integer );
                        procedure SetMusicVolume( MVolume : Integer );
        end;

implementation

uses    uPalanthir;

constructor TSoundManager.Create( MVolume, SVolume : Integer );
begin
        Loaded := True;
        if SDL_Init( SDL_INIT_AUDIO ) = -1 then begin
                Log.Write( 'Initializing SDL Audio failed' );
                Loaded := False;
                exit;
        end;

        if Mix_OpenAudio( 22050, MIX_DEFAULT_FORMAT, 1, 1024 ) = -1 then begin
                Log.Write( 'Opening SDL Audio failed' );
                SDL_QuitSubSystem( SDL_INIT_AUDIO );
                Loaded := False;
                exit;
        end;

        Mix_VolumeMusic( MVolume );
        SoundVolume := SVolume;
        MusicVolume := MVolume;
        Sound := nil;
        Music := nil;
        CurrentMusicID := -1;        
end;

destructor TSoundManager.Free;
begin
        if Sound <> nil then begin
                Mix_FreeChunk( Sound );
                Sound := nil;
        end;

        if Music <> nil then begin
                SMPEG_Stop( Music );
                Music := nil;
        end;

        if Loaded then begin
                Mix_CloseAudio;
                SDL_Quit;
        end;
end;

procedure TSoundManager.PlaySound( Id : Integer; Flags : Byte; X, Y, Z : Word );
var     Volume : Integer;
begin
        if not RunSound then
                exit;

        if Sound <> nil then begin
                Mix_FreeChunk( Sound );
                Sound := nil;
        end;

        Sound := Palanthir.Data.GetSound( Id );

        if Sound = nil then
                exit;

        Volume := SoundVolume;

        //Hier ev. Entfernungsabhngigkeit
        Mix_VolumeChunk( Sound, Volume );

        if Mix_PlayChannel( -1, Sound, 0 ) = -1 then begin
                Log.Write( Mix_GetError );
                Mix_FreeChunk( Sound );
                Sound := nil;
        end;
end;

procedure TSoundManager.PlayMidi( Id : Integer );
var     PMusic : PMusicRecord;
        Frequency, Channels : Integer;
        Format : Word;
        Spec : TSDL_AudioSpec;
        Error : String;
begin
        CurrentMusicID := Id;
        
        if not RunMusic then
                exit;

        if Music <> nil then begin
                SMPEG_Stop( Music );
                Music := nil;
        end;

        PMusic := Palanthir.Data.GetMusic( Id );
        if PMusic = nil then
                exit;

        if (PMusic.FileName = '') or (not FileExists( PMusic.FileName )) then
                exit;

        Log.Write( PMusic.FileName );
        Music := SMPEG_New( PChar( PMusic.FileName ), nil, 0 );
        if Music = nil then
                exit;

        Error := SMPEG_Error( Music );
        if Error <> '' then
                showmessage( Error );

        SMPEG_enableaudio( Music, 0 );

        Mix_QuerySpec( Frequency, Format, Channels );
        Spec.freq := Frequency;
        Spec.format := Format;
        Spec.channels := Channels;

        SMPEG_actualSpec( Music, @Spec );

        Mix_HookMusic( @SMPEG_playAudioSDL, Music );
        SMPEG_Enableaudio( Music, 1 );
        SMPEG_Enablevideo( Music, 0 );
        SMPEG_Setvolume( Music, MusicVolume );
        if PMusic.Loop then
                SMPEG_Loop( Music, 1 )
        else
                SMPEG_Loop( Music, 0 );
        SMPEG_Play( Music );
end;

procedure TSoundManager.SetMusic( Run : Boolean );
begin
        RunMusic := Run;

        if (not RunMusic) and (Music <> nil) then begin
                SMPEG_Stop( Music );
                Music := nil;
        end;
        if RunMusic and (Music = nil) and (CurrentMusicID <> -1) then begin
                PlayMidi( CurrentMusicID );
        end;
end;

procedure TSoundManager.SetSound( Run : Boolean );
begin
        RunSound := Run;

        if (not RunSound) and (Sound <> nil) then begin
                Mix_FreeChunk( Sound );
                Sound := nil;
        end;

end;

procedure TSoundManager.SetSoundVolume( SVolume : Integer );
begin
        SoundVolume := SVolume;
end;

procedure TSoundManager.SetMusicVolume( MVolume : Integer );
begin
        MusicVolume := MVolume;
end;

end.
