unit uTexCache;

interface

uses    dglOpenGL, Dialogs, SysUtils, uBitMask, uCounter, uLog, uUtilities;

const   Tex_ArtMap = 0;
        Tex_ArtStatic = 1;
        Tex_Texture = 2;
        Tex_Ascii = 3;
        Tex_Unicode = 4;
        Tex_Gump = 5;
        Tex_Radar = 6;
        Tex_Light = 7;
        Tex_Anim = 8;
        Tex_Checker = 9;
        Tex_ExtArt = 10;
        Tex_Fonts = 11;

        TexExpireTime = 30*1000;

type    TTexObject = Class
                public
                        BitMask : TBitMask;
                        Breite : Word;
                        Count : LongWord;
                        Frame : Word;
                        Hue : Integer;
                        Hoehe : Word;
                        ID : LongWord;
                        TexID : Integer;
                        Typ : Byte;
                        ZeroTime : LongWord;
                        Loading : Boolean;
                        HasAlpha : Boolean;
                        constructor Create( Typ : Byte );
                        destructor Free;
                        procedure InitBitMask32( Pixels : PByteArray );
                        procedure InitBitMask16( Pixels : PByteArray );                        
                        function CheckPixel( X, Y : Integer ) : Boolean;
                        function Equals( Texture : TTexObject ) : Boolean;
        end;

        TTexArray = array[0..1] of TTexObject;
        PTexArray = ^TTexArray;

        TTexCache = Class
                private
                public
                        AutoDelete : Boolean;
                        Cache : PTexArray;
                        Count : Integer;
                        constructor Create;
                        destructor Free;
                        procedure AddObject( TexObject : TTexObject );
                        function TestObject( ID : LongWord; Hue : Integer = 0 ) : Boolean;
                        function GetTexID( ID : LongWord; Hue : Integer = 0; Frame : Word = 0 ) : Integer;
                        function GetTexObject( ID : LongWord; Hue : Integer = 0; Frame : Word = 0 ) : TTexObject;
                        procedure IncCount( ID : LongWord; Hue : Integer = 0; Frame : Word = 0 );
                        procedure DecCount( ID : LongWord; Hue : Integer = 0; Frame : Word = 0 );
                        procedure GarbageCollection;
        end;

implementation

constructor TTexObject.Create( Typ : Byte );
begin
        Frame := 0;
        BitMask := TBitMask.Create;
        Self.Typ := Typ;
        TexID := -1;
        Count := 0;
        ZeroTime := 0;
        Loading := False;
        HasAlpha := False;
        
        Counter.IncCount( Count_Texture );

        Case Typ of
                Tex_ArtMap : Counter.IncCount( Count_TexArtMap );
                Tex_ArtStatic : Counter.IncCount( Count_TexArtStatic );
                Tex_Texture : Counter.IncCount( Count_TexTexture );
                Tex_Ascii : Counter.IncCount( Count_TexAscii );
                Tex_Unicode : Counter.IncCount( Count_TexUnicode );
                Tex_Gump : Counter.IncCount( Count_TexGump );
                Tex_Radar : Counter.IncCount( Count_TexRadar );
                Tex_Light : Counter.IncCount( Count_TexLight );
                Tex_Anim : Counter.IncCount( Count_TexAnim );
        end;
end;

destructor TTexObject.Free;
begin
        Counter.DecCount( Count_Texture );

        Case Typ of
                Tex_ArtMap : Counter.DecCount( Count_TexArtMap );
                Tex_ArtStatic : Counter.DecCount( Count_TexArtStatic );
                Tex_Texture : Counter.DecCount( Count_TexTexture );
                Tex_Ascii : Counter.DecCount( Count_TexAscii );
                Tex_Unicode : Counter.DecCount( Count_TexUnicode );
                Tex_Gump : Counter.DecCount( Count_TexGump );
                Tex_Radar : Counter.DecCount( Count_TexRadar );
                Tex_Light : Counter.DecCount( Count_TexLight );
                Tex_Anim : Counter.DecCount( Count_TexAnim );
        end;

        if TexID <> -1 then
                glDeleteTextures( 1, @TexID );
        BitMask.Free;
end;

procedure TTexObject.InitBitMask32( Pixels : PByteArray );
begin
        BitMask.Init32( Breite, Hoehe, Pixels );
end;

procedure TTexObject.InitBitMask16( Pixels : PByteArray );
begin
        BitMask.Init16( Breite, Hoehe, Pixels );
end;

function TTexObject.CheckPixel( X, Y : Integer ) : Boolean;
begin
        Result := BitMask.CheckPixel( X, Y );
end;

function TTexObject.Equals( Texture : TTexObject ) : Boolean;
begin
        Result := (Texture.ID = ID) and (Texture.Hue = Hue) and (Texture.Frame = Frame) and (Texture.Typ = Typ);
end;

function TTexCache.TestObject( ID : LongWord; Hue : Integer ) : Boolean;
var     I : Integer;
begin
        for I := 0 to Count-1 do begin
                if (Cache^[I].ID = ID) and (Cache^[I].Hue = Hue) then begin
                        Result := True;
                        exit;
                end;
        end;

        Result := False;
end;

constructor TTexCache.Create;
begin
        Count := 0;
        AutoDelete := True;
end;

destructor TTexCache.Free;
var     I : Integer;
begin
        if Count > 0 then begin
                for I := 0 to Count-1 do begin
                        Cache^[ I ].Free;
                end;
                FreeMem( Cache );
        end;
end;

procedure TTexCache.AddObject( TexObject : TTexObject );
var     Max, Min, Pos : Integer;
        NewCache : PTexArray;
begin
        Min := 0;
        Max := Count;
        
        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].ID > TexObject.ID then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].ID < TexObject.ID then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].ID = TexObject.ID then
                                if Cache^[ Pos ].Hue > TexObject.Hue then begin
                                        if Max = Pos then
                                                break
                                        else
                                                Max := Pos;
                                end
                                else if Cache^[ Pos ].Hue < TexObject.Hue then begin
                                        if Min = Pos then
                                                break
                                        else
                                                Min := Pos;
                                end
                                else if Cache^[ Pos ].Hue = TexObject.Hue then begin
                                        if Cache^[ Pos ].Frame > TexObject.Frame then begin
                                                if Max = Pos then
                                                        break
                                                else
                                                        Max := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame < TexObject.Frame then begin
                                                if Min = Pos then
                                                        break
                                                else
                                                        Min := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame = TexObject.Frame then begin
                                                break;
                                        end;
                                end;
                end;
        end
        else
                Max := 0;
        
        GetMem( NewCache, (Count+1)*sizeof( TTexObject ) );
        if Max > 0 then
                Move( Cache^[ 0 ], NewCache^[ 0 ], Max*sizeof( TTexObject ) );
        NewCache^[ Max ] := TexObject;
        if Count > Max then
                Move( Cache^[ Max ], NewCache^[ Max+1 ], (Count-Max)*sizeof( TTexObject ) );
        if Count > 0 then
                FreeMem( Cache );
        GetMem( Cache, (Count+1)*sizeof( TTexObject ) );
        Move( NewCache^[ 0 ], Cache^[ 0 ], (Count+1)*sizeof( TTexObject ) );
        FreeMem( NewCache );
        Inc( Count );
end;

function TTexCache.GetTexID( ID : LongWord; Hue : Integer; Frame : Word ) : Integer;
var     Max, Min, Pos : Integer;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].ID > ID then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].ID < ID then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].ID = ID then
                                if Cache^[ Pos ].Hue > Hue then begin
                                        if Max = Pos then
                                                break
                                        else
                                                Max := Pos;
                                end
                                else if Cache^[ Pos ].Hue < Hue then begin
                                        if Min = Pos then
                                                break
                                        else
                                                Min := Pos;
                                end
                                else if Cache^[ Pos ].Hue = Hue then begin
                                        if Cache^[ Pos ].Frame > Frame then begin
                                                if Max = Pos then
                                                        break
                                                else
                                                        Max := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame < Frame then begin
                                                if Min = Pos then
                                                        break
                                                else
                                                        Min := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame = Frame then begin
                                                Result := Cache^[ Pos ].TexID;
                                                exit;
                                        end;
                                end;
                end;
        end;
        Result := -1;
end;

function TTexCache.GetTexObject( ID : LongWord; Hue : Integer; Frame : Word ) : TTexObject;
var     Max, Min, Pos : Integer;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].ID > ID then begin
                                if Max = Pos then begin
                                        break;
                                end
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].ID < ID then begin
                                if Min = Pos then begin
                                        break;
                                end
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].ID = ID then
                                if Cache^[ Pos ].Hue > Hue then begin
                                        if Max = Pos then begin
                                                break;
                                        end
                                        else
                                                Max := Pos;
                                end
                                else if Cache^[ Pos ].Hue < Hue then begin
                                        if Min = Pos then begin
                                                break;
                                        end
                                        else
                                                Min := Pos;
                                end
                                else if Cache^[ Pos ].Hue = Hue then begin
                                        if Cache^[ Pos ].Frame > Frame then begin
                                                if Max = Pos then begin
                                                        break;
                                                end
                                                else
                                                        Max := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame < Frame then begin
                                                if Min = Pos then begin
                                                        break;
                                                end
                                                else
                                                        Min := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame = Frame then begin
                                                Result := Cache^[ Pos ];
                                                exit;
                                        end;
                                end;
                end;
        end;

        Result := nil;
end;

procedure TTexCache.IncCount( ID : LongWord; Hue : Integer; Frame : Word );
var     Max, Min, Pos : Integer;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].ID > ID then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].ID < ID then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].ID = ID then
                                if Cache^[ Pos ].Hue > Hue then begin
                                        if Max = Pos then
                                                break
                                        else
                                                Max := Pos;
                                end
                                else if Cache^[ Pos ].Hue < Hue then begin
                                        if Min = Pos then
                                                break
                                        else
                                                Min := Pos;
                                end
                                else if Cache^[ Pos ].Hue = Hue then begin
                                        if Cache^[ Pos ].Frame > Frame then begin
                                                if Max = Pos then
                                                        break
                                                else
                                                        Max := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame < Frame then begin
                                                if Min = Pos then
                                                        break
                                                else
                                                        Min := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame = Frame then begin
                                                Inc( Cache^[ Pos ].Count );
                                                exit;
                                        end;
                                end;
                end;
        end;
end;

procedure TTexCache.DecCount( ID : LongWord; Hue : Integer; Frame : Word );
var     Max, Min, Pos : Integer;
        NewCache : PTexArray;
begin
        Min := 0;
        Max := Count;

        if Count <> 0 then begin
                while True do begin
                        Pos := ( Min + Max ) div 2;
                        if Cache^[ Pos ].ID > ID then begin
                                if Max = Pos then
                                        break
                                else
                                        Max := Pos;
                        end
                        else if Cache^[ Pos ].ID < ID then begin
                                if Min = Pos then
                                        break
                                else
                                        Min := Pos;
                        end
                        else if Cache^[ Pos ].ID = ID then
                                if Cache^[ Pos ].Hue > Hue then begin
                                        if Max = Pos then
                                                break
                                        else
                                                Max := Pos;
                                end
                                else if Cache^[ Pos ].Hue < Hue then begin
                                        if Min = Pos then
                                                break
                                        else
                                                Min := Pos;
                                end
                                else if Cache^[ Pos ].Hue = Hue then begin
                                        if Cache^[ Pos ].Frame > Frame then begin
                                                if Max = Pos then
                                                        break
                                                else
                                                        Max := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame < Frame then begin
                                                if Min = Pos then
                                                        break
                                                else
                                                        Min := Pos;
                                        end
                                        else if Cache^[ Pos ].Frame = Frame then begin
                                                if Cache^[ Pos ].Count > 1 then begin
                                                        Dec( Cache^[ Pos ].Count );
                                                end
                                                else begin
                                                        if AutoDelete and (not Cache^[ Pos ].Loading) then begin
                                                                Cache^[ Pos ].Free;

                                                                if Count > 1 then begin
                                                                        GetMem( NewCache, (Count-1)*sizeof( TTexObject ) );
                                                                        if Pos > 0 then
                                                                                Move( Cache^[ 0 ], NewCache^[ 0 ], Pos*sizeof( TTexObject ) );
                                                                        if ( Count > Pos+1 ) then
                                                                                Move( Cache^[ Pos+1 ], NewCache^[ Pos ], (Count-Pos-1)*sizeof( TTexObject ) );
                                                                        FreeMem( Cache );
                                                                        GetMem( Cache, (Count-1)*sizeof( TTexObject ) );
                                                                        Move( NewCache^[ 0 ], Cache^[ 0 ], (Count-1)*sizeof( TTexObject ) );
                                                                        FreeMem( NewCache );
                                                                end
                                                                else if Count > 0 then begin
                                                                        FreeMem( Cache );
                                                                end;
                                                                Dec( Count );
                                                        end
                                                        else begin
                                                                Cache^[ Pos ].ZeroTime := CustomGetTickCount;
                                                                if Cache^[ Pos ].Count > 0 then
                                                                        Dec( Cache^[ Pos ].Count );
                                                        end;
                                                end;
                                                exit;
                                        end;
                                end;
                end;
        end;
end;

procedure TTexCache.GarbageCollection;
var     NewCount : Integer;
        I : Integer;
        NewCache : PTexArray;
        ExpireTime : LongWord;
        OldPos, NewPos : Integer;
begin
        NewCount := 0;
        ExpireTime := CustomGetTickCount - TexExpireTime;

        for I := 0 to Count-1 do begin
                if (Cache^[ I ].Count <> 0) or (Expiretime < Cache^[ I ].ZeroTime) or Cache^[ I ].Loading then begin
                        Inc( NewCount );
                end;
        end;

        if (Count > 0) and (NewCount <> Count) then begin
                OldPos := 0;
                NewPos := 0;

                GetMem( NewCache, NewCount*sizeof( TTexObject ) );

                for I := 0 to Count-1 do begin
                        if (Cache^[ I ].Count = 0) and (Expiretime >= Cache^[ I ].ZeroTime) and (not Cache^[ I ].Loading) then begin
                                if OldPos < I then begin
                                        Move( Cache^[ OldPos ], NewCache^[ NewPos ], (I-OldPos)*sizeof( TTexObject ) );
                                        NewPos := NewPos + I - OldPos;
                                end;

                                Cache^[ I ].Free;
                                OldPos := I+1;
                        end;
                end;

                if OldPos < Count then begin
                        Move( Cache^[ OldPos ], NewCache^[ NewPos ], (Count-OldPos)*sizeof( TTexObject ) );
                end;

                FreeMem( Cache );
                Cache := NewCache;
                Count := NewCount;
        end;
end;


end.
