unit uTimer;

interface

uses    uUtilities, uLog, SysUtils;

const   Timer_MainLoop = 0;
        Timer_Network = 1;
        Timer_Movement = 2;
        Timer_Maus = 3;
        Timer_ItemAnim = 4;
        Timer_Anim = 5;
        Timer_Effects = 6;
        Timer_DrawWorld = 7;
        Timer_DrawSpeech = 8;
        Timer_DrawGumps = 9;
        Timer_DrawCursor = 10;
        Timer_Garbage = 11;
        Timer_DrawWorldList = 12;
        Timer_Keyboard = 13;        
        Timer_Chars = 14;
        Timer_AllChars = 15;
        Timer_Items = 16;
        Timer_AllItems = 17;
        Timer_Statics = 18;
        Timer_AllStatics = 19;
        Timer_Map = 20;
        Timer_AllMap = 21;
        Timer_Renderer = 22;
        Timer_Renderer2 = 23;
        Timer_Renderer3 = 24;
        Timer_Renderer4 = 25;
        Timer_RendererCalc = 26;
        Timer_MausCheck = 27;
        Timer_Light = 28;
        Timer_SSU = 29;
        Timer_Frames = 30;
        Timer_SwapBuffers = 31;
        Timer_Draw = 32;
        Timer_Sort = 33;
        Timer_LoadMap = 34;
        Timer_Test = 35;
        Timer_Count = 36;

        TimerNames : Array[0..Timer_Count-1] of String = (
        'MainLoop', 'Network', 'Movement', 'Mouse', 'ItemAnims',
        'Anims', 'Effects', 'DrawWorld', 'DrawSpeech', 'DrawGumps',
        'DrawCursors', 'Garbage Collection', 'Draw WorldList', 'Keyboard', 'Chars',
        'All Chars', 'Items', 'All Items', 'Statics', 'All Statics',
        'Maptiles', 'All MapTiles', 'Renderer', 'Renderer2', 'Renderer3',
        'Renderer4', 'Renderer Calculations', 'MausCheck', 'Light', 'SSU',
        'Frames', 'SwapBuffers', 'Draw', 'Sort', 'LoadMap',
        'Test' );

type    TInternalTimer = Class
                private
                        Times : Array[0..Timer_Count-1] of LongWord;
                        ElapsedTime : Array[0..Timer_Count-1] of LongWord;
                        Counter : Array[0..Timer_Count-1] of LongWord;
                public
                        constructor Create;
                        destructor Free;
                        procedure Start( Typ : Word );
                        procedure Stop( Typ : Word );
                        procedure Pause( Typ : Word );
                        procedure Continue( Typ : Word );
                        procedure Reset( Typ : Word );
                        procedure ResetAll;
                        function GetMeanTime( Typ : Word ) : Real;
                        procedure Log;
        end;

var     Timer : TInternalTimer;

implementation

uses    uPalanthir;

constructor TInternalTimer.Create;
var     I : Integer;
begin
        for I := 0 to Timer_Count-1 do begin
                Times[ I ] := 0;
                ElapsedTime[ I ] := 0;
                Counter[ I ] := 0;
        end;
end;

destructor TInternalTimer.Free;
begin
end;

procedure TInternalTimer.Start( Typ : Word );
begin
        Times[ Typ ] := CustomGetTickCount;
end;

procedure TInternalTimer.Stop( Typ : Word );
begin
        if Times[ Typ ] > 0 then begin
                ElapsedTime[ Typ ] := ElapsedTime[ Typ ] + CustomGetTickCount - Times[ Typ ];
                Times[ Typ ] := 0;
        end;
        Inc( Counter[ Typ ] );
end;

procedure TInternalTimer.Pause( Typ : Word );
begin
        ElapsedTime[ Typ ] := ElapsedTime[ Typ ] + CustomGetTickCount - Times[ Typ ];
        Times[ Typ ] := 0;
end;

procedure TInternalTimer.Continue( Typ : Word );
begin
        Times[ Typ ] := CustomGetTickCount;
end;

procedure TInternalTimer.Reset( Typ : Word );
begin
        Times[ Typ ] := 0;
        Counter[ Typ ] := 0;
        ElapsedTime[ Typ ] := 0;
end;

procedure TInternalTimer.ResetAll;
var     I : Integer;
begin
        for I := 0 to Timer_Count-1 do
                Reset( I );
end;

function TInternalTimer.GetMeanTime( Typ : Word ) : Real;
begin
        if Counter[ Typ ] = 0 then
                Result := 0
        else
                Result := ElapsedTime[ Typ ] / Counter[ Typ ];
end;

procedure TInternalTimer.Log;
var     I : Integer;
begin
        uLog.Log.Write( Format( 'Position: %d,%d,%d', [Palanthir.Player.Pos.X,Palanthir.Player.Pos.Y,Palanthir.Player.Pos.Z] ) );
        uLog.Log.Write( Format( 'Frames: %d', [Trunc(Palanthir.FPS)] ) );
        uLog.Log.Write( Format( 'WorldListCount: %d', [Palanthir.GetWorldListCount] ) );
        uLog.Log.Write( 'Timer Results:' );
        for I := 0 to Timer_Count-1 do
                uLog.Log.Write( Format( '-%10s  %4.2f', [TimerNames[ I ],Timer.GetMeanTime( I )] ) );
end;

end.
