unit uTooltip;

interface

uses    uBasicDrawObject, uGumps, Classes, SysUtils, uUtilities, StrLib;

type    TTooltip = Class
                private
                        LastChange : LongWord;
                        Target : TBasicDrawObject;
                        Visible : Boolean;
                        X, Y : Integer;
                        Text : String;
                public
                        Gump : TGump;
                        constructor Create;
                        destructor Free;
                        procedure Draw;
                        procedure SetPos( X, Y : Integer );
                        procedure SetTarget( Target : TBasicDrawObject );
                        function GetTarget : TBasicDrawObject;
                        procedure FreeGump;
        end;

implementation

constructor TTooltip.Create;
begin
        LastChange := CustomGetTickCount;
        Target := nil;
        Visible := False;
        Gump := nil;
        Text := '';
end;

destructor TTooltip.Free;
begin
        FreeGump;
end;

procedure TTooltip.Draw;
var     List : TStringList;
        I : Integer;
        HtmlGump : THtmlGump;
        Back : TTiledImage;
        CheckerTrans : TCheckerTrans;
        MaxBreite : Integer;
        MaxHoehe : Integer;
        Breite, Hoehe : Word;
begin
        if (not Visible) or (Target = nil) then begin
                Exit;
        end;

        if (Text <> Target.Tooltip) then begin
                Text := Target.Tooltip;
                if Gump <> nil then begin
                        Gump.Free;
                        Gump := nil;
                end;
        end;

        if Text = '' then begin
                Exit;
        end;

        if Gump = nil then begin
                List := TStringList.Create;
                StrLib.Split( Text, #10, List );

                Gump := TGump.Create;
                Back := Gump.AddTiledImage( 0, 0, 10, 10, $A40, $3BB, 0 );
                CheckerTrans := Gump.AddCheckerTrans( 0, 0, 10, 10, 0 );

                MaxBreite := 0;
                MaxHoehe := 5;
                for I := 0 to List.Count-1 do begin
                        HtmlGump := Gump.AddHtmlGump( 10, MaxHoehe, List.Strings[ I ], 300, 100, False, False, 0 );
                        if HtmlGump.GetTextureBreite > MaxBreite then
                                MaxBreite := HtmlGump.GetTextureBreite;
                        MaxHoehe := MaxHoehe + HtmlGump.GetTextureHoehe + 5;
                end;

                for I := 0 to List.Count-1 do begin
                        HtmlGump := THtmlGump( Gump.GetObject( I+2 ) );
                        HtmlGump.X := (MaxBreite - HtmlGump.GetTextureBreite) div 2; 
                end;

                Breite := (MaxBreite div 2)*2 + 11;
                Hoehe := (MaxHoehe div 2)*2 + 1;

                Back.Breite := Breite;
                Back.Hoehe := Hoehe;

                CheckerTrans.Resize( Breite, Hoehe );

                Gump.Breite := Breite;
                Gump.Hoehe := Hoehe;

                List.Free;
        end;

        Gump.X := X - Gump.Breite;
        Gump.Y := Y - Gump.Hoehe;
        
        Gump.Draw;
end;

procedure TTooltip.SetPos( X, Y : Integer );
begin
        Self.X := X;
        Self.Y := Y;
end;

procedure TTooltip.SetTarget( Target : TBasicDrawObject );
begin
        if Self.Target = Target then begin
                if (not Visible) and (CustomGetTickCount - LastChange > 1000) then begin
                        Visible := True;
                end;
        end
        else begin
                Visible := False;
                LastChange := CustomGetTickCount;
                Self.Target := Target;
        end;
end;

function TTooltip.GetTarget : TBasicDrawObject;
begin
        Result := Target;
end;

procedure TTooltip.FreeGump;
begin
        if Gump <> nil then begin
                Gump.Free;
                Gump := nil;
        end;
end;

end.
