unit uUObject;

interface

uses    uBasicTypedefs, Classes, uPos, Dialogs, SysUtils, uSendPackets,
        uTexCache, uRenderer, uUtilities;

const   PrioList : Array[0..8,1..24] of Byte = (
                ( 21, 22, 03, 02, 01, 20, 11, 06, 07, 14, 15, 17, 05, 08, 09, 18, 13, 19, 10, 23, 24, 16, 12, 04 ),
                ( 21, 23, 03, 02, 01, 20, 11, 06, 07, 14, 15, 17, 05, 08, 09, 18, 13, 19, 10, 22, 24, 16, 12, 04 ),
                ( 21, 23, 03, 02, 01, 20, 11, 06, 07, 14, 15, 17, 05, 08, 09, 18, 13, 19, 10, 22, 24, 16, 12, 04 ),
                ( 22, 23, 04, 03, 02, 21, 12, 07, 08, 15, 16, 18, 06, 09, 10, 19, 14, 20, 11, 01, 24, 17, 13, 05 ),
                ( 21, 23, 03, 02, 01, 20, 11, 06, 07, 14, 15, 17, 05, 08, 09, 18, 13, 19, 10, 22, 24, 16, 12, 04 ),
                ( 21, 23, 03, 02, 01, 20, 11, 06, 07, 14, 15, 17, 05, 08, 09, 18, 13, 19, 10, 22, 24, 16, 12, 04 ),
                ( 21, 22, 03, 02, 01, 20, 11, 06, 07, 14, 15, 17, 05, 08, 09, 18, 13, 19, 10, 23, 24, 16, 12, 04 ),
                ( 21, 22, 03, 02, 01, 20, 11, 06, 07, 14, 15, 17, 05, 08, 09, 18, 13, 19, 10, 23, 24, 16, 12, 04 ),
                ( 22, 23, 04, 03, 02, 21, 13, 09, 10, 15, 16, 17, 07, 11, 12, 19, 08, 20, 06, 01, 24, 17, 14, 05 )                
                );

type    TUObject = Class( TUODrawObject )
                public
                        Serial : LongWord;
                        Registered : Boolean;
                        Direction : Byte;
                        Container : TUObject;
                        Content : TList;
                        PersonalLightLevel : Byte;
                        LastUpdated : LongWord;
                        constructor Create; override;
                        destructor Free; override;
                        function IsUObject : Boolean; override;
                        procedure RegisterObject;
                        procedure UnRegisterObject;
                        procedure RemoveObjectFromCont( UObject : TUObject ); virtual;
                        procedure OnClick; override;
                        procedure OnDblClick; override;
                        procedure RemoveContent;
                        procedure SortContainer;
        end;

implementation

uses    uPalanthir, uWorldCache, uItem, uChar;

constructor TUObject.Create;
begin
        inherited Create;
        PersonalLightLevel := 1;
        Registered := False;
        Content := TList.Create;
        Container := nil;
        LastUpdated := CustomGetTickCount;
end;

destructor TUObject.Free;
begin
        RemoveContent;
        if Container <> nil then
                Container.RemoveObjectFromCont( Self );
        UnRegisterObject;
        Container := nil;
        Content.Free;
        inherited Free;
end;

function TUObject.IsUObject : Boolean;
begin
        Result := True;
end;

procedure TUObject.RegisterObject;
var     Block : TWorldBlock;
begin
        if Container = nil then begin
                Block := Palanthir.Data.WorldCache.GetObject( BlockID );
                Block.ObjectListe.AddObject( Self );
                if Block.Visible then
                        Palanthir.AddWorldItem( Self );
        end;
        Palanthir.Data.GlobalObjectList.AddObject( Self );
        Registered := True;
end;

procedure TUObject.UnRegisterObject;
var     Block : TWorldBlock;
begin
        if Container = nil then begin
                Block := Palanthir.Data.WorldCache.GetObject( BlockID );
                if Block.Visible then
                        Palanthir.RemoveWorldItem( Self );
                Block.ObjectListe.DeleteObject( Self );
        end
        else begin
                if Light <> nil then
                        Palanthir.LightManager.RemoveLight( Light );
        end;
        Palanthir.Data.GlobalObjectList.DeleteObject( Self );
        Registered := False;
end;

procedure TUObject.RemoveObjectFromCont( UObject : TUObject );
var     I : Integer;
begin
        if Content.Count > 0 then
                for I := Content.Count-1 downto 0 do
                        if UObject = Content.Items[ I ] then begin
                                Content.Delete( I );
                                break;
                        end;

        if IsItem and UObject.IsItem then begin
                Palanthir.ScriptManager.OnRemoveItemFromCont( TItem( Self ), TItem( UObject ) );
        end
        else if IsChar and UObject.IsItem then begin
                Palanthir.ScriptManager.OnRemoveItemFromChar( TChar( Self ), TItem( UObject ) );
        end;
end;

procedure TUObject.OnClick;
var     SendSingleClick : TSendSingleClick;
begin
        if not Palanthir.ScriptManager.OnClick( Self ) then begin
                SendSingleClick := TSendSingleClick.Create;
                SendSingleClick.SetSerial( Serial );
                Palanthir.NetClient.Send( SendSingleClick );
        end;
end;

procedure TUObject.OnDblClick;
var     SendDoubleClick : TSendDoubleClick;
        SendAttack : TSendAttack;
begin
        if IsChar and Palanthir.Player.WarMode and (not IsPlayer) then begin
                SendAttack := TSendAttack.Create;
                SendAttack.SetAttackTarget( Serial );
                Palanthir.NetClient.Send( SendAttack );
        end
        else begin
                SendDoubleClick := TSendDoubleClick.Create;
                SendDoubleClick.SetSerial( Serial );
                Palanthir.NetClient.Send( SendDoubleClick );
        end;
end;

procedure TUObject.RemoveContent;
var     I : Integer;
begin
        for I := Content.Count-1 downto 0 do
                TItem( Content.Items[ I ] ).Free;
        Content.Clear;
end;

procedure TUObject.SortContainer;
        function SortItems( Object1, Object2 : Pointer ) : Integer;
        var     Item1, Item2 : TItem;
                Value1, Value2 : Byte;
                Dir : ShortInt;
        begin
                if Object1 = Object2 then begin
                        Result := 0;
                        exit;
                end;

                Dir := TItem( Object1 ).Container.Direction;
                if Dir < 0 then
                        Dir := Dir + 128;
                Dir := Dir mod 8;

                Item1 := TItem( Object1 );
                if (Item1.Layer >= 1) and (Item1.Layer <= 24) then
                        Value1 := PrioList[ Dir ][ Item1.Layer ]
                else
                        Value1 := Item1.Layer;

                Item2 := TItem( Object2 );
                if (Item2.Layer >= 1) and (Item2.Layer <= 24) then
                        Value2 := PrioList[ Dir ][ Item2.Layer ]
                else
                        Value2 := Item2.Layer;


                if Value1 > Value2 then
                        Result := 1
                else if Value1 < Value2 then
                        Result := -1
                else
                        Result := 0;
        end;
begin
        Content.Sort( @SortItems );
end;

end.
