unit uUtilities;

interface

uses    Math, ShellApi, Windows, Clipbrd, NB30, Classes, SysUtils, Dialogs,
        DCPRijndael, SDL;

type    TIndexRecord = packed record
                case Integer of
                        0: ( Offset, Length, Extra : Integer );
                        1: ( B : array [0..11] of Byte );
                end;

function Color15toBlue( Zahl : Word ) : Byte;
function Color15toGreen( Zahl : Word ) : Byte;
function Color15toRed( Zahl : Word ) : Byte;
function GetNextBit( Zahl : LongWord ) : LongWord;
function DelDir( Dir: string ): Boolean;
function RenameDir( OldDir, NewDir: string ): Boolean;
function CustomGetTickCount : LongWord;
function GetMapHoehe : Word;
function GetMapBreite : Word;
function IsInRect( X, Y, X1, Y1, X2, Y2 : Integer ) : Boolean;
procedure OpenProg( Parameter : String );
function GetPasteString : WideString;
procedure SetPasteString( Text : WideString );
function GetMacAddress : String;
function DecryptPassword( Pass : String ) : String;
function EncryptPassword( Pass : String ) : String;
function SwapBytes( Input : LongWord ) : LongWord;

implementation

uses    uPalanthir;

function Color15toBlue( Zahl : Word ) : Byte;
begin
        Result := ( Zahl and $1F ) * 8;
end;

function Color15toGreen( Zahl : Word ) : Byte;
begin
        Result := ( ( Zahl shr 5 ) and $1F ) * 8;
end;

function Color15toRed( Zahl : Word ) : Byte;
begin
        Result := ( ( Zahl shr 10 ) and $1F ) * 8;
end;

function GetNextBit( Zahl : LongWord ) : LongWord;
begin
        Result := Ceil( ln( Zahl ) / ln( 2 ) );
        Result := Round( exp( Result*ln( 2 ) ) );
end;

function DelDir( Dir: string ): Boolean;
{$IFDEF WIN32}
var     Fos: TSHFileOpStruct;
{$ENDIF}
begin
        Result := False;
        {$IFDEF WIN32}
        FillChar( Fos, SizeOf(TSHFileOpStruct), 0);
        with Fos do begin
                wFunc := FO_DELETE;
                fFlags := FOF_SILENT or FOF_NOCONFIRMATION;
                pFrom := PChar( Dir + #0 );
        end;
        Result := ( 0 = ShFileOperation( Fos ) );
        {$ENDIF}
end;

function RenameDir( OldDir, NewDir: string ) : Boolean;
{$IFDEF WIN32}
var     Fos: TSHFileOpStruct;
{$ENDIF}
begin
        Result := False;
        {$IFDEF WIN32}
        FillChar( Fos, SizeOf(TSHFileOpStruct), 0);
        with Fos do begin
                wFunc := FO_RENAME;
                fFlags := FOF_SILENT or FOF_NOCONFIRMATION;
                pFrom := PChar( OldDir + #0 );
                pTo := PChar( NewDir + #0 );
        end;
        Result := ( 0 = ShFileOperation( Fos ) );
        {$ENDIF}
end;

function CustomGetTickCount : LongWord;
begin
        {$IFDEF WIN32}
        Result := GetTickCount;
        {$ELSE}
        Result := SDL_GetTicks;
        {$ENDIF}
end;

function GetMapHoehe : Word;
begin
        Result := Palanthir.Data.GetMapHoehe;
end;

function GetMapBreite : Word;
begin
        Result := Palanthir.Data.GetMapBreite;
end;

function IsInRect( X, Y, X1, Y1, X2, Y2 : Integer ) : Boolean;
begin
        if ( X >= X1 ) and ( Y >= Y1 ) and ( X <= X2 ) and ( Y <= Y2 ) then
                Result := True
        else
                Result := False;
end;

procedure OpenProg( Parameter : String );
begin
        {$IFDEF WIN32}
        ShellExecute( 0, 'open', PChar( Parameter ) , nil, nil, SW_SHOWNORMAL );
        {$ENDIF}
end;

function GetPasteString : WideString;
begin
        Result := '';
        {$IFDEF WIN32}
        Result := Clipboard.AsText;
        {$ENDIF}
end;

procedure SetPasteString( Text : WideString );
begin
        {$IFDEF WIN32}
        Clipboard.AsText := Text;
        {$ENDIF}
end;

function GetMacAddress : String;
var     NCB : PNCB;
        RetCode : Char;
        Adapter : PAdapterStatus;
        I : Integer;
        Lenum : PlanaEnum;
        _SystemID : String;
begin
        Result := '00-00-00-00-00-00';

        {$IFDEF WIN32}
        _SystemID := '00-00-00-00-00-00';
        Getmem( NCB, SizeOf( TNCB ) );
        Fillchar( NCB^, SizeOf( TNCB ), 0 );

        Getmem( Lenum, SizeOf( TLanaEnum ) );
        Fillchar( Lenum^, SizeOf( TLanaEnum ), 0);

        Getmem( Adapter, SizeOf( TAdapterStatus ) );
        Fillchar( Adapter^, SizeOf( TAdapterStatus ), 0 );

        Lenum.Length := Chr( 0 );
        NCB.ncb_command := Chr( NCBENUM );
        NCB.ncb_buffer := Pointer( Lenum );
        NCB.ncb_length := SizeOf( Lenum );

        I := 0;
        repeat
                Fillchar( NCB^, SizeOf( TNCB ), 0 );
                Ncb.ncb_command := chr( NCBRESET );
                Ncb.ncb_lana_num := lenum.lana[ I ];

                Fillchar( NCB^, SizeOf( TNCB ), 0 );
                Ncb.ncb_command  := Chr( NCBASTAT );
                Ncb.ncb_lana_num := lenum.lana[ I ];
                // Must be 16
                Ncb.ncb_callname := '*               ';

                Ncb.ncb_buffer := Pointer( Adapter );

                Ncb.ncb_length := SizeOf( TAdapterStatus );
                RetCode := Netbios( Ncb );
                //---- calc _systemId from mac-address[2-5] XOR mac-address[1]...
                if (RetCode = chr(0)) or (RetCode = chr(6)) then begin
                        _SystemId := IntToHex( Ord( Adapter.adapter_address[ 0 ] ), 2 ) + '-' +
                                     IntToHex( Ord( Adapter.adapter_address[ 1 ] ), 2 ) + '-' +
                                     IntToHex( Ord( Adapter.adapter_address[ 2 ] ), 2 ) + '-' +
                                     IntToHex( Ord( Adapter.adapter_address[ 3 ] ), 2 ) + '-' +
                                     IntToHex( Ord( Adapter.adapter_address[ 4 ] ), 2 ) + '-' +
                                     IntToHex( Ord( Adapter.adapter_address[ 5 ] ), 2 );
                end;
                Inc( I );
        until (I >= Ord(Lenum.Length)) or (_SystemID <> '00-00-00-00-00-00');

        FreeMem( NCB );
        FreeMem( Adapter );
        FreeMem( Lenum );
        Result := _SystemID;
        {$ENDIF}
end;

function EncryptPassword( Pass : String ) : String;
var     Crypt : TDCP_Rijndael;
        Key : Array[0..15] of Byte;
        InitVektor : PByteArray;
        I : Integer;
begin
        Key[0] := $E2;
        Key[1] := $F3;
        Key[2] := $AA;
        Key[3] := $69;
        Key[4] := $B2;
        Key[5] := $79;
        Key[6] := $3B;
        Key[7] := $29;
        Key[8] := $C2;
        Key[9] := $C1;
        Key[10] := $54;
        Key[11] := $E7;
        Key[12] := $FB;
        Key[13] := $23;
        Key[14] := $38;
        Key[15] := $48;

        Crypt := TDCP_Rijndael.Create( nil );

        GetMem( InitVektor, 16 );
        for I := 0 to 15 do
                InitVektor^[I] := 0;
        
        Crypt.Init( Key, 128, InitVektor );
        FreeMem( InitVektor );

        Result := Crypt.EncryptString( Pass );

        Crypt.Free;
end;

function DecryptPassword( Pass : String ) : String;
var     Crypt : TDCP_Rijndael;
        Key : Array[0..15] of Byte;
        InitVektor : PByteArray;
        I : Integer;        
begin
        Key[0] := $E2;
        Key[1] := $F3;
        Key[2] := $AA;
        Key[3] := $69;
        Key[4] := $B2;
        Key[5] := $79;
        Key[6] := $3B;
        Key[7] := $29;
        Key[8] := $C2;
        Key[9] := $C1;
        Key[10] := $54;
        Key[11] := $E7;
        Key[12] := $FB;
        Key[13] := $23;
        Key[14] := $38;
        Key[15] := $48;

        Crypt := TDCP_Rijndael.Create( nil );

        GetMem( InitVektor, 16 );
        for I := 0 to 15 do
                InitVektor^[I] := 0;
        
        Crypt.Init( Key, 128, InitVektor );
        FreeMem( InitVektor );

        Result := Crypt.DecryptString( Pass );

        Crypt.Free;
end;

function SwapBytes( Input : LongWord ) : LongWord;
begin
        Result := (Input and $FF000000) shr 24 + (Input and $00FF0000) shr 8 +
                  (Input and $0000FF00) shl 8 + (Input and $000000FF) shl 24;
end;

end.
