unit uVector;

interface

uses    uCounter;

type    TVector = Class
                public
                        X, Y, Z : Real;
                        constructor Create( X, Y, Z : Real ); overload;
                        constructor Create( Vector : TVector ); overload;
                        destructor Free;
                        procedure SetTo( X, Y, Z : Real ); overload;
                        procedure SetTo( Vector : TVector ); overload;
                        procedure Add( Vector : TVector );
                        procedure Multiply( Factor : Real );
                        procedure Kreutzproduct( Vector : TVector );
                        function Skalarproduct( Vector : TVector ) : Real;
                        procedure Normalize;
        end;

implementation

constructor TVector.Create( X, Y, Z : Real );
begin
        Self.X := X;
        Self.Y := Y;
        Self.Z := Z;

        Counter.IncCount( Count_Vector );
end;

constructor TVector.Create( Vector : TVector );
begin
        X := Vector.X;
        Y := Vector.Y;
        Z := Vector.Z;

        Counter.IncCount( Count_Vector );
end;

destructor TVector.Free;
begin
        Counter.DecCount( Count_Vector );
end;

procedure TVector.SetTo( X, Y, Z : Real );
begin
        Self.X := X;
        Self.Y := Y;
        Self.Z := Z;
end;

procedure TVector.SetTo( Vector : TVector );
begin
        X := Vector.X;
        Y := Vector.Y;
        Z := Vector.Z;
end;

procedure TVector.Add( Vector : TVector );
begin
        X := X + Vector.X;
        Y := Y + Vector.Y;
        Z := Z + Vector.Z;
end;

procedure TVector.Multiply( Factor : Real );
begin
        X := Factor*X;
        Y := Factor*Y;
        Z := Factor*Z;
end;

procedure TVector.Kreutzproduct( Vector : TVector );
var     NewX, NewY, NewZ : Real;
begin
        NewX := Y*Vector.Z - Z*Vector.Y;
        NewY := Z*Vector.X - X*Vector.Z;
        NewZ := X*Vector.Y - Y*Vector.X;

        X := NewX;
        Y := NewY;
        Z := NewZ;
end;

function TVector.Skalarproduct( Vector : TVector ) : Real;
begin
        Result := X*Vector.X + Y*Vector.Y + Z*Vector.Z;
end;

procedure TVector.Normalize;
var     Factor : Real;
begin
        if ( X = 0 ) and ( Y = 0 ) and ( Z = 0 ) then begin
                exit;
        end;

        Factor := sqrt( X*X + Y*Y + Z*Z );

        X := X / Factor;
        Y := Y / Factor;
        Z := Z / Factor;
end;

end.
