unit uVertexCache;

//Diese Ganze Unit ist noch voll verbuggt und wurde deshalb
//erstmal auf spter verschoben...

interface

uses    Classes, SysUtils, dglOpenGL;

type    TVertex = Record
                TexCoordX, TexCoordY : Real;
                PosX, PosY : Real;
                Red, Green, Blue, Alpha : Real;
        end;

        TVertexArray = Array[0..1] of TVertex;
        PVertexArray = ^TVertexArray;

        TVertexCache = Class
                private
                        Cache : PVertexArray;
                        TexturenCache : PIntegerArray;
                        Count : Integer;
                        MaxCount : Integer;
                public
                        constructor Create;
                        destructor Free;
                        procedure Init;
                        procedure Resize;
                        procedure AddTexture( Vertex1, Vertex2, Vertex3, Vertex4 : TVertex; Texture : Integer );
                        procedure Draw;
        end;

implementation

constructor TVertexCache.Create;
begin
        Cache := nil;
        TexturenCache := nil;
        glEnableClientState( GL_VERTEX_ARRAY );
        glEnableClientState( GL_TEXTURE_COORD_ARRAY );
        glEnableClientState( GL_COLOR_ARRAY );
end;

destructor TVertexCache.Free;
begin
        if Cache <> nil then
                FreeMem( Cache );

        if TexturenCache <> nil then
                FreeMem( TexturenCache );
end;

procedure TVertexCache.Init;
begin
        if Cache <> nil then
                FreeMem( Cache );

        if TexturenCache <> nil then
                FreeMem( TexturenCache );
        Count := 0;
        MaxCount := 200;
        GetMem( Cache, 4*MaxCount*SizeOf( TVertex ) );
        GetMem( TexturenCache, MaxCount*SizeOf( Integer ) );

        glVertexPointer( 2, GL_FLOAT, SizeOf( TVertex ), @Cache^[ 0 ].PosX );
        glTexCoordPointer( 2, GL_FLOAT, SizeOf( TVertex ), @Cache^[ 0 ].TexCoordX );
        glColorPointer( 4, GL_FLOAT, SizeOf( TVertex ), @Cache^[ 0 ].Red );
end;

procedure TVertexCache.Resize;
var     Temp : PVertexArray;
        TexTemp : PIntegerArray;
begin
        GetMem( Temp, 4*(MaxCount + 200)*SizeOf( TVertex ) );
        GetMem( TexTemp, (MaxCount + 200)*SizeOf( Integer ) );

        Move( Cache^[ 0 ], Temp^[ 0 ], 4*MaxCount );
        Move( TexturenCache^[ 0 ], TexTemp^[ 0 ], MaxCount );

        FreeMem( Cache );
        FreeMem( TexturenCache );
        GetMem( Cache, 4*(MaxCount + 200)*SizeOf( TVertex ) );
        GetMem( TexturenCache, (MaxCount + 200)*SizeOf( Integer ) );
        Move( Temp^[ 0 ], Cache^[ 0 ], 4*MaxCount );
        Move( TexTemp^[ 0 ], TexturenCache^[ 0 ], MaxCount );

        MaxCount := MaxCount + 200;
        FreeMem( Temp );
        FreeMem( TexTemp );

        glVertexPointer( 2, GL_FLOAT, SizeOf( TVertex ), @Cache^[ 0 ].PosX );
        glTexCoordPointer( 2, GL_FLOAT, SizeOf( TVertex ), @Cache^[ 0 ].TexCoordX );
        glColorPointer( 4, GL_FLOAT, SizeOf( TVertex ), @Cache^[ 0 ].Red );
end;

procedure TVertexCache.AddTexture( Vertex1, Vertex2, Vertex3, Vertex4 : TVertex; Texture : Integer );
begin
        while Count >= MaxCount do
                Resize;

        Cache^[ Count*4 ] := Vertex1;
        Cache^[ Count*4+1 ] := Vertex2;
        Cache^[ Count*4+2 ] := Vertex3;
        Cache^[ Count*4+3 ] := Vertex4;
        TexturenCache^[ Count ] := Texture;

        Inc( Count );
end;

procedure TVertexCache.Draw;
var     I : Integer;
        ActTex : Integer;
begin
        if Count = 0 then
                exit;

        ActTex := -1;
        for I := 0 to Count-1 do begin
                if TexturenCache^[ I ] <> ActTex then begin
                        ActTex := TexturenCache^[ I ];
                        glBindTexture( GL_TEXTURE_2D, ActTex );
                end;
                glDrawArrays( GL_QUADS, I*4, 4 );
        end;
end;

end.
