unit uPyChar;

interface

uses    Python, uChar, uItem, SysUtils, uPyUtilities, uPyItem, uUObject, uPlayer;

{
        \object char
        \description Represents a char object.
}

type    TpyChar = Record
                ob_refcnt : Integer;
		ob_type : PPyTypeObject;
                CharSerial : LongWord;
        end;

        PpyChar = ^TpyChar;

function pyChar_Str( Self : PPyObject ) : PPyObject; cdecl;
procedure pyChar_Dealloc( Self : PPyObject ); cdecl;
function pyChar_getAttr( Self : PPyObject; Name : PChar ) : PPyObject; cdecl;
function pyChar_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer; cdecl;
function pyChar_compare( Char1, Char2 : PPyObject ) : Integer; cdecl;
function pyChar_getChar( Self : PPyObject ) : TChar; cdecl;
function pyChar_check( Self : PPyObject ) : Boolean;
function pyGetChar( Char : TChar ) : PPyObject; cdecl;
function pyConvertChar( PyObject : PPyObject; Char : P_Char ) : Integer; cdecl;

function pyChar_delete( Self : PPyObject; Args : PPyObject ) : PPyObject; cdecl;
function pyChar_moveto( Self : PPyObject; Args : PPyObject ) : PPyObject; cdecl;
function pyChar_additem( Self : PPyObject; Args : PPyObject ) : PPyObject; cdecl;
function pyChar_isArmed( Self : PPyObject; Args : PPyObject ) : PPyObject; cdecl;
function pyChar_onMount( Self : PPyObject; Args : PPyObject ) : PPyObject; cdecl;
function pyChar_getItemOnLayer( Self : PPyObject; Args : PPyObject ) : PPyObject; cdecl;

const pyCharType : PyTypeObject = (
		ob_refcnt : 0;
		ob_type : nil;
		ob_size : 0;
		tp_name : 'pyChar';
		tp_basicsize : sizeof( pyCharType );
                tp_itemsize : 0;

		tp_dealloc : pyChar_Dealloc;
		tp_print : nil;
		tp_getattr : pyChar_getAttr;
		tp_setattr : pyChar_setAttr;
		tp_compare : pyChar_compare;
		tp_repr : nil;

		tp_as_number : nil;
		tp_as_sequence : nil;
		tp_as_mapping : nil;

		tp_hash : nil;
		tp_call : nil;
		tp_str : pyChar_Str;
		tp_getattro : nil;
		tp_setattro : nil;

		tp_as_buffer : nil;
		tp_flags : 0;
		tp_doc : nil;

		tp_traverse : nil;

		tp_clear : nil;
		tp_richcompare : nil;

		tp_weaklistoffset : 0;

		tp_iter : nil;
		tp_iternext : nil;

		tp_methods : nil;
		tp_members : nil;
		tp_getset : nil;
		tp_base : nil;
		tp_dict : nil;
		tp_descr_get : nil;
		tp_descr_set : nil;
		tp_dictoffset : 0;
		tp_init : nil;
		tp_alloc : nil;
		tp_new : nil;
		tp_free : nil;
		tp_is_gc : nil;
		tp_bases : nil;
		tp_mro : nil;
		tp_cache : nil;
		tp_subclasses : nil;
		tp_weaklist : nil;
        );

        pyCharMethods : Array[0..6] of PyMethodDef =
                ( ( ml_name : 'delete'; ml_meth : pyChar_delete; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'additem'; ml_meth : pyChar_additem; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'moveto'; ml_meth : pyChar_moveto; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'isarmed'; ml_meth : pyChar_isArmed; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'onmount'; ml_meth : pyChar_onMount; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getitemonlayer'; ml_meth : pyChar_getItemOnLayer; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

implementation

uses    uPalanthir;

function pyChar_Str( Self : PPyObject ) : PPyObject;
var     Char : TChar;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnNone;
                Exit;
        end;

        Char := pyChar_getChar( Self );

        if Char <> nil then
                Result := PyString_FromString( PChar( Format( '0x%x', [Char.Serial] ) ) )
        else
                Result := PyReturnNone;
end;

procedure pyChar_Dealloc( Self : PPyObject );
begin
        PyDealloc( Self );
end;

function pyChar_getAttr( Self : PPyObject; Name : PChar ) : PPyObject;
var     Char : TChar;
        TestName : String;
        I : Integer;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Char := pyChar_getChar( Self );

        if Char = nil then begin
                Result := PyReturnFalse;
                Exit;
        end;

        TestName := LowerCase( Name );

        {
                \property char.name Name
        }
        if TestName = 'name' then begin
                Result := PyString_FromString( PChar( Char.Name ) );
        end
        {
                \property char.title Title
        }
        else if TestName = 'title' then begin
                Result := PyString_FromString( PChar( Char.Title ) );
        end
        {
                \property char.id Id
        }
        else if TestName = 'id' then begin
                Result := PyInt_FromLong( Char.ID );
        end
        {
                \property char.color Skin
        }
        else if TestName = 'color' then begin
                Result := PyInt_FromLong( Char.Color );
        end
        {
                \property char.x X
        }
        else if TestName = 'x' then begin
                Result := PyInt_FromLong( Char.Pos.X );
        end
        {
                \property char.y Y
        }
        else if TestName = 'y' then begin
                Result := PyInt_FromLong( Char.Pos.Y );
        end
        {
                \property char.z Z
        }
        else if TestName = 'z' then begin
                Result := PyInt_FromLong( Char.Pos.Z );
        end
        {
                \property char.map Map
        }
        else if TestName = 'map' then begin
                Result := PyInt_FromLong( Char.Pos.Map );
        end
        {
                \property char.ischar IsChar
        }
        else if TestName = 'ischar' then begin
                Result := pyInt_FromLong( 1 );
        end
        {
                \property char.ismap IsMap
        }
        {
                \property char.isstatic IsStatic
        }
        {
                \property char.isitem IsItem
        }
        {
                \property char.iseffect IsEffect
        }
        {
                \property char.ismultiitem IsMultiItem
        }
        else if (TestName = 'ismap') or (TestName = 'isstatic') or (TestName = 'isitem') or
                (TestName = 'iseffect') or (TestName = 'ismultiitem') then begin
                Result := pyInt_FromLong( 0 );
        end
        {
                \property char.isplayer IsPlayer
        }
        else if TestName = 'isplayer' then begin
                if Char = Palanthir.Player then
                        Result := pyInt_FromLong( 1 )
                else
                        Result := pyInt_FromLong( 0 );
        end
        {
                \property char.saycolor Saycolor
        }
        else if TestName = 'saycolor' then begin
                Result := PyInt_FromLong( Char.SayColor );
        end
        {
                \property char.emotecolor Emotecolor
        }
        else if TestName = 'emotecolor' then begin
                Result := PyInt_FromLong( Char.EmoteColor );
        end
        {
                \property char.serial Serial
        }
        else if TestName = 'serial' then begin
                Result := PyInt_FromLong( Char.Serial );
        end
        {
                \property char.warmode Warmode
        }
        else if TestName = 'warmode' then begin
                if Char.WarMode then begin
                        Result := PyInt_FromLong( 1 );
                end else begin
                        Result := PyInt_FromLong( 0 );
                end;
        end
        {
                \property char.content A list of <object id="item">item</object> objects of the items that are in this container.
        }
        else if Testname = 'content' then begin
                Result := PyTuple_New( Char.Content.Count );
                for I := 0 to Char.Content.Count-1 do begin
                        PyTuple_SetItem( Result, I, PyGetItem( TItem( Char.Content.Items[ I ] ) ) );
                end;
        end
        {
                \property char.customvars A dictionary to save variables on the item. (see cv)
        }
        {
                \property char.cv A dictionary to save variables on the item. (see customvars)
        }
        else if (TestName = 'customvars') or (TestName = 'cv') then begin
                if Char.CustomVars = nil then begin
                        Char.CustomVars := PyDict_New;
                end;

                Py_INCREF( Char.CustomVars );
                Result := Char.CustomVars;
        end
        else begin
                Result := Py_FindMethod( @pyCharMethods, Self, PChar( TestName ) );
        end;
end;

function pyChar_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer;
var     Char : TChar;
        TestName : String;
begin
        if not pyChar_check( Self ) then begin
                Result := 1;
                Exit;
        end;

        Char := pyChar_getChar( Self );

        if Char = nil then begin
                Result := 1;
                Exit;
        end;

        TestName := LowerCase( Name );

        if TestName = 'name' then begin
                if PyString_Check( Value ) then begin
                        Char.Name := PyString_AsString( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'title' then begin
                if PyString_Check( Value ) then begin
                        Char.Title := PyString_AsString( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'id' then begin
                if PyInt_Check( Value ) then begin
                        Char.ID := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'color' then begin
                if PyInt_Check( Value ) then begin
                        Char.Color := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'saycolor' then begin
                if PyInt_Check( Value ) then begin
                        Char.SayColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'emotecolor' then begin
                if PyInt_Check( Value ) then begin
                        Char.EmoteColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'serial' then begin
                if PyInt_Check( Value ) then begin
                        Char.UnRegisterObject;
                        Char.Serial := PyInt_AsLong( Value );
                        Char.RegisterObject;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'warmode' then begin
                if Char.IsPlayer and PyInt_Check( Value ) then begin
                        TPlayer( Char ).SendChangeWarModeRequest( PyInt_AsLong( Value ) = 1 );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end;
end;


function pyChar_compare( Char1, Char2 : PPyObject ) : Integer;
var     Char_1, Char_2 : TChar;
begin
        if (not pyChar_check( Char1 )) or (not pyChar_check( Char2 )) then begin
                Result := -1;
                Exit;
        end;

        Char_1 := pyChar_getChar( Char1 );
        Char_2 := pyChar_getChar( Char2 );

        if (Char_1 = nil) or (Char_2 = nil) then begin
                Result := -1;
                Exit;
        end;

        if Char_1.Serial = Char_2.Serial then
                Result := 0
        else
                Result := -1;
end;

function pyChar_getChar( Self : PPyObject ) : TChar;
var     UObject : TUObject;
begin
        if not pyChar_check( Self ) then begin
                Result := nil;
                Exit;
        end;

        UObject := Palanthir.Data.GlobalObjectList.GetObject( PpyChar( Self ).CharSerial );
        if (UObject <> nil) and UObject.IsChar then
                Result := TChar( UObject )
        else
                Result := nil;
end;

function pyChar_check( Self : PPyObject ) : Boolean;
begin
        Result := Self.ob_type = @pyCharType;
end;

function pyGetChar( Char : TChar ) : PPyObject;
var     PyChar : PpyChar;
begin
        PyChar := PpyChar( PyObject_new( @pyCharType ) );
        PyChar.CharSerial := Char.Serial;
        Result := PPyObject( PyChar );
end;

function pyConvertChar( PyObject : PPyObject; Char : P_Char ) : Integer;
begin
        if not pyChar_check( PyObject ) then begin
                PyErr_BadArgument;
                Result := 0;
                Exit;
        end;

        Char^ := pyChar_getChar( pyObject );
        Result := 1;
end;

{
        \method char.delete
        \description Deletes the char.
}
function pyChar_delete( Self : PPyObject; Args : PPyObject ) : PPyObject;
var     Char : TChar;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Char := pyChar_getChar( Self );
        Char.Free;

        Result := PyReturnTrue;
end;

{
        \method char.moveto
        \param x
        \param y
        \param z
        \param map (optional, default = currentmap)
        \description Moves the item to (x, y, z, map)
}
function pyChar_moveto( Self : PPyObject; Args : PPyObject ) : PPyObject;
var     Char : TChar;
        X, Y, Z : Integer;
        Map : Byte;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Char := pyChar_getChar( Self );

        Map := Palanthir.CurrentMap;
        if PyArg_ParseTuple( Args, 'iii|b:char.moveto( x, y, z, [map] )', [@X,@Y,@Z,@Map] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Char.MoveTo( X, Y, Z );
        Char.Pos.Map := Map;

        Result := PyReturnTrue;
end;

{
        \method char.additem
        \param item An <object id="item">item</object> object
        \description Adds an item to a char.
}
function pyChar_additem( Self : PPyObject; Args : PPyObject ) : PPyObject;
var     Char : TChar;
        Item : TItem;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Char := pyChar_getChar( Self );

        if PyArg_ParseTuple( Args, 'O&|b:item.additem( item )', [@pyConvertItem,@Item] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        if Item = nil then
                Exit;

        if Item.Container <> nil then
                Item.RemoveFromCont;
        
        Item.UnRegisterObject;

        Item.Container := Char;
        Item.RegisterObject;

        Char.AddItem( Item );

        Result := PyReturnTrue;
end;

{
        \method char.isarmed
        \return Returns 1 if the char is armed, 0 otherwise.
}
function pyChar_isArmed( Self : PPyObject; Args : PPyObject ) : PPyObject;
var     Char : TChar;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Char := pyChar_getChar( Self );

        if Char.IsArmed then
                Result := PyInt_FromLong( 1 )
        else
                Result := PyInt_FromLong( 0 )
end;

{
        \method char.onmount
        \return Returns 1 if the char is mounted, 0 otherwise.
}
function pyChar_onMount( Self : PPyObject; Args : PPyObject ) : PPyObject;
var     Char : TChar;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Char := pyChar_getChar( Self );

        if Char.OnMount then
                Result := PyInt_FromLong( 1 )
        else
                Result := PyInt_FromLong( 0 )
end;

{
        \method char.getitemonlayer
        \param  layer
        \return The item on the given layer, or null.
}
function pyChar_getItemOnLayer( Self : PPyObject; Args : PPyObject ) : PPyObject;
var     Char : TChar;
        Layer : Byte;
begin
        if not pyChar_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        if PyArg_ParseTuple( Args, 'b:char.getitemonlayer( layer )', [@Layer] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Char := pyChar_getChar( Self );
        if Char.GetItemOnLayer( Layer ) <> nil then
                Result := PyGetItem( Char.GetItemOnLayer( Layer ) )
        else
                Result := PyReturnNone;
end;


end.
