unit uPyGumpObject;

interface

uses    uGumps, Python, uPyUtilities, SysUtils, Classes;

{
        \object gumpobject
        \description Represents a gumpobject object.
}

type    TpyGumpObject = Record
                ob_refcnt : Integer;
		ob_type : PPyTypeObject;
                Serial : LongWord;
        end;

        PpyGumpObject = ^TpyGumpObject;

function pyGumpObject_Str( Self : PPyObject ) : PPyObject; cdecl;
procedure pyGumpObject_Dealloc( Self : PPyObject ); cdecl;
function pyGumpObject_getAttr( Self : PPyObject; Name : PChar ) : PPyObject; cdecl;
function pyGumpObject_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer; cdecl;
function pyGumpObject_compare( GumpObject1, GumpObject2 : PPyObject ) : Integer; cdecl;
function pyGumpObject_getGumpObject( Self : PPyObject ) : TGumpObject;
function pyGumpObject_check( Self : PPyObject ) : Boolean;
function pyGetGumpObject( GumpObject : TGumpObject ) : PPyObject; cdecl;
function pyConvertGumpObject( PyObject : PPyObject; GumpObject : P_GumpObject ) : Integer; cdecl;

function pyGumpObject_ApplyHue( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyGumpObject_Draw( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyGumpObject_SendBack( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyGumpObject_SendFront( Self, Args : PPyObject ) : PPyObject; cdecl;

const pyGumpObjectType : PyTypeObject = (
		ob_refcnt : 0;
		ob_type : nil;
		ob_size : 0;
		tp_name : 'pyGumpObject';
		tp_basicsize : sizeof( pyGumpObjectType );
                tp_itemsize : 0;

		tp_dealloc : pyGumpObject_Dealloc;
		tp_print : nil;
		tp_getattr : pyGumpObject_getAttr;
		tp_setattr : pyGumpObject_setAttr;
		tp_compare : pyGumpObject_compare;
		tp_repr : nil;

		tp_as_number : nil;
		tp_as_sequence : nil;
		tp_as_mapping : nil;

		tp_hash : nil;
		tp_call : nil;
		tp_str : pyGumpObject_Str;
		tp_getattro : nil;
		tp_setattro : nil;

		tp_as_buffer : nil;
		tp_flags : 0;
		tp_doc : nil;

		tp_traverse : nil;

		tp_clear : nil;
		tp_richcompare : nil;

		tp_weaklistoffset : 0;

		tp_iter : nil;
		tp_iternext : nil;

		tp_methods : nil;
		tp_members : nil;
		tp_getset : nil;
		tp_base : nil;
		tp_dict : nil;
		tp_descr_get : nil;
		tp_descr_set : nil;
		tp_dictoffset : 0;
		tp_init : nil;
		tp_alloc : nil;
		tp_new : nil;
		tp_free : nil;
		tp_is_gc : nil;
		tp_bases : nil;
		tp_mro : nil;
		tp_cache : nil;
		tp_subclasses : nil;
		tp_weaklist : nil;
        );

        pyGumpObjectMethods : Array[0..4] of PyMethodDef =
                ( ( ml_name : 'applyhue'; ml_meth : pyGumpObject_ApplyHue; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'draw'; ml_meth : pyGumpObject_Draw; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'sendback'; ml_meth : pyGumpObject_SendBack; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'sendfront'; ml_meth : pyGumpObject_SendFront; ml_flags : METH_VARARGS; ml_doc : nil ),                  
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

implementation

uses    uPyGump, uPythonGump, uPalanthir;

function pyGumpObject_Str( Self : PPyObject ) : PPyObject;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyString_FromString( PChar( 'gumpobject' ) );        
end;

procedure pyGumpObject_Dealloc( Self : PPyObject );
begin
        PyDealloc( Self );
end;

function pyGumpObject_getAttr( Self : PPyObject; Name : PChar ) : PPyObject;
var     GumpObject : TGumpObject;
        TestName : String;
        Lines : TStringList;
        I : Integer;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        GumpObject := pyGumpObject_getGumpObject( Self );
        if GumpObject = nil then begin
                Result := PyReturnFalse;
                Exit;
        end;
        TestName := LowerCase( Name );

        {
                \property gumpobject.x X
        }
        if TestName = 'x' then begin
                Result := PyInt_FromLong( GumpObject.X );
        end
        {
                \property gumpobject.y Y
        }
        else if TestName = 'y' then begin
                Result := PyInt_FromLong( GumpObject.Y );
        end
        {
                \property gumpobject.page Page
        }
        else if TestName = 'page' then begin
                Result := PyInt_FromLong( GumpObject.Page );
        end
        {
                \property gumpobject.visible Visible
        }
        else if TestName = 'visible' then begin
                if GumpObject.Visible then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.gump <object id="gump">gump</object>
        }
        else if TestName = 'gump' then begin
                if (GumpObject.Gump = nil) or (GumpObject.Gump.Typ <> GumpTyp_PythonGump) then
                        Result := PyReturnNone
                else
                        Result := pyGetGump( TPythonGump( GumpObject.Gump ) );
        end
        {
                \property gumpobject.width width
        }
        else if TestName = 'width' then begin
                Result := PyInt_FromLong( GumpObject.GetBreite );
        end
        {
                \property gumpobject.height height
        }
        else if TestName = 'height' then begin
                Result := PyInt_FromLong( GumpObject.GetHoehe );
        end
        {
                \property char.customvars A dictionary to save variables on the item. (see cv)
        }
        {
                \property char.cv A dictionary to save variables on the item. (see customvars)
        }
        else if (TestName = 'customvars') or (TestName = 'cv') then begin
                if GumpObject.CustomVars = nil then begin
                        GumpObject.CustomVars := PyDict_New;
                end;

                Py_INCREF( GumpObject.CustomVars );
                Result := GumpObject.CustomVars;
        end
        {
                \property gumpobject.isbutton IsButton
        }
        else if TestName = 'isbutton' then begin
                if GumpObject.Typ = gt_Button then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.ispagebutton IsPageButton
        }
        else if TestName = 'ispagebutton' then begin
                if GumpObject.Typ = gt_PageButton then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isimage IsImage
        }
        else if TestName = 'isimage' then begin
                if GumpObject.Typ = gt_Image then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.istiledimage IsTiledImage
        }
        else if TestName = 'istiledimage' then begin
                if GumpObject.Typ = gt_TiledImage then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.istilepic IsTilePic
        }
        else if TestName = 'istilepic' then begin
                if GumpObject.Typ = gt_TilePic then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.istext IsText
        }
        else if TestName = 'istext' then begin
                if GumpObject.Typ = gt_Text then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isresizegump IsResizeGump
        }
        else if TestName = 'isresizegump' then begin
                if GumpObject.Typ = gt_ResizeGump then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.iscroppedtext IsCroppedText
        }
        else if TestName = 'iscroppedtext' then begin
                if GumpObject.Typ = gt_CroppedText then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.ishtmlgump IsHtmlGump
        }
        else if TestName = 'ishtmlgump' then begin
                if GumpObject.Typ = gt_HtmlGump then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isxmfhtmlgump IsXmfHtmlGump
        }
        else if TestName = 'isxmfhtmlguml' then begin
                if GumpObject.Typ = gt_XmfHtmlGump then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.ischeckertrans IsCheckerTrans
        }
        else if TestName = 'ischeckertrans' then begin
                if GumpObject.Typ = gt_CheckerTrans then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isinputfield IsInputField
        }
        else if TestName = 'isinputfield' then begin
                if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.ischeckbox IsCheckBox
        }
        else if TestName = 'ischeckbox' then begin
                if GumpObject.Typ = gt_Checkbox then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isradiobutton IsRadioButton
        }
        else if TestName = 'isradiobutton' then begin
                if GumpObject.Typ = gt_RadioButton then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.istextbutton IsTextButton
        }
        else if TestName = 'istextbutton' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isgumpitem IsGumpItem
        }
        else if TestName = 'isgumpitem' then begin
                if GumpObject.Typ = gt_GumpItem then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isgumpstaticitem IsGumpStaticItem
        }
        else if TestName = 'isgumpstaticitem' then begin
                if GumpObject.Typ = gt_GumpStaticItem then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isscrollbar IsScrollBar
        }
        else if TestName = 'isscrollbar' then begin
                if GumpObject.Typ = gt_ScrollBar then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.ishuebutton IsHueButton
        }
        else if TestName = 'ishuebutton' then begin
                if GumpObject.Typ = gt_HueButton then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isprogressbar IsProgressBar
        }
        else if TestName = 'isprogressbar' then begin
                if GumpObject.Typ = gt_ProgressBar then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.isextimage IsExtImage
        }
        else if TestName = 'isextimage' then begin
                if GumpObject.Typ = gt_ExtImage then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.islandtilepic IsLandTilePic
        }
        else if TestName = 'islandtilepic' then begin
                if GumpObject.Typ = gt_LandTilePic then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.istooltip IsTooltip
        }
        else if TestName = 'istooltip' then begin
                if GumpObject.Typ = gt_GumpToolTip then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.upid (GumpButton, PageButton, ScrollBar)
        }
        else if TestName = 'upid' then begin
                if GumpObject.Typ = gt_Button then
                        Result := PyInt_FromLong( TGumpButton( GumpObject ).UpId )
                else if GumpObject.Typ = gt_PageButton then
                        Result := PyInt_FromLong( TPageButton( GumpObject ).UpId )
                else if GumpObject.Typ = gt_ScrollBar then
                        Result := PyInt_FromLong( TScrollBar( GumpObject ).UpId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.downid (GumpButton, PageButton)
        }
        else if TestName = 'downid' then begin
                if GumpObject.Typ = gt_Button then
                        Result := PyInt_FromLong( TGumpButton( GumpObject ).DownId )
                else if GumpObject.Typ = gt_PageButton then
                        Result := PyInt_FromLong( TPageButton( GumpObject ).DownId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.moveoverid (GumpButton, PageButton)
        }
        else if TestName = 'moveoverid' then begin
                if GumpObject.Typ = gt_Button then
                        Result := PyInt_FromLong( TGumpButton( GumpObject ).MoveOverId )
                else if GumpObject.Typ = gt_ScrollBar then
                        Result := PyInt_FromLong( TScrollBar( GumpObject ).MoveOverId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.hue (GumpButton, GumpImage, TiledImage, TilePic, LandTilePic, ResizeGump, Text, CroppedText, InputField, XmfHtmlGump )
        }
        else if TestName = 'hue' then begin
                if GumpObject.Typ = gt_Button then
                        Result := PyInt_FromLong( TGumpButton( GumpObject ).Hue )
                else if GumpObject.Typ = gt_Image then
                        Result := PyInt_FromLong( TGImage( GumpObject ).Hue )
                else if GumpObject.Typ = gt_TiledImage then
                        Result := PyInt_FromLong( TTiledImage( GumpObject ).Hue )
                else if GumpObject.Typ = gt_TilePic then
                        Result := PyInt_FromLong( TTilePic( GumpObject ).Hue )
                else if GumpObject.Typ = gt_LandTilePic then
                        Result := PyInt_FromLong( TLandTilePic( GumpObject ).Hue )
                else if GumpObject.Typ = gt_ResizeGump then
                        Result := PyInt_FromLong( TResizeGump( GumpObject ).Hue )
                else if GumpObject.Typ = gt_Text then
                        Result := PyInt_FromLong( TGumpText( GumpObject ).Hue )
                else if GumpObject.Typ = gt_CroppedText then
                        Result := PyInt_FromLong( TCroppedText( GumpObject ).Hue )
                else if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).Hue )
                else if GumpObject.Typ = gt_XmfHtmlGump then
                        Result := PyInt_FromLong( TXmfHtmlGump( GumpObject ).Color )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.down (GumpButton, PageButton)
        }
        else if TestName = 'down' then begin
                if (GumpObject.Typ = gt_Button) and TGumpButton( GumpObject ).IsDown then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_PageButton) and TPageButton( GumpObject ).Down then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.mouseover (GumpButton, PageButton, TextButton)
        }
        else if TestName = 'mouseover' then begin
                if (GumpObject.Typ = gt_Button) and TGumpButton( GumpObject ).IsMausOver then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_HueButton) and THueButton( GumpObject ).IsMausOver then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_TextButton) and TTextButton( GumpObject ).IsMausOver then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.returnnumber (GumpButton, HueButton, TextButton, CheckBox, RadioButton)
        }
        else if TestName = 'returnnumber' then begin
                if GumpObject.Typ = gt_Button then
                        Result := PyInt_FromLong( TGumpButton( GumpObject ).ReturnNumber )
                else if GumpObject.Typ = gt_HueButton then
                        Result := PyInt_FromLong( THueButton( GumpObject ).ReturnNumber )
                else if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).ReturnNumber )
                else if GumpObject.Typ = gt_CheckBox then
                        Result := PyInt_FromLong( TCheckBox( GumpObject ).ReturnNumber )
                else if GumpObject.Typ = gt_RadioButton then
                        Result := PyInt_FromLong( TRadioButton( GumpObject ).ReturnNumber )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.red (HueButton)
        }
        else if TestName = 'red' then begin
                if GumpObject.Typ = gt_HueButton then
                        Result := PyInt_FromLong( THueButton( GumpObject ).Red )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.blue (HueButton)
        }
        else if TestName = 'blue' then begin
                if GumpObject.Typ = gt_HueButton then
                        Result := PyInt_FromLong( THueButton( GumpObject ).Blue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.green (HueButton)
        }
        else if TestName = 'green' then begin
                if GumpObject.Typ = gt_HueButton then
                        Result := PyInt_FromLong( THueButton( GumpObject ).Green )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.pageid (TextButton, PageButton)
        }
        else if TestName = 'pageid' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).PageId )
                else if GumpObject.Typ = gt_PageButton then
                        Result := PyInt_FromLong( TPageButton( GumpObject ).PageId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.font (TextButton, Text, CroppedText, InputField)
        }
        else if TestName = 'font' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).Font )
                else if GumpObject.Typ = gt_Text then
                        Result := PyInt_FromLong( TGumpText( GumpObject ).Font )
                else if GumpObject.Typ = gt_CroppedText then
                        Result := PyInt_FromLong( TCroppedText( GumpObject ).Font )
                else if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).Font )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.ispagebutton (TextButton)
        }
        else if TestName = 'ispagebutton' then begin
                if (GumpObject.Typ = gt_TextButton) and TTextButton( GumpObject ).IsPageButton then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.text (TextButton, Text, CroppedText, InputField, HtmlGump, XmfHtmlGump, ProgressBar, Tooltip)
        }
        else if TestName = 'text' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyString_FromString( PChar( TTextButton( GumpObject ).Text ) )
                else if GumpObject.Typ = gt_Text then
                        Result := PyString_FromString( PChar( TGumpText( GumpObject ).Text ) )
                else if GumpObject.Typ = gt_CroppedText then
                        Result := PyString_FromString( PChar( TCroppedText( GumpObject ).Text ) )
                else if GumpObject.Typ = gt_InputField then
                        Result := PyString_FromString( PChar( TInputField( GumpObject ).Text ) )
                else if GumpObject.Typ = gt_HtmlGump then
                        Result := PyString_FromString( PChar( THtmlGump( GumpObject ).Text ) )
                else if GumpObject.Typ = gt_XmfHtmlGump then
                        Result := PyString_FromString( PChar( TXmfHtmlGump( GumpObject ).Text ) )
                else if GumpObject.Typ = gt_ProgressBar then
                        Result := PyString_FromString( PChar( TProgressBar( GumpObject ).Text ) )
                else if GumpObject.Typ = gt_GumpToolTip then
                        Result := PyString_FromString( PChar( TGumpTooltip( GumpObject ).Tooltip ) )
                else
                        Result := PyString_FromString( '' );
        end
        {
                \property gumpobject.textlines (InputField)
        }
        else if TestName = 'textlines' then begin
                if GumpObject.Typ = gt_InputField then begin
                        Lines := TInputField( GumpObject ).GetLines;
                        Result := PyTuple_New( Lines.Count );
                        for I := 0 to Lines.Count-1 do begin
                                PyTuple_SetItem( Result, I, PyString_FromString( PChar( Lines.Strings[I] ) ) );
                        end;
                end else begin
                        Result := PyString_FromString( '' );
                end;
        end
        {
                \property gumpobject.uphue (TextButton)
        }
        else if TestName = 'uphue' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).UpHue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.downhue (TextButton)
        }
        else if TestName = 'downhue' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).DownHue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.moveoverhue (TextButton)
        }
        else if TestName = 'moveoverhue' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).MoveOverHue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.backuphue (TextButton)
        }
        else if TestName = 'backuphue' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).BackUpHue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.backdownhue (TextButton)
        }
        else if TestName = 'backdownhue' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).BackDownHue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.backmoveoverhue (TextButton)
        }
        else if TestName = 'backmoveoverhue' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).BackMoveOverHue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.backupid (TextButton)
        }
        else if TestName = 'backupid' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).BackUpId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.backdownid (TextButton)
        }
        else if TestName = 'backdownid' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).BackDownId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.backmoveoverid (TextButton)
        }
        else if TestName = 'backmoveoverid' then begin
                if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).BackMoveOverId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.id (GumpImage, TiledImage, TilePic, LandTilePic, ResizeGump)
        }
        else if TestName = 'id' then begin
                if GumpObject.Typ = gt_Image then
                        Result := PyInt_FromLong( TGImage( GumpObject ).Id )
                else if GumpObject.Typ = gt_TiledImage then
                        Result := PyInt_FromLong( TTiledImage( GumpObject ).Id )
                else if GumpObject.Typ = gt_TilePic then
                        Result := PyInt_FromLong( TTilePic( GumpObject ).Id )
                else if GumpObject.Typ = gt_LandTilePic then
                        Result := PyInt_FromLong( TLandTilePic( GumpObject ).Id )
                else if GumpObject.Typ = gt_ResizeGump then
                        Result := PyInt_FromLong( TResizeGump( GumpObject ).Id )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.onlyborder (ResizeGump)
        }
        else if TestName = 'onlyborder' then begin
                if (GumpObject.Typ = gt_ResizeGump) and TResizeGump( GumpObject ).OnlyBorder then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.border (Text, InputField, TextButton, CroppedText)
        }
        else if TestName = 'border' then begin
                if (GumpObject.Typ = gt_Text) and TGumpText( GumpObject ).Border then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_InputField) and TInputField( GumpObject ).Border then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_TextButton) and TTextButton( GumpObject ).Border then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_CroppedText) and TCroppedText( GumpObject ).Border then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.maxlines (CroppedText, InputField)
        }
        else if TestName = 'maxlines' then begin
                if GumpObject.Typ = gt_CroppedText then
                        Result := PyInt_FromLong( TCroppedText( GumpObject ).MaxLines )
                else if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).MaxLines )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.minx (CroppedText, InputField)
        }
        else if TestName = 'minx' then begin
                if GumpObject.Typ = gt_CroppedText then
                        Result := PyInt_FromLong( TCroppedText( GumpObject ).MinX )
                else if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).MinX )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.miny (CroppedText, InputField)
        }
        else if TestName = 'miny' then begin
                if GumpObject.Typ = gt_CroppedText then
                        Result := PyInt_FromLong( TCroppedText( GumpObject ).MinY )
                else if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).MinY )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.hasstars (InputField)
        }
        else if TestName = 'hasstars' then begin
                if (GumpObject.Typ = gt_InputField) and TInputField( GumpObject ).HasStars then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.allowonlynumbers (InputField)
        }
        else if TestName = 'allowonlynumbers' then begin
                if (GumpObject.Typ = gt_InputField) and TInputField( GumpObject ).AllowOnlyNumbers then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.allowmultilines (InputField)
        }
        else if TestName = 'allowmultilines' then begin
                if (GumpObject.Typ = gt_InputField) and TInputField( GumpObject ).AllowMultiLines then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.textid (InputField)
        }
        else if TestName = 'textid' then begin
                if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).TextId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.selectionhue (InputField)
        }
        else if TestName = 'selectionhue' then begin
                if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).SelectionHue )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.selectedpos (InputField)
        }
        else if TestName = 'selectedpos' then begin
                if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).SelectedPos )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.textchanged (InputField)
        }
        else if TestName = 'textchanged' then begin
                if (GumpObject.Typ = gt_InputField) and TInputField( GumpObject ).TextChanged then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.deletetextonnextchange (InputField)
        }
        else if TestName = 'deletetextonnextchange' then begin
                if (GumpObject.Typ = gt_InputField) and TInputField( GumpObject ).DeleteTextOnNextChange then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.trueid (CheckBox, RadioButton)
        }
        else if TestName = 'trueid' then begin
                if GumpObject.Typ = gt_CheckBox then
                        Result := PyInt_FromLong( TCheckBox( GumpObject ).TrueId )
                else if GumpObject.Typ = gt_RadioButton then
                        Result := PyInt_FromLong( TRadioButton( GumpObject ).TrueId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.falseid (CheckBox, RadioButton)
        }
        else if TestName = 'falseid' then begin
                if GumpObject.Typ = gt_CheckBox then
                        Result := PyInt_FromLong( TCheckBox( GumpObject ).FalseId )
                else if GumpObject.Typ = gt_RadioButton then
                        Result := PyInt_FromLong( TRadioButton( GumpObject ).FalseId )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.checked (CheckBox, RadioButton)
        }
        else if TestName = 'checked' then begin
                if (GumpObject.Typ = gt_CheckBox) and TCheckBox( GumpObject ).Checked then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_RadioButton) and TRadioButton( GumpObject ).Checked then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.group (RadioButton)
        }
        else if TestName = 'group' then begin
                if GumpObject.Typ = gt_RadioButton then
                        Result := PyInt_FromLong( TRadioButton( GumpObject ).Group )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.startpos (HtmlGump)
        }
        else if TestName = 'startpos' then begin
                if GumpObject.Typ = gt_HtmlGump then
                        Result := PyInt_FromLong( THtmlGump( GumpObject ).StartPos )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.hasback (HtmlGump, XmfHtmlGump)
        }
        else if TestName = 'hasback' then begin
                if (GumpObject.Typ = gt_HtmlGump) and THtmlGump( GumpObject ).hasBack then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_XmfHtmlGump) and TXmfHtmlGump( GumpObject ).hasBack then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.hasback (HtmlGump, XmfHtmlGump)
        }
        else if TestName = 'canscroll' then begin
                if (GumpObject.Typ = gt_HtmlGump) and THtmlGump( GumpObject ).canScroll then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_XmfHtmlGump) and TXmfHtmlGump( GumpObject ).canScroll then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.clilocid (XmfHtmlGump)
        }
        else if TestName = 'clilocid' then begin
                if GumpObject.Typ = gt_XmfHtmlGump then
                        Result := PyInt_FromLong( TXmfHtmlGump( GumpObject ).ClilocID )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.itemserial (GumpItem, GumpStaticItem)
        }
        else if TestName = 'itemserial' then begin
                if GumpObject.Typ = gt_GumpItem then
                        Result := PyInt_FromLong( TGumpItem( GumpObject ).GetSerial )
                else if GumpObject.Typ = gt_GumpStaticItem then
                        Result := PyInt_FromLong( TGumpStaticItem( GumpObject ).ItemSerial )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.fixed (ScrollBar)
        }
        else if TestName = 'fixed' then begin
                if (GumpObject.Typ = gt_ScrollBar) and TScrollBar( GumpObject ).Fixed then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.number (ScrollBar)
        }
        else if TestName = 'number' then begin
                if GumpObject.Typ = gt_ScrollBar  then
                        Result := PyInt_FromLong( TScrollBar( GumpObject ).Number )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.promille (ScrollBar)
        }
        else if TestName = 'promille' then begin
                if GumpObject.Typ = gt_ScrollBar  then
                        Result := PyInt_FromLong( TScrollBar( GumpObject ).Promille )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.horizontal (ScrollBar, ProgressBar)
        }
        else if TestName = 'horizontal' then begin
                if (GumpObject.Typ = gt_ScrollBar) and TScrollBar( GumpObject ).Horizontal then
                        Result := PyInt_FromLong( 1 )
                else if (GumpObject.Typ = gt_ProgressBar) and TProgressBar( GumpObject ).Waagerecht then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.upbutton (ScrollBar)
        }
        else if TestName = 'upbutton' then begin
                if GumpObject.Typ = gt_ScrollBar  then
                        Result := PyGetGumpObject( TScrollBar( GumpObject ).UpButton )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.downbutton (ScrollBar)
        }
        else if TestName = 'downbutton' then begin
                if GumpObject.Typ = gt_ScrollBar  then
                        Result := PyGetGumpObject( TScrollBar( GumpObject ).DownButton )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.htmlgump (ScrollBar)
        }
        else if TestName = 'htmlgump' then begin
                if GumpObject.Typ = gt_ScrollBar  then
                        Result := PyGetGumpObject( TScrollBar( GumpObject ).HtmlGump )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.align (ProgressBar)
        }
        else if TestName = 'align' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyString_FromString( PChar( TProgressBar( GumpObject ).Align ) )
                else
                        Result := PyString_FromString( PChar( '' ) );
        end
        {
                \property gumpobject.backleftcolor (ProgressBar)
        }
        else if TestName = 'backleftcolor' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyInt_FromLong( TProgressBar( GumpObject ).BackLeftColor )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.backrightcolor (ProgressBar)
        }
        else if TestName = 'backrightcolor' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyInt_FromLong( TProgressBar( GumpObject ).BackRightColor )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.leftcolor (ProgressBar)
        }
        else if TestName = 'leftcolor' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyInt_FromLong( TProgressBar( GumpObject ).LeftColor )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.rightcolor (ProgressBar)
        }
        else if TestName = 'rightcolor' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyInt_FromLong( TProgressBar( GumpObject ).RightColor )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.max (ProgressBar)
        }
        else if TestName = 'max' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyInt_FromLong( TProgressBar( GumpObject ).Max )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.current (ProgressBar)
        }
        else if TestName = 'current' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyInt_FromLong( TProgressBar( GumpObject ).Current )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.textcolor (ProgressBar)
        }
        else if TestName = 'textcolor' then begin
                if GumpObject.Typ = gt_ProgressBar  then
                        Result := PyInt_FromLong( TProgressBar( GumpObject ).TextColor )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.divheightmod (CroppedText)
        }
        else if TestName = 'divheightmod' then begin
                if GumpObject.Typ = gt_CroppedText  then
                        Result := PyInt_FromLong( TCroppedText( GumpObject ).DivHeight )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.checkcompleterectangle (Button)
        }
        else if TestName = 'checkcompleterectangle' then begin
                if (GumpObject.Typ = gt_Button) and TGumpButton( GumpObject ).CheckCompleteRectangle then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.textureheight (CroppedText, GumpText, TextButton, InputField, HtmlGump, TilePic, LandTilePic)
        }
        else if TestName = 'textureheight' then begin
                if GumpObject.Typ = gt_CroppedText then
                        Result := PyInt_FromLong( TCroppedText( GumpObject ).GetTextureHoehe )
                else if GumpObject.Typ = gt_Text then
                        Result := PyInt_FromLong( TGumpText( GumpObject ).GetTextureHoehe )
                else if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).GetTextureHoehe )                        
                else if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).GetTextureHoehe )
                else if GumpObject.Typ = gt_HtmlGump then
                        Result := PyInt_FromLong( THtmlGump( GumpObject ).GetTextureHoehe )
                else if GumpObject.Typ = gt_TilePic then
                        Result := PyInt_FromLong( TTilePic( GumpObject ).GetTextureHoehe )
                else if GumpObject.Typ = gt_LandTilePic then
                        Result := PyInt_FromLong( TLandTilePic( GumpObject ).GetTextureHoehe )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.texturewidth (GumpText, TextButton, InputField, HtmlGump, TilePic, LandTilePic)
        }
        else if TestName = 'texturewidth' then begin
                if GumpObject.Typ = gt_Text then
                        Result := PyInt_FromLong( TGumpText( GumpObject ).GetTextureBreite )
                else if GumpObject.Typ = gt_TextButton then
                        Result := PyInt_FromLong( TTextButton( GumpObject ).GetTextureBreite )
                else if GumpObject.Typ = gt_InputField then
                        Result := PyInt_FromLong( TInputField( GumpObject ).GetTextureBreite )
                else if GumpObject.Typ = gt_HtmlGump then
                        Result := PyInt_FromLong( THtmlGump( GumpObject ).GetTextureBreite )
                else if GumpObject.Typ = gt_TilePic then
                        Result := PyInt_FromLong( TTilePic( GumpObject ).GetTextureBreite )
                else if GumpObject.Typ = gt_LandTilePic then
                        Result := PyInt_FromLong( TLandTilePic( GumpObject ).GetTextureBreite )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.keepproportions (GumpImage)
        }
        else if TestName = 'keepproportions' then begin
                if (GumpObject.Typ = gt_Image) and TGImage( GumpObject ).KeepProportions then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property gumpobject.domousecheck
        }
        else if TestName = 'domousecheck' then begin
                if GumpObject.DoMouseCheck then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        else begin
                Result := Py_FindMethod( @pyGumpObjectMethods, Self, PChar( TestName ) );
        end;
end;

function pyGumpObject_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer;
var     GumpObject : TGumpObject;
        TestName : String;
        TmpGumpObject : TGumpObject;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := 1;
                Exit;
        end;

        GumpObject := pyGumpObject_getGumpObject( Self );
        if GumpObject = nil then begin
                Result := 1;
                Exit;
        end;        
        TestName := LowerCase( Name );

        if TestName = 'x' then begin
                if PyInt_Check( Value ) then begin
                        GumpObject.X := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'y' then begin
                if PyInt_Check( Value ) then begin
                        GumpObject.Y := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'page' then begin
                if PyInt_Check( Value ) then begin
                        GumpObject.Page := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'visible' then begin
                if PyInt_Check( Value ) then begin
                        GumpObject.Visible := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'gump' then begin
                if pyGump_check( Value ) then begin
                        GumpObject.Gump := PyGump_GetGump( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'upid' then begin
                if (GumpObject.Typ = gt_Button) and pyInt_Check( Value ) then begin
                        TGumpButton( GumpObject ).UpId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_PageButton) and pyInt_Check( Value ) then begin
                        TPageButton( GumpObject ).UpId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).UpId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'downid' then begin
                if (GumpObject.Typ = gt_Button) and pyInt_Check( Value ) then begin
                        TGumpButton( GumpObject ).DownId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_PageButton) and pyInt_Check( Value ) then begin
                        TPageButton( GumpObject ).DownId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'moveoverid' then begin
                if (GumpObject.Typ = gt_Button) and pyInt_Check( Value ) then begin
                        TGumpButton( GumpObject ).MoveOverId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).MoveOverId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'hue' then begin
                if (GumpObject.Typ = gt_Button) and pyInt_Check( Value ) then begin
                        TGumpButton( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_Image) and pyInt_Check( Value ) then begin
                        TGImage( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TiledImage) and pyInt_Check( Value ) then begin
                        TTiledImage( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TilePic) and pyInt_Check( Value ) then begin
                        TTilePic( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_LandTilePic) and pyInt_Check( Value ) then begin
                        TLandTilePic( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ResizeGump) and pyInt_Check( Value ) then begin
                        TResizeGump( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_Text) and pyInt_Check( Value ) then begin
                        TGumpText( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).Hue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_XmfHtmlGump) and pyInt_Check( Value ) then begin
                        TXmfHtmlGump( GumpObject ).Color := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'returnnumber' then begin
                if (GumpObject.Typ = gt_Button) and pyInt_Check( Value ) then begin
                        TGumpButton( GumpObject ).ReturnNumber := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_HueButton) and pyInt_Check( Value ) then begin
                        THueButton( GumpObject ).ReturnNumber := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).ReturnNumber := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CheckBox) and pyInt_Check( Value ) then begin
                        TCheckBox( GumpObject ).ReturnNumber := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_RadioButton) and pyInt_Check( Value ) then begin
                        TRadioButton( GumpObject ).ReturnNumber := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'red' then begin
                if (GumpObject.Typ = gt_HueButton) and pyInt_Check( Value ) then begin
                        THueButton( GumpObject ).Red := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'blue' then begin
                if (GumpObject.Typ = gt_HueButton) and pyInt_Check( Value ) then begin
                        THueButton( GumpObject ).Blue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'green' then begin
                if (GumpObject.Typ = gt_HueButton) and pyInt_Check( Value ) then begin
                        THueButton( GumpObject ).Green := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'width' then begin
                if (GumpObject.Typ = gt_HueButton) and pyInt_Check( Value ) then begin
                        THueButton( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TiledImage) and pyInt_Check( Value ) then begin
                        TTiledImage( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ResizeGump) and pyInt_Check( Value ) then begin
                        TResizeGump( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_HtmlGump) and pyInt_Check( Value ) then begin
                        THtmlGump( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_XmfHtmlGump) and pyInt_Check( Value ) then begin
                        TXmfHtmlGump( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CheckerTrans) and pyInt_Check( Value ) then begin
                        TCheckerTrans( GumpObject ).Resize( PyInt_AsLong( Value ), TCheckerTrans( GumpObject ).GetHoehe );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_GumpToolTip) and pyInt_Check( Value ) then begin
                        TGumpToolTip( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TilePic) and pyInt_Check( Value ) then begin
                        TTilePic( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_LandTilePic) and pyInt_Check( Value ) then begin
                        TLandTilePic( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_Image) and pyInt_Check( Value ) then begin
                        TGImage( GumpObject ).Breite := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'height' then begin
                if (GumpObject.Typ = gt_HueButton) and pyInt_Check( Value ) then begin
                        THueButton( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TiledImage) and pyInt_Check( Value ) then begin
                        TTiledImage( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ResizeGump) and pyInt_Check( Value ) then begin
                        TResizeGump( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_HtmlGump) and pyInt_Check( Value ) then begin
                        THtmlGump( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_XmfHtmlGump) and pyInt_Check( Value ) then begin
                        TXmfHtmlGump( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CheckerTrans) and pyInt_Check( Value ) then begin
                        TCheckerTrans( GumpObject ).Resize( TCheckerTrans( GumpObject ).GetBreite, PyInt_AsLong( Value ) );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_GumpToolTip) and pyInt_Check( Value ) then begin
                        TGumpToolTip( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TilePic) and pyInt_Check( Value ) then begin
                        TTilePic( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_LandTilePic) and pyInt_Check( Value ) then begin
                        TLandTilePic( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_Image) and pyInt_Check( Value ) then begin
                        TGImage( GumpObject ).Hoehe := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'pageid' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).PageId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_PageButton) and pyInt_Check( Value ) then begin
                        TPageButton( GumpObject ).PageId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'font' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).Font := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_Text) and pyInt_Check( Value ) then begin
                        TGumpText( GumpObject ).Font := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).Font := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).Font := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'ispagebutton' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).IsPageButton := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'text' then begin
                if (GumpObject.Typ = gt_TextButton) and pyString_Check( Value ) then begin
                        TTextButton( GumpObject ).Text := PyString_AsString( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_Text) and pyString_Check( Value ) then begin
                        TGumpText( GumpObject ).Text := PyString_AsString( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CroppedText) and pyString_Check( Value ) then begin
                        TCroppedText( GumpObject ).Text := PyString_AsString( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyString_Check( Value ) then begin
                        TInputField( GumpObject ).Text := PyString_AsString( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_HtmlGump) and pyString_Check( Value ) then begin
                        THtmlGump( GumpObject ).Text := PyString_AsString( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ProgressBar) and pyString_Check( Value ) then begin
                        TProgressBar( GumpObject ).Text := PyString_AsString( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_GumpToolTip) and pyString_Check( Value ) then begin
                        TGumpToolTip( GumpObject ).Tooltip := PyString_AsString( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'uphue' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).UpHue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'downhue' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).DownHue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'moveoverhue' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).MoveOverHue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backuphue' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).BackUpHue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backdownhue' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).BackDownHue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backmoveoverhue' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).BackMoveOverHue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backupid' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).BackUpId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backdownid' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).BackDownId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backmoveoverid' then begin
                if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).BackMoveOverId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'id' then begin
                if (GumpObject.Typ = gt_Image) and pyInt_Check( Value ) then begin
                        TGImage( GumpObject ).Id := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TiledImage) and pyInt_Check( Value ) then begin
                        TTiledImage( GumpObject ).Id := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TilePic) and pyInt_Check( Value ) then begin
                        TTilePic( GumpObject ).Id := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_LandTilePic) and pyInt_Check( Value ) then begin
                        TLandTilePic( GumpObject ).Id := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ResizeGump) and pyInt_Check( Value ) then begin
                        TResizeGump( GumpObject ).Id := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'onlyborder' then begin
                if (GumpObject.Typ = gt_ResizeGump) and pyInt_Check( Value ) then begin
                        TResizeGump( GumpObject ).OnlyBorder := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'border' then begin
                if (GumpObject.Typ = gt_Text) and pyInt_Check( Value ) then begin
                        TGumpText( GumpObject ).Border := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).Border := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_TextButton) and pyInt_Check( Value ) then begin
                        TTextButton( GumpObject ).Border := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_Text) and pyInt_Check( Value ) then begin
                        TGumpText( GumpObject ).Border := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).Border := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'maxlines' then begin
                if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).MaxLines := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).MaxLines := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'minx' then begin
                if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).MinX := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).MinX := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'miny' then begin
                if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).MinY := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).MinY := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'hasstars' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).HasStars := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'allowonlynumbers' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).AllowOnlyNumbers := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'allowmultilines' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).AllowMultiLines := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'textchanged' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).TextChanged := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'deletetextonnextchange' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).DeleteTextOnNextChange := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'textid' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).TextId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selectionhue' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).SelectionHue := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selectedpos' then begin
                if (GumpObject.Typ = gt_InputField) and pyInt_Check( Value ) then begin
                        TInputField( GumpObject ).SelectedPos := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'trueid' then begin
                if (GumpObject.Typ = gt_CheckBox) and pyInt_Check( Value ) then begin
                        TCheckBox( GumpObject ).TrueId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_RadioButton) and pyInt_Check( Value ) then begin
                        TRadioButton( GumpObject ).TrueId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'falseid' then begin
                if (GumpObject.Typ = gt_CheckBox) and pyInt_Check( Value ) then begin
                        TCheckBox( GumpObject ).FalseId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_RadioButton) and pyInt_Check( Value ) then begin
                        TRadioButton( GumpObject ).FalseId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'checked' then begin
                if (GumpObject.Typ = gt_CheckBox) and pyInt_Check( Value ) then begin
                        TCheckBox( GumpObject ).Checked := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_RadioButton) and pyInt_Check( Value ) then begin
                        TRadioButton( GumpObject ).Checked := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'group' then begin
                if (GumpObject.Typ = gt_RadioButton) and pyInt_Check( Value ) then begin
                        TRadioButton( GumpObject ).Group := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'startpos' then begin
                if (GumpObject.Typ = gt_HtmlGump) and pyInt_Check( Value ) then begin
                        THtmlGump( GumpObject ).StartPos := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'hasback' then begin
                if (GumpObject.Typ = gt_HtmlGump) and pyInt_Check( Value ) then begin
                        THtmlGump( GumpObject ).hasBack := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_XmfHtmlGump) and pyInt_Check( Value ) then begin
                        TXmfHtmlGump( GumpObject ).hasBack := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'canscroll' then begin
                if (GumpObject.Typ = gt_HtmlGump) and pyInt_Check( Value ) then begin
                        THtmlGump( GumpObject ).canScroll := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_XmfHtmlGump) and pyInt_Check( Value ) then begin
                        TXmfHtmlGump( GumpObject ).canScroll := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'clilocid' then begin
                if (GumpObject.Typ = gt_XmfHtmlGump) and pyInt_Check( Value ) then begin
                        TXmfHtmlGump( GumpObject ).ClilocID := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'itemserial' then begin
                if (GumpObject.Typ = gt_GumpItem) and pyInt_Check( Value ) then begin
                        TGumpItem( GumpObject ).SetSerial( PyInt_AsLong( Value ) );
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_GumpStaticItem) and pyInt_Check( Value ) then begin
                        TGumpStaticItem( GumpObject ).ItemSerial := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'fixed' then begin
                if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).Fixed := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'number' then begin
                if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).Number := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'promille' then begin
                if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).Promille := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'horizontal' then begin
                if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TScrollBar( GumpObject ).Horizontal := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).Waagerecht := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'upbutton' then begin
                if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TmpGumpObject := TGumpButton( PyGumpObject_GetGumpObject( Value ) );
                        if (TmpGumpObject <> nil) and (TmpGumpObject.Typ = gt_Button) then begin
                                TScrollBar( GumpObject ).UpButton := TGumpButton( TmpGumpObject );
                                Result := 0;
                        end
                        else begin
                                Result := 1;
                        end;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'downbutton' then begin
                if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TmpGumpObject := TGumpButton( PyGumpObject_GetGumpObject( Value ) );
                        if (TmpGumpObject <> nil) and (TmpGumpObject.Typ = gt_Button) then begin
                                TScrollBar( GumpObject ).DownButton := TGumpButton( TmpGumpObject );
                                Result := 0;
                        end
                        else begin
                                Result := 1;
                        end;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'htmlgump' then begin
                if (GumpObject.Typ = gt_ScrollBar) and pyInt_Check( Value ) then begin
                        TmpGumpObject := TGumpButton( PyGumpObject_GetGumpObject( Value ) );
                        if (TmpGumpObject <> nil) and (TmpGumpObject.Typ = gt_HtmlGump) then begin
                                TScrollBar( GumpObject ).HtmlGump := THtmlGump( TmpGumpObject );
                                Result := 0;
                        end
                        else begin
                                Result := 1;
                        end;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'align' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyString_Check( Value ) then begin
                        TProgressBar( GumpObject ).Align := PyString_AsString( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backleftcolor' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).BackLeftColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'backrightcolor' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).BackRightColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'leftcolor' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).LeftColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'rightcolor' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).RightColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'max' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).Max := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'current' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).Current := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'textcolor' then begin
                if (GumpObject.Typ = gt_ProgressBar) and pyInt_Check( Value ) then begin
                        TProgressBar( GumpObject ).TextColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'divheightmod' then begin
                if (GumpObject.Typ = gt_CroppedText) and pyInt_Check( Value ) then begin
                        TCroppedText( GumpObject ).DivHeight := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'checkcompleterectangle' then begin
                if (GumpObject.Typ = gt_Button) and pyInt_Check( Value ) then begin
                        TGumpButton( GumpObject ).CheckCompleteRectangle := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'keepproportions' then begin
                if (GumpObject.Typ = gt_Image) and pyInt_Check( Value ) then begin
                        TGImage( GumpObject ).KeepProportions := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'domousecheck' then begin
                if pyInt_Check( Value ) then begin
                        GumpObject.DoMouseCheck := PyInt_AsLong( Value ) = 1;
                        Result := 0;
                end else begin
                        Result := 1;
                end;
        end
        else begin
                Result := 1;
        end;
end;

function pyGumpObject_compare( GumpObject1, GumpObject2 : PPyObject ) : Integer;
var     P1, P2 : TGumpObject;
begin
        if (not pyGumpObject_check( GumpObject1 )) and (not pyGumpObject_check( GumpObject2 )) then begin
                Result := -1;
                Exit;
        end;

        P1 := pyGumpObject_getGumpObject( GumpObject1 );
        P2 := pyGumpObject_getGumpObject( GumpObject2 );

        if P1 = P2 then begin
                Result := 0;
        end
        else begin
                Result := -1;
        end;
end;

function pyGumpObject_getGumpObject( Self : PPyObject ) : TGumpObject;
var     I : Integer;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := nil;
                Exit;
        end;

        Result := nil;

        for I := 0 to Palanthir.GlobalGumpObjectList.Count-1 do begin
                if TGumpObject( Palanthir.GlobalGumpObjectList.Items[ I ] ).InternalID = PpyGumpObject( Self ).Serial then begin
                        Result := TGumpObject( Palanthir.GlobalGumpObjectList.Items[ I ] );
                        Break;
                end;
        end;
end;

function pyGumpObject_check( Self : PPyObject ) : Boolean;
begin
        Result := Self.ob_type = @pyGumpObjectType;
end;

function pyGetGumpObject( GumpObject : TGumpObject ) : PPyObject;
var     PyGumpObject : PpyGumpObject;
begin
        PyGumpObject := PpyGumpObject( PyObject_new( @pyGumpObjectType ) );
        PyGumpObject.Serial := GumpObject.InternalID;
        Result := PPyObject( PyGumpObject );
end;

function pyConvertGumpObject( PyObject : PPyObject; GumpObject : P_GumpObject ) : Integer;
begin
        if not pyGumpObject_check( PyObject ) then begin
                PyErr_BadArgument;
                Result := 0;
                Exit;
        end;

        GumpObject^ := pyGumpObject_getGumpObject( pyObject );
        Result := 1;
end;

{
        \method gumpobject.applyhue
        \param Hue
        \description Applies the given Hue to an huebutton.
}
function pyGumpObject_ApplyHue( Self, Args : PPyObject ) : PPyObject;
var     GumpObject : TGumpObject;
        Hue : Word;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := PyReturnNone;
                Exit;
        end;

        if PyArg_ParseTuple( Args, 'h:gumpobject.applyhue( hue )', [@Hue] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        GumpObject := pyGumpObject_getGumpObject( Self );
        if (GumpObject = nil) or (GumpObject.Typ <> gt_HueButton) then begin
                Result := PyReturnNone;
                Exit;
        end
        else begin
                THueButton( GumpObject ).SetColor( Hue );
        end;

        Result := PyReturnNone;
end;

{
        \method gumpobject.draw
        \description Draws the gumpobject. To see it you have to call this function once per drawcycle
}
function pyGumpObject_Draw( Self, Args : PPyObject ) : PPyObject;
var     GumpObject : TGumpObject;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := PyReturnNone;
                Exit;
        end;

        GumpObject := pyGumpObject_getGumpObject( Self );
        if GumpObject = nil then begin
                Result := PyReturnNone;
                Exit;
        end;

        GumpObject.Draw;
        Result := PyReturnNone;
end;

{
        \method gumpobject.sendback
        \description Moves the gumpobject to the last position in the drawlist of its gump.
}
function pyGumpObject_SendBack( Self, Args : PPyObject ) : PPyObject;
var     GumpObject : TGumpObject;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := PyReturnNone;
                Exit;
        end;

        GumpObject := pyGumpObject_getGumpObject( Self );
        if GumpObject = nil then begin
                Result := PyReturnNone;
                Exit;
        end;

        if GumpObject.Gump <> nil then
                GumpObject.Gump.SendBack( GumpObject );
        Result := PyReturnNone;
end;

{
        \method gumpobject.sendfront
        \description Moves the gumpobject to the last position in the drawlist of its gump.
}
function pyGumpObject_SendFront( Self, Args : PPyObject ) : PPyObject;
var     GumpObject : TGumpObject;
begin
        if not pyGumpObject_check( Self ) then begin
                Result := PyReturnNone;
                Exit;
        end;

        GumpObject := pyGumpObject_getGumpObject( Self );
        if GumpObject = nil then begin
                Result := PyReturnNone;
                Exit;
        end;

        if GumpObject.Gump <> nil then
                GumpObject.Gump.SendFront( GumpObject );
        Result := PyReturnNone;
end;

end.
