unit uPyKeyboard;

interface

uses    Python, uKeyboard, uPyUtilities, SysUtils, Windows;

{
        \object Keyboard
        \description Object to access and change keyboard propeties.
}

type    TpyKeyboard = Record
                ob_refcnt : Integer;
		ob_type : PPyTypeObject;
        end;

        PpyKeyboard = ^TpyKeyboard;

function pyKeyboard_Str( Self : PPyObject ) : PPyObject; cdecl;
function pyKeyboard_getAttr( Self : PPyObject; Name : PChar ) : PPyObject; cdecl;
function pyKeyboard_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer; cdecl;
function pyKeyboard_compare( Keyboard1, Keyboard2 : PPyObject ) : Integer; cdecl;
function pyKeyboard_check( Self : PPyObject ) : Boolean;
function pyGetKeyboard : PPyObject; cdecl;

const pyKeyboardType : PyTypeObject = (
		ob_refcnt : 0;
		ob_type : nil;
		ob_size : 0;
		tp_name : 'pyKeyboard';
		tp_basicsize : sizeof( pyKeyboardType );
                tp_itemsize : 0;

		tp_dealloc : PyDealloc;
		tp_print : nil;
		tp_getattr : pyKeyboard_getAttr;
		tp_setattr : pyKeyboard_setAttr;
		tp_compare : pyKeyboard_compare;
		tp_repr : nil;

		tp_as_number : nil;
		tp_as_sequence : nil;
		tp_as_mapping : nil;

		tp_hash : nil;
		tp_call : nil;
		tp_str : pyKeyboard_Str;
		tp_getattro : nil;
		tp_setattro : nil;

		tp_as_buffer : nil;
		tp_flags : 0;
		tp_doc : nil;

		tp_traverse : nil;

		tp_clear : nil;
		tp_richcompare : nil;

		tp_weaklistoffset : 0;

		tp_iter : nil;
		tp_iternext : nil;

		tp_methods : nil;
		tp_members : nil;
		tp_getset : nil;
		tp_base : nil;
		tp_dict : nil;
		tp_descr_get : nil;
		tp_descr_set : nil;
		tp_dictoffset : 0;
		tp_init : nil;
		tp_alloc : nil;
		tp_new : nil;
		tp_free : nil;
		tp_is_gc : nil;
		tp_bases : nil;
		tp_mro : nil;
		tp_cache : nil;
		tp_subclasses : nil;
		tp_weaklist : nil;
        );

        pyKeyboardMethods : Array[0..1] of PyMethodDef =
                ( ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ),
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

implementation

uses    uPalanthir;

function pyKeyboard_Str( Self : PPyObject ) : PPyObject;
begin
        Result := PyString_FromString( PChar( 'Keyboard' ) );
end;

function pyKeyboard_getAttr( Self : PPyObject; Name : PChar ) : PPyObject;
var     TestName : String;
begin
        if not pyKeyboard_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        TestName := LowerCase( Name );

        {
                \property keyboard.speechtext Current text of the keyboard.
        }
        if TestName = 'speechtext' then begin
                Result := PyString_FromString( PChar( Palanthir.Keyboard.SpeechText ) );
        end
        {
                \property keyboard.speechcolor Current speechcolor of the keyboard.
        }
        else if TestName = 'speechcolor' then begin
                Result := PyInt_FromLong( Palanthir.Keyboard.SpeechColor );
        end
        {
                \property keyboard.emotecolor Current emotecolor of the keyboard.
        }
        else if TestName = 'emotecolor' then begin
                Result := PyInt_FromLong( Palanthir.Keyboard.EmoteColor );
        end
        {
                \property keyboard.font Current font of the keyboard.
        }
        else if TestName = 'font' then begin
                Result := PyInt_FromLong( Palanthir.Keyboard.Font );
        end
        {
                \property keyboard.alt Current status of the alt key (readonly).
        }
        else if TestName = 'alt' then begin
                if GetKeyState( VK_MENU ) < 0 then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );                
        end
        {
                \property keyboard.ctrl Current status of the ctrl key (readonly).
        }
        else if TestName = 'ctrl' then begin
                if GetKeyState( VK_CONTROL ) < 0 then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );                
        end
        {
                \property keyboard.shift Current status of the shift key (readonly).
        }
        else if TestName = 'shift' then begin
                if GetKeyState( VK_SHIFT ) < 0 then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );                
        end
        else begin
                Result := Py_FindMethod( @pyKeyboardMethods, Self, PChar( TestName ) );
        end;
end;

function pyKeyboard_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer;
var     TestName : String;
begin
        if not pyKeyboard_check( Self ) then begin
                Result := 1;
                Exit;
        end;

        TestName := LowerCase( Name );

        if TestName = 'speechtext' then begin
                if PyString_Check( Value ) then begin
                        Palanthir.Keyboard.SpeechText := PyString_AsString( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'speechcolor' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Keyboard.SpeechColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'emotecolor' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Keyboard.EmoteColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'font' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Keyboard.Font := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else begin
                Result := 1;
        end;
end;

function pyKeyboard_compare( Keyboard1, Keyboard2 : PPyObject ) : Integer;
begin
        Result := 1;
end;

function pyKeyboard_check( Self : PPyObject ) : Boolean;
begin
        Result := Self.ob_type = @pyKeyboardType;
end;

function pyGetKeyboard : PPyObject;
begin
        Result := PyObject_new( @pyKeyboardType );
end;

end.
