unit uPyMap;

interface

uses    Python, uBasicTypedefs, SysUtils, uPyUtilities, uUObject;

{
        \object map
        \description Represents a map object.
}

type    TpyMap = Record
                ob_refcnt : Integer;
		ob_type : PPyTypeObject;
                MapItem : TMapItem;
        end;

        PpyMap = ^TpyMap;

function pyMap_Str( Self : PPyObject ) : PPyObject; cdecl;
procedure pyMap_Dealloc( Self : PPyObject ); cdecl;
function pyMap_getAttr( Self : PPyObject; Name : PChar ) : PPyObject; cdecl;
function pyMap_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer; cdecl;
function pyMap_compare( Map1, Map2 : PPyObject ) : Integer; cdecl;
function pyMap_getMap( Self : PPyObject ) : TMapItem;
function pyMap_check( Self : PPyObject ) : Boolean;
function pyGetMap( MapItem : TMapItem ) : PPyObject; cdecl;
function pyConvertMap( PyObject : PPyObject; MapItem : P_MapItem ) : Integer; cdecl;

const pyMapType : PyTypeObject = (
		ob_refcnt : 0;
		ob_type : nil;
		ob_size : 0;
		tp_name : 'pyMap';
		tp_basicsize : sizeof( pyMapType );
                tp_itemsize : 0;

		tp_dealloc : pyMap_Dealloc;
		tp_print : nil;
		tp_getattr : pyMap_getAttr;
		tp_setattr : pyMap_setAttr;
		tp_compare : pyMap_compare;
		tp_repr : nil;

		tp_as_number : nil;
		tp_as_sequence : nil;
		tp_as_mapping : nil;

		tp_hash : nil;
		tp_call : nil;
		tp_str : pyMap_Str;
		tp_getattro : nil;
		tp_setattro : nil;

		tp_as_buffer : nil;
		tp_flags : 0;
		tp_doc : nil;

		tp_traverse : nil;

		tp_clear : nil;
		tp_richcompare : nil;

		tp_weaklistoffset : 0;

		tp_iter : nil;
		tp_iternext : nil;

		tp_methods : nil;
		tp_members : nil;
		tp_getset : nil;
		tp_base : nil;
		tp_dict : nil;
		tp_descr_get : nil;
		tp_descr_set : nil;
		tp_dictoffset : 0;
		tp_init : nil;
		tp_alloc : nil;
		tp_new : nil;
		tp_free : nil;
		tp_is_gc : nil;
		tp_bases : nil;
		tp_mro : nil;
		tp_cache : nil;
		tp_subclasses : nil;
		tp_weaklist : nil;
        );

        pyMapMethods : Array[0..1] of PyMethodDef =
                ( ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ),
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

implementation

uses    uPalanthir, uPyPos;

function pyMap_Str( Self : PPyObject ) : PPyObject;
var     MapItem : TMapItem;
begin
        if not pyMap_check( Self ) then begin
                Result := PyReturnNone;
                Exit;
        end;

        MapItem := pyMap_getMap( Self );

        if MapItem <> nil then
                Result := PyString_FromString( PChar( Format( '%d %d %d 0x%x', [MapItem.Pos.X,MapItem.Pos.Y,MapItem.Pos.Z,MapItem.Id] ) ) )
        else
                Result := PyReturnNone;
end;

procedure pyMap_Dealloc( Self : PPyObject );
begin
        PyDealloc( Self );
end;

function pyMap_getAttr( Self : PPyObject; Name : PChar ) : PPyObject;
var     pyMap : PpyMap;
        MapItem : TMapItem;
        TestName : String;
begin
        if not pyMap_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        pyMap := PpyMap( Self );
        MapItem := pyMap_getMap( Self );

        if MapItem = nil then begin
                Result := PyReturnFalse;
                Exit;
        end;

        TestName := LowerCase( Name );

        {
                \property map.id Id
        }
        if TestName = 'id' then begin
                Result := PyInt_FromLong( MapItem.ID );
        end
        {
                \property map.x X
        }
        else if TestName = 'x' then begin
                Result := PyInt_FromLong( MapItem.Pos.X );
        end
        {
                \property map.y Y
        }
        else if TestName = 'y' then begin
                Result := PyInt_FromLong( MapItem.Pos.Y );
        end
        {
                \property map.z Z
        }
        else if TestName = 'z' then begin
                Result := PyInt_FromLong( MapItem.Pos.Z );
        end
        {
                \property map.map Map
        }
        else if TestName = 'map' then begin
                Result := PyInt_FromLong( MapItem.Pos.Map );
        end
        {
                \property map.ismap IsMap
        }
        else if TestName = 'ismap' then begin
                Result := pyInt_FromLong( 1 );
        end
        {
                \property map.isitem IsItem
        }
        {
                \property map.isstatic IsStatic
        }
        {
                \property map.ischar IsChar
        }
        {
                \property map.isplayer IsPlayer
        }
        {
                \property map.iseffect IsEffect
        }
        {
                \property map.ismultiitem IsMultiItem
        }
        else if (TestName = 'isitem') or (TestName = 'isstatic') or (TestName = 'ischar') or
                (TestName = 'isplayer') or (TestName = 'iseffect') or (TestName = 'ismultiitem') then begin
                Result := pyInt_FromLong( 0 );
        end
        {
                \property map.customvars A dictionary to save variables on the item. (see cv)
        }
        {
                \property map.cv A dictionary to save variables on the item. (see customvars)
        }
        else if (TestName = 'customvars') or (TestName = 'cv') then begin
                if MapItem.CustomVars = nil then begin
                        MapItem.CustomVars := PyDict_New;
                end;

                Py_INCREF( MapItem.CustomVars );
                Result := MapItem.CustomVars;
        end
        else begin
                Result := Py_FindMethod( @pyMapMethods, Self, PChar( TestName ) );
        end;
end;

function pyMap_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer;
var     pyMap : PpyMap;
        MapItem : TMapItem;
        TestName : String;
begin
        if not pyMap_check( Self ) then begin
                Result := 1;
                Exit;
        end;

        pyMap := PpyMap( Self );
        MapItem := pyMap_getMap( Self );

        if MapItem = nil then begin
                Result := 1;
                Exit;
        end;

        TestName := LowerCase( Name );

        if TestName = 'id' then begin
                if PyInt_Check( Value ) then begin
                        MapItem.ID := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else begin
                Result := 1;
        end;
end;


function pyMap_compare( Map1, Map2 : PPyObject ) : Integer;
var     Map_1, Map_2 : TMapItem;
begin
        if (not pyMap_check( Map1 )) or (not pyMap_check( Map2 )) then begin
                Result := -1;
                Exit;
        end;

        Map_1 := pyMap_getMap( Map1 );
        Map_2 := pyMap_getMap( Map2 );

        if (Map_1 = nil) or (Map_2 = nil) then begin
                Result := -1;
                Exit;
        end;

        if Map_1 = Map_2 then
                Result := 0
        else
                Result := -1;
end;

function pyMap_getMap( Self : PPyObject ) : TMapItem;
begin
        if not pyMap_check( Self ) then begin
                Result := nil;
                Exit;
        end;

        Result := PpyMap( Self ).MapItem;
end;

function pyMap_check( Self : PPyObject ) : Boolean;
begin
        Result := Self.ob_type = @pyMapType;
end;

function pyGetMap( MapItem : TMapItem ) : PPyObject;
var     pyMap : PpyMap;
begin
        pyMap := PpyMap( PyObject_new( @pyMapType ) );
        pyMap.MapItem := MapItem;
        Result := PPyObject( pyMap );
end;

function pyConvertMap( PyObject : PPyObject; MapItem : P_MapItem ) : Integer;
begin
        if not pyMap_check( PyObject ) then begin
                PyErr_BadArgument;
                Result := 0;
                Exit;
        end;

        MapItem^ := pyMap_getMap( pyObject );
        Result := 1;
end;

end.
