unit uPyMouse;

interface

uses    Python, uMausHandler, uPyUtilities, SysUtils;

{
        \object Mouse
        \description Object to access and change mouse propeties.
}

type    TpyMouse = Record
                ob_refcnt : Integer;
		ob_type : PPyTypeObject;
        end;

        PpyMouse = ^TpyMouse;

function pyMouse_Str( Self : PPyObject ) : PPyObject; cdecl;
function pyMouse_getAttr( Self : PPyObject; Name : PChar ) : PPyObject; cdecl;
function pyMouse_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer; cdecl;
function pyMouse_compare( Mouse1, Mouse2 : PPyObject ) : Integer; cdecl;
function pyMouse_check( Self : PPyObject ) : Boolean;
function pyGetMouse : PPyObject; cdecl;

const pyMouseType : PyTypeObject = (
		ob_refcnt : 0;
		ob_type : nil;
		ob_size : 0;
		tp_name : 'pyMouse';
		tp_basicsize : sizeof( pyMouseType );
                tp_itemsize : 0;

		tp_dealloc : PyDealloc;
		tp_print : nil;
		tp_getattr : pyMouse_getAttr;
		tp_setattr : pyMouse_setAttr;
		tp_compare : pyMouse_compare;
		tp_repr : nil;

		tp_as_number : nil;
		tp_as_sequence : nil;
		tp_as_mapping : nil;

		tp_hash : nil;
		tp_call : nil;
		tp_str : pyMouse_Str;
		tp_getattro : nil;
		tp_setattro : nil;

		tp_as_buffer : nil;
		tp_flags : 0;
		tp_doc : nil;

		tp_traverse : nil;

		tp_clear : nil;
		tp_richcompare : nil;

		tp_weaklistoffset : 0;

		tp_iter : nil;
		tp_iternext : nil;

		tp_methods : nil;
		tp_members : nil;
		tp_getset : nil;
		tp_base : nil;
		tp_dict : nil;
		tp_descr_get : nil;
		tp_descr_set : nil;
		tp_dictoffset : 0;
		tp_init : nil;
		tp_alloc : nil;
		tp_new : nil;
		tp_free : nil;
		tp_is_gc : nil;
		tp_bases : nil;
		tp_mro : nil;
		tp_cache : nil;
		tp_subclasses : nil;
		tp_weaklist : nil;
        );

        pyMouseMethods : Array[0..1] of PyMethodDef =
                ( ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ),
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

implementation

uses    uPalanthir, uPyGumpObject, uPyUODrawObject;

function pyMouse_Str( Self : PPyObject ) : PPyObject;
begin
        Result := PyString_FromString( PChar( 'Mouse' ) );
end;

function pyMouse_getAttr( Self : PPyObject; Name : PChar ) : PPyObject;
var     TestName : String;
begin
        if not pyMouse_check( Self ) then begin
                Result := PyReturnFalse;
                Exit;
        end;

        TestName := LowerCase( Name );

        {
                \property mouse.x Current X position of the mouse.
        }
        if TestName = 'x' then begin
                Result := PyInt_FromLong( Palanthir.Maus.AktX );
        end
        {
                \property mouse.y Current Y position of the mouse.
        }
        else if TestName = 'y' then begin
                Result := PyInt_FromLong( Palanthir.Maus.AktY );
        end
        {
                \property mouse.mx X position of the mouse when the left button was pressed last time if its down, otherwise the same as X.
        }
        else if TestName = 'mx' then begin
                Result := PyInt_FromLong( Palanthir.Maus.MX );
        end
        {
                \property mouse.my Y position of the mouse when the left button was pressed last time if its down, otherwise the same as Y.
        }
        else if TestName = 'my' then begin
                Result := PyInt_FromLong( Palanthir.Maus.MY );
        end
        {
                \property mouse.ldown True if the left mouse buttons is down.
        }
        else if TestName = 'ldown' then begin
                if Palanthir.Maus.LDown then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property mouse.rdown True if the right mouse buttons is down.
        }
        else if TestName = 'ldown' then begin
                if Palanthir.Maus.RDown then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property mouse.isingamewindow True if the mouse cursor is in the gamewindow. (readonly)
        }
        else if TestName = 'isingamewindow' then begin
                if Palanthir.Maus.IsInGameWindow then
                        Result := PyInt_FromLong( 1 )
                else
                        Result := PyInt_FromLong( 0 );
        end
        {
                \property mouse.selectedgumpobject The gumpobject the mouse is over, if there is one. (readonly)
        }
        else if TestName = 'selectedgumpobject' then begin
                Result := PyGetGumpObject( Palanthir.Maus.SelectedGumpObject );
        end
        {
                \property mouse.selecteddownrgumpobject The gumpobject the mouse was over, when the right button went down. (readonly)
        }
        else if TestName = 'selecteddownrgumpobject' then begin
                Result := PyGetGumpObject( Palanthir.Maus.SelectedDownRGumpObject );
        end
        {
                \property mouse.selecteddownlgumpobject The gumpobject the mouse was over, when the left button went down. (readonly)
        }
        else if TestName = 'selecteddownlgumpobject' then begin
                Result := PyGetGumpObject( Palanthir.Maus.SelectedDownLGumpObject );
        end
        {
                \property mouse.selecteduobject The gameobject the mouse is over, if there is one. (readonly)
        }
        else if TestName = 'selecteduobject' then begin
                Result := PyGetUODrawObject( Palanthir.Maus.SelectedUObject );
        end
        {
                \property mouse.selecteddownruobject The gameobject the mouse was over, when the right button went down. (readonly)
        }
        else if TestName = 'selecteddownruobject' then begin
                Result := PyGetUODrawObject( Palanthir.Maus.SelectedDownRUObject );
        end
        {
                \property mouse.selecteddownluobject The gameobject the mouse was over, when the left button went down. (readonly)
        }
        else if TestName = 'selecteddownluobject' then begin
                Result := PyGetUODrawObject( Palanthir.Maus.SelectedDownLUObject );
        end
        {
                \property mouse.dragserial Serial of the you item are dragging.
        }
        else if TestName = 'dragserial' then begin
                Result := PyInt_FromLong( Palanthir.Maus.DragSerial );
        end
        {
                \property mouse.dragid Id of the you item are dragging.
        }
        else if TestName = 'dragid' then begin
                Result := PyInt_FromLong( Palanthir.Maus.DragId );
        end
        {
                \property mouse.dragcolor Color of the you item are dragging.
        }
        else if TestName = 'dragcolor' then begin
                Result := PyInt_FromLong( Palanthir.Maus.DragColor );
        end
        {
                \property mouse.dragamount Amount of the you item are dragging.
        }
        else if TestName = 'dragamount' then begin
                Result := PyInt_FromLong( Palanthir.Maus.DragAmount );
        end
        {
                \property mouse.draglayer Layer of the you item are dragging.
        }
        else if TestName = 'draglayer' then begin
                Result := PyInt_FromLong( Palanthir.Maus.DragLayer );
        end
        else begin
                Result := Py_FindMethod( @pyMouseMethods, Self, PChar( TestName ) );
        end;
end;

function pyMouse_setAttr( Self : PPyObject; Name : PChar; Value : PPyObject ) : Integer;
var     TestName : String;
begin
        if not pyMouse_check( Self ) then begin
                Result := 1;
                Exit;
        end;

        TestName := LowerCase( Name );

        if TestName = 'x' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.AktX := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'y' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.AktY := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'mx' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.MX := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'my' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.MY := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'dragserial' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.DragSerial := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'dragid' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.DragId := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'dragcolor' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.DragColor := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'dragamount' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.DragAmount := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'draglayer' then begin
                if PyInt_Check( Value ) then begin
                        Palanthir.Maus.DragLayer := PyInt_AsLong( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selectedgumpobject' then begin
                if PyGumpObject_Check( Value ) then begin
                        Palanthir.Maus.SelectedGumpObject := pyGumpObject_getGumpObject( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selecteddownrgumpobject' then begin
                if PyGumpObject_Check( Value ) then begin
                        Palanthir.Maus.SelectedDownRGumpObject := pyGumpObject_getGumpObject( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selecteddownlgumpobject' then begin
                if PyGumpObject_Check( Value ) then begin
                        Palanthir.Maus.SelectedDownLGumpObject := pyGumpObject_getGumpObject( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selecteduobject' then begin
                if PyUODrawObject_Check( Value ) then begin
                        Palanthir.Maus.SelectedUObject := pyUODrawObject_getUODrawObject( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selecteddownruobject' then begin
                if PyUODrawObject_Check( Value ) then begin
                        Palanthir.Maus.SelectedDownLUObject := pyUODrawObject_getUODrawObject( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else if TestName = 'selecteddownluobject' then begin
                if PyUODrawObject_Check( Value ) then begin
                        Palanthir.Maus.SelectedDownRUObject := pyUODrawObject_getUODrawObject( Value );
                        Result := 0;
                end
                else begin
                        Result := 1;
                end;
        end
        else begin
                Result := 1;
        end;
end;

function pyMouse_compare( Mouse1, Mouse2 : PPyObject ) : Integer;
begin
        Result := 1;
end;

function pyMouse_check( Self : PPyObject ) : Boolean;
begin
        Result := Self.ob_type = @pyMouseType;
end;

function pyGetMouse : PPyObject;
begin
        Result := PyObject_new( @pyMouseType );
end;

end.
