unit uPyPalanthir;

interface

uses    Python, uLog, uPyUtilities, uPyPacket, uPacket, uPythonGump, uPyGump,
        uGumps, uBasicTypedefs, Classes, uPyConfig, uConfig, uUtilities,
        uSendPackets, uClient, SysUtils, uLoaderTiledata;

function pyPalanthir_log( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getVersion( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_newPacket( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_sendPacket( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_newGump( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getGumpCount( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getGump( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getCustomVars( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getMouse( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getKeyboard( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getConfig( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getShardConfig( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_getCharConfig( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_login( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_returnToLogin( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_close( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_isME( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_registerPacketHandler( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_setShardName( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyPalanthir_openJournal( Self, Args : PPyObject ) : PPyObject; cdecl;
procedure Init_pyPalanthir;

function pyWorld_getChar( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyWorld_getItem( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyWorld_getMap( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyWorld_getStatics( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyWorld_getItems( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyWorld_getChars( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyWorld_getPlayer( Self, Args : PPyObject ) : PPyObject; cdecl;

function pyData_getClilocMessage( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getIntlocMessage( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getStaticArtWidth( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getStaticArtHeight( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getAnimGumpId( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getAmountId( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getLandTileEntry( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getStaticTileEntry( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getSkillName( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_skillHasButton( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getSkillGroup( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getSkillGroupName( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_setSkillGroup( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_setSkillGroupName( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_addSkillGroup( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getSkillGroupCount( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyData_getSkillCount( Self, Args : PPyObject ) : PPyObject; cdecl;

function pyUtilities_encryptPassword( Self, Args : PPyObject ) : PPyObject; cdecl;
function pyUtilities_decryptPassword( Self, Args : PPyObject ) : PPyObject; cdecl;

const   pyPalanthir : Array[0..21] of PyMethodDef =
                ( ( ml_name : 'log'; ml_meth : pyPalanthir_log; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'version'; ml_meth : pyPalanthir_getVersion; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'newpacket'; ml_meth : pyPalanthir_newPacket; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'sendpacket'; ml_meth : pyPalanthir_sendPacket; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'newgump'; ml_meth : pyPalanthir_newGump; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getgumpcount'; ml_meth : pyPalanthir_getGumpCount; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getgump'; ml_meth : pyPalanthir_getGump; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getcv'; ml_meth : pyPalanthir_getCustomVars; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getcustomvars'; ml_meth : pyPalanthir_getCustomVars; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'mouse'; ml_meth : pyPalanthir_getMouse; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'keyboard'; ml_meth : pyPalanthir_getKeyboard; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'config'; ml_meth : pyPalanthir_getConfig; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'shardconfig'; ml_meth : pyPalanthir_getShardConfig; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'charconfig'; ml_meth : pyPalanthir_getCharConfig; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'login'; ml_meth : pyPalanthir_login; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'returntologin'; ml_meth : pyPalanthir_returnToLogin; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'close'; ml_meth : pyPalanthir_close; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'isme'; ml_meth : pyPalanthir_isME; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'registerpackethandler'; ml_meth : pyPalanthir_registerPacketHandler; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'setshardname'; ml_meth : pyPalanthir_setShardName; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'openjournal'; ml_meth : pyPalanthir_openJournal; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

        pyWorld : Array[0..7] of PyMethodDef =
                ( ( ml_name : 'getchar'; ml_meth : pyWorld_getChar; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getitem'; ml_meth : pyWorld_getItem; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getmap'; ml_meth : pyWorld_getMap; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getstatics'; ml_meth : pyWorld_getStatics; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getitems'; ml_meth : pyWorld_getItems; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getchars'; ml_meth : pyWorld_getChars; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getplayer'; ml_meth : pyWorld_getPlayer; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

        pyData : Array[0..17] of PyMethodDef =
                ( ( ml_name : 'getclilocmessage'; ml_meth : pyData_getClilocMessage; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getintlocmessage'; ml_meth : pyData_getIntlocMessage; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getstaticartwidth'; ml_meth : pyData_getStaticArtWidth; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getstaticartheight'; ml_meth : pyData_getStaticArtHeight; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getanimgumpid'; ml_meth : pyData_getAnimGumpId; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getamountid'; ml_meth : pyData_getAmountId; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getlandtileentry'; ml_meth : pyData_getLandTileEntry; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getstatictileentry'; ml_meth : pyData_getStaticTileEntry; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getskillname'; ml_meth : pyData_getSkillName; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'skillhasbutton'; ml_meth : pyData_skillHasButton; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getskillgroup'; ml_meth : pyData_getSkillGroup; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getskillgroupname'; ml_meth : pyData_getSkillGroupName; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'setskillgroup'; ml_meth : pyData_setSkillGroup; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'setskillgroupname'; ml_meth : pyData_setSkillGroupName; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'addskillgroup'; ml_meth : pyData_addSkillGroup; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getskillgroupcount'; ml_meth : pyData_getSkillGroupCount; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'getskillcount'; ml_meth : pyData_getSkillCount; ml_flags : METH_VARARGS; ml_doc : nil ),                  
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );

        pyUtilities : Array[0..2] of PyMethodDef =
                ( ( ml_name : 'encryptpassword'; ml_meth : pyUtilities_encryptPassword; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : 'decryptpassword'; ml_meth : pyUtilities_decryptPassword; ml_flags : METH_VARARGS; ml_doc : nil ),
                  ( ml_name : nil; ml_meth : nil; ml_flags : 0; ml_doc : nil ) );


implementation

uses    uPalanthir, uPyChar, uPyItem, uPyMap, uPyStatic, uChar, uItem, uUObject,
        uPyMouse, uPyKeyboard;

{
        \function palanthir.log
        \param text The Text to write into the log.
        \description Writes some text into the log.
}

function pyPalanthir_log( Self, Args : PPyObject ) : PPyObject;
var     Text : PChar;
begin
        if PyArg_ParseTuple( Args, 's:palanthir.log( text )', [@Text] ) = 0 then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Log.Write( Text );

        Result := PyReturnTrue;
end;

{
        \function palanthir.version
        \return Returns current version of Palanthir.
}

function pyPalanthir_getVersion( Self, Args : PPyObject ) : PPyObject;
begin
        Result := PyInt_FromLong( Version );
end;

{
        \function palanthir.newpacket
        \param id Id of the Packet (first byte)
        \param length Length of the Packet
        \return Returns a <object id="packet">packet</object> object.
        \description Creates a new packet object with given id and length.
        Id does NOT set the second and third byte to packetlength, even if this packet is expected to have it there.
}

function pyPalanthir_newPacket( Self, Args : PPyObject ) : PPyObject;
var     Id : Byte;
        Length : Word;
        Packet : UOPacket;
begin
        if PyArg_ParseTuple( Args, 'bh:palanthir.newpacket( id, length )', [@Id,@Length] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Packet := UOPacket.Create( Id, Length );
        Result := pyGetPacketObject( Packet );
end;

{
        \function palanthir.sendpacket
        \param Packet A <object id="packet">packet</object> object.
        \description Sends the packet to the server.
}

function pyPalanthir_sendPacket( Self, Args : PPyObject ) : PPyObject;
var     Packet : UOPacket;
begin
        if PyArg_ParseTuple( Args, 'O&:palanthir.sendpacket( packet )', [@pyConvertPacketObject,@Packet] ) = 0 then begin
                Result := PyReturnFalse;
                Exit;
        end;

        Palanthir.SendPacket( Packet );
        Result := PyReturnTrue;
end;

{
        \function palanthir.newgump
        \param x X position of the new gump (optional).
        \param y Y position of the new gump (optional).
        \return Returns a <object id="gump">gump</object> object.
        \description Creates a new gump object.
}

function pyPalanthir_newGump( Self, Args : PPyObject ) : PPyObject;
var     Gump : TPythonGump;
        X, Y : Integer;
begin
        X := 0;
        Y := 0;

        if PyArg_ParseTuple( Args, '|ii:palanthir.newgump( [x], [y] )', [@X,@Y] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Gump := TPythonGump.Create;
        Gump.X := X;
        Gump.Y := Y;
        Result := pyGetGump( Gump );
end;

{
        \function palanthir.getgumpcount
        \return Returns the number of gumps in the internal gump list.
}

function pyPalanthir_getGumpCount( Self, Args : PPyObject ) : PPyObject;
begin
        Result := pyInt_FromLong( Palanthir.GetGumpCount );
end;

{
        \function palanthir.getgump
        \param index Index of the gump.
        \return Returns a <object id="gump">gump</object> object.
        \description Returns the gump at the given index in the internal gump list.
}

function pyPalanthir_getGump( Self, Args : PPyObject ) : PPyObject;
var     Gump : TGump;
        Index : Integer;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.getgump( index )', [@Index] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Gump := Palanthir.GetGump( Index );
        if (Gump = nil) or (Gump.Typ <> GumpTyp_PythonGump) then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := pyGetGump( TPythonGump( Gump ) );
end;

{
        \function palanthir.getcv
        \description Returns a dictionary to save variables in.
}

{
        \function palanthir.getcustomvars
        \description Returns a dictionary to save variables in.
}

function pyPalanthir_getCustomVars( Self, Args : PPyObject ) : PPyObject;
begin
        if Palanthir.CustomVars = nil then begin
                Palanthir.CustomVars := PyDict_New;
        end;

        Py_INCREF( Palanthir.CustomVars );
        Result := Palanthir.CustomVars;
end;

{
        \function palanthir.mouse
        \description Returns a the <object id="mouse">mouse</object> object of the client.
}

function pyPalanthir_getMouse( Self, Args : PPyObject ) : PPyObject;
begin
        Result := pyGetMouse();
end;

{
        \function palanthir.keyboard
        \description Returns a the <object id="keyboard">keyboard</object> object of the client.
}

function pyPalanthir_getKeyboard( Self, Args : PPyObject ) : PPyObject;
begin
        Result := pyGetKeyboard();
end;

{
        \function palanthir.config
        \description Returns the global <object id="config">configfile</object> object.
}

function pyPalanthir_getConfig( Self, Args : PPyObject ) : PPyObject;
begin
        Result := pyGetConfig( Config );
end;

{
        \function palanthir.shardconfig
        \description Returns the shard spezific <object id="config">configfile</object> object.
}

function pyPalanthir_getShardConfig( Self, Args : PPyObject ) : PPyObject;
begin
        Result := pyGetConfig( Palanthir.Shard.ShardConfig );
end;

{
        \function palanthir.charconfig
        \description Returns the player spezific <object id="config">configfile</object> object.
}

function pyPalanthir_getCharConfig( Self, Args : PPyObject ) : PPyObject;
begin
        if (Palanthir.Player <> nil) and (Palanthir.Player.CharConfig <> nil) then begin
                Result := pyGetConfig( Palanthir.Player.CharConfig );
        end else begin
                Result := PyReturnNone;
        end;
end;

{
        \function palanthir.login
        \param login
        \param password
        \description Sends a loginrequest to the server.
}

function pyPalanthir_login( Self, Args : PPyObject ) : PPyObject;
var     Login, Password : PChar;
        EncryptionPacket : TEncryptionPacket;
        LoginRequest : TLoginRequest;
        Seed : LongWord;
begin
        if PyArg_ParseTuple( Args, 'ss:palanthir.login( login, password )', [@Login,@Password] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Palanthir.NetClient := TClient.Create( True );
        Palanthir.NetClient.Init( Palanthir.Shard.ShardConfig.GetString( 'IP' ), Palanthir.Shard.ShardConfig.GetInteger( 'Port' ) );
        Palanthir.NetClient.Resume;
        Seed := $FFFFFFFF;
        if Palanthir.Shard.ShardConfig.GetBool( 'ActivateLoginEncryption' ) then
                Palanthir.NetClient.InitClientEncryption( StrToInt( Palanthir.Shard.ShardConfig.GetString( 'LoginKey1' ) ), StrToInt( Palanthir.Shard.ShardConfig.GetString( 'LoginKey2' ) ), Seed, Encrypt_Login );

        EncryptionPacket := TEncryptionPacket.Create( Seed );
        EncryptionPacket.ForceUnencrypted := True;
        Palanthir.NetClient.Send( EncryptionPacket );

        Palanthir.Player.Login := Login;
        Palanthir.Player.Password := Password;

        LoginRequest := TLoginRequest.Create;
        LoginRequest.SetUserID( Palanthir.Player.Login );
        LoginRequest.SetPassword( Palanthir.Player.Password );
        LoginRequest.SetUnknown( $FF );
        Palanthir.NetClient.Send( LoginRequest );

        Result := PyReturnNone;
end;

{
        \function palanthir.returntologin
        \description Disconnects from the server if connected and returns to the logingump.
}

function pyPalanthir_returnToLogin( Self, Args : PPyObject ) : PPyObject;
begin
        Palanthir.ReturnToLoginGump;
        Result := PyReturnNone;
end;

{
        \function palanthir.close
        \description Closes the client.
}

function pyPalanthir_close( Self, Args : PPyObject ) : PPyObject;
begin
        Palanthir.State := State_Ending;
        Result := PyReturnNone;
end;

{
        \function palanthir.isme
        \description Returns true if selected shard is uome, otherwise false.
}

function pyPalanthir_isME( Self, Args : PPyObject ) : PPyObject;
begin
        if Palanthir.MulEncryption then
                Result := PyInt_FromLong( 1 )
        else
                Result := PyInt_FromLong( 0 );
end;

{
        \function palanthir.registerpackethandler
        \param  packetid
        \param  function
        \description Registers a function to be called when the client recieves a packet with the given packetid.
}

function pyPalanthir_registerPacketHandler( Self, Args : PPyObject ) : PPyObject;
var     PacketId : Byte;
        PyFunction : PPyObject;
begin
        if PyTuple_Size( Args ) < 2 then begin
                PyErr_BadArgument;
                Result := PyReturnNone;
                Exit;
        end;

        if not PyInt_Check( PyTuple_GetItem( Args, 0 ) ) then begin
                PyErr_BadArgument;
                Result := PyReturnNone;
                Exit;
        end else begin
                PacketId := PyInt_AsLong( PyTuple_GetItem( Args, 0 ) );
        end;

        if not PyCallable_Check( PyTuple_GetItem( Args, 1 ) ) = 0 then begin
                PyErr_BadArgument;
                Result := PyReturnNone;
                Exit;
        end else begin
                PyFunction := PyTuple_GetItem( Args, 1 );
        end;

        Palanthir.ScriptManager.RegisterPacketHandler( PacketId, PyFunction );
        Result := PyReturnNone;
end;

{
        \function palanthir.setshardname
        \param  name
        \description Sets the internal shard name.
}

function pyPalanthir_setShardName( Self, Args : PPyObject ) : PPyObject;
var     Name : PChar;
begin
        if PyArg_ParseTuple( Args, 's:palanthir.setshardname( name )', [@Name] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Palanthir.SetShardName( Name );
        Result := PyReturnNone;
end;

{
        \function palanthir.openjournal
        \description Opens the journal.
}

function pyPalanthir_openJournal( Self, Args : PPyObject ) : PPyObject;
begin
        Palanthir.Player.Journal.Visible := True;
        Palanthir.Player.Journal.Rolle := False;
        Result := PyReturnNone;
end;

{
        \function palanthir.world.getchar
        \param Serial
        \return Returns a <object id="char">char</object> object.
        \description Returns the char object from the serial.
}

function pyWorld_getChar( Self, Args : PPyObject ) : PPyObject;
var     Serial : LongWord;
        UObject : TUObject;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.world.getchar( serial )', [@Serial] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        UObject := Palanthir.Data.GlobalObjectList.GetObject( Serial );

        if (UObject <> nil) and UObject.IsChar then begin
                Result := pyGetChar( TChar( UObject ) );
        end
        else begin
                Result := pyReturnNone;
        end;
end;

{
        \function palanthir.world.getitem
        \param Serial
        \return Returns a <object id="item">item</object> object.
        \description Returns the item object from the serial.
}

function pyWorld_getItem( Self, Args : PPyObject ) : PPyObject;
var     Serial : Integer;
        UObject : TUObject;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.world.getitem( serial )', [@Serial] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        UObject := Palanthir.Data.GlobalObjectList.GetObject( Serial );

        if (UObject <> nil) and UObject.IsItem then begin
                Result := pyGetItem( TItem( UObject ) );
        end
        else begin
                Result := pyReturnNone;
        end;
end;

{
        \function palanthir.world.getmap
        \param x
        \param y
        \return Returns a <object id="map">map</object> object.
        \description Returns the map object at the given position.
}

function pyWorld_getMap( Self, Args : PPyObject ) : PPyObject;
var     X, Y : Integer;
        MapItem : TMapItem;
begin
        if PyArg_ParseTuple( Args, 'ii:palanthir.world.getmap( x, y )', [@X,@Y] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        MapItem := Palanthir.Data.WorldCache.GetMapItem( X, Y );

        if MapItem <> nil then begin
                Result := pyGetMap( MapItem );
        end
        else begin
                Result := pyReturnNone;
        end;
end;

{
        \function palanthir.world.getstatics
        \param x
        \param y
        \return Returns a list of <object id="static">static</object> objects.
        \description Returns the static objects at the given position.
}

function pyWorld_getStatics( Self, Args : PPyObject ) : PPyObject;
var     X, Y, I : Integer;
        List : TList;
        PyStatic : PPyObject;
begin
        if PyArg_ParseTuple( Args, 'ii:palanthir.world.getstatics( x, y )', [@X,@Y] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        List := Palanthir.Data.WorldCache.GetStaticObjects( X, Y );

        Result := PyList_New( 0 );

        for I := 0 to List.Count-1 do begin
                PyStatic := PyGetStatic( TStaticItem( List.Items[ I ] ) );
                PyList_Append( Result, PyStatic );
                Py_DECREF( PyStatic );
        end;

        List.Free;
end;

{
        \function palanthir.world.getitems
        \param x
        \param y
        \return Returns a list of <object id="item">item</object> objects.
        \description Returns the item objects at the given position.
}

function pyWorld_getItems( Self, Args : PPyObject ) : PPyObject;
var     X, Y, I : Integer;
        List : TList;
        PyItem : PPyObject;
begin
        if PyArg_ParseTuple( Args, 'ii:palanthir.world.getitems( x, y )', [@X,@Y] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        List := Palanthir.Data.WorldCache.GetItems( X, Y );

        Result := PyList_New( 0 );

        for I := 0 to List.Count-1 do begin
                PyItem := PyGetItem( TItem( List.Items[ I ] ) );
                PyList_Append( Result, PyItem );
                Py_DECREF( PyItem );
        end;

        List.Free;
end;

{
        \function palanthir.world.getchars
        \param x
        \param y
        \return Returns a list of <object id="char">char</object> objects.
        \description Returns the char objects at the given position.
}

function pyWorld_getChars( Self, Args : PPyObject ) : PPyObject;
var     X, Y, I : Integer;
        List : TList;
        PyChar : PPyObject;
begin
        if PyArg_ParseTuple( Args, 'ii:palanthir.world.getchars( x, y )', [@X,@Y] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        List := Palanthir.Data.WorldCache.GetChars( X, Y );

        Result := PyList_New( 0 );

        for I := 0 to List.Count-1 do begin
                PyChar := PyGetChar( TChar( List.Items[ I ] ) );
                PyList_Append( Result, PyChar );
                Py_DECREF( PyChar );
        end;

        List.Free;
end;

{
        \function palanthir.world.getplayer
        \return Returns a <object id="char">char</object> object.
        \description Returns the player object.
}

function pyWorld_getPlayer( Self, Args : PPyObject ) : PPyObject;
begin
        Result := PyGetChar( Palanthir.Player );
end;

{
        \function palanthir.data.getclilocmessage
        \param id
        \description Returns the cliloc entry.
}

function pyData_getClilocMessage( Self, Args : PPyObject ) : PPyObject;
var     Id : LongWord;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.data.getclilocmessage( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyString_FromString( PChar( Palanthir.Data.GetClilocMessage( Id ) ) );
end;

{
        \function palanthir.data.getintlocmessage
        \param id
        \param filenr
        \description Returns the intloc entry.
}

function pyData_getIntlocMessage( Self, Args : PPyObject ) : PPyObject;
var     Id : Word;
        FileNr : Byte;
begin
        if PyArg_ParseTuple( Args, 'hb:palanthir.data.getintlocmessage( id, filenr )', [@Id,@FileNr] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyString_FromString( PChar( Palanthir.Data.GetIntlocMessage( FileNr, Id ) ) );
end;

{
        \function palanthir.data.getstaticartwidth
        \param id
        \description Returns the width of the static art graphic.
}

function pyData_getStaticArtWidth( Self, Args : PPyObject ) : PPyObject;
var     Id : Word;
begin
        if PyArg_ParseTuple( Args, 'h:palanthir.data.getstaticartwidth( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyInt_FromLong( Palanthir.Data.GetStaticArtWidth( Id ) );
end;

{
        \function palanthir.data.getstaticartheight
        \param id
        \description Returns the height of the static art graphic.
}

function pyData_getStaticArtHeight( Self, Args : PPyObject ) : PPyObject;
var     Id : Word;
begin
        if PyArg_ParseTuple( Args, 'h:palanthir.data.getstaticartheight( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyInt_FromLong( Palanthir.Data.GetStaticArtHeight( Id ) );
end;

{
        \function palanthir.data.getanimgumpid
        \param  id
        \description Returns the paperdoll gumpid for a given animid as defined in anim2paperdoll.txt.
}

function pyData_getAnimGumpId( Self, Args : PPyObject ) : PPyObject;
var     Id : Word;
begin
        if PyArg_ParseTuple( Args, 'h:palanthir.data.getanimgumpid( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyInt_FromLong( Palanthir.Shard.GetAnimGumpId( Id ) );
end;

{
        \function palanthir.data.getamountid
        \param  baseid
        \param  amount
        \description Returns the id that should be shown instead of the baseid when the amount is > 1, as defined in amount.txt.
}

function pyData_getAmountId( Self, Args : PPyObject ) : PPyObject;
var     BaseId : Word;
        Amount : Word;
begin
        if PyArg_ParseTuple( Args, 'hh:palanthir.data.getamountid( baseid, amount )', [@BaseId,@Amount] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyInt_FromLong( Palanthir.Shard.GetAmountId( BaseId, Amount ) );
end;

{
        \function palanthir.data.getlandtileentry
        \param  id
        \return Returns a dictionary with the following keys:
        - <code>name</code>
        - <code>texid</code>

        - <code>background</code>
        - <code>weapon</code>
        - <code>transparent</code>
        - <code>translucent</code>
        - <code>wall</code>
        - <code>damaging</code>
        - <code>impassable</code>
        - <code>liquid</code>

        - <code>unknown1</code>
        - <code>surface</code>
        - <code>bridge</code>
        - <code>generic</code>
        - <code>window</code>
        - <code>noshoot</code>
        - <code>a</code>
        - <code>an</code>

        - <code>mongen</code>
        - <code>foliage</code>
        - <code>partialhue</code>
        - <code>unknown2</code>
        - <code>map</code>
        - <code>container</code>
        - <code>wearable</code>
        - <code>lightsource</code>

        - <code>animation</code>
        - <code>nodiagonal</code>
        - <code>unknown3</code>
        - <code>armor</code>
        - <code>roof</code>
        - <code>door</code>
        - <code>stairback</code>
        - <code>stairright</code>
}

function pyData_getLandTileEntry( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.data.getlandtileentry( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyDict_New;
        PyDict_SetStolenItem( Result, 'name', PyString_FromString( PChar( Palanthir.Data.Tiledata.GetLandName( Id ) ) ) );
        PyDict_SetStolenItem( Result, 'texid', PyInt_FromLong( Palanthir.Data.Tiledata.GetLandTexId( Id ) ) );

        PyDict_SetStolenItem( Result, 'background', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dBACKGROUND ) ) );
        PyDict_SetStolenItem( Result, 'weapon', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dWEAPON ) ) );
        PyDict_SetStolenItem( Result, 'transparent', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dTRANSPARENT ) ) );
        PyDict_SetStolenItem( Result, 'translucent', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dTRANSLUCENT ) ) );
        PyDict_SetStolenItem( Result, 'wall', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dWALL ) ) );
        PyDict_SetStolenItem( Result, 'damaging', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dDAMAGING ) ) );
        PyDict_SetStolenItem( Result, 'impassable', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dIMPASSABLE ) ) );
        PyDict_SetStolenItem( Result, 'liquid', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dLIQUID ) ) );

        PyDict_SetStolenItem( Result, 'unknown1', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dUNKNOWN1 ) ) );
        PyDict_SetStolenItem( Result, 'surface', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dSURFACE ) ) );
        PyDict_SetStolenItem( Result, 'bridge', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dBRIDGE ) ) );
        PyDict_SetStolenItem( Result, 'generic', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dGENERIC ) ) );
        PyDict_SetStolenItem( Result, 'window', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dWINDOW ) ) );
        PyDict_SetStolenItem( Result, 'noshoot', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dNOSHOOT ) ) );
        PyDict_SetStolenItem( Result, 'a', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dA ) ) );
        PyDict_SetStolenItem( Result, 'an', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dAN ) ) );

        PyDict_SetStolenItem( Result, 'mongen', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dMONGEN ) ) );
        PyDict_SetStolenItem( Result, 'foliage', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dFOLIAGE ) ) );
        PyDict_SetStolenItem( Result, 'partialhue', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dPARTIALHUE ) ) );
        PyDict_SetStolenItem( Result, 'unknown2', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dUNKNOWN2 ) ) );
        PyDict_SetStolenItem( Result, 'map', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dMAP ) ) );
        PyDict_SetStolenItem( Result, 'container', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dCONTAINER ) ) );
        PyDict_SetStolenItem( Result, 'wearable', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dWEARABLE ) ) );
        PyDict_SetStolenItem( Result, 'lightsource', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dLIGHTSOURCE ) ) );

        PyDict_SetStolenItem( Result, 'animation', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dANIMATION ) ) );
        PyDict_SetStolenItem( Result, 'nodiagonal', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dNODIAGONAL ) ) );
        PyDict_SetStolenItem( Result, 'unknown3', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dUNKNOWN3 ) ) );
        PyDict_SetStolenItem( Result, 'armor', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dARMOR ) ) );
        PyDict_SetStolenItem( Result, 'roof', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dROOF ) ) );
        PyDict_SetStolenItem( Result, 'door', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dDOOR ) ) );
        PyDict_SetStolenItem( Result, 'stairback', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dSTAIRBACK ) ) );
        PyDict_SetStolenItem( Result, 'stairright', PyConvertBool( Palanthir.Data.Tiledata.GetLandFlag( Id, dSTAIRRIGHT ) ) );
end;

{
        \function palanthir.data.getstatictileentry
        \param  id
        \return Returns a dictionary with the following keys:
        - <code>name</code>
        - <code>animid</code>
        - <code>height</code>
        - <code>hue</code>
        - <code>quality</code>
        - <code>quantity</code>
        - <code>weight</code>
        - <code>unknown1</code>
        - <code>unknown2</code>
        - <code>unknown3</code>
        - <code>unknown4</code>
        - <code>unknown5</code>

        - <code>background</code>
        - <code>weapon</code>
        - <code>transparent</code>
        - <code>translucent</code>
        - <code>wall</code>
        - <code>damaging</code>
        - <code>impassable</code>
        - <code>liquid</code>

        - <code>unknown1</code>
        - <code>surface</code>
        - <code>bridge</code>
        - <code>generic</code>
        - <code>window</code>
        - <code>noshoot</code>
        - <code>a</code>
        - <code>an</code>

        - <code>mongen</code>
        - <code>foliage</code>
        - <code>partialhue</code>
        - <code>unknown2</code>
        - <code>map</code>
        - <code>container</code>
        - <code>wearable</code>
        - <code>lightsource</code>

        - <code>animation</code>
        - <code>nodiagonal</code>
        - <code>unknown3</code>
        - <code>armor</code>
        - <code>roof</code>
        - <code>door</code>
        - <code>stairback</code>
        - <code>stairright</code>
}

function pyData_getStaticTileEntry( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.data.getstatictileentry( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyDict_New;
        PyDict_SetStolenItem( Result, 'name', PyString_FromString( PChar( Palanthir.Data.Tiledata.GetStaticName( Id ) ) ) );
        PyDict_SetStolenItem( Result, 'animid', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticAnimId( Id ) ) );
        PyDict_SetStolenItem( Result, 'height', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticHeight( Id ) ) );
        PyDict_SetStolenItem( Result, 'hue', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticHue( Id ) ) );
        PyDict_SetStolenItem( Result, 'quality', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticQuality( Id ) ) );
        PyDict_SetStolenItem( Result, 'quantity', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticQuantity( Id ) ) );
        PyDict_SetStolenItem( Result, 'weight', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticWeight( Id ) ) );
        PyDict_SetStolenItem( Result, 'unknown1', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticUnknown1( Id ) ) );
        PyDict_SetStolenItem( Result, 'unknown2', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticUnknown2( Id ) ) );
        PyDict_SetStolenItem( Result, 'unknown3', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticUnknown3( Id ) ) );
        PyDict_SetStolenItem( Result, 'unknown4', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticUnknown4( Id ) ) );
        PyDict_SetStolenItem( Result, 'unknown5', PyInt_FromLong( Palanthir.Data.Tiledata.GetStaticUnknown5( Id ) ) );

        PyDict_SetStolenItem( Result, 'background', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dBACKGROUND ) ) );
        PyDict_SetStolenItem( Result, 'weapon', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dWEAPON ) ) );
        PyDict_SetStolenItem( Result, 'transparent', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dTRANSPARENT ) ) );
        PyDict_SetStolenItem( Result, 'translucent', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dTRANSLUCENT ) ) );
        PyDict_SetStolenItem( Result, 'wall', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dWALL ) ) );
        PyDict_SetStolenItem( Result, 'damaging', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dDAMAGING ) ) );
        PyDict_SetStolenItem( Result, 'impassable', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dIMPASSABLE ) ) );
        PyDict_SetStolenItem( Result, 'liquid', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dLIQUID ) ) );

        PyDict_SetStolenItem( Result, 'unknown1', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dUNKNOWN1 ) ) );
        PyDict_SetStolenItem( Result, 'surface', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dSURFACE ) ) );
        PyDict_SetStolenItem( Result, 'bridge', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dBRIDGE ) ) );
        PyDict_SetStolenItem( Result, 'generic', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dGENERIC ) ) );
        PyDict_SetStolenItem( Result, 'window', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dWINDOW ) ) );
        PyDict_SetStolenItem( Result, 'noshoot', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dNOSHOOT ) ) );
        PyDict_SetStolenItem( Result, 'a', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dA ) ) );
        PyDict_SetStolenItem( Result, 'an', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dAN ) ) );

        PyDict_SetStolenItem( Result, 'mongen', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dMONGEN ) ) );
        PyDict_SetStolenItem( Result, 'foliage', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dFOLIAGE ) ) );
        PyDict_SetStolenItem( Result, 'partialhue', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dPARTIALHUE ) ) );
        PyDict_SetStolenItem( Result, 'unknown2', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dUNKNOWN2 ) ) );
        PyDict_SetStolenItem( Result, 'map', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dMAP ) ) );
        PyDict_SetStolenItem( Result, 'container', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dCONTAINER ) ) );
        PyDict_SetStolenItem( Result, 'wearable', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dWEARABLE ) ) );
        PyDict_SetStolenItem( Result, 'lightsource', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dLIGHTSOURCE ) ) );

        PyDict_SetStolenItem( Result, 'animation', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dANIMATION ) ) );
        PyDict_SetStolenItem( Result, 'nodiagonal', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dNODIAGONAL ) ) );
        PyDict_SetStolenItem( Result, 'unknown3', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dUNKNOWN3 ) ) );
        PyDict_SetStolenItem( Result, 'armor', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dARMOR ) ) );
        PyDict_SetStolenItem( Result, 'roof', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dROOF ) ) );
        PyDict_SetStolenItem( Result, 'door', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dDOOR ) ) );
        PyDict_SetStolenItem( Result, 'stairback', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dSTAIRBACK ) ) );
        PyDict_SetStolenItem( Result, 'stairright', PyConvertBool( Palanthir.Data.Tiledata.GetStaticFlag( Id, dSTAIRRIGHT ) ) );
end;

{
        \function palanthir.data.getskillname
        \param id
        \description Returns the name of the skill with the given id.
}

function pyData_getSkillName( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.data.getskillname( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyString_FromString( PChar( Palanthir.Data.GetSkillName( Id ) ) );
end;

{
        \function palanthir.data.skillhasbutton
        \param id
        \description Returns true if the skill with the given id has a button.
}

function pyData_skillHasButton( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.data.skillhasbutton( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        if Palanthir.Data.SkillHasButton( Id ) then
                Result := PyInt_FromLong( 1 )
        else
                Result := PyInt_FromLong( 0 );
end;

{
        \function palanthir.data.getskillgroup
        \param id
        \description Returns the name of the skill with the given id.
}

function pyData_getSkillGroup( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.data.getskillgroup( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyInt_FromLong( Palanthir.Data.GetSkillGroup( Id ) );
end;

{
        \function palanthir.data.getskillgroupname
        \param id
        \description Returns the name of the skill with the given id.
}

function pyData_getSkillGroupName( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
begin
        if PyArg_ParseTuple( Args, 'i:palanthir.data.getskillgroupname( id )', [@Id] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyString_FromString( PChar( Palanthir.Data.GetSkillGroupName( Id ) ) );
end;

{
        \function palanthir.data.setskillgroup
        \param id
        \param group
        \description Sets the skillgroup of the skill with the given id.
}

function pyData_setSkillGroup( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
        Group : Byte;
begin
        if PyArg_ParseTuple( Args, 'ib:palanthir.data.setskillgroup( id, group )', [@Id,@Group] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Palanthir.Data.SetSkillGroup( Id, Group );
        Result := PyReturnTrue;
end;

{
        \function palanthir.data.setskillgroupname
        \param id
        \param name
        \description Sets the name of the skill with the given id.
}

function pyData_setSkillGroupName( Self, Args : PPyObject ) : PPyObject;
var     Id : Integer;
        Name : PChar;
begin
        if PyArg_ParseTuple( Args, 'is:palanthir.data.setskillgroupname( id, name )', [@Id,@Name] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Palanthir.Data.SetSkillGroupName( Id, Name );
        Result := PyReturnTrue;
end;

{
        \function palanthir.data.addskillgroup
        \param name
        \return Id of the new skillgroup.
        \description Adds a skillgroup with the given name.
}

function pyData_addSkillGroup( Self, Args : PPyObject ) : PPyObject;
var     Name : PChar;
begin
        if PyArg_ParseTuple( Args, 's:palanthir.data.addskillgroup( name )', [@Name] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyInt_FromLong( Palanthir.Data.AddSkillGroup( Name ) );
end;

{
        \function palanthir.data.getskillgroupcount
        \description Returns the number of existing skillgroups.
}

function pyData_getSkillGroupCount( Self, Args : PPyObject ) : PPyObject;
begin
        Result := PyInt_FromLong( Palanthir.Data.GetSkillGroupCount );
end;

{
        \function palanthir.data.getskillcount
        \description Returns the number of existing skills.
}

function pyData_getSkillCount( Self, Args : PPyObject ) : PPyObject;
begin
        Result := PyInt_FromLong( Palanthir.Data.GetSkillCount );
end;

{
        \function palanthir.utilities.encryptpassword
        \param password
        \description Encrypts the password.
}

function pyUtilities_encryptPassword( Self, Args : PPyObject ) : PPyObject;
var     Password : PChar;
begin
        if PyArg_ParseTuple( Args, 's:palanthir.utilities.encryptpassword( password )', [@Password] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyString_FromString( PChar( EncryptPassword( Password ) ) );
end;

{
        \function palanthir.utilities.decryptpassword
        \param password
        \description Decrypts the password.
}

function pyUtilities_decryptPassword( Self, Args : PPyObject ) : PPyObject;
var     Password : PChar;
begin
        if PyArg_ParseTuple( Args, 's:palanthir.utilities.decryptpassword( password )', [@Password] ) = 0 then begin
                Result := PyReturnNone;
                Exit;
        end;

        Result := PyString_FromString( PChar( DecryptPassword( Password ) ) );
end;

procedure Init_pyPalanthir;
var     Namespace : PPyObject;
        World : PPyObject;
        Data : PPyObject;
        Utilities : PPyObject;
begin
        Namespace := Py_InitModule( 'palanthir', @pyPalanthir );

        World := Py_InitModule( 'world', @pyWorld );
        PyObject_SetAttrString( Namespace, 'world', World );

        Data := Py_InitModule( 'data', @pyData );
        PyObject_SetAttrString( Namespace, 'data', Data );

        Utilities := Py_InitModule( 'utilities', @pyUtilities );
        PyObject_SetAttrString( Namespace, 'utilities', Utilities );
end;

end.

