unit uPyUODrawObject;

interface

uses    Python, SysUtils, uBasicTypedefs, uPyUtilities;

function pyGetUODrawObject( UODrawObject : TUODrawObject ) : PPyObject; cdecl;
function pyUODrawObject_getUODrawObject( Self : PPyObject ) : TUODrawObject;
function pyUODrawObject_Check( Self : PPyObject ) : Boolean;
function pyConvertUODrawObject( PyObject : PPyObject; UODrawObject : P_UODrawObject ) : Integer; cdecl;

implementation

uses    uPyMap, uPyStatic, uPyItem, uPyChar, uChar, uItem;

function pyGetUODrawObject( UODrawObject : TUODrawObject ) : PPyObject;
begin
        if UODrawObject = nil then begin
                Result := PyReturnNone;
                Exit;
        end;

        if UODrawObject.IsMap then begin
                Result := PyGetMap( TMapItem( UODrawObject ) );
        end
        else if UODrawObject.IsStatic then begin
                Result := PyGetStatic( TStaticItem( UODrawObject ) );
        end
        else if UODrawObject.IsItem then begin
                Result := PyGetItem( TItem( UODrawObject ) );
        end
        else if UODrawObject.IsChar then begin
                Result := PyGetChar( TChar( UODrawObject ) );
        end
        else begin
                Result := PyReturnNone;
        end;
end;

function pyUODrawObject_getUODrawObject( Self : PPyObject ) : TUODrawObject;
begin
        if PyMap_Check( Self ) then begin
                Result := PyMap_getMap( Self );
        end else if PyStatic_Check( Self ) then begin
                Result := PyStatic_getStatic( Self );
        end else if PyItem_Check( Self ) then begin
                Result := PyItem_getItem( Self );
        end else if PyChar_Check( Self ) then begin
                Result := PyChar_getChar( Self );
        end else begin
                PyErr_BadArgument;
                Result := nil;
        end;
end;

function pyUODrawObject_Check( Self : PPyObject ) : Boolean;
begin
        if PyMap_Check( Self ) then begin
                Result := True;
        end else if PyStatic_Check( Self ) then begin
                Result := True;
        end else if PyItem_Check( Self ) then begin
                Result := True;
        end else if PyChar_Check( Self ) then begin
                Result := True;
        end else begin
                Result := False;
        end;
end;

function pyConvertUODrawObject( PyObject : PPyObject; UODrawObject : P_UODrawObject ) : Integer;
begin
        UODrawObject^ := pyUODrawObject_getUODrawObject( PyObject );
        if UODrawObject^ <> nil then
                Result := 1
        else
                Result := 0;
end;

end.
