unit uPyUtilities;

interface

uses    Python;

function PyReturnNone : PPyObject;
function PyReturnTrue : PPyObject;
function PyReturnFalse : PPyObject;
procedure PyDealloc( Self : PPyObject ); cdecl;
procedure PyDict_SetStolenItem( Dict : PPyObject; Key : PChar; Item : PPyObject );
procedure PyList_AppendStolen( List : PPyObject; Item : PPyObject );
function PyConvertBool( Value : Boolean ) : PPyObject;

implementation

function PyReturnNone : PPyObject;
begin
        Py_XINCREF( Py_None );
        Result := Py_None;
end;

function PyReturnTrue : PPyObject;
begin
        Py_XINCREF( PPyObject( Py_True ) );
        Result := PPyObject( Py_True );
end;

function PyReturnFalse : PPyObject;
begin
        Py_XINCREF( PPyObject( Py_False ) );
        Result := PPyObject( Py_False );
end;

procedure PyDealloc( Self : PPyObject );
begin
        PyObject_Free( Self );
end;

procedure PyDict_SetStolenItem( Dict : PPyObject; Key : PChar; Item : PPyObject );
begin
        PyDict_SetItemString( Dict, Key, Item );
        Py_DECREF( Item );
end;

procedure PyList_AppendStolen( List : PPyObject; Item : PPyObject );
begin
        PyList_Append( List, Item );
        Py_DECREF( Item );
end;

function PyConvertBool( Value : Boolean ) : PPyObject;
begin
        if Value then
                Result := PyInt_FromLong( 1 )
        else
                Result := PyInt_FromLong( 0 );
end;

end.
