program Client;

uses
  madExcept,
  madLinkDisAsm,
  Forms,
  SysUtils,
  Dialogs,
  uConfig in 'uConfig.pas',
  uFileCache in 'uFileCache.pas',
  uLog in 'uLog.pas',
  uUtilities in 'uUtilities.pas',
  md5 in '..\Network\MD5.pas',
  uAutoPatcher in '..\Forms\uAutoPatcher.pas' {Patcher},
  uAutoupdate in '..\Forms\uAutoupdate.pas' {Autoupdate},
  uGlobalSettings in '..\Forms\uGlobalSettings.pas' {GlobalSettings},
  uMessageForm in '..\Forms\uMessageForm.pas' {MessageForm},
  uShardSelect in '..\Forms\uShardSelect.pas' {ShardSelect},
  uShardSettings in '..\Forms\uShardSettings.pas' {ShardSettings},
  uSpecialInput in '..\Forms\uSpecialInput.pas' {InputForm},
  uMulCrypt in '..\Palanthir\uMulCrypt.pas',
  uCheckRunning in 'uCheckRunning.pas',
  uIrisUpdate in '..\Forms\uIrisUpdate.pas' {IrisUpdate},
  uIrisConfig in '..\Forms\uIrisConfig.pas' {IrisConfigForm};

{$R *.res}

begin
        uLog.Log := TLog.Create( ExtractFilePath( Application.ExeName ) + 'starterlog.txt' );
        if not uLog.Log.Init then begin
                uLog.Log.Free;
                ShowMessage( Format( 'Could not open %sstarterlog.txt', [ExtractFilePath( Application.ExeName )] ) );
                exit;
        end;
        uConfig.Config := TConfig.Create;
        try
                uConfig.Config.Load( ExtractFilePath( Application.ExeName ) + 'config.xml' );
        except
                ShowMessage( Format( 'Could not open %sconfig.xml', [ExtractFilePath( Application.ExeName )] ) );
                exit;
        end;

        Application.Initialize;
        Application.Title := 'Ultima Online Starter';
        Application.ShowMainForm := False;
        Application.CreateForm(TShardSelect, ShardSelect);
        Application.CreateForm(TShardSettings, ShardSettings);
        Application.CreateForm(TPatcher, Patcher);
        Application.CreateForm(TGlobalSettings, GlobalSettings);
        Application.CreateForm(TMessageForm, MessageForm);
        Application.CreateForm(TInputForm, InputForm);
        Application.CreateForm(TIrisConfigForm, IrisConfigForm);
        Application.Run;

        uConfig.Config.Free;
        uLog.Log.Free;        
end.
