unit uFileCache;

interface

uses    SysUtils, Classes, uUtilities, Dialogs, uLog;

type    TFileStreamRecord = Class
                public
                        FileName : String;
                        Stream : TFileStream;                
                        constructor Create( Dir, Name : String );
                        destructor Free;
        end;

        TFileCache = Class
                private
                        Cache : TList;
                        Dir : String;
                public
                        constructor Create( NewDir : String );
                        destructor Free;
                        function GetFileStream( FileName : String ) : TFileStream;
                        procedure FreeFile( FileName : String );
                        procedure Clear;
        end;

implementation

uses    uAutoPatcher;

constructor TFileStreamRecord.Create( Dir, Name : String );
begin
        FileName := Name;
        try
                if FileExists( Dir + Name ) then
                        Stream := TFileStream.Create( Dir + Name, fmOpenReadWrite )
                else
                        Stream := TFileStream.Create( Dir + Name, fmCreate );
        except
                on E : Exception do
                        raise Exception.Create( E.Message );
        end;
end;

destructor TFileStreamRecord.Free;
begin
        try
                Stream.Free;
        except
                on E : Exception do
                        raise Exception.Create( E.Message );
        end;
end;

constructor TFileCache.Create( NewDir : String );
begin
        Dir := NewDir;
        Cache := TList.Create;
end;

destructor TFileCache.Free;
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do begin
                try
                        TFileStreamRecord( Cache.Items[ I ] ).Free;
                except
                        on E : Exception do
                                raise Exception.Create( E.Message );
                end;
        end;
        Cache.Free;
end;

function TFileCache.GetFileStream( FileName : String ) : TFileStream;
var     I : Integer;
        FileStreamRecord : TFileStreamRecord;
begin
        for I := 0 to Cache.Count-1 do begin
                if LowerCase( TFileStreamRecord( Cache.Items[ I ] ).FileName ) = LowerCase( FileName ) then begin
                        Result := TFileStreamRecord( Cache.Items[ I ] ).Stream;
                        exit;
                end;
        end;

        //file is not cached yet
        Patcher.Log( Format( 'ffne %s.', [FileName] ) );
        FileStreamRecord := TFileStreamRecord.Create( Dir, Filename );
        Patcher.Log( Format( '%s geffnet.', [FileName] ) );        
        Cache.Add( FileStreamRecord );
        Result := FileStreamRecord.Stream;
end;

procedure TFileCache.FreeFile( FileName : String );
var     I : Integer;
begin
        for I := 0 to Cache.Count-1 do begin
                if LowerCase( TFileStreamRecord( Cache.Items[ I ] ).FileName ) = LowerCase( FileName ) then begin
                        TFileStreamRecord( Cache.Items[ I ] ).Free;
                        Cache.Delete( I );
                        exit;
                end;
        end;
end;

procedure TFileCache.Clear;
var     I : Integer;
begin
        for I := Cache.Count-1 downto 0 do begin
                TFileStreamRecord( Cache.Items[ I ] ).Free;
                Cache.Delete( I );
        end;
end;

end.
