unit uLog;

interface

uses    SysUtils, Classes;

type    TLog = Class
                private
                        FileName : String;
                        Datei : TextFile;
                        Enabled : Boolean;
                public
                        constructor Create( FileName : String );
                        destructor Free;
                        function Init : Boolean;
                        procedure Write( Liste : TStringList ); overload;
                        procedure Write( Zeile : String ); overload;
        end;

var     Log : TLog;

implementation

constructor TLog.Create( FileName : String );
begin
        Self.FileName := FileName;
        Enabled := False;
end;

destructor TLog.Free;
begin
        if Enabled then
                CloseFile( Datei );
end;

function TLog.Init : Boolean;
begin
        try
                if FileExists( FileName ) then
                        DeleteFile( FileName );

                AssignFile( Datei, Filename );
                {$I-}
                ReWrite( Datei );
                {$I+}

                Write( 'Logging initialized.' );

                Result := True;
                Enabled := True;
        except
                Result := False;
        end;
end;

procedure TLog.Write( Liste : TStringList );
var     I : Integer;
begin
        if Liste.Count > 0 then
                for I := 0 to Liste.Count-1 do
                        WriteLn( Datei, Liste.Strings[I] );
        Liste.Free;
end;

procedure TLog.Write( Zeile : String );
begin
        WriteLn( Datei, Zeile );
        Flush( Datei );
end;

end.
