unit uUtilities;

interface

uses Math, ShellApi, Windows, DCPRijndael, SysUtils;

const   Color_Grayify = -1;

        Encrypt_None = 0;
        Encrypt_Login = 1;
        Encrypt_Twofish = 2;

type    TIndexRecord = packed record
                case Integer of
                        0: ( Lookup, Length, Tag : Integer );
                        1: ( B : array [0..11] of Byte );
                end;

function Color15toBlue( Zahl : Word ) : Byte;
function Color15toGreen( Zahl : Word ) : Byte;
function Color15toRed( Zahl : Word ) : Byte;
function GetNextBit( Zahl : LongWord ) : LongWord;
function DelDir( Dir: string ): Boolean;
function RenameDir( OldDir, NewDir: string ): Boolean;
function CustomGetTickCount : LongWord;
function DecryptPassword( Pass : String ) : String;
function EncryptPassword( Pass : String ) : String;

implementation

function Color15toBlue( Zahl : Word ) : Byte;
begin
        Result := ( Zahl and $1F ) * 8;
end;

function Color15toGreen( Zahl : Word ) : Byte;
begin
        Result := ( ( Zahl shr 5 ) and $1F ) * 8;
end;

function Color15toRed( Zahl : Word ) : Byte;
begin
        Result := ( ( Zahl shr 10 ) and $1F ) * 8;
end;

function GetNextBit( Zahl : LongWord ) : LongWord;
begin
        Result := Ceil( ln( Zahl ) / ln( 2 ) );
        Result := Round( exp( Result*ln( 2 ) ) );
end;

function DelDir( Dir: string ): Boolean;
var     Fos: TSHFileOpStruct;
begin
        FillChar( Fos, SizeOf(TSHFileOpStruct), 0);
        with Fos do begin
                wFunc := FO_DELETE;
                fFlags := FOF_SILENT or FOF_NOCONFIRMATION;
                pFrom := PChar( Dir + #0 );
        end;
        Result := ( 0 = ShFileOperation( Fos ) );
end;

function RenameDir( OldDir, NewDir: string ) : Boolean;
var     Fos: TSHFileOpStruct;
begin
        FillChar( Fos, SizeOf(TSHFileOpStruct), 0);
        with Fos do begin
                wFunc := FO_RENAME;
                fFlags := FOF_SILENT or FOF_NOCONFIRMATION;
                pFrom := PChar( OldDir + #0 );
                pTo := PChar( NewDir + #0 );
        end;
        Result := ( 0 = ShFileOperation( Fos ) );
end;

function CustomGetTickCount : LongWord;
begin
        Result := GetTickCount;
end;

function EncryptPassword( Pass : String ) : String;
var     Crypt : TDCP_Rijndael;
        Key : Array[0..15] of Byte;
        InitVektor : PByteArray;
        I : Integer;
begin
        Key[0] := $E2;
        Key[1] := $F3;
        Key[2] := $AA;
        Key[3] := $69;
        Key[4] := $B2;
        Key[5] := $79;
        Key[6] := $3B;
        Key[7] := $29;
        Key[8] := $C2;
        Key[9] := $C1;
        Key[10] := $54;
        Key[11] := $E7;
        Key[12] := $FB;
        Key[13] := $23;
        Key[14] := $38;
        Key[15] := $48;

        Crypt := TDCP_Rijndael.Create( nil );

        GetMem( InitVektor, 16 );
        for I := 0 to 15 do
                InitVektor^[I] := 0;
        
        Crypt.Init( Key, 128, InitVektor );
        FreeMem( InitVektor );

        Result := Crypt.EncryptString( Pass );

        Crypt.Free;
end;

function DecryptPassword( Pass : String ) : String;
var     Crypt : TDCP_Rijndael;
        Key : Array[0..15] of Byte;
        InitVektor : PByteArray;
        I : Integer;        
begin
        Key[0] := $E2;
        Key[1] := $F3;
        Key[2] := $AA;
        Key[3] := $69;
        Key[4] := $B2;
        Key[5] := $79;
        Key[6] := $3B;
        Key[7] := $29;
        Key[8] := $C2;
        Key[9] := $C1;
        Key[10] := $54;
        Key[11] := $E7;
        Key[12] := $FB;
        Key[13] := $23;
        Key[14] := $38;
        Key[15] := $48;

        Crypt := TDCP_Rijndael.Create( nil );

        GetMem( InitVektor, 16 );
        for I := 0 to 15 do
                InitVektor^[I] := 0;
        
        Crypt.Init( Key, 128, InitVektor );
        FreeMem( InitVektor );

        Result := Crypt.DecryptString( Pass );

        Crypt.Free;
end;

end.
