unit python;

INTERFACE

uses	
	{$IFDEF WIN32}
  	Windows,
        Winsock,
	{$ENDIF}
	{$IFDEF LINUX}
	Types,
	Libc,
	{$ENDIF}
	SysUtils;

const

{$IFDEF WIN32}
	PYTHON_VERSION = 'python24.dll';
{$ENDIF}

{$IFDEF LINUX}
	PYTHON_VERSION = 'libpython2.4.so';
{$ENDIF}

	RegVersion = '2.4';
	APIVersion = 1012;
	UnicodeTypeSuffix = 'UCS2';

	PYT_METHOD_BUFFER_INCREASE = 10;
	PYT_MEMBER_BUFFER_INCREASE = 10;
	PYT_GETSET_BUFFER_INCREASE = 10;

	METH_VARARGS  = $0001;
	METH_KEYWORDS = $0002;
        METH_NOARGS   = $0004;
        METH_O        = $0008;

	// Masks for the co_flags field of PyCodeObject
	CO_OPTIMIZED   = $0001;
	CO_NEWLOCALS   = $0002;
	CO_VARARGS     = $0004;
	CO_VARKEYWORDS = $0008;

	// Rich comparison opcodes introduced in version 2.1
	Py_LT = 0;
	Py_LE = 1;
	Py_EQ = 2;
	Py_NE = 3;
	Py_GT = 4;
	Py_GE = 5;
	
type	TRichComparisonOpcode = (pyLT, pyLE, pyEQ, pyNE, pyGT, pyGE);

const
	Py_TPFLAGS_HAVE_GETCHARBUFFER = (1 shl 0);

	// PySequenceMethods contains sq_contains
	Py_TPFLAGS_HAVE_SEQUENCE_IN = (1 shl 1);

	// Objects which participate in garbage collection (see objimp.h)
	Py_TPFLAGS_GC = (1 shl 2);

	// PySequenceMethods and PyNumberMethods contain in-place operators
	Py_TPFLAGS_HAVE_INPLACEOPS = (1 shl 3);

	// PyNumberMethods do their own coercion */
	Py_TPFLAGS_CHECKTYPES = (1 shl 4);

	Py_TPFLAGS_HAVE_RICHCOMPARE = (1 shl 5);

	// Objects which are weakly referencable if their tp_weaklistoffset is >0
	// XXX Should this have the same value as Py_TPFLAGS_HAVE_RICHCOMPARE?
	// These both indicate a feature that appeared in the same alpha release.

	Py_TPFLAGS_HAVE_WEAKREFS = (1 shl 6);

	// tp_iter is defined
	Py_TPFLAGS_HAVE_ITER = (1 shl 7);

	// New members introduced by Python 2.2 exist
	Py_TPFLAGS_HAVE_CLASS = (1 shl 8);

	// Set if the type object is dynamically allocated
	Py_TPFLAGS_HEAPTYPE = (1 shl 9);

	// Set if the type allows subclassing
	Py_TPFLAGS_BASETYPE = (1 shl 10);

	// Set if the type is 'ready' -- fully initialized
	Py_TPFLAGS_READY = (1 shl 12);

	// Set while the type is being 'readied', to prevent recursive ready calls
	Py_TPFLAGS_READYING = (1 shl 13);

	// Objects support garbage collection (see objimp.h)
	Py_TPFLAGS_HAVE_GC = (1 shl 14);

	Py_TPFLAGS_DEFAULT  = Py_TPFLAGS_HAVE_GETCHARBUFFER
        	           or Py_TPFLAGS_HAVE_SEQUENCE_IN
                           or Py_TPFLAGS_HAVE_INPLACEOPS
                           or Py_TPFLAGS_HAVE_RICHCOMPARE
                           or Py_TPFLAGS_HAVE_WEAKREFS
                           or Py_TPFLAGS_HAVE_ITER
                          or Py_TPFLAGS_HAVE_CLASS;
                          
type	TPFlag = (tpfHaveGetCharBuffer, tpfHaveSequenceIn, tpfGC, tpfHaveInplaceOps,
            tpfCheckTypes, tpfHaveRichCompare, tpfHaveWeakRefs, tpfHaveIter, tpfHaveClass,
            tpfHeapType, tpfBaseType, tpfReady, tpfReadying, tpfHaveGC );
	
	TPFlags = set of TPFlag;                          
	
const	TPFLAGS_DEFAULT = [tpfHaveGetCharBuffer, tpfHaveSequenceIn, tpfHaveInplaceOps,
                     	   tpfHaveRichCompare, tpfHaveWeakRefs, tpfHaveIter, tpfHaveClass];	
                     	   
Const
	single_input                 = 256;
	file_input                   = 257;
	eval_input                   = 258;
	funcdef                      = 259;
	parameters                   = 260;
	varargslist                  = 261;
	fpdef                        = 262;
	fplist                       = 263;
	stmt                         = 264;
	simple_stmt                  = 265;
	small_stmt                   = 266;
	expr_stmt                    = 267;
	augassign                    = 268;
	print_stmt                   = 269;
	del_stmt                     = 270;
	pass_stmt                    = 271;
	flow_stmt                    = 272;
	break_stmt                   = 273;
	continue_stmt                = 274;
	return_stmt                  = 275;
	raise_stmt                   = 276;
	import_stmt                  = 277;
	import_as_name               = 278;
	dotted_as_name               = 279;
	dotted_name                  = 280;
	global_stmt                  = 281;
	exec_stmt                    = 282;
	assert_stmt                  = 283;
	compound_stmt                = 284;
	if_stmt                      = 285;
	while_stmt                   = 286;
	for_stmt                     = 287;
	try_stmt                     = 288;
	except_clause                = 289;
	suite                        = 290;
	test                         = 291;
	and_test                     = 291;
	not_test                     = 293;
	comparison                   = 294;
	comp_op                      = 295;
	expr                         = 296;
	xor_expr                     = 297;
	and_expr                     = 298;
	shift_expr                   = 299;
	arith_expr                   = 300;
	term                         = 301;
	factor                       = 302;
	power                        = 303;
	atom                         = 304;
	listmaker                    = 305;
	lambdef                      = 306;
	trailer                      = 307;
	subscriptlist                = 308;
	subscript                    = 309;
	sliceop                      = 310;
	exprlist                     = 311;
	testlist                     = 312;
	dictmaker                    = 313;
	classdef                     = 314;
	arglist                      = 315;
	argument                     = 316;
	list_iter                    = 317;
	list_for                     = 318;
	list_if                      = 319;
	
const	// structmember.h
	//* Types */
	T_SHORT                       = 0;
	T_INT                         = 1;
	T_LONG                        = 2;
	T_FLOAT                       = 3;
	T_DOUBLE                      = 4;
	T_STRING                      = 5;
	T_OBJECT                      = 6;
	//* XXX the ordering here is weird for binary compatibility */
	T_CHAR                        = 7;	//* 1-character string */
	T_BYTE                        = 8;	//* 8-bit signed int */
	//* unsigned variants: */
	T_UBYTE                       = 9;
	T_USHORT                      = 10;
	T_UINT                        = 11;
	T_ULONG                       = 12;

	//* Added by Jack: strings contained in the structure */
	T_STRING_INPLACE= 13;

	T_OBJECT_EX                   = 16;{* Like T_OBJECT, but raises AttributeError
                                        when the value is NULL, instead of
                                        converting to None. *}

	//* Flags */
	READONLY                      = 1;
	RO                            = READONLY;		//* Shorthand */
	READ_RESTRICTED               = 2;
	WRITE_RESTRICTED              = 4;
	RESTRICTED                    = (READ_RESTRICTED or WRITE_RESTRICTED);
	
type	TPyMemberType = (mtShort, mtInt, mtLong, mtFloat, mtDouble, mtString, mtObject,
			 mtChar, mtByte, mtUByte, mtUShort, mtUInt, mtULong,
                   	 mtStringInplace, mtObjectEx);
	TPyMemberFlag = (mfDefault, mfReadOnly, mfReadRestricted, mfWriteRestricted, mfRestricted);	
	
const
	ErrInit         = -300;
	CR              = #13;
	LF              = #10;
	TAB             = #09;
	CRLF            = CR+LF;
	
type
	TPChar  = array[0..16000] of PChar;
	PPChar  = ^TPChar;
	PInt    = ^Integer;
	PDouble = ^Double;
	PFloat  = ^Real;
	PLong   = ^LongInt;
	PShort  = ^ShortInt;
	PString = ^PChar;
	
type
	PP_frozen	    = ^P_frozen;
	P_frozen	    = ^_frozen;
	PPyObject	    = ^PyObject;
	PPPyObject	    = ^PPyObject;
	PPPPyObject	    = ^PPPyObject;
	PPyIntObject	    = ^PyIntObject;
	PPyTypeObject     = ^PyTypeObject;
	PPySliceObject    = ^PySliceObject;

	AtExitProc        = procedure;

	PyCFunction       = function( self, args:PPyObject): PPyObject; cdecl;
	PyCFunctionWithKW = function( self, args, keywords:PPyObject): PPyObject; cdecl;

	unaryfunc         = function( ob1 : PPyObject): PPyObject; cdecl;
	binaryfunc        = function( ob1,ob2 : PPyObject): PPyObject; cdecl;
	ternaryfunc       = function( ob1,ob2,ob3 : PPyObject): PPyObject; cdecl;
	inquiry           = function( ob1 : PPyObject): integer; cdecl;
	coercion          = function( ob1,ob2 : PPPyObject): integer; cdecl;
	intargfunc        = function( ob1 : PPyObject; i: integer): PPyObject; cdecl;
	intintargfunc     = function( ob1 : PPyObject; i1, i2: integer):
                                PPyObject; cdecl;
	intobjargproc     = function( ob1 : PPyObject; i: integer; ob2 : PPyObject):
                                integer; cdecl;
	intintobjargproc  = function( ob1: PPyObject; i1, i2: integer;
                                ob2: PPyObject): integer; cdecl;
	objobjargproc     = function( ob1,ob2,ob3 : PPyObject): integer; cdecl;

	pydestructor      = procedure(ob: PPyObject); cdecl;
	printfunc         = function( ob: PPyObject; var f: file; i: integer): integer; cdecl;
	getattrfunc       = function( ob1: PPyObject; name: PChar): PPyObject; cdecl;
	setattrfunc       = function( ob1: PPyObject; name: PChar; ob2: PPyObject): integer; cdecl;
	cmpfunc           = function( ob1,ob2: PPyObject): integer; cdecl;
	reprfunc          = function( ob: PPyObject): PPyObject; cdecl;
	hashfunc          = function( ob: PPyObject): LongInt; cdecl;
	getattrofunc      = function( ob1,ob2: PPyObject): PPyObject; cdecl;
	setattrofunc      = function( ob1,ob2,ob3: PPyObject): integer; cdecl;		
	
	getreadbufferproc = function ( ob1: PPyObject; i: integer; ptr: Pointer): integer; cdecl;
	getwritebufferproc= function ( ob1: PPyObject; i: integer; ptr: Pointer): integer; cdecl;
	getsegcountproc   = function ( ob1: PPyObject; i: integer): integer; cdecl;
	getcharbufferproc = function ( ob1: PPyObject; i: integer; const pstr: PChar): integer; cdecl;
	objobjproc        = function ( ob1, ob2: PPyObject): integer; cdecl;
	visitproc         = function ( ob1: PPyObject; ptr: Pointer): integer; cdecl;
	traverseproc      = function ( ob1: PPyObject; proc: visitproc; ptr: Pointer): integer; cdecl;	
	
	richcmpfunc       = function ( ob1, ob2 : PPyObject; i : Integer) : PPyObject; cdecl;
	getiterfunc       = function ( ob1 : PPyObject) : PPyObject; cdecl;
	iternextfunc      = function ( ob1 : PPyObject) : PPyObject; cdecl;
	descrgetfunc      = function ( ob1, ob2, ob3 : PPyObject) : PPyObject; cdecl;
	descrsetfunc      = function ( ob1, ob2, ob3 : PPyObject) : Integer; cdecl;
	initproc          = function ( self, args, kwds : PPyObject) : Integer; cdecl;
	newfunc           = function ( subtype: PPyTypeObject; args, kwds : PPyObject) : PPyObject; cdecl;
	allocfunc         = function ( self: PPyTypeObject; nitems : integer) : PPyObject; cdecl;
	
	
	PyNumberMethods = packed record
		nb_add           : binaryfunc;
		nb_substract     : binaryfunc;
		nb_multiply      : binaryfunc;
		nb_divide        : binaryfunc;
		nb_remainder     : binaryfunc;
		nb_divmod        : binaryfunc;
		nb_power         : ternaryfunc;
		nb_negative      : unaryfunc;
		nb_positive      : unaryfunc;
		nb_absolute      : unaryfunc;
		nb_nonzero       : inquiry;
		nb_invert        : unaryfunc;
		nb_lshift        : binaryfunc;
		nb_rshift        : binaryfunc;
		nb_and           : binaryfunc;
		nb_xor           : binaryfunc;
		nb_or            : binaryfunc;
		nb_coerce        : coercion;
		nb_int           : unaryfunc;
		nb_long          : unaryfunc;
		nb_float         : unaryfunc;
		nb_oct           : unaryfunc;
		nb_hex           : unaryfunc;
		nb_inplace_add       : binaryfunc;
		nb_inplace_subtract  : binaryfunc;
		nb_inplace_multiply  : binaryfunc;
		nb_inplace_divide    : binaryfunc;
		nb_inplace_remainder : binaryfunc;
		nb_inplace_power     : ternaryfunc;
		nb_inplace_lshift    : binaryfunc;
		nb_inplace_rshift    : binaryfunc;
		nb_inplace_and       : binaryfunc;
		nb_inplace_xor       : binaryfunc;
		nb_inplace_or        : binaryfunc;
		nb_floor_divide         : binaryfunc;
		nb_true_divide          : binaryfunc;
		nb_inplace_floor_divide : binaryfunc;
		nb_inplace_true_divide  : binaryfunc;
	end;
	
	PPyNumberMethods = ^PyNumberMethods;

	PySequenceMethods = packed record
		sq_length    : inquiry;
		sq_concat    : binaryfunc;
		sq_repeat    : intargfunc;
		sq_item      : intargfunc;
		sq_slice     : intintargfunc;
		sq_ass_item  : intobjargproc;
		sq_ass_slice : intintobjargproc;
		sq_contains        : objobjproc;
		sq_inplace_concat  : binaryfunc;
		sq_inplace_repeat  : intargfunc;
  	end;
  	
  	PPySequenceMethods = ^PySequenceMethods;

	PyMappingMethods = packed record
		mp_length	      : inquiry;
		mp_subscript     : binaryfunc;
		mp_ass_subscript : objobjargproc;
	end;
	
	PPyMappingMethods = ^PyMappingMethods;

	PyBufferProcs = packed record
		bf_getreadbuffer   : getreadbufferproc;
		bf_getwritebuffer  : getwritebufferproc;
		bf_getsegcount     : getsegcountproc;
		bf_getcharbuffer   : getcharbufferproc;
	end;
	
	PPyBufferProcs = ^PyBufferProcs;
	
	Py_complex =  packed record
		real : double;
		imag : double;
	end;

	PyObject = packed record
		ob_refcnt: Integer;
		ob_type:   PPyTypeObject;
	end;

	PyIntObject = packed record
		ob_refcnt : Integer;
		ob_type   : PPyTypeObject;
		ob_ival   : LongInt;
	end;

	_frozen = packed record
		name	: PChar;
		code	: PByte;
		size	: Integer;
	end;

	PySliceObject = packed record
		ob_refcnt:          Integer;
		ob_type:            PPyTypeObject;
		start, stop, step:  PPyObject;
	end;

	PPyMethodDef = ^PyMethodDef;
  	PyMethodDef  = packed record
		ml_name:  PChar;
		ml_meth:  PyCFunction;
		ml_flags: Integer;
		ml_doc:   PChar;
	end;
	
	PPyMemberDef = ^PyMemberDef;
	PyMemberDef = packed record
		name : PChar;
		_type : integer;
		offset : integer;
		flags : integer;
		doc : PChar;
	end;

	getter = function ( obj : PPyObject; context : Pointer) : PPyObject; cdecl;
	setter = function ( obj, value : PPyObject; context : Pointer) : integer; cdecl;

	PPyGetSetDef = ^PyGetSetDef;
	PyGetSetDef = packed record
		name : PChar;
		get : getter;
		_set : setter;
		doc : PChar;
		closure : Pointer;
	end;

	wrapperfunc = function (self, args: PPyObject; wrapped : Pointer) : PPyObject; cdecl;

	pwrapperbase = ^wrapperbase;
	wrapperbase = packed record
		name : PChar;
		wrapper : wrapperfunc;
		doc : PChar;
	end;

	PPyDescrObject = ^PyDescrObject;
  	PyDescrObject = packed record
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		d_type     : PPyTypeObject;
		d_name     : PPyObject;
	end;

	PPyMethodDescrObject = ^PyMethodDescrObject;
	PyMethodDescrObject = packed record
		// Start of PyDescr_COMMON
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		d_type     : PPyTypeObject;
		d_name     : PPyObject;
		// End of PyDescr_COMMON
		d_method : PPyMethodDef;
	end;

	PPyMemberDescrObject = ^PyMemberDescrObject;
	PyMemberDescrObject = packed record
		// Start of PyDescr_COMMON
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		d_type     : PPyTypeObject;
		d_name     : PPyObject;
		// End of PyDescr_COMMON
		d_member : PPyMemberDef;
	end;

	PPyGetSetDescrObject = ^PyGetSetDescrObject;
	PyGetSetDescrObject = packed record
		// Start of PyDescr_COMMON
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		d_type     : PPyTypeObject;
		d_name     : PPyObject;
		// End of PyDescr_COMMON
		d_getset : PPyGetSetDef;
	end;

	PPyWrapperDescrObject = ^PyWrapperDescrObject;
	PyWrapperDescrObject = packed record
		// Start of PyDescr_COMMON
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		d_type     : PPyTypeObject;
		d_name     : PPyObject;
		// End of PyDescr_COMMON
		d_base : pwrapperbase;
		d_wrapped : Pointer; // This can be any function pointer
	end;
	
	PyTypeObject = packed record
		ob_refcnt:      Integer;
		ob_type:        PPyTypeObject;
		ob_size:        Integer; // Number of items in variable part
		tp_name:        PChar;   // For printing
		tp_basicsize, tp_itemsize: Integer; // For allocation

		// Methods to implement standard operations

		tp_dealloc:     pydestructor;
		tp_print:       printfunc;
		tp_getattr:     getattrfunc;
		tp_setattr:     setattrfunc;
		tp_compare:     cmpfunc;
		tp_repr:        reprfunc;

		// Method suites for standard classes

		tp_as_number:   PPyNumberMethods;
		tp_as_sequence: PPySequenceMethods;
		tp_as_mapping:  PPyMappingMethods;

		// More standard operations (here for binary compatibility)

		tp_hash:        hashfunc;
		tp_call:        ternaryfunc;
		tp_str:         reprfunc;
		tp_getattro:    getattrofunc;
		tp_setattro:    setattrofunc;

		// Functions to access object as input/output buffer
		tp_as_buffer:   PPyBufferProcs;
		// Flags to define presence of optional/expanded features
		tp_flags:       LongInt;

		tp_doc:         PChar; // Documentation string

		// call function for all accessible objects
		tp_traverse:    traverseproc;

		// delete references to contained objects
		tp_clear:       inquiry;
		// rich comparisons
		tp_richcompare: richcmpfunc;

		// weak reference enabler
		tp_weaklistoffset: Longint;

		// Iterators
		tp_iter : getiterfunc;
		tp_iternext : iternextfunc;

		// Attribute descriptor and subclassing stuff
		tp_methods          : PPyMethodDef;
		tp_members          : PPyMemberDef;
		tp_getset           : PPyGetSetDef;
		tp_base             : PPyTypeObject;
		tp_dict             : PPyObject;
		tp_descr_get        : descrgetfunc;
		tp_descr_set        : descrsetfunc;
		tp_dictoffset       : longint;
		tp_init             : initproc;
		tp_alloc            : allocfunc;
		tp_new              : newfunc;
		tp_free             : pydestructor; // Low-level free-memory routine
		tp_is_gc            : inquiry; // For PyObject_IS_GC
		tp_bases            : PPyObject;
		tp_mro              : PPyObject; // method resolution order
		tp_cache            : PPyObject;
		tp_subclasses       : PPyObject;
		tp_weaklist         : PPyObject;
	end;
	
	
	PPyMethodChain = ^PyMethodChain;
	PyMethodChain = packed record
		methods: PPyMethodDef;
		link:    PPyMethodChain;
	end;

	PPyClassObject = ^PyClassObject;
	PyClassObject = packed record
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		cl_bases   : PPyObject;       // A tuple of class objects
		cl_dict    : PPyObject;       // A dictionary
		cl_name    : PPyObject;       // A string
		// The following three are functions or NULL
		cl_getattr : PPyObject;
		cl_setattr : PPyObject;
		cl_delattr : PPyObject;
	end;

	PPyInstanceObject = ^PyInstanceObject;
	PyInstanceObject = packed record
		// Start of the Head of an object
		ob_refcnt : Integer;
		ob_type   : PPyTypeObject;
		// End of the Head of an object
		in_class  : PPyClassObject;      // The class object
		in_dict   : PPyObject;           // A dictionary
	end;

	{ Instance method objects are used for two purposes:
	(a) as bound instance methods (returned by instancename.methodname)
	(b) as unbound methods (returned by ClassName.methodname)
	In case (b), im_self is NULL
	}

	PPyMethodObject = ^PyMethodObject;
	PyMethodObject = packed record
		// Start of the Head of an object
		ob_refcnt : Integer;
		ob_type   : PPyTypeObject;
		// End of the Head of an object
		im_func  : PPyObject;      // The function implementing the method
		im_self  : PPyObject;      // The instance it is bound to, or NULL
		im_class : PPyObject;      // The class that defined the method
	end;


	// Bytecode object, compile.h
  	PPyCodeObject = ^PyCodeObject;
	PyCodeObject = packed record
		ob_refcnt      : Integer;
		ob_type        : PPyTypeObject;
		co_argcount    : Integer;         // #arguments, except *args
		co_nlocals     : Integer;         // #local variables
		co_stacksize   : Integer;          // #entries needed for evaluation stack
		co_flags       : Integer;         // CO_..., see below
		co_code        : PPyObject;       // instruction opcodes (it hides a PyStringObject)
		co_consts      : PPyObject;       // list (constants used)
		co_names       : PPyObject;       // list of strings (names used)
		co_varnames    : PPyObject;       // tuple of strings (local variable names)
		co_freevars    : PPyObject;	      // tuple of strings (free variable names)
		co_cellvars    : PPyObject;       // tuple of strings (cell variable names)
		// The rest doesn't count for hash/cmp
		co_filename    : PPyObject;       // string (where it was loaded from)
		co_name        : PPyObject;       // string (name, for reference)
		co_firstlineno : Integer;         // first source line number
		co_lnotab      : PPyObject;       // string (encoding addr<->lineno mapping)
	end;
	
	// from pystate.h
	PPyInterpreterState = ^PyInterpreterState;
	PPyThreadState = ^PyThreadState;
	PPyFrameObject = ^PyFrameObject;

	// Interpreter environments
	PyInterpreterState = packed record
		next           : PPyInterpreterState;
		tstate_head    : PPyThreadState;

		modules        : PPyObject;
		sysdict        : PPyObject;
		builtins       : PPyObject;
		
		checkinterval  : integer;
	end;

	// Thread specific information
	PyThreadState = packed record
		next           : PPyThreadState;
		interp         : PPyInterpreterState;
		
		frame          : PPyFrameObject;
		recursion_depth: integer;
		ticker         : integer;
		tracing        : integer;

		sys_profilefn  : Pointer;           // c-functions for profile/trace
		sys_tracefn    : Pointer;
		
		sys_profilefunc: PPyObject;
		sys_tracefunc  : PPyObject;

		curexc_type    : PPyObject;
		curexc_value   : PPyObject;
		curexc_traceback: PPyObject;

		exc_type       : PPyObject;
		exc_value      : PPyObject;
		exc_traceback  : PPyObject;

		dict           : PPyObject;
		tick_counter      :Integer;
		gilstate_counter  :Integer;

		async_exc         :PPyObject; { Asynchronous exception to raise }
		thread_id         :LongInt;   { Thread id where this tstate was created }
	end;	
	
	
	PPyTryBlock = ^PyTryBlock;
	PyTryBlock = packed record
		b_type    : Integer;       // what kind of block this is
		b_handler : Integer;       // where to jump to find handler
		b_level   : Integer;       // value stack level to pop to
	end;

	CO_MAXBLOCKS  = 0..19;
	PyFrameObject = packed record
		// Start of the VAR_HEAD of an object.
		ob_refcnt    : Integer;
		ob_type      : PPyTypeObject;
		ob_size      : Integer;           // Number of items in variable part
		
		// End of the Head of an object
		f_back       : PPyFrameObject;    // previous frame, or NULL
		f_code       : PPyCodeObject;     // code segment
		f_builtins   : PPyObject;         // builtin symbol table (PyDictObject)
		f_globals    : PPyObject;         // global symbol table (PyDictObject)
		f_locals     : PPyObject;         // local symbol table (PyDictObject)
		f_valuestack : PPPyObject;        // points after the last local
		
    		(* Next free slot in f_valuestack.  Frame creation sets to f_valuestack.
       		Frame evaluation usually NULLs it, but a frame that yields sets it
       		to the current stack top. *)
		f_stacktop   : PPPyObject;
		f_trace      : PPyObject;         // Trace function
		f_exc_type, f_exc_value, f_exc_traceback: PPyObject;
		f_tstate     : PPyThreadState;
		f_lasti      : Integer;           // Last instruction if called
		f_lineno     : Integer;           // Current line number
		f_restricted : Integer;           // Flag set if restricted operations
		                                  // in this scope
		f_iblock     : Integer;           // index in f_blockstack
		f_blockstack : array[CO_MAXBLOCKS] of PyTryBlock; // for try and loop blocks
		f_nlocals    : Integer;           // number of locals
		f_ncells     : Integer;
		f_nfreevars  : Integer;
		f_stacksize  : Integer;           // size of value stack
		f_localsplus : array[0..0] of PPyObject; // locals+stack, dynamically sized
	end;

	// From traceback.c
	PPyTraceBackObject = ^PyTraceBackObject;
	PyTraceBackObject = packed record
		// Start of the Head of an object
		ob_refcnt : Integer;
		ob_type   : PPyTypeObject;
		// End of the Head of an object
		tb_next   : PPyTraceBackObject;
		tb_frame  : PPyFrameObject;
		tb_lasti  : Integer;
		tb_lineno : Integer;
	end;

	// Parse tree node interface
	PNode = ^node;
	node = packed record
		n_type      : smallint;
		n_str       : PChar;
		n_lineno    : smallint;
		n_nchildren : smallint;
		n_child     : PNode;
	end;

	// From weakrefobject.h
	PPyWeakReference = ^PyWeakReference;
	PyWeakReference = packed record
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		wr_object   : PPyObject;
		wr_callback : PPyObject;
		hash        : longint;
		wr_prev     : PPyWeakReference;
		wr_next     : PPyWeakReference;
	end;


	// from datetime.h
	{* Fields are packed into successive bytes, each viewed as unsigned and
 	* big-endian, unless otherwise noted:
 	*
 	* byte offset
 	*  0 		year     2 bytes, 1-9999
 	*  2	  	month    1 byte,  1-12
 	*  3 		day      1 byte,  1-31
 	*  4     hour     1 byte,  0-23
 	*  5 		minute   1 byte,  0-59
 	*  6 		second   1 byte,  0-59
 	*  7 		usecond  3 bytes, 0-999999
 	* 10
 	*}

const
	{ # of bytes for year, month, and day. }
	_PyDateTime_DATE_DATASIZE = 4;

	{ # of bytes for hour, minute, second, and usecond. }
	_PyDateTime_TIME_DATASIZE = 6;

	{ # of bytes for year, month, day, hour, minute, second, and usecond. }
	_PyDateTime_DATETIME_DATASIZE = 10;
	
type
	PyDateTime_Delta = packed record
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		hashcode    : Integer;  // -1 when unknown
		days        : Integer;  // -MAX_DELTA_DAYS <= days <= MAX_DELTA_DAYS
		seconds     : Integer;  // 0 <= seconds < 24*3600 is invariant
		microseconds: Integer;  // 0 <= microseconds < 1000000 is invariant
	end;
	PPyDateTime_Delta = ^PyDateTime_Delta;

	PyDateTime_TZInfo = packed record // a pure abstract base clase
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
	end;
	PPyDateTime_TZInfo = ^PyDateTime_TZInfo;

	{
	/* The datetime and time types have hashcodes, and an optional tzinfo member,
 	* present if and only if hastzinfo is true.
 	*/
	#define _PyTZINFO_HEAD		\
		PyObject_HEAD		\
		long hashcode;		\
		char hastzinfo;		/* boolean flag */
	}

	{* No _PyDateTime_BaseTZInfo is allocated; it's just to have something
 	* convenient to cast to, when getting at the hastzinfo member of objects
 	* starting with _PyTZINFO_HEAD.
 	*}
	_PyDateTime_BaseTZInfo = packed record
		// Start of _PyTZINFO_HEAD
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		hashcode   : Integer;
		hastzinfo  : Char;  // boolean flag
		// End of _PyTZINFO_HEAD
	end;
	_PPyDateTime_BaseTZInfo = ^_PyDateTime_BaseTZInfo;

	{* All time objects are of PyDateTime_TimeType, but that can be allocated
 	* in two ways, with or without a tzinfo member.  Without is the same as
 	* tzinfo == None, but consumes less memory.  _PyDateTime_BaseTime is an
 	* internal struct used to allocate the right amount of space for the
 	* "without" case.
 	*}
	{#define _PyDateTime_TIMEHEAD	\
		_PyTZINFO_HEAD		\
		unsigned char data[_PyDateTime_TIME_DATASIZE];
	}

	_PyDateTime_BaseTime = packed record // hastzinfo false
		// Start of _PyDateTime_TIMEHEAD
		// Start of _PyTZINFO_HEAD
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		hashcode   : Integer;
		hastzinfo  : Char;  // boolean flag
		// End of _PyTZINFO_HEAD
		data       : array[0..Pred(_PyDateTime_TIME_DATASIZE)] of Byte;
		// End of _PyDateTime_TIMEHEAD
	end;
	_PPyDateTime_BaseTime = ^_PyDateTime_BaseTime;

	PyDateTime_Time = packed record // hastzinfo true
		// Start of _PyDateTime_TIMEHEAD
		// Start of _PyTZINFO_HEAD
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		hashcode   : Integer;
		hastzinfo  : Char;  // boolean flag
		// End of _PyTZINFO_HEAD
		data       : array[0..Pred(_PyDateTime_TIME_DATASIZE)] of Byte;
		// End of _PyDateTime_TIMEHEAD
		tzinfo     : PPyObject;
	end;
	PPyDateTime_Time = ^PyDateTime_Time;

	{* All datetime objects are of PyDateTime_DateTimeType, but that can be
 	* allocated in two ways too, just like for time objects above.  In addition,
 	* the plain date type is a base class for datetime, so it must also have
 	* a hastzinfo member (although it's unused there).
	*}
	PyDateTime_Date = packed record
		// Start of _PyTZINFO_HEAD
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		hashcode   : Integer;
		hastzinfo  : Char;  // boolean flag
		// End of _PyTZINFO_HEAD
		data       : array[0..Pred(_PyDateTime_DATE_DATASIZE)] of Byte;
	end;
	PPyDateTime_Date = ^PyDateTime_Date;

 	{
	#define _PyDateTime_DATETIMEHEAD	\
		_PyTZINFO_HEAD			\
		unsigned char data[_PyDateTime_DATETIME_DATASIZE];
	}

	_PyDateTime_BaseDateTime = packed record // hastzinfo false
		// Start of _PyTZINFO_HEAD
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		hashcode   : Integer;
		hastzinfo  : Char;  // boolean flag
		// End of _PyTZINFO_HEAD
		data       : array[0..Pred(_PyDateTime_DATETIME_DATASIZE)] of Byte;
	end;
	_PPyDateTime_BaseDateTime = ^_PyDateTime_BaseDateTime;

	PyDateTime_DateTime = packed record // hastzinfo true
		// Start of _PyDateTime_DATETIMEHEAD
		// Start of _PyTZINFO_HEAD
		// Start of the Head of an object
		ob_refcnt  : Integer;
		ob_type    : PPyTypeObject;
		// End of the Head of an object
		hashcode   : Integer;
		hastzinfo  : Char;  // boolean flag
		// End of _PyTZINFO_HEAD
		data       : array[0..Pred(_PyDateTime_DATETIME_DATASIZE)] of Byte;
		// End of _PyDateTime_DATETIMEHEAD
		tzinfo : PPyObject;
	end;
	PPyDateTime_DateTime = ^PyDateTime_DateTime;
	
	
var
	DLL_PyArg_Parse: function( args: PPyObject; format: PChar {;....}) : Integer; cdecl;
	DLL_PyArg_ParseTuple: function( args: PPyObject; format: PChar {;...}): Integer; cdecl;
	DLL_Py_BuildValue: function( format: PChar {;...}): PPyObject; cdecl;
	DLL_PyCode_Addr2Line: function ( co: PPyCodeObject; addrq : Integer ) : Integer; cdecl;
	DLL_Py_GetBuildInfo: function : PChar; cdecl;
	DLL_PyImport_ExecCodeModule: function ( const name : String; codeobject : PPyObject) : PPyObject; cdecl;

	// define Python flags. See file pyDebug.h
	Py_DebugFlag: PInt;
	Py_VerboseFlag: PInt;
	Py_InteractiveFlag: PInt;
	Py_OptimizeFlag: PInt;
	Py_NoSiteFlag: PInt;
	Py_UseClassExceptionsFlag: PInt;
	Py_FrozenFlag: PInt;
	Py_TabcheckFlag: PInt;
	Py_UnicodeFlag: PInt;
	Py_IgnoreEnvironmentFlag: PInt;
	Py_DivisionWarningFlag: PInt;
    	//_PySys_TraceFunc:    PPPyObject;
	//_PySys_ProfileFunc: PPPPyObject;

	PyImport_FrozenModules: PP_frozen;

	Py_None:            PPyObject;
	Py_Ellipsis:        PPyObject;
	Py_False:           PPyIntObject;
	Py_True:            PPyIntObject;
	Py_NotImplemented:  PPyObject;	

	PyExc_AttributeError: PPPyObject;
	PyExc_EOFError: PPPyObject;
	PyExc_IOError: PPPyObject;
	PyExc_ImportError: PPPyObject;
	PyExc_IndexError: PPPyObject;
	PyExc_KeyError: PPPyObject;
	PyExc_KeyboardInterrupt: PPPyObject;
	PyExc_MemoryError: PPPyObject;
	PyExc_NameError: PPPyObject;
	PyExc_OverflowError: PPPyObject;
	PyExc_RuntimeError: PPPyObject;
	PyExc_SyntaxError: PPPyObject;
	PyExc_SystemError: PPPyObject;
	PyExc_SystemExit: PPPyObject;
	PyExc_TypeError: PPPyObject;
	PyExc_ValueError: PPPyObject;
	PyExc_ZeroDivisionError: PPPyObject;
	PyExc_ArithmeticError: PPPyObject;
	PyExc_Exception: PPPyObject;
	PyExc_FloatingPointError: PPPyObject;
	PyExc_LookupError: PPPyObject;
	PyExc_StandardError: PPPyObject;
	PyExc_AssertionError: PPPyObject;
	PyExc_EnvironmentError: PPPyObject;
	PyExc_IndentationError: PPPyObject;
	PyExc_MemoryErrorInst: PPPyObject;
	PyExc_NotImplementedError: PPPyObject;
	PyExc_OSError: PPPyObject;
	PyExc_TabError: PPPyObject;
	PyExc_UnboundLocalError: PPPyObject;
	PyExc_UnicodeError: PPPyObject;
 	{$IFDEF WIN32}
	PyExc_WindowsError: PPPyObject;
	{$ENDIF}
	PyExc_Warning: PPPyObject;
	PyExc_DeprecationWarning: PPPyObject;
	PyExc_RuntimeWarning: PPPyObject;
	PyExc_SyntaxWarning: PPPyObject;
	PyExc_UserWarning: PPPyObject;
	PyExc_OverflowWarning: PPPyObject;
	PyExc_ReferenceError: PPPyObject;
	PyExc_StopIteration: PPPyObject;
	PyExc_FutureWarning: PPPyObject;
	PyExc_PendingDeprecationWarning: PPPyObject;
	PyExc_UnicodeDecodeError: PPPyObject;
	PyExc_UnicodeEncodeError: PPPyObject;
	PyExc_UnicodeTranslateError: PPPyObject;

	PyType_Type: PPyTypeObject;
	PyCFunction_Type: PPyTypeObject;
	PyCObject_Type: PPyTypeObject;
	PyClass_Type: PPyTypeObject;
	PyCode_Type: PPyTypeObject;
	PyComplex_Type: PPyTypeObject;
	PyDict_Type: PPyTypeObject;
	PyFile_Type: PPyTypeObject;
	PyFloat_Type: PPyTypeObject;
	PyFrame_Type: PPyTypeObject;
	PyFunction_Type: PPyTypeObject;
	PyInstance_Type: PPyTypeObject;
	PyInt_Type: PPyTypeObject;
	PyList_Type: PPyTypeObject;
	PyLong_Type: PPyTypeObject;
	PyMethod_Type: PPyTypeObject;
	PyModule_Type: PPyTypeObject;
	PyObject_Type: PPyTypeObject;
	PyRange_Type: PPyTypeObject;
	PySlice_Type: PPyTypeObject;
	PyString_Type: PPyTypeObject;
	PyTuple_Type: PPyTypeObject;
	PyBaseObject_Type: PPyTypeObject;
	PyBuffer_Type: PPyTypeObject;
	PyCallIter_Type: PPyTypeObject;
	PyCell_Type: PPyTypeObject;
	PyClassMethod_Type: PPyTypeObject;
	PyProperty_Type: PPyTypeObject;
	PySeqIter_Type: PPyTypeObject;
	PyStaticMethod_Type: PPyTypeObject;
	PySuper_Type: PPyTypeObject;
	PySymtableEntry_Type: PPyTypeObject;
	PyTraceBack_Type: PPyTypeObject;
	PyUnicode_Type: PPyTypeObject;
	PyWrapperDescr_Type: PPyTypeObject;
	
	_PyWeakref_RefType: PPyTypeObject;
	_PyWeakref_ProxyType: PPyTypeObject;
	_PyWeakref_CallableProxyType: PPyTypeObject;

	PyBaseString_Type: PPyTypeObject;
	PyBool_Type: PPyTypeObject;
	PyEnum_Type: PPyTypeObject;

	//PyArg_GetObject: function(args : PPyObject; nargs, i: integer; p_a: PPPyObject): integer; cdecl;
	//PyArg_GetLong:   function(args : PPyObject; nargs, i: integer; p_a: PLong): integer; cdecl;
	//PyArg_GetShort:  function(args : PPyObject; nargs, i: integer; p_a: PShort): integer; cdecl;
	//PyArg_GetFloat:  function(args : PPyObject; nargs, i: integer; p_a: PFloat): integer; cdecl;
	//PyArg_GetString: function(args : PPyObject; nargs, i: integer; p_a: PString): integer; cdecl;
	//PyArgs_VaParse:  function (args : PPyObject; format: PChar; va_list: array of const): integer; cdecl;
	// Does not work!
	// Py_VaBuildValue: function (format: PChar; va_list: array of const): PPyObject; cdecl;
	//PyBuiltin_Init:     procedure; cdecl;

	PyComplex_FromCComplex: function(c: Py_complex):PPyObject; cdecl;
	PyComplex_FromDoubles: function(realv,imag : double):PPyObject; cdecl;
	PyComplex_RealAsDouble: function(op : PPyObject ): double; cdecl;
	PyComplex_ImagAsDouble: function(op : PPyObject ): double; cdecl;
	PyComplex_AsCComplex: function(op : PPyObject ): Py_complex; cdecl;
	PyCFunction_GetFunction: function(ob : PPyObject): Pointer; cdecl;
	PyCFunction_GetSelf: function(ob : PPyObject): PPyObject; cdecl;
	PyCallable_Check: function(ob	: PPyObject): integer; cdecl;
	PyCObject_FromVoidPtr: function(cobj, destruct : Pointer): PPyObject; cdecl;
	PyCObject_AsVoidPtr: function(ob : PPyObject): Pointer; cdecl;
	PyClass_New: function (ob1,ob2,ob3 :  PPyObject): PPyObject; cdecl;
	PyClass_IsSubclass: function (ob1, ob2 : PPyObject): integer cdecl;
	
	Py_InitModule4: function( name: PChar; methods: PPyMethodDef; doc: PChar;
                              passthrough: PPyObject; Api_Version: Integer):PPyObject; cdecl;
	PyErr_BadArgument:  function: integer; cdecl;
	PyErr_BadInternalCall: procedure; cdecl;
	PyErr_CheckSignals: function: integer; cdecl;
	PyErr_Clear:        procedure; cdecl;
	PyErr_Fetch:        procedure( errtype, errvalue, errtraceback: PPPyObject); cdecl;
        PyErr_NormalizeException: procedure( errtype, errvalue, errtraceback: PPPyObject); cdecl;
	PyErr_NoMemory:     function: PPyObject; cdecl;
	PyErr_Occurred:     function: PPyObject; cdecl;
	PyErr_Print:        procedure; cdecl;
	PyErr_Restore:      procedure  (errtype, errvalue, errtraceback: PPyObject); cdecl;
	PyErr_SetFromErrno: function (ob :  PPyObject):PPyObject; cdecl;
	PyErr_SetNone:      procedure(value: PPyObject); cdecl;
	PyErr_SetObject:    procedure  (ob1, ob2	: PPyObject); cdecl;
	PyErr_SetString:    procedure( ErrorObject: PPyObject; text: PChar); cdecl;
	PyImport_GetModuleDict: function: PPyObject; cdecl;
	PyInt_FromLong:     function( x: LongInt):PPyObject; cdecl;
	Py_Initialize:      procedure; cdecl;
	Py_Exit:            procedure( RetVal: Integer); cdecl;
	PyEval_GetBuiltins: function: PPyObject; cdecl;
	PyDict_Copy:        function(mp: PPyObject):PPyObject; cdecl;
	PyDict_GetItem:     function(mp, key : PPyObject):PPyObject; cdecl;
	PyDict_SetItem:     function(mp, key, item :PPyObject ):integer; cdecl;
	PyDict_DelItem:     function(mp, key : PPyObject ):integer; cdecl;
	PyDict_Clear:       procedure(mp : PPyObject); cdecl;
	PyDict_Next:        function(mp : PPyObject; pos: PInt; key, value: PPPyObject):integer; cdecl;
	PyDict_Keys:        function(mp: PPyObject):PPyObject; cdecl;
	PyDict_Values:      function(mp: PPyObject):PPyObject; cdecl;
	PyDict_Items:       function(mp: PPyObject):PPyObject; cdecl;
	PyDict_Size:        function(mp: PPyObject):integer; cdecl;
	PyDict_DelItemString: function(dp : PPyObject;key : PChar ):integer; cdecl;
	PyDict_New: function: PPyObject; cdecl;
	PyDict_GetItemString: function( dp: PPyObject; key: PChar): PPyObject; cdecl;
	PyDict_SetItemString: function( dp: PPyObject; key: PChar; item: PPyObject): Integer; cdecl;
	PyDictProxy_New: function (obj : PPyObject) : PPyObject; cdecl;
	PyModule_GetDict:     function( module:PPyObject): PPyObject; cdecl;
	PyObject_Str:         function( v: PPyObject): PPyObject; cdecl;
	PyRun_String:         function( str: PChar; start: Integer; globals: PPyObject; locals: PPyObject): PPyObject; cdecl;
	PyRun_SimpleString:   function( str: PChar): Integer; cdecl;
	PyString_AsString:    function( ob: PPyObject): PChar; cdecl;
	PyString_FromString:  function( str: PChar): PPyObject; cdecl;
	PySys_SetArgv:        procedure( argc: Integer; argv: PPChar); cdecl;

	PyCFunction_New: function(md:PPyMethodDef;ob:PPyObject):PPyObject; cdecl;
	PyEval_CallObject: function(callable_obj, args:PPyObject):PPyObject; cdecl;
	PyEval_CallObjectWithKeywords:function (callable_obj, args, kw:PPyObject):PPyObject; cdecl;
	PyEval_GetFrame:function :PPyObject; cdecl;
	PyEval_GetGlobals:function :PPyObject; cdecl;
	PyEval_GetLocals:function :PPyObject; cdecl;
	//PyEval_GetOwner:function :PPyObject; cdecl;
	PyEval_GetRestricted:function :integer; cdecl;

	PyEval_InitThreads:procedure; cdecl;
	PyEval_RestoreThread:procedure( tstate: PPyThreadState); cdecl;
	PyEval_SaveThread:function :PPyThreadState; cdecl;

	PyFile_FromString:function (pc1,pc2:PChar):PPyObject; cdecl;
	PyFile_GetLine:function (ob:PPyObject;i:integer):PPyObject; cdecl;
	PyFile_Name:function (ob:PPyObject):PPyObject; cdecl;
	PyFile_SetBufSize:procedure(ob:PPyObject;i:integer); cdecl;
	PyFile_SoftSpace:function (ob:PPyObject;i:integer):integer; cdecl;
	PyFile_WriteObject:function (ob1,ob2:PPyObject;i:integer):integer; cdecl;
	PyFile_WriteString:procedure(s:PChar;ob:PPyObject); cdecl;
	PyFloat_AsDouble:function (ob:PPyObject):DOUBLE; cdecl;
	PyFloat_FromDouble:function (db:double):PPyObject; cdecl;
	PyFunction_GetCode:function (ob:PPyObject):PPyObject; cdecl;
	PyFunction_GetGlobals:function (ob:PPyObject):PPyObject; cdecl;
	PyFunction_New:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyImport_AddModule:function (name:PChar):PPyObject; cdecl;
	PyImport_Cleanup:procedure; cdecl;
	PyImport_GetMagicNumber:function :LONGINT; cdecl;
	PyImport_ImportFrozenModule:function (key:PChar):integer; cdecl;
	PyImport_ImportModule:function (name:PChar):PPyObject; cdecl;
	PyImport_Import:function (name:PPyObject):PPyObject; cdecl;
	//PyImport_Init:procedure; cdecl;
	PyImport_ReloadModule:function (ob:PPyObject):PPyObject; cdecl;
	PyInstance_New:function (obClass, obArg, obKW:PPyObject):PPyObject; cdecl;
	PyInt_AsLong:function (ob:PPyObject):LONGINT; cdecl;
	PyList_Append:function (ob1,ob2:PPyObject):integer; cdecl;
	PyList_AsTuple:function (ob:PPyObject):PPyObject; cdecl;
	PyList_GetItem:function (ob:PPyObject;i:integer):PPyObject; cdecl;
	PyList_GetSlice:function (ob:PPyObject;i1,i2:integer):PPyObject; cdecl;
	PyList_Insert:function (dp:PPyObject;idx:Integer;item:PPyObject):integer; cdecl;
	PyList_New:function (size:integer):PPyObject; cdecl;
	PyList_Reverse:function (ob:PPyObject):integer; cdecl;
	PyList_SetItem:function (dp:PPyObject;idx:Integer;item:PPyObject):integer; cdecl;
	PyList_SetSlice:function (ob:PPyObject;i1,i2:integer;ob2:PPyObject):integer; cdecl;
	PyList_Size:function (ob:PPyObject):integer; cdecl;
	PyList_Sort:function (ob:PPyObject):integer; cdecl;
	PyLong_AsDouble:function (ob:PPyObject):DOUBLE; cdecl;
	PyLong_AsLong:function (ob:PPyObject):LONGINT; cdecl;
	PyLong_FromDouble:function (db:double):PPyObject; cdecl;
	PyLong_FromLong:function (l:longint):PPyObject; cdecl;
	PyLong_FromString:function (pc:PChar;var ppc:PChar;i:integer):PPyObject; cdecl;
	PyLong_FromUnsignedLong:function(val:cardinal) : PPyObject; cdecl;
	PyLong_AsUnsignedLong:function(ob:PPyObject) : Cardinal; cdecl;
	PyLong_FromUnicode:function(ob:PPyObject; a, b : integer) : PPyObject; cdecl;
	PyLong_FromLongLong:function(val:Int64) : PPyObject; cdecl;
	PyLong_AsLongLong:function(ob:PPyObject) : Int64; cdecl;
	PyMapping_Check:function (ob:PPyObject):integer; cdecl;
	PyMapping_GetItemString:function (ob:PPyObject;key:PChar):PPyObject; cdecl;
	PyMapping_HasKey:function (ob,key:PPyObject):integer; cdecl;
	PyMapping_HasKeyString:function (ob:PPyObject;key:PChar):integer; cdecl;
	PyMapping_Length:function (ob:PPyObject):integer; cdecl;
	PyMapping_SetItemString:function (ob:PPyObject; key:PChar; value:PPyObject):integer; cdecl;
	PyMethod_Class:function (ob:PPyObject):PPyObject; cdecl;
	PyMethod_Function:function (ob:PPyObject):PPyObject; cdecl;
	PyMethod_New:function (ob1,ob2,ob3:PPyObject):PPyObject; cdecl;
	PyMethod_Self:function (ob:PPyObject):PPyObject; cdecl;
	PyModule_GetName:function (ob:PPyObject):PChar; cdecl;
	PyModule_New:function (key:PChar):PPyObject; cdecl;
	PyNumber_Absolute:function (ob:PPyObject):PPyObject; cdecl;
	PyNumber_Add:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_And:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Check:function (ob:PPyObject):integer; cdecl;
	PyNumber_Coerce:function (var ob1,ob2:PPyObject):integer; cdecl;
	PyNumber_Divide:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_FloorDivide:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_TrueDivide:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Divmod:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Float:function (ob:PPyObject):PPyObject; cdecl;
	PyNumber_Int:function (ob:PPyObject):PPyObject; cdecl;
	PyNumber_Invert:function (ob:PPyObject):PPyObject; cdecl;
	PyNumber_Long:function (ob:PPyObject):PPyObject; cdecl;
	PyNumber_Lshift:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Multiply:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Negative:function (ob:PPyObject):PPyObject; cdecl;
	PyNumber_Or:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Positive:function (ob:PPyObject):PPyObject; cdecl;
	PyNumber_Power:function (ob1,ob2,ob3:PPyObject):PPyObject; cdecl;
	PyNumber_Remainder:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Rshift:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Subtract:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyNumber_Xor:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyOS_InitInterrupts:procedure; cdecl;
	PyOS_InterruptOccurred:function :integer; cdecl;
	PyObject_CallObject:function (ob,args:PPyObject):PPyObject; cdecl;
	PyObject_Compare:function (ob1,ob2:PPyObject):integer; cdecl;
	PyObject_GetAttr:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyObject_GetAttrString:function (ob:PPyObject;c:PChar):PPyObject; cdecl;
	PyObject_GetItem:function (ob,key:PPyObject):PPyObject; cdecl;
	PyObject_DelItem:function (ob,key:PPyObject):PPyObject; cdecl;
	PyObject_HasAttrString:function (ob:PPyObject;key:PChar):integer; cdecl;
	PyObject_Hash:function (ob:PPyObject):LONGINT; cdecl;
	PyObject_IsTrue:function (ob:PPyObject):integer; cdecl;
	PyObject_Length:function (ob:PPyObject):integer; cdecl;
	PyObject_Repr:function (ob:PPyObject):PPyObject; cdecl;
	PyObject_SetAttr:function (ob1,ob2,ob3:PPyObject):integer; cdecl;
	PyObject_SetAttrString:function (ob:PPyObject;key:Pchar;value:PPyObject):integer; cdecl;
	PyObject_SetItem:function (ob1,ob2,ob3:PPyObject):integer; cdecl;
	PyObject_Init:function (ob:PPyObject; t:PPyTypeObject):PPyObject; cdecl;
	PyObject_InitVar:function (ob:PPyObject; t:PPyTypeObject; size:integer):PPyObject; cdecl;
	PyObject_New:function (t:PPyTypeObject):PPyObject; cdecl;
	PyObject_NewVar:function (t:PPyTypeObject; size:integer):PPyObject; cdecl;
	PyObject_Free:procedure (ob:PPyObject); cdecl;
	PyObject_GetIter: function (obj: PPyObject) : PPyObject; cdecl;
	PyIter_Next: function (obj: PPyObject) : PPyObject; cdecl;
	PyObject_IsInstance:function (inst, cls:PPyObject):integer; cdecl;
	PyObject_IsSubclass:function (derived, cls:PPyObject):integer; cdecl;
	PyObject_Call:function (ob, args, kw:PPyObject):PPyObject; cdecl;
	PyObject_GenericGetAttr:function (obj, name : PPyObject) : PPyObject; cdecl;
	PyObject_GenericSetAttr:function (obj, name, value : PPyObject) : Integer; cdecl;
	PyObject_GC_Malloc:function (size:integer):PPyObject; cdecl;
	PyObject_GC_New:function (t:PPyTypeObject):PPyObject; cdecl;
	PyObject_GC_NewVar:function (t:PPyTypeObject; size:integer):PPyObject; cdecl;
	PyObject_GC_Resize:function (t:PPyObject; newsize:integer):PPyObject; cdecl;
	PyObject_GC_Del:procedure (ob:PPyObject); cdecl;
	PyObject_GC_Track:procedure (ob:PPyObject); cdecl;
	PyObject_GC_UnTrack:procedure (ob:PPyObject); cdecl;
	PyRange_New:function (l1,l2,l3:longint;i:integer):PPyObject; cdecl;
	PySequence_Check:function (ob:PPyObject):integer; cdecl;
	PySequence_Concat:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PySequence_Count:function (ob1,ob2:PPyObject):integer; cdecl;
	PySequence_GetItem:function (ob:PPyObject;i:integer):PPyObject; cdecl;
	PySequence_GetSlice:function (ob:PPyObject;i1,i2:integer):PPyObject; cdecl;
	PySequence_In:function (ob1,ob2:PPyObject):integer; cdecl;
	PySequence_Index:function (ob1,ob2:PPyObject):integer; cdecl;
	PySequence_Length:function (ob:PPyObject):integer; cdecl;
	PySequence_Repeat:function (ob:PPyObject;count:integer):PPyObject; cdecl;
	PySequence_SetItem:function (ob:PPyObject;i:integer;value:PPyObject):integer; cdecl;
	PySequence_SetSlice:function (ob:PPyObject;i1,i2:integer;value:PPyObject):integer; cdecl;
	PySequence_DelSlice:function (ob:PPyObject;i1,i2:integer):integer; cdecl;
	PySequence_Tuple:function (ob:PPyObject):PPyObject; cdecl;
	PySequence_Contains:function (ob, value:PPyObject):integer; cdecl;
	PySlice_GetIndices:function (ob:PPySliceObject;length:integer;var start,stop,step:integer):integer; cdecl;
	PySlice_GetIndicesEx:function (ob:PPySliceObject;length:integer;var start,stop,step,slicelength:integer):integer; cdecl;
	PySlice_New:function (start,stop,step:PPyObject):PPyObject; cdecl;
	PyString_Concat:procedure(var ob1:PPyObject;ob2:PPyObject); cdecl;
	PyString_ConcatAndDel:procedure(var ob1:PPyObject;ob2:PPyObject); cdecl;
	PyString_Format:function (ob1,ob2:PPyObject):PPyObject; cdecl;
	PyString_FromStringAndSize:function (s:PChar;i:integer):PPyObject; cdecl;
	PyString_Size:function (ob:PPyObject):integer; cdecl;
	PyString_DecodeEscape:function(s:PChar; len:integer; errors:PChar; unicode:integer; recode_encoding:PChar):PPyObject; cdecl;
	PyString_Repr:function(ob:PPyObject; smartquotes:integer):PPyObject; cdecl;
	PySys_GetObject:function (s:PChar):PPyObject; cdecl;
	//PySys_Init:procedure; cdecl;
	PySys_SetObject:function (s:PChar;ob:PPyObject):integer; cdecl;
	PySys_SetPath:procedure(path:PChar); cdecl;
	//PyTraceBack_Fetch:function :PPyObject; cdecl;
	PyTraceBack_Here:function (p:pointer):integer; cdecl;
	PyTraceBack_Print:function (ob1,ob2:PPyObject):integer; cdecl;
	//PyTraceBack_Store:function (ob:PPyObject):integer; cdecl;
	PyTuple_GetItem:function (ob:PPyObject;i:integer):PPyObject; cdecl;
	PyTuple_GetSlice:function (ob:PPyObject;i1,i2:integer):PPyObject; cdecl;
	PyTuple_New:function (size:Integer):PPyObject; cdecl;
	PyTuple_SetItem:function (ob:PPyObject;key:integer;value:PPyObject):integer; cdecl;
	PyTuple_Size:function (ob:PPyObject):integer; cdecl;
	PyType_IsSubtype:function (a, b : PPyTypeObject):integer; cdecl;
	PyType_GenericAlloc:function(atype: PPyTypeObject; nitems:Integer) : PPyObject; cdecl;
	PyType_GenericNew:function(atype: PPyTypeObject; args, kwds : PPyObject) : PPyObject; cdecl;
	PyType_Ready:function(atype: PPyTypeObject) : integer; cdecl;
	PyUnicode_FromWideChar:function (const w:PWideChar; size:integer):PPyObject; cdecl;
	PyUnicode_AsWideChar:function (unicode: PPyObject; w:PWideChar; size:integer):integer; cdecl;
	PyUnicode_FromOrdinal:function (ordinal:integer):PPyObject; cdecl;
	PyWeakref_GetObject: function ( ref : PPyObject) : PPyObject; cdecl;
	PyWeakref_NewProxy: function ( ob, callback : PPyObject) : PPyObject; cdecl;
	PyWeakref_NewRef: function ( ob, callback : PPyObject) : PPyObject; cdecl;
	PyWrapper_New: function ( ob1, ob2 : PPyObject) : PPyObject; cdecl;
	PyBool_FromLong: function ( ok : Integer) : PPyObject; cdecl;
	PyThreadState_SetAsyncExc: function(t_id :LongInt; exc :PPyObject) : Integer; cdecl;   
	Py_AtExit:function (proc: AtExitProc):integer; cdecl;
	//Py_Cleanup:procedure; cdecl;
	Py_CompileString:function (s1,s2:PChar;i:integer):PPyObject; cdecl;
	Py_FatalError:procedure(s:PChar); cdecl;
	Py_FindMethod:function (md:PPyMethodDef;ob:PPyObject;key:PChar):PPyObject; cdecl;
	Py_FindMethodInChain:function (mc:PPyMethodChain;ob:PPyObject;key:PChar):PPyObject; cdecl;
	Py_FlushLine:procedure; cdecl;
	_PyObject_New:function (obt:PPyTypeObject;ob:PPyObject):PPyObject; cdecl;
	_PyString_Resize:function (var ob:PPyObject;i:integer):integer; cdecl;
	Py_Finalize                     : procedure; cdecl;
	PyErr_ExceptionMatches          : function ( exc : PPyObject) : Integer; cdecl;
	PyErr_GivenExceptionMatches     : function ( raised_exc, exc : PPyObject) : Integer; cdecl;
	PyEval_EvalCode                 : function ( co : PPyCodeObject; globals, locals : PPyObject) : PPyObject; cdecl;
	Py_GetVersion                   : function : PChar; cdecl;
	Py_GetCopyright                 : function : PChar; cdecl;
	Py_GetExecPrefix                : function : PChar; cdecl;
	Py_GetPath                      : function : PChar; cdecl;
	Py_GetPrefix                    : function : PChar; cdecl;
	Py_GetProgramName               : function : PChar; cdecl;

	PyParser_SimpleParseString      : function ( str : PChar; start : Integer) : PNode; cdecl;
	PyNode_Free                     : procedure( n : PNode ); cdecl;
	PyErr_NewException              : function ( name : PChar; base, dict : PPyObject ) : PPyObject; cdecl;
	Py_Malloc                       : function ( size : Integer ) : Pointer;
	PyMem_Malloc                    : function ( size : Integer ) : Pointer;
	PyObject_CallMethod             : function ( obj : PPyObject; method, format : PChar ) : PPyObject; cdecl;

	{New exported Objects in Python 1.5}
	Py_SetProgramName               : procedure( name: PChar); cdecl;
	Py_IsInitialized                : function : integer; cdecl;
	Py_GetProgramFullPath           : function : PChar; cdecl;
	Py_NewInterpreter               : function : PPyThreadState; cdecl;
	Py_EndInterpreter               : procedure( tstate: PPyThreadState); cdecl;
	PyEval_AcquireLock              : procedure; cdecl;
	PyEval_ReleaseLock              : procedure; cdecl;
	PyEval_AcquireThread            : procedure( tstate: PPyThreadState); cdecl;
	PyEval_ReleaseThread            : procedure( tstate: PPyThreadState); cdecl;
	PyInterpreterState_New          : function : PPyInterpreterState; cdecl;
	PyInterpreterState_Clear        : procedure( interp: PPyInterpreterState); cdecl;
	PyInterpreterState_Delete       : procedure( interp: PPyInterpreterState); cdecl;
	PyThreadState_New               : function ( interp: PPyInterpreterState): PPyThreadState; cdecl;
	PyThreadState_Clear             : procedure( tstate: PPyThreadState); cdecl;
	PyThreadState_Delete            : procedure( tstate: PPyThreadState); cdecl;
	PyThreadState_Get               : function : PPyThreadState; cdecl;
	PyThreadState_Swap              : function ( tstate: PPyThreadState): PPyThreadState; cdecl;
	PyErr_SetInterrupt              : procedure; cdecl;

	{Further exported Objects, may be implemented later}
	{
	PyCode_New: Pointer;
	PyErr_SetInterrupt: Pointer;
	PyFile_AsFile: Pointer;
	PyFile_FromFile: Pointer;
	PyFloat_AsString: Pointer;
	PyFrame_BlockPop: Pointer;
	PyFrame_BlockSetup: Pointer;
	PyFrame_ExtendStack: Pointer;
	PyFrame_FastToLocals: Pointer;
	PyFrame_LocalsToFast: Pointer;
	PyFrame_New: Pointer;
	PyGrammar_AddAccelerators: Pointer;
	PyGrammar_FindDFA: Pointer;
	PyGrammar_LabelRepr: Pointer;
	PyInstance_DoBinOp: Pointer;
	PyInt_GetMax: Pointer;
	PyMarshal_Init: Pointer;
	PyMarshal_ReadLongFromFile: Pointer;
	PyMarshal_ReadObjectFromFile: Pointer;
	PyMarshal_ReadObjectFromString: Pointer;
	PyMarshal_WriteLongToFile: Pointer;
	PyMarshal_WriteObjectToFile: Pointer;
	PyMember_Get: Pointer;
	PyMember_Set: Pointer;
	PyNode_AddChild: Pointer;
	PyNode_Compile: Pointer;
	PyNode_New: Pointer;
	PyOS_GetLastModificationTime: Pointer;
	PyOS_Readline: Pointer;
	PyOS_strtol: Pointer;
	PyOS_strtoul: Pointer;
	PyObject_CallFunction: Pointer;
	PyObject_CallMethod: Pointer;
	PyObject_Print: Pointer;
	PyParser_AddToken: Pointer;
	PyParser_Delete: Pointer;
	PyParser_New: Pointer;
	PyParser_ParseFile: Pointer;
	PyParser_ParseString: Pointer;
	PyParser_SimpleParseFile: Pointer;
	PyRun_AnyFile: Pointer;
	PyRun_File: Pointer;
	PyRun_InteractiveLoop: Pointer;
	PyRun_InteractiveOne: Pointer;
	PyRun_SimpleFile: Pointer;
	PySys_GetFile: Pointer;
	PyToken_OneChar: Pointer;
	PyToken_TwoChars: Pointer;
	PyTokenizer_Free: Pointer;
	PyTokenizer_FromFile: Pointer;
	PyTokenizer_FromString: Pointer;
	PyTokenizer_Get: Pointer;
	Py_Main: Pointer;
	_PyObject_NewVar: Pointer;
	_PyParser_Grammar: Pointer;
	_PyParser_TokenNames: Pointer;
	_PyThread_Started: Pointer;
	_Py_c_diff: Pointer;
	_Py_c_neg: Pointer;
	_Py_c_pow: Pointer;
	_Py_c_prod: Pointer;
	_Py_c_quot: Pointer;
	_Py_c_sum: Pointer;
	
	}


procedure Py_INCREF   ( op: PPyObject);
procedure Py_DECREF   ( op: PPyObject);
procedure Py_XINCREF  ( op: PPyObject);
procedure Py_XDECREF  ( op: PPyObject);

function Py_GetPlatform: PChar; cdecl;

function PyArg_Parse     ( args: PPyObject; format: PChar; argp: array of Pointer): Integer; cdecl;
function PyArg_ParseTuple( args: PPyObject; format: PChar; argp: array of Pointer): Integer; cdecl;

// This function handles all cardinals, pointer types (with no adjustment of pointers!)
// (Extended) floats, which are handled as Python doubles and currencies, handled
// as (normalized) Python doubles.
function Py_BuildValue( format: PChar; args: array of const): PPyObject; cdecl;
function PyCode_Addr2Line( co: PPyCodeObject; addrq : Integer ) : Integer; cdecl;
function Py_GetBuildInfo: PChar; cdecl;
function PyImport_ExecCodeModule( const AName : String; codeobject : PPyObject) : PPyObject;
function PyString_Check( obj : PPyObject ) : Boolean;
function PyString_CheckExact( obj : PPyObject ) : Boolean;
function PyFloat_Check( obj : PPyObject ) : Boolean;
function PyFloat_CheckExact( obj : PPyObject ) : Boolean;
function PyInt_Check( obj : PPyObject ) : Boolean;
function PyInt_CheckExact( obj : PPyObject ) : Boolean;
function PyLong_Check( obj : PPyObject ) : Boolean;
function PyLong_CheckExact( obj : PPyObject ) : Boolean;
function PyTuple_Check( obj : PPyObject ) : Boolean;
function PyTuple_CheckExact( obj : PPyObject ) : Boolean;
function PyInstance_Check( obj : PPyObject ) : Boolean;
function PyClass_Check( obj : PPyObject ) : Boolean;
function PyMethod_Check( obj : PPyObject ) : Boolean;
function PyList_Check( obj : PPyObject ) : Boolean;
function PyList_CheckExact( obj : PPyObject ) : Boolean;
function PyDict_Check( obj : PPyObject ) : Boolean;
function PyDict_CheckExact( obj : PPyObject ) : Boolean;
function PyModule_Check( obj : PPyObject ) : Boolean;
function PyModule_CheckExact( obj : PPyObject ) : Boolean;
function PySlice_Check( obj : PPyObject ) : Boolean;
function PyFunction_Check( obj : PPyObject ) : Boolean;
function PyIter_Check( obj : PPyObject ) : Boolean;
function PyUnicode_Check( obj : PPyObject ) : Boolean;
function PyUnicode_CheckExact( obj : PPyObject ) : Boolean;
function PyType_IS_GC(t : PPyTypeObject ) : Boolean;
function PyObject_IS_GC( obj : PPyObject ) : Boolean;
function PyWeakref_Check( obj : PPyObject ) : Boolean;
function PyWeakref_CheckRef( obj : PPyObject ) : Boolean;
function PyWeakref_CheckProxy( obj : PPyObject ) : Boolean;
function PyBool_Check( obj : PPyObject ) : Boolean;
function PyBaseString_Check( obj : PPyObject ) : Boolean;
function PyEnum_Check( obj : PPyObject ) : Boolean;
function PyObject_TypeCheck(obj:PPyObject; t:PPyTypeObject) : Boolean;
function Py_InitModule( const AName : PChar; md : PPyMethodDef) : PPyObject;
function PyType_HasFeature(AType : PPyTypeObject; AFlag : Integer) : Boolean;

const
	LIBPYTHON_UNDEFINED = 0;
	LIBPYTHON_MISSING = 1;
	LIBPYTHON_INCOMPATIBLE = 2;
	LIBPYTHON_READY = 3;

var
	libpython_handle: HMODULE = 0;
	libpython_status: byte = LIBPYTHON_UNDEFINED;

function libpython_load( name: pChar ): byte;
procedure libpython_free;

IMPLEMENTATION

procedure Py_INCREF(op: PPyObject);
begin
	Inc(op^.ob_refcnt);
end;

procedure Py_DECREF(op: PPyObject);
begin
	with op^ do begin
		Dec(ob_refcnt);
		if ob_refcnt = 0 then begin
			ob_type^.tp_dealloc(op);
		end;
	end;
end;

procedure Py_XINCREF(op: PPyObject);
begin
	if op <> nil then
		Py_INCREF(op);
end;

procedure Py_XDECREF(op: PPyObject);
begin
	if op <> nil then
		Py_DECREF(op);
end;

function Py_GetPlatform: PChar; cdecl;
begin
	Py_GetPlatform := 'win32';
end;

function Py_BuildValue( format: PChar; args: array of const): PPyObject; {$IFNDEF FPC} assembler; {$ENDIF} cdecl;
const	tenthousand : double = 10000.0;
var	temp : Double;
{$IFDEF FPC} begin {$ENDIF}
asm
        push ebx             // save ebx, four registers needed
        mov eax,[args]       // gets args pointer
        mov edx,[args+$4]    // gets invisible argument count-1 parameter
@loop1: lea ebx,[eax+edx*8]  // get argument address
        cmp byte ptr [ebx+$4], vtExtended // Is Extended?
        jz  @IsDouble
        cmp byte ptr [ebx+$4], vtCurrency // Is Currency, 64bit integer?
        jnz @NoDouble
@IsCurrency:
        mov ebx,[ebx]        // get 64 bit integer
        fild qword ptr [ebx] // put on float stack
        wait
        fdiv tenthousand     // normalize to double float
        jmp @PushDouble      // Handle as double value
@IsDouble:
        mov ebx,[ebx]        // get extended float
        fld tbyte ptr [ebx]  // put on float stack
@PushDouble:
        wait
        fstp temp            //get double from float stack
        wait
        lea ebx,temp         // get temp
        mov ecx,[ebx+$4]     // push 4 high bytes of temp
        push ecx
@NoDouble:
        mov ecx,[ebx]        // get one argument
        push ecx             // push 4 bytes of the argument
        dec edx              // go to the next argument
        jns  @loop1          // next argument, if any
        mov  eax,DLL_Py_BuildValue	// get invisible self parameter
        mov  edx,format      // call DLL Py_Builtin function
        push edx
        call eax
        mov ebx,[ebp-$c]       // get saved ebx from ebp-based offset
                               // (current esp could not be used!)
end;
{$IFDEF FPC} end; {$ENDIF}

{DELPHI does the right thing here. It automatically generates
 a copy of the argp on the stack}
function PyArg_Parse( args: PPyObject; format: PChar; argp: array of Pointer): Integer; cdecl;
begin
	{ Do not optimize this to a "pure" assembler routine, because such
	  a routine does not copy the array arguments in the prologue code }
	asm
		lea edx, format
		push [edx]

		sub edx, TYPE PChar
		push [edx]

		mov eax, DLL_PyArg_Parse
		call eax

		pop edx
		pop edx
		mov Result, eax
	end;
end;

function PyArg_ParseTuple( args: PPyObject; format: PChar; argp: array of Pointer): Integer; cdecl;
begin
	Result := 0;
	{ Do not optimize this to a "pure" assembler routine, because such
	  a routine does not copy the array arguments in the prologue code }
	asm
		lea edx, format
		push [edx]

		sub edx, TYPE PChar
		push [edx]

		//mov eax, DLL_PyArg_ParseTuple
		//call eax
                call DLL_PyArg_ParseTuple

		pop edx
		pop edx
		mov Result, eax
	end;
end;

// This function is copied from compile.c because it was not
// exported in the Dll
function PyCode_Addr2Line( co: PPyCodeObject; addrq : Integer ) : Integer; cdecl;
var	size : Integer;
	p : PChar;
	line : Integer;
	addr : Integer;
	cpt : Integer;
begin
	if Assigned(DLL_PyCode_Addr2Line) then begin
		Result := DLL_PyCode_Addr2Line( co, addrq );
		Exit;
	end;
	size := PyString_Size(co^.co_lnotab) div 2;
	p := PyString_AsString(co^.co_lnotab);
	line := co^.co_firstlineno;
	addr := 0;
	cpt := 0;
	while (size-1) >= 0 do begin
		Dec( size );
		Inc( addr, Ord(p[cpt]) );
		Inc( cpt );
		if addr > addrq then
			Break;
		Inc( line, Ord(p[cpt]) );
		Inc( cpt );
	end;
	Result := line;
end;

function Py_GetBuildInfo : PChar; cdecl;
begin
	if Assigned(DLL_Py_GetBuildInfo) then begin
		Result := DLL_Py_GetBuildInfo;
		Exit;
	end;
	Result := 'No build info';
end;

function PyImport_ExecCodeModule( const AName : String; codeobject : PPyObject) : PPyObject;
var	m, d, v, modules : PPyObject;
begin
	if Assigned(DLL_PyImport_ExecCodeModule) then begin
		Result := DLL_PyImport_ExecCodeModule(PChar(AName), codeobject);
		Exit;
	end;
	
	m := PyImport_AddModule(PChar(AName));
	if not Assigned(m) then begin
		Result := nil;
		Exit;
	end;
	
	d := PyModule_GetDict(m);
	if PyDict_GetItemString(d, '__builtins__') = nil then begin
		if PyDict_SetItemString(d, '__builtins__', PyEval_GetBuiltins) <> 0 then begin
			Result := nil;
			Exit;
		end;
	end;
	
	//Remember the fielname as the __file__ attribute
	if PyDict_SetItemString(d, '__file__', PPyCodeObject(codeobject)^.co_filename) <> 0 then
		PyErr_Clear; // Not important enough to report
	v := PyEval_EvalCode(PPyCodeObject(codeobject), d, d); // XXX owner ?
	if not Assigned(v) then begin
		Result := nil;
		Exit;
	end;
	
	Py_XDECREF(v);
	modules := PyImport_GetModuleDict;
	if PyDict_GetItemString(modules, PChar(AName)) = nil then begin
		PyErr_SetString(PyExc_ImportError^, PChar(Format('Loaded module %.200s not found in sys.modules', [AName])));
		Result := nil;
		Exit;
	end;
	
	Py_XINCREF(m);
	Result := m;
end;

function PyString_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyString_Type);
end;

function PyString_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyString_Type));
end;

function PyFloat_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyFloat_Type);
end;

function PyFloat_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyFloat_Type));
end;

function PyInt_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyInt_Type);
end;

function PyInt_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyInt_Type));
end;

function PyLong_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyLong_Type);
end;

function PyLong_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyLong_Type));
end;

function PyTuple_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyTuple_Type);
end;

function PyTuple_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyTuple_Type));
end;

function PyInstance_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyInstance_Type));
end;

function PyClass_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyClass_Type));
end;

function PyMethod_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyMethod_Type));
end;

function PyList_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyList_Type);
end;

function PyList_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyList_Type));
end;

function PyDict_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyDict_Type);
end;

function PyDict_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyDict_Type));
end;

function PyModule_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyModule_Type);
end;

function PyModule_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyModule_Type));
end;

function PySlice_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PySlice_Type));
end;

function PyFunction_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and ((obj^.ob_type = PPyTypeObject(PyCFunction_Type)) or (obj^.ob_type = PPyTypeObject(PyFunction_Type)));
end;

function PyIter_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (PyType_HasFeature(obj^.ob_type, Py_TPFLAGS_HAVE_ITER) and Assigned(obj^.ob_type^.tp_iternext));
end;

function PyUnicode_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyUnicode_Type);
end;

function PyUnicode_CheckExact(obj: PPyObject): Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyUnicode_Type));
end;

function PyType_IS_GC(t : PPyTypeObject ) : Boolean;
begin
	Result := PyType_HasFeature(t, Py_TPFLAGS_HAVE_GC);
end;

function PyObject_IS_GC( obj : PPyObject ) : Boolean;
begin
	Result := PyType_IS_GC(obj^.ob_type) and (not Assigned(obj^.ob_type^.tp_is_gc) or (obj^.ob_type^.tp_is_gc(obj) = 1));
end;

function PyWeakref_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (PyWeakref_CheckRef(obj) or PyWeakref_CheckProxy(obj));
end;

function PyWeakref_CheckRef( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(_PyWeakref_RefType));
end;

function PyWeakref_CheckProxy( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and ( (obj^.ob_type = PPyTypeObject(_PyWeakref_ProxyType)) or (obj^.ob_type = PPyTypeObject(_PyWeakref_CallableProxyType)) );
end;

function PyBool_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyBool_Type);
end;

function PyBaseString_Check( obj : PPyObject ) : Boolean;
begin
	Result := PyObject_TypeCheck(obj, PyBaseString_Type);
end;

function PyEnum_Check( obj : PPyObject ) : Boolean;
begin
	Result := Assigned( obj ) and (obj^.ob_type = PPyTypeObject(PyEnum_Type));
end;

function PyObject_TypeCheck(obj : PPyObject; t : PPyTypeObject) : Boolean;
begin
	Result := Assigned(obj) and (obj^.ob_type = t);
	if not Result and Assigned(obj) and Assigned(t) then
		Result := PyType_IsSubtype(obj^.ob_type, t) = 1;
end;

function Py_InitModule( const AName : PChar; md : PPyMethodDef) : PPyObject;
begin
	result := Py_InitModule4( AName, md, nil, nil, APIVersion );
end;

function PyType_HasFeature(AType : PPyTypeObject; AFlag : Integer) : Boolean;
begin
	Result := (((AType)^.tp_flags and (AFlag)) <> 0);
end;

function libpython_load( name: pChar ): byte;

	function assign_proc( name: String ) : Pointer;
	begin
		Result := GetProcAddress( libpython_handle, pChar( name ) );
		if Result = nil then
                        libpython_status := LIBPYTHON_INCOMPATIBLE;
	end;

begin
	libpython_free;
	if name = nil then
		name := PYTHON_VERSION;
	libpython_handle := LoadLibrary( name );
	
	if libpython_handle = 0 then
		libpython_status := LIBPYTHON_MISSING
	else begin
		libpython_status := LIBPYTHON_READY;
                Py_DebugFlag := assign_proc( 'Py_DebugFlag' );
		Py_VerboseFlag := assign_proc( 'Py_VerboseFlag' );
		Py_InteractiveFlag := assign_proc( 'Py_InteractiveFlag' );
		Py_OptimizeFlag := assign_proc( 'Py_OptimizeFlag' );
		Py_NoSiteFlag := assign_proc( 'Py_NoSiteFlag' );
		Py_UseClassExceptionsFlag := assign_proc( 'Py_UseClassExceptionsFlag' );
		Py_FrozenFlag := assign_proc( 'Py_FrozenFlag' );
		Py_TabcheckFlag := assign_proc( 'Py_TabcheckFlag' );
		Py_UnicodeFlag := assign_proc( 'Py_UnicodeFlag' );
		Py_IgnoreEnvironmentFlag := assign_proc( 'Py_IgnoreEnvironmentFlag' );
		Py_DivisionWarningFlag := assign_proc( 'Py_DivisionWarningFlag' );

		//_PySys_TraceFunc := assign_proc( '_PySys_TraceFunc' );
		//_PySys_ProfileFunc := assign_proc( '_PySys_ProfileFunc' );

		Py_None := assign_proc( '_Py_NoneStruct' );
		Py_Ellipsis := assign_proc( '_Py_EllipsisObject' );
		Py_False := assign_proc( '_Py_ZeroStruct' );
		Py_True := assign_proc( '_Py_TrueStruct' );
		Py_NotImplemented := assign_proc( '_Py_NotImplementedStruct' );

		PyImport_FrozenModules := assign_proc( 'PyImport_FrozenModules' );

		PyExc_AttributeError := assign_proc( 'PyExc_AttributeError' );
		PyExc_EOFError := assign_proc( 'PyExc_EOFError' );
		PyExc_IOError := assign_proc( 'PyExc_IOError' );
		PyExc_ImportError := assign_proc( 'PyExc_ImportError' );
		PyExc_IndexError := assign_proc( 'PyExc_IndexError' );
		PyExc_KeyError := assign_proc( 'PyExc_KeyError' );
		PyExc_KeyboardInterrupt := assign_proc( 'PyExc_KeyboardInterrupt' );
		PyExc_MemoryError := assign_proc( 'PyExc_MemoryError' );
		PyExc_NameError := assign_proc( 'PyExc_NameError' );
		PyExc_OverflowError := assign_proc( 'PyExc_OverflowError' );
		PyExc_RuntimeError := assign_proc( 'PyExc_RuntimeError' );
		PyExc_SyntaxError := assign_proc( 'PyExc_SyntaxError' );
		PyExc_SystemError := assign_proc( 'PyExc_SystemError ');
		PyExc_SystemExit := assign_proc( 'PyExc_SystemExit' );
		PyExc_TypeError := assign_proc( 'PyExc_TypeError' );
		PyExc_ValueError := assign_proc( 'PyExc_ValueError' );
		PyExc_ZeroDivisionError := assign_proc( 'PyExc_ZeroDivisionError' );
		PyExc_ArithmeticError := assign_proc( 'PyExc_ArithmeticError' );
		PyExc_Exception := assign_proc( 'PyExc_Exception' );
		PyExc_FloatingPointError := assign_proc( 'PyExc_FloatingPointError' );
		PyExc_LookupError := assign_proc( 'PyExc_LookupError' );
		PyExc_StandardError := assign_proc( 'PyExc_StandardError' );
		PyExc_AssertionError := assign_proc( 'PyExc_AssertionError' );
		PyExc_EnvironmentError := assign_proc( 'PyExc_EnvironmentError' );
		PyExc_IndentationError := assign_proc( 'PyExc_IndentationError' );
		PyExc_MemoryErrorInst := assign_proc( 'PyExc_MemoryErrorInst' );
		PyExc_NotImplementedError := assign_proc( 'PyExc_NotImplementedError' );
		PyExc_OSError := assign_proc( 'PyExc_OSError' );
		PyExc_TabError := assign_proc( 'PyExc_TabError' );
		PyExc_UnboundLocalError := assign_proc( 'PyExc_UnboundLocalError' );
		PyExc_UnicodeError := assign_proc( 'PyExc_UnicodeError' );

  		{$IFDEF WIN32}
  		PyExc_WindowsError := assign_proc( 'PyExc_WindowsError' );
  		{$ENDIF}
  		
		PyExc_Warning := assign_proc( 'PyExc_Warning' );
		PyExc_DeprecationWarning := assign_proc( 'PyExc_DeprecationWarning' );
		PyExc_RuntimeWarning := assign_proc( 'PyExc_RuntimeWarning' );
		PyExc_SyntaxWarning := assign_proc( 'PyExc_SyntaxWarning' );
		PyExc_UserWarning := assign_proc( 'PyExc_UserWarning' );
		PyExc_OverflowWarning := assign_proc( 'PyExc_OverflowWarning' );
		PyExc_ReferenceError := assign_proc( 'PyExc_ReferenceError' );
		PyExc_StopIteration := assign_proc( 'PyExc_StopIteration' );
		PyExc_FutureWarning := assign_proc( 'PyExc_FutureWarning' );
		PyExc_PendingDeprecationWarning := assign_proc( 'PyExc_PendingDeprecationWarning' );
		PyExc_UnicodeDecodeError := assign_proc( 'PyExc_UnicodeDecodeError' );
		PyExc_UnicodeEncodeError := assign_proc( 'PyExc_UnicodeEncodeError' );
		PyExc_UnicodeTranslateError := assign_proc( 'PyExc_UnicodeTranslateError' );
		PyType_Type := assign_proc( 'PyType_Type' );
		PyCFunction_Type := assign_proc( 'PyCFunction_Type' );
		PyCObject_Type := assign_proc( 'PyCObject_Type' );
		PyClass_Type := assign_proc( 'PyClass_Type' );
		PyCode_Type := assign_proc( 'PyCode_Type' );
		PyComplex_Type := assign_proc( 'PyComplex_Type' );
		PyDict_Type := assign_proc( 'PyDict_Type' );
		PyFile_Type := assign_proc( 'PyFile_Type' );
		PyFloat_Type := assign_proc( 'PyFloat_Type' );
		PyFrame_Type := assign_proc( 'PyFrame_Type' );
		PyFunction_Type := assign_proc( 'PyFunction_Type' );
		PyInstance_Type := assign_proc( 'PyInstance_Type' );
		PyInt_Type := assign_proc( 'PyInt_Type' );
		PyList_Type := assign_proc( 'PyList_Type' );
		PyLong_Type := assign_proc( 'PyLong_Type' );
		PyMethod_Type := assign_proc( 'PyMethod_Type' );
		PyModule_Type := assign_proc( 'PyModule_Type' );
		PyObject_Type := assign_proc( 'PyObject_Type' );
		PyRange_Type := assign_proc( 'PyRange_Type' );
		PySlice_Type := assign_proc( 'PySlice_Type' );
		PyString_Type := assign_proc( 'PyString_Type' );
		PyTuple_Type := assign_proc( 'PyTuple_Type' );
		PyUnicode_Type := assign_proc( 'PyUnicode_Type' );
		PyBaseObject_Type := assign_proc( 'PyBaseObject_Type' );
		PyBuffer_Type := assign_proc( 'PyBuffer_Type' );
		PyCallIter_Type := assign_proc( 'PyCallIter_Type' );
		PyCell_Type := assign_proc( 'PyCell_Type' );
		PyClassMethod_Type := assign_proc( 'PyClassMethod_Type' );
		PyProperty_Type := assign_proc( 'PyProperty_Type' );
		PySeqIter_Type := assign_proc( 'PySeqIter_Type' );
		PyStaticMethod_Type := assign_proc( 'PyStaticMethod_Type' );
		PySuper_Type := assign_proc( 'PySuper_Type' );
		PySymtableEntry_Type := assign_proc( 'PySymtableEntry_Type' );
		PyTraceBack_Type := assign_proc( 'PyTraceBack_Type' );
		PyWrapperDescr_Type := assign_proc( 'PyWrapperDescr_Type' );
		_PyWeakref_RefType := assign_proc( '_PyWeakref_RefType' );
		_PyWeakref_ProxyType := assign_proc( '_PyWeakref_ProxyType' );
		_PyWeakref_CallableProxyType := assign_proc( '_PyWeakref_CallableProxyType' );
		PyBaseString_Type := assign_proc( 'PyBaseString_Type' );
		PyBool_Type := assign_proc( 'PyBool_Type' );
		PyEnum_Type := assign_proc( 'PyEnum_Type' );

		//PyArg_GetObject := assign_proc( 'PyArg_GetObject' );
		//PyArg_GetLong := assign_proc( 'PyArg_GetLong' );
		//PyArg_GetShort := assign_proc( 'PyArg_GetShort' );
		//PyArg_GetFloat := assign_proc( 'PyArg_GetFloat' );
		//PyArg_GetString := assign_proc( 'PyArg_GetString' );
		//PyArgs_VaParse := assign_proc( 'PyArgs_VaParse' );
		//Py_VaBuildValue := assign_proc( 'Py_VaBuildValue' );
		//PyBuiltin_Init := assign_proc( 'PyBuiltin_Init' );
		PyComplex_FromCComplex := assign_proc( 'PyComplex_FromCComplex' );
		PyComplex_FromDoubles := assign_proc( 'PyComplex_FromDoubles' );
		PyComplex_RealAsDouble := assign_proc( 'PyComplex_RealAsDouble' );
		PyComplex_ImagAsDouble := assign_proc( 'PyComplex_ImagAsDouble' );
		PyComplex_AsCComplex := assign_proc( 'PyComplex_AsCComplex' );
		PyCFunction_GetFunction := assign_proc( 'PyCFunction_GetFunction' );
		PyCFunction_GetSelf := assign_proc( 'PyCFunction_GetSelf' );
		PyCallable_Check := assign_proc( 'PyCallable_Check' );
		PyCObject_FromVoidPtr := assign_proc( 'PyCObject_FromVoidPtr' );
		PyCObject_AsVoidPtr := assign_proc( 'PyCObject_AsVoidPtr' );
		PyClass_New := assign_proc( 'PyClass_New' );
		PyClass_IsSubclass := assign_proc( 'PyClass_IsSubclass' );
		PyDict_GetItem := assign_proc( 'PyDict_GetItem' );
		PyDict_SetItem := assign_proc( 'PyDict_SetItem' );
		PyDict_DelItem := assign_proc( 'PyDict_DelItem' );
		PyDict_Clear := assign_proc( 'PyDict_Clear' );
		PyDict_Next := assign_proc( 'PyDict_Next' );
		PyDict_Keys := assign_proc( 'PyDict_Keys' );
		PyDict_Values := assign_proc( 'PyDict_Values' );
		PyDict_Items := assign_proc( 'PyDict_Items' );
		PyDict_Size := assign_proc( 'PyDict_Size' );
		PyDict_DelItemString := assign_proc( 'PyDict_DelItemString' );
		PyDict_Copy := assign_proc( 'PyDict_Copy' );
		PyDictProxy_New := assign_proc( 'PyDictProxy_New' );
		Py_InitModule4 := assign_proc( 'Py_InitModule4' );
		PyErr_Print := assign_proc( 'PyErr_Print' );
		PyErr_SetNone := assign_proc( 'PyErr_SetNone' );
		PyErr_SetObject := assign_proc( 'PyErr_SetObject' );
		PyErr_Restore := assign_proc( 'PyErr_Restore' );
		PyErr_BadArgument := assign_proc( 'PyErr_BadArgument' );
		PyErr_NoMemory := assign_proc( 'PyErr_NoMemory' );
		PyErr_SetFromErrno := assign_proc( 'PyErr_SetFromErrno' );
		PyErr_BadInternalCall := assign_proc( 'PyErr_BadInternalCall' );
		PyErr_CheckSignals := assign_proc( 'PyErr_CheckSignals' );
		PyErr_Occurred := assign_proc( 'PyErr_Occurred' );
		PyErr_Clear := assign_proc( 'PyErr_Clear' );
		PyErr_Fetch := assign_proc( 'PyErr_Fetch' );
                PyErr_NormalizeException := assign_proc( 'PyErr_NormalizeException' );
		PyErr_SetString := assign_proc( 'PyErr_SetString' );
		PyEval_GetBuiltins := assign_proc( 'PyEval_GetBuiltins' );
		PyImport_GetModuleDict := assign_proc( 'PyImport_GetModuleDict' );
		PyInt_FromLong := assign_proc( 'PyInt_FromLong' );
		DLL_PyArg_ParseTuple := assign_proc( 'PyArg_ParseTuple' );
		DLL_PyArg_Parse := assign_proc( 'PyArg_Parse' );
		DLL_Py_BuildValue := assign_proc( 'Py_BuildValue' );
		Py_Initialize := assign_proc( 'Py_Initialize' );
		PyDict_New := assign_proc( 'PyDict_New' );
		PyDict_SetItemString := assign_proc( 'PyDict_SetItemString' );
		PyModule_GetDict := assign_proc( 'PyModule_GetDict' );
		PyObject_Str := assign_proc( 'PyObject_Str' );
		PyRun_String := assign_proc( 'PyRun_String' );
		PyRun_SimpleString := assign_proc( 'PyRun_SimpleString' );
		PyDict_GetItemString := assign_proc( 'PyDict_GetItemString' );
		PyString_AsString := assign_proc( 'PyString_AsString' );
		PyString_FromString := assign_proc( 'PyString_FromString' );
		PySys_SetArgv := assign_proc( 'PySys_SetArgv' );
		Py_Exit := assign_proc( 'Py_Exit' );

		PyCFunction_New := assign_proc( 'PyCFunction_New' );
		PyEval_CallObject := assign_proc( 'PyEval_CallObject' );
		PyEval_CallObjectWithKeywords := assign_proc( 'PyEval_CallObjectWithKeywords' );
		PyEval_GetFrame := assign_proc( 'PyEval_GetFrame' );
		PyEval_GetGlobals := assign_proc( 'PyEval_GetGlobals' );
		PyEval_GetLocals := assign_proc( 'PyEval_GetLocals' );
		//PyEval_GetOwner := assign_proc( 'PyEval_GetOwner' );
		PyEval_GetRestricted := assign_proc( 'PyEval_GetRestricted' );
		PyEval_InitThreads := assign_proc( 'PyEval_InitThreads' );
		PyEval_RestoreThread := assign_proc( 'PyEval_RestoreThread' );
		PyEval_SaveThread := assign_proc( 'PyEval_SaveThread' );
		PyFile_FromString := assign_proc( 'PyFile_FromString' );
		PyFile_GetLine := assign_proc( 'PyFile_GetLine' );
		PyFile_Name := assign_proc( 'PyFile_Name' );
		PyFile_SetBufSize := assign_proc( 'PyFile_SetBufSize' );
		PyFile_SoftSpace := assign_proc( 'PyFile_SoftSpace' );
		PyFile_WriteObject := assign_proc( 'PyFile_WriteObject' );
		PyFile_WriteString := assign_proc( 'PyFile_WriteString' );
		PyFloat_AsDouble := assign_proc( 'PyFloat_AsDouble' );
		PyFloat_FromDouble := assign_proc( 'PyFloat_FromDouble' );
		PyFunction_GetCode := assign_proc( 'PyFunction_GetCode' );
		PyFunction_GetGlobals := assign_proc( 'PyFunction_GetGlobals' );
		PyFunction_New := assign_proc( 'PyFunction_New' );
		PyImport_AddModule := assign_proc( 'PyImport_AddModule' );
		PyImport_Cleanup := assign_proc( 'PyImport_Cleanup' );
		PyImport_GetMagicNumber := assign_proc( 'PyImport_GetMagicNumber' );
		PyImport_ImportFrozenModule := assign_proc( 'PyImport_ImportFrozenModule' );
		PyImport_ImportModule := assign_proc( 'PyImport_ImportModule' );
		PyImport_Import := assign_proc( 'PyImport_Import' );
		//PyImport_Init := assign_proc( 'PyImport_Init' );
		PyImport_ReloadModule := assign_proc( 'PyImport_ReloadModule' );
		PyInstance_New := assign_proc( 'PyInstance_New' );
		PyInt_AsLong := assign_proc( 'PyInt_AsLong' );
		PyList_Append := assign_proc( 'PyList_Append' );
		PyList_AsTuple := assign_proc( 'PyList_AsTuple' );
		PyList_GetItem := assign_proc( 'PyList_GetItem' );
		PyList_GetSlice := assign_proc( 'PyList_GetSlice' );
		PyList_Insert := assign_proc( 'PyList_Insert' );
		PyList_New := assign_proc( 'PyList_New' );
		PyList_Reverse := assign_proc( 'PyList_Reverse' );
		PyList_SetItem := assign_proc( 'PyList_SetItem' );
		PyList_SetSlice := assign_proc( 'PyList_SetSlice' );
		PyList_Size := assign_proc( 'PyList_Size' );
		PyList_Sort := assign_proc( 'PyList_Sort' );
		PyLong_AsDouble := assign_proc( 'PyLong_AsDouble' );
		PyLong_AsLong := assign_proc( 'PyLong_AsLong' );
		PyLong_FromDouble := assign_proc( 'PyLong_FromDouble' );
		PyLong_FromLong := assign_proc( 'PyLong_FromLong' );
		PyLong_FromString := assign_proc( 'PyLong_FromString' );
		PyLong_FromString := assign_proc( 'PyLong_FromString' );
		PyLong_FromUnsignedLong := assign_proc( 'PyLong_FromUnsignedLong' );
		PyLong_AsUnsignedLong := assign_proc( 'PyLong_AsUnsignedLong' );
		PyLong_FromUnicode := assign_proc( 'PyLong_FromUnicode' );
		PyLong_FromLongLong := assign_proc( 'PyLong_FromLongLong' );
		PyLong_AsLongLong := assign_proc( 'PyLong_AsLongLong' );
		PyMapping_Check := assign_proc( 'PyMapping_Check' );
		PyMapping_GetItemString := assign_proc( 'PyMapping_GetItemString' );
		PyMapping_HasKey := assign_proc( 'PyMapping_HasKey' );
		PyMapping_HasKeyString := assign_proc( 'PyMapping_HasKeyString' );
		PyMapping_Length := assign_proc( 'PyMapping_Length' );
		PyMapping_SetItemString := assign_proc( 'PyMapping_SetItemString' );
		PyMethod_Class := assign_proc( 'PyMethod_Class' );
		PyMethod_Function := assign_proc( 'PyMethod_Function' );
		PyMethod_New := assign_proc( 'PyMethod_New' );
		PyMethod_Self := assign_proc( 'PyMethod_Self' );
		PyModule_GetName := assign_proc( 'PyModule_GetName' );
		PyModule_New := assign_proc( 'PyModule_New' );
		PyNumber_Absolute := assign_proc( 'PyNumber_Absolute' );
		PyNumber_Add := assign_proc( 'PyNumber_Add' );
		PyNumber_And := assign_proc( 'PyNumber_And' );
		PyNumber_Check := assign_proc( 'PyNumber_Check' );
		PyNumber_Coerce := assign_proc( 'PyNumber_Coerce' );
		PyNumber_Divide := assign_proc( 'PyNumber_Divide' );
		PyNumber_FloorDivide := assign_proc( 'PyNumber_FloorDivide' );
		PyNumber_TrueDivide := assign_proc( 'PyNumber_TrueDivide' );
		PyNumber_Divmod := assign_proc( 'PyNumber_Divmod' );
		PyNumber_Float := assign_proc( 'PyNumber_Float' );
		PyNumber_Int := assign_proc( 'PyNumber_Int' );
		PyNumber_Invert := assign_proc( 'PyNumber_Invert' );
		PyNumber_Long := assign_proc( 'PyNumber_Long' );
		PyNumber_Lshift := assign_proc( 'PyNumber_Lshift' );
		PyNumber_Multiply := assign_proc( 'PyNumber_Multiply' );
		PyNumber_Negative := assign_proc( 'PyNumber_Negative' );
		PyNumber_Or := assign_proc( 'PyNumber_Or' );
		PyNumber_Positive := assign_proc( 'PyNumber_Positive' );
		PyNumber_Power := assign_proc( 'PyNumber_Power' );
		PyNumber_Remainder := assign_proc( 'PyNumber_Remainder' );
		PyNumber_Rshift := assign_proc( 'PyNumber_Rshift' );
		PyNumber_Subtract := assign_proc( 'PyNumber_Subtract' );
		PyNumber_Xor := assign_proc( 'PyNumber_Xor' );
		PyOS_InitInterrupts := assign_proc( 'PyOS_InitInterrupts' );
		PyOS_InterruptOccurred := assign_proc( 'PyOS_InterruptOccurred' );
		PyObject_CallObject := assign_proc( 'PyObject_CallObject' );
		PyObject_Compare := assign_proc( 'PyObject_Compare' );
		PyObject_GetAttr := assign_proc( 'PyObject_GetAttr' );
		PyObject_GetAttrString := assign_proc( 'PyObject_GetAttrString' );
		PyObject_GetItem := assign_proc( 'PyObject_GetItem' );
		PyObject_DelItem := assign_proc( 'PyObject_DelItem' );
		PyObject_HasAttrString := assign_proc( 'PyObject_HasAttrString' );
		PyObject_Hash := assign_proc( 'PyObject_Hash' );
		PyObject_IsTrue := assign_proc( 'PyObject_IsTrue' );
		PyObject_Length := assign_proc( 'PyObject_Length' );
		PyObject_Repr := assign_proc( 'PyObject_Repr' );
		PyObject_SetAttr := assign_proc( 'PyObject_SetAttr' );
		PyObject_SetAttrString := assign_proc( 'PyObject_SetAttrString' );
		PyObject_SetItem := assign_proc( 'PyObject_SetItem' );
		PyObject_Init := assign_proc( 'PyObject_Init' );
		PyObject_InitVar := assign_proc( 'PyObject_InitVar' );
		PyObject_New := assign_proc( '_PyObject_New' );
		PyObject_NewVar := assign_proc( '_PyObject_NewVar' );
		PyObject_Free := assign_proc( 'PyObject_Free' );
		PyObject_GetIter := assign_proc( 'PyObject_GetIter' );
		PyIter_Next := assign_proc( 'PyIter_Next' );
		PyObject_IsInstance := assign_proc( 'PyObject_IsInstance' );
		PyObject_IsSubclass := assign_proc( 'PyObject_IsSubclass' );
		PyObject_Call := assign_proc( 'PyObject_Call' );
		PyObject_GenericGetAttr := assign_proc( 'PyObject_GenericGetAttr' );
		PyObject_GenericSetAttr := assign_proc( 'PyObject_GenericSetAttr' );
		PyObject_GC_Malloc := assign_proc( '_PyObject_GC_Malloc' );
		PyObject_GC_New := assign_proc( '_PyObject_GC_New' );
		PyObject_GC_NewVar := assign_proc( '_PyObject_GC_NewVar' );
		PyObject_GC_Resize := assign_proc( '_PyObject_GC_Resize' );
		PyObject_GC_Del := assign_proc( 'PyObject_GC_Del' );
		PyObject_GC_Track := assign_proc( 'PyObject_GC_Track' );
		PyObject_GC_UnTrack := assign_proc( 'PyObject_GC_UnTrack' );
		PyRange_New := assign_proc( 'PyRange_New' );
		PySequence_Check := assign_proc( 'PySequence_Check' );
		PySequence_Concat := assign_proc( 'PySequence_Concat' );
		PySequence_Count := assign_proc( 'PySequence_Count' );
		PySequence_GetItem := assign_proc( 'PySequence_GetItem' );
		PySequence_GetSlice := assign_proc( 'PySequence_GetSlice' );
		PySequence_In := assign_proc( 'PySequence_In' );
		PySequence_Index := assign_proc( 'PySequence_Index' );
		PySequence_Length := assign_proc( 'PySequence_Length' );
		PySequence_Repeat := assign_proc( 'PySequence_Repeat' );
		PySequence_SetItem := assign_proc( 'PySequence_SetItem' );
		PySequence_SetSlice := assign_proc( 'PySequence_SetSlice' );
		PySequence_DelSlice := assign_proc( 'PySequence_DelSlice' );
		PySequence_Tuple := assign_proc( 'PySequence_Tuple' );
		PySequence_Contains := assign_proc( 'PySequence_Contains' );		
		PySlice_GetIndices := assign_proc( 'PySlice_GetIndices' );
		PySlice_GetIndicesEx := assign_proc( 'PySlice_GetIndicesEx' );
		PySlice_New := assign_proc( 'PySlice_New' );
		PyString_Concat := assign_proc( 'PyString_Concat' );
		PyString_ConcatAndDel := assign_proc( 'PyString_ConcatAndDel' );
		PyString_Format := assign_proc( 'PyString_Format' );
		PyString_FromStringAndSize := assign_proc( 'PyString_FromStringAndSize' );
		PyString_Size := assign_proc( 'PyString_Size');
		PyString_DecodeEscape := assign_proc( 'PyString_DecodeEscape');
		PyString_Repr := assign_proc( 'PyString_Repr');
		PySys_GetObject := assign_proc( 'PySys_GetObject');
		//PySys_Init := assign_proc( 'PySys_Init');
		PySys_SetObject := assign_proc( 'PySys_SetObject' );
		PySys_SetPath := assign_proc( 'PySys_SetPath' );
  		//PyTraceBack_Fetch := assign_proc( 'PyTraceBack_Fetch' );
		PyTraceBack_Here := assign_proc( 'PyTraceBack_Here' );
		PyTraceBack_Print := assign_proc( 'PyTraceBack_Print' );
		//PyTraceBack_Store := assign_proc( 'PyTraceBack_Store' );
		PyTuple_GetItem := assign_proc( 'PyTuple_GetItem' );
		PyTuple_GetSlice := assign_proc( 'PyTuple_GetSlice' );
		PyTuple_New := assign_proc( 'PyTuple_New' );
		PyTuple_SetItem := assign_proc( 'PyTuple_SetItem' );
		PyTuple_Size := assign_proc( 'PyTuple_Size' );	
		PyType_IsSubtype := assign_proc( 'PyType_IsSubtype' );
		PyType_GenericAlloc := assign_proc( 'PyType_GenericAlloc' );
		PyType_GenericNew := assign_proc( 'PyType_GenericNew' );
		PyType_Ready := assign_proc( 'PyType_Ready' );
		PyUnicode_FromWideChar := assign_proc( Format('PyUnicode%s_FromWideChar',[UnicodeTypeSuffix]) );
		PyUnicode_AsWideChar := assign_proc( Format('PyUnicode%s_AsWideChar',[UnicodeTypeSuffix]) );
		PyUnicode_FromOrdinal := assign_proc( Format('PyUnicode%s_FromOrdinal',[UnicodeTypeSuffix]) );
		PyWeakref_GetObject := assign_proc( 'PyWeakref_GetObject' );
		PyWeakref_NewProxy := assign_proc( 'PyWeakref_NewProxy' );
		PyWeakref_NewRef := assign_proc( 'PyWeakref_NewRef' );
		PyWrapper_New := assign_proc( 'PyWrapper_New' );
		PyBool_FromLong := assign_proc( 'PyBool_FromLong' );
		PyThreadState_SetAsyncExc := assign_proc( 'PyThreadState_SetAsyncExc' );
		Py_AtExit := assign_proc( 'Py_AtExit' );
		//Py_Cleanup := assign_proc( 'Py_Cleanup' );
		Py_CompileString := assign_proc( 'Py_CompileString' );
		Py_FatalError := assign_proc( 'Py_FatalError' );
		Py_FindMethod := assign_proc( 'Py_FindMethod' );
		Py_FindMethodInChain := assign_proc( 'Py_FindMethodInChain' );
		Py_FlushLine := assign_proc( 'Py_FlushLine' );
		_PyObject_New := assign_proc( '_PyObject_New' );
		_PyString_Resize := assign_proc( '_PyString_Resize' );
		Py_Finalize := assign_proc( 'Py_Finalize' );
		DLL_PyCode_Addr2Line := assign_proc( 'PyCode_Addr2Line' );
		DLL_PyImport_ExecCodeModule := assign_proc( 'PyImport_ExecCodeModule' );
		PyClass_IsSubclass := assign_proc( 'PyClass_IsSubclass' );
		PyErr_ExceptionMatches := assign_proc( 'PyErr_ExceptionMatches' );
		PyErr_GivenExceptionMatches := assign_proc( 'PyErr_GivenExceptionMatches' );
		PyEval_EvalCode := assign_proc( 'PyEval_EvalCode' );
		Py_GetVersion := assign_proc( 'Py_GetVersion' );
		Py_GetCopyright := assign_proc( 'Py_GetCopyright' );
		Py_GetExecPrefix := assign_proc( 'Py_GetExecPrefix' );
		Py_GetPath := assign_proc( 'Py_GetPath' );
		Py_GetPrefix := assign_proc( 'Py_GetPrefix' );
		Py_GetProgramName := assign_proc( 'Py_GetProgramName' );
		PyParser_SimpleParseString := assign_proc( 'PyParser_SimpleParseString' );
		PyNode_Free := assign_proc( 'PyNode_Free' );
		PyErr_NewException := assign_proc( 'PyErr_NewException' );
		Py_Malloc := assign_proc( 'PyMem_Malloc' );
		PyMem_Malloc := assign_proc( 'PyMem_Malloc' );
		Py_Malloc := assign_proc( 'Py_Malloc' );
		PyObject_CallMethod := assign_proc( 'PyObject_CallMethod' );
		Py_SetProgramName := assign_proc( 'Py_SetProgramName' );
		Py_IsInitialized := assign_proc( 'Py_IsInitialized' );
		Py_GetProgramFullPath := assign_proc( 'Py_GetProgramFullPath' );
		DLL_Py_GetBuildInfo := assign_proc( 'Py_GetBuildInfo' );
		Py_NewInterpreter := assign_proc( 'Py_NewInterpreter' );
		Py_EndInterpreter := assign_proc( 'Py_EndInterpreter' );
		PyEval_AcquireLock := assign_proc( 'PyEval_AcquireLock' );
		PyEval_ReleaseLock := assign_proc( 'PyEval_ReleaseLock' );
		PyEval_AcquireThread := assign_proc( 'PyEval_AcquireThread' );
		PyEval_ReleaseThread := assign_proc( 'PyEval_ReleaseThread' );
		PyInterpreterState_New := assign_proc( 'PyInterpreterState_New' );
		PyInterpreterState_Clear := assign_proc( 'PyInterpreterState_Clear' );
		PyInterpreterState_Delete := assign_proc( 'PyInterpreterState_Delete' );
		PyThreadState_New := assign_proc( 'PyThreadState_New' );
		PyThreadState_Clear := assign_proc( 'PyThreadState_Clear' );
		PyThreadState_Delete := assign_proc( 'PyThreadState_Delete' );
		PyThreadState_Get := assign_proc( 'PyThreadState_Get' );
		PyThreadState_Swap := assign_proc( 'PyThreadState_Swap' );
		PyErr_SetInterrupt := assign_proc( 'PyErr_SetInterrupt' );
	end;
	
	Result := libpython_status;
end;

procedure libpython_free;
begin
	if libpython_handle <> 0 then
		FreeLibrary( libpython_handle );
	libpython_handle := 0;
	libpython_status := LIBPYTHON_UNDEFINED;
end;

INITIALIZATION

begin
	libpython_load( PYTHON_VERSION );
end;

FINALIZATION

begin
	libpython_free;
end;

end.