Unit StrAdapterBase;

Interface

Type
  TStringAdapterMetaClass = Class Of TBaseStringAdapter;

  TBaseStringAdapter = Class
  Protected
    fUseEntities : Boolean;  // true: use entities (&quot;)
                             // false: use codes (&#34;)
  Public
    Constructor Create(Const AUseEntities : Boolean = true); Virtual;
    Destructor  Destroy; Override;

    Class Function EncodingID : String; Virtual; Abstract;

    Function    Decode(Const AString: String): String; Virtual; Abstract;
    Function    Encode(Const AString: String): String; Virtual; Abstract;
  End;

Implementation

{ TBaseStringAdapter }

Constructor TBaseStringAdapter.Create(const AUseEntities: Boolean);
Begin
  Inherited Create;

  fUseEntities := AUseEntities;
End;

Destructor TBaseStringAdapter.Destroy;
Begin

  Inherited Destroy;
End;


End.
