Unit StrAdapterDefault;

Interface

Uses
  StrAdapterBase;

    // Default Encoder: nix!
Type
  TDefaultAdapter = Class(TBaseStringAdapter)
  Public
    Class Function EncodingID : String; Override;

    Function    Decode(Const AString: String): String; Override;
    Function    Encode(Const AString: String): String; Override;
  End;

Implementation

Uses
  StrAdapter;

{ TDefaultAdapter }

Function TDefaultAdapter.Decode(Const AString: String): String;
Begin
  Result := AString;
End;

Function TDefaultAdapter.Encode(Const AString: String): String;
Begin
  Result := AString;
End;

Class Function TDefaultAdapter.EncodingID: String;
Begin
  Result := '';
End;

Initialization
  TStringAdapter.RegisterAdapter(TDefaultAdapter);

End.
