Unit StrAdapterISO8859_1;

Interface

Uses
  StrAdapterBase;

    // "ISO-8859-1"
Type
  TISO8859_1Adapter = Class(TBaseStringAdapter)
  Public
    Class Function EncodingID : String; Override;

    Function    Decode(Const AString: String): String; Override;
    Function    Encode(Const AString: String): String; Override;
  End;

Implementation

{ TISO8859_1Adapter }

Uses
  StrAdapter,
  SysUtils;

Type
  TCodingTableEntry = Record
    mChar    : Char;
    mEntity  : String;
    mCode    : String;
    mEncode  : Boolean;
  End;

Const
  AISO8859_1CodingTable : Array[0..101] Of TCodingTableEntry = (
    ( mChar: '"'; mEntity: '&quot;';    mCode: '&#34;';   mEncode: True  ), // quotation mark
    ( mChar: '&'; mEntity: '&amp;';     mCode: '&#38;';   mEncode: True  ), // ampersand
    ( mChar: '<'; mEntity: '&lt;';      mCode: '&#60;';   mEncode: True  ), // less-than sign
    ( mChar: '>'; mEntity: '&gt;';      mCode: '&#62;';   mEncode: True  ), // greater-than sign
    ( mChar: ' '; mEntity: '&nbsp;';    mCode: '&#160;';  mEncode: False ), // non-breaking space
    ( mChar: ''; mEntity: '&iexcl;';   mCode: '&#161;';  mEncode: True  ), // inverted exclamation
    ( mChar: ''; mEntity: '&cent;';    mCode: '&#162;';  mEncode: True  ), // cent sign
    ( mChar: ''; mEntity: '&pound;';   mCode: '&#163;';  mEncode: True  ), // pound sterling
    ( mChar: ''; mEntity: '&curren;';  mCode: '&#164;';  mEncode: True  ), // general currency sign
    ( mChar: ''; mEntity: '&yen;';     mCode: '&#165;';  mEncode: True  ), // yen sign
    ( mChar: ''; mEntity: '&brvbar;';  mCode: '&#166;';  mEncode: True  ), // broken vertical bar
    ( mChar: ''; mEntity: '&sect;';    mCode: '&#167;';  mEncode: True  ), // section sign
    ( mChar: ''; mEntity: '&uml;';     mCode: '&#168;';  mEncode: True  ), // umlaut (dieresis)
    ( mChar: ''; mEntity: '&copy;';    mCode: '&#169;';  mEncode: True  ), // copyright
    ( mChar: ''; mEntity: '&ordf;';    mCode: '&#170;';  mEncode: True  ), // feminine ordinal
    ( mChar: ''; mEntity: '&laquo;';   mCode: '&#171;';  mEncode: True  ), // left angle quote, guillemotleft
    ( mChar: ''; mEntity: '&not;';     mCode: '&#172;';  mEncode: True  ), // not sign
    ( mChar: ''; mEntity: '&shy;';     mCode: '&#173;';  mEncode: True  ), // soft hyphen
    ( mChar: ''; mEntity: '&reg;';     mCode: '&#174;';  mEncode: True  ), // registered trademark
    ( mChar: ''; mEntity: '&macr;';    mCode: '&#175;';  mEncode: True  ), // macron accent
    ( mChar: ''; mEntity: '&hibar;';   mCode: '&#175;';  mEncode: True  ), // macron accent
    ( mChar: ''; mEntity: '&deg;';     mCode: '&#176;';  mEncode: True  ), // degree sign
    ( mChar: ''; mEntity: '&plusmn;';  mCode: '&#177;';  mEncode: True  ), // plus or minus
    ( mChar: ''; mEntity: '&sup2;';    mCode: '&#178;';  mEncode: True  ), // superscript two
    ( mChar: ''; mEntity: '&sup3;';    mCode: '&#179;';  mEncode: True  ), // superscript three
    ( mChar: ''; mEntity: '&acute;';   mCode: '&#180;';  mEncode: True  ), // acute accent
    ( mChar: ''; mEntity: '&micro;';   mCode: '&#181;';  mEncode: True  ), // micro sign
    ( mChar: ''; mEntity: '&para;';    mCode: '&#182;';  mEncode: True  ), // paragraph sign
    ( mChar: ''; mEntity: '&middot;';  mCode: '&#183;';  mEncode: True  ), // middle dot
    ( mChar: ''; mEntity: '&cedil;';   mCode: '&#184;';  mEncode: True  ), // cedilla
    ( mChar: ''; mEntity: '&sup1;';    mCode: '&#185;';  mEncode: True  ), // superscript one
    ( mChar: ''; mEntity: '&ordm;';    mCode: '&#186;';  mEncode: True  ), // masculine ordinal
    ( mChar: ''; mEntity: '&raquo;';   mCode: '&#187;';  mEncode: True  ), // right angle quote, guillemotright
    ( mChar: ''; mEntity: '&frac14;';  mCode: '&#188;';  mEncode: True  ), // fraction one-fourth
    ( mChar: ''; mEntity: '&frac12;';  mCode: '&#189;';  mEncode: True  ), // fraction one-half
    ( mChar: ''; mEntity: '&frac34;';  mCode: '&#190;';  mEncode: True  ), // fraction three-fourths
    ( mChar: ''; mEntity: '&iquest;';  mCode: '&#191;';  mEncode: True  ), // inverted question mark
    ( mChar: ''; mEntity: '&Agrave;';  mCode: '&#192;';  mEncode: True  ), // capital A, grave accent
    ( mChar: ''; mEntity: '&Aacute;';  mCode: '&#193;';  mEncode: True  ), // capital A, acute accent
    ( mChar: ''; mEntity: '&Acirc;';   mCode: '&#194;';  mEncode: True  ), // capital A, circumflex accent
    ( mChar: ''; mEntity: '&Atilde;';  mCode: '&#195;';  mEncode: True  ), // capital A, tilde
    ( mChar: ''; mEntity: '&Auml;';    mCode: '&#196;';  mEncode: False ), // capital A, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&Aring;';   mCode: '&#197;';  mEncode: True  ), // capital A, ring
    ( mChar: ''; mEntity: '&AElig;';   mCode: '&#198;';  mEncode: True  ), // capital AE diphthong (ligature)
    ( mChar: ''; mEntity: '&Ccedil;';  mCode: '&#199;';  mEncode: True  ), // capital C, cedilla
    ( mChar: ''; mEntity: '&Egrave;';  mCode: '&#200;';  mEncode: True  ), // capital E, grave accent
    ( mChar: ''; mEntity: '&Eacute;';  mCode: '&#201;';  mEncode: True  ), // capital E, acute accent
    ( mChar: ''; mEntity: '&Ecirc;';   mCode: '&#202;';  mEncode: True  ), // capital E, circumflex accent
    ( mChar: ''; mEntity: '&Euml;';    mCode: '&#203;';  mEncode: True  ), // capital E, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&Igrave;';  mCode: '&#204;';  mEncode: True  ), // capital I, grave accent
    ( mChar: ''; mEntity: '&Iacute;';  mCode: '&#205;';  mEncode: True  ), // capital I, acute accent
    ( mChar: ''; mEntity: '&Icirc;';   mCode: '&#206;';  mEncode: True  ), // capital I, circumflex accent
    ( mChar: ''; mEntity: '&Iuml;';    mCode: '&#207;';  mEncode: True  ), // capital I, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&ETH;';     mCode: '&#208;';  mEncode: True  ), // capital Eth, Icelandic
    ( mChar: ''; mEntity: '&Dstrok;';  mCode: '&#208;';  mEncode: True  ), // capital Eth, Icelandic
    ( mChar: ''; mEntity: '&Ntilde;';  mCode: '&#209;';  mEncode: True  ), // capital N, tilde
    ( mChar: ''; mEntity: '&Ograve;';  mCode: '&#210;';  mEncode: True  ), // capital O, grave accent
    ( mChar: ''; mEntity: '&Oacute;';  mCode: '&#211;';  mEncode: True  ), // capital O, acute accent
    ( mChar: ''; mEntity: '&Ocirc;';   mCode: '&#212;';  mEncode: True  ), // capital O, circumflex accent
    ( mChar: ''; mEntity: '&Otilde;';  mCode: '&#213;';  mEncode: True  ), // capital O, tilde
    ( mChar: ''; mEntity: '&Ouml;';    mCode: '&#214;';  mEncode: False ), // capital O, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&times;';   mCode: '&#215;';  mEncode: True  ), // multiply sign
    ( mChar: ''; mEntity: '&Oslash;';  mCode: '&#216;';  mEncode: True  ), // capital O, slash
    ( mChar: ''; mEntity: '&Ugrave;';  mCode: '&#217;';  mEncode: True  ), // capital U, grave accent
    ( mChar: ''; mEntity: '&Uacute;';  mCode: '&#218;';  mEncode: True  ), // capital U, acute accent
    ( mChar: ''; mEntity: '&Ucirc;';   mCode: '&#219;';  mEncode: True  ), // capital U, circumflex accent
    ( mChar: ''; mEntity: '&Uuml;';    mCode: '&#220;';  mEncode: False ), // capital U, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&Yacute;';  mCode: '&#221;';  mEncode: True  ), // capital Y, acute accent
    ( mChar: ''; mEntity: '&THORN;';   mCode: '&#222;';  mEncode: True  ), // capital THORN, Icelandic
    ( mChar: ''; mEntity: '&szlig;';   mCode: '&#223;';  mEncode: False ), // small sharp s, German (sz ligature)
    ( mChar: ''; mEntity: '&agrave;';  mCode: '&#224;';  mEncode: True  ), // small a, grave accent
    ( mChar: ''; mEntity: '&aacute;';  mCode: '&#225;';  mEncode: True  ), // small a, acute accent
    ( mChar: ''; mEntity: '&acirc;';   mCode: '&#226;';  mEncode: True  ), // small a, circumflex accent
    ( mChar: ''; mEntity: '&atilde;';  mCode: '&#227;';  mEncode: True  ), // small a, tilde
    ( mChar: ''; mEntity: '&auml;';    mCode: '&#228;';  mEncode: False ), // small a, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&aring;';   mCode: '&#229;';  mEncode: True  ), // small a, ring
    ( mChar: ''; mEntity: '&aelig;';   mCode: '&#230;';  mEncode: True  ), // small ae diphthong (ligature)
    ( mChar: ''; mEntity: '&ccedil;';  mCode: '&#231;';  mEncode: True  ), // small c, cedilla
    ( mChar: ''; mEntity: '&egrave;';  mCode: '&#232;';  mEncode: True  ), // small e, grave accent
    ( mChar: ''; mEntity: '&eacute;';  mCode: '&#233;';  mEncode: True  ), // small e, acute accent
    ( mChar: ''; mEntity: '&ecirc;';   mCode: '&#234;';  mEncode: True  ), // small e, circumflex accent
    ( mChar: ''; mEntity: '&euml;';    mCode: '&#235;';  mEncode: True  ), // small e, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&igrave;';  mCode: '&#236;';  mEncode: True  ), // small i, grave accent
    ( mChar: ''; mEntity: '&iacute;';  mCode: '&#237;';  mEncode: True  ), // small i, acute accent
    ( mChar: ''; mEntity: '&icirc;';   mCode: '&#238;';  mEncode: True  ), // small i, circumflex accent
    ( mChar: ''; mEntity: '&iuml;';    mCode: '&#239;';  mEncode: True  ), // small i, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&eth;';     mCode: '&#240;';  mEncode: True  ), // small eth, Icelandic
    ( mChar: ''; mEntity: '&ntilde;';  mCode: '&#241;';  mEncode: True  ), // small n, tilde
    ( mChar: ''; mEntity: '&ograve;';  mCode: '&#242;';  mEncode: True  ), // small o, grave accent
    ( mChar: ''; mEntity: '&oacute;';  mCode: '&#243;';  mEncode: True  ), // small o, acute accent
    ( mChar: ''; mEntity: '&ocirc;';   mCode: '&#244;';  mEncode: True  ), // small o, circumflex accent
    ( mChar: ''; mEntity: '&otilde;';  mCode: '&#245;';  mEncode: True  ), // small o, tilde
    ( mChar: ''; mEntity: '&ouml;';    mCode: '&#246;';  mEncode: False ), // small o, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&divide;';  mCode: '&#247;';  mEncode: True  ), // division sign
    ( mChar: ''; mEntity: '&oslash;';  mCode: '&#248;';  mEncode: True  ), // small o, slash
    ( mChar: ''; mEntity: '&ugrave;';  mCode: '&#249;';  mEncode: True  ), // small u, grave accent
    ( mChar: ''; mEntity: '&uacute;';  mCode: '&#250;';  mEncode: True  ), // small u, acute accent
    ( mChar: ''; mEntity: '&ucirc;';   mCode: '&#251;';  mEncode: True  ), // small u, circumflex accent
    ( mChar: ''; mEntity: '&uuml;';    mCode: '&#252;';  mEncode: False ), // small u, dieresis or umlaut mark
    ( mChar: ''; mEntity: '&yacute;';  mCode: '&#253;';  mEncode: True  ), // small y, acute accent
    ( mChar: ''; mEntity: '&thorn;';   mCode: '&#254;';  mEncode: True  ), // small thorn, Icelandic
    ( mChar: ''; mEntity: '&yuml;';    mCode: '&#255;';  mEncode: True  )  // small y, dieresis or umlaut mark
                                          );

Function TISO8859_1Adapter.Decode(const AString: String): String;
Var
  i : Integer;
Begin
  Result := AString;

  For i := Low(AISO8859_1CodingTable) To High(AISO8859_1CodingTable) Do
  Begin
    Result := StringReplace(Result, AISO8859_1CodingTable[i].mCode,   AISO8859_1CodingTable[i].mChar, [rfReplaceAll]);
    Result := StringReplace(Result, AISO8859_1CodingTable[i].mEntity, AISO8859_1CodingTable[i].mChar, [rfReplaceAll]);
  End;
End;

Function TISO8859_1Adapter.Encode(const AString: String): String;
Var
  i : Integer;
Begin
  Result := AString;
  If ( fUseEntities ) Then
  Begin
    For i := Low(AISO8859_1CodingTable) To High(AISO8859_1CodingTable) Do
      If ( AISO8859_1CodingTable[i].mEncode ) Then
        Result := StringReplace(Result, AISO8859_1CodingTable[i].mChar, AISO8859_1CodingTable[i].mEntity, [rfReplaceAll]);
  End
  Else
  Begin
    For i := Low(AISO8859_1CodingTable) To High(AISO8859_1CodingTable) Do
      If ( AISO8859_1CodingTable[i].mEncode ) Then
        Result := StringReplace(Result, AISO8859_1CodingTable[i].mChar, AISO8859_1CodingTable[i].mCode, [rfReplaceAll]);
  End;
End;

Class Function TISO8859_1Adapter.EncodingID: String;
Begin
  Result := 'ISO-8859-1';
End;

Initialization
  TStringAdapter.RegisterAdapter(TISO8859_1Adapter);

End.
