import palanthir
from bulletinboardmessage import OpenBBMessage
from bulletinboardconsts import *

class BBMessageSummary:
	def __init__( self, BB, serial, parentserial, poster, subject, time ):
		self.BB = BB
		self.serial = serial		
		self.parentserial = parentserial
		self.poster = poster
		self.subject = subject
		self.time = time
		self.sons = []
		
		self.extended = 0
		self.plus = BB.addbutton( 0, 0, PLUSID, PLUSID, 10000 + BB.cv[ "buttoncount" ]+1, 2, PLUSID, 1 )
		self.plus.cv[ "summary" ] = self
		self.minus = BB.addbutton( 0, 0, MINUSID, MINUSID, 10000 + BB.cv[ "buttoncount" ]+2, 2, MINUSID, 1 )
		self.minus.cv[ "summary" ] = self
		BB.cv[ "buttoncount" ] += 2
		self.pergament = BB.addimage( 0, 0, PERGAMENTID, 0, 2 )
		
		self.text = BB.addcroppedtext( 0, 0, 200, 20, poster + "   -   " + subject + "  [" + time + "]", 1, 1, 2, 1, 0 )
		
	def __del__( self ):
		palanthir.log( "del: " + self.subject )
		self.BB.deleteobject( self.plus )
		self.BB.deleteobject( self.minus )
		self.BB.deleteobject( self.pergament )
		
		self.BB.deleteobject( self.text )
	
	def delete( self ):
		palanthir.log( "del: " + self.subject )
		self.plus.cv[ "summery" ] = 0
		self.minus.cv[ "summary" ] = 0
		
		while len( self.sons ) > 0:
			son = self.sons[0]
			del self.sons[0]
			son.delete()
		
		del self.BB.cv[ "summaries" ][ self.BB.cv[ "summaries" ].index( self ) ]
		del self.BB.cv[ "VisibleSummariesList" ][ self.BB.cv[ "VisibleSummariesList" ].index( self ) ]
		self.BB.cv[ "VisibleSummariesCount" ] = len( self.BB.cv[ "VisibleSummariesList" ] )
		self.preparedraw( 0, 0 )
		return 0
	
	def update( self ):
		self.text.text = self.poster + "   -   " + self.subject + "  [" + self.time + "]"
		return 0
	
	def preparedraw( self, X, draw ):
		if not draw:
			self.plus.page = 2
			self.minus.page = 2
			self.pergament.page = 2
			
			self.text.page = 2
			
			for son in self.sons:
				son.preparedraw( 0, 0, 0 )						
			return 0
				
		draw = len( self.BB.cv[ "VisibleSummariesList" ] ) >= self.BB.cv[ "firstdrawnsummary" ]
		drawindex = len( self.BB.cv[ "VisibleSummariesList" ] ) - self.BB.cv[ "firstdrawnsummary" ]
		if drawindex >= 10:
			draw = 0
		
		Y = 160 + 18 * drawindex
		self.BB.cv[ "VisibleSummariesList" ] += [ self ]
		
		if not draw:
			self.plus.page = 2
			self.minus.page = 2
			self.pergament.page = 2
			
			self.text.page = 2
						
			if self.extended:		
				for son in self.sons:				
					son.preparedraw( X + 20, 1 )
			else:
				for son in self.sons:
					son.preparedraw( 0, 0 )
			return 0
		
		if self.extended:
			if len( self.sons ) > 0:
				self.minus.X = X
				self.minus.Y = Y
				self.minus.page = 0
			else:
				self.minus.page = 2
			self.plus.page = 2
			
			for son in self.sons:
				son.preparedraw( X + 20, 1 )
		else:
			if len( self.sons ) > 0:			
				self.plus.X = X
				self.plus.Y = Y
				self.plus.page = 0
			else:
				self.plus.page = 2
			self.minus.page = 2
			
			for son in self.sons:
				son.preparedraw( 0, 0 )
			
		self.pergament.X = X+18
		self.pergament.Y = Y
		self.pergament.page = 0
		
		self.text.X = X + 41
		self.text.Y = Y
		self.text.page = 0
		if 310 - X > 0:
			self.text.width = 310 - X
		else:
			self.text.page = 2				
		
		return 0

def onLoad():
	palanthir.registerpackethandler( 0x71, onPacket )
	return 0

def onPacket( Packet ):	
	if Packet.getbyte( 3 ) == 0:
		OpenBulletinBoard( Packet )
	elif Packet.getbyte( 3 ) == 1:
		GetMessageSummary( Packet )
	elif Packet.getbyte( 3 ) == 2:
		GetMessage( Packet )
	return 1
	
def onRemoveGump( Gump ):
	if Gump.cv.has_key( "name" ) and Gump.cv[ "name" ] == "bulletinboard":
		if palanthir.getcv().has_key( "bulletinboard" ):
			for key in palanthir.getcv()[ "bulletinboard" ].keys():
				if int( key ) == Gump.cv[ "serial" ]:
					BB = palanthir.getcv()[ "bulletinboard" ][ key ]
					
					while len( BB.cv[ "summaries" ] ) > 0:
						S = BB.cv[ "summaries" ][ 0 ]
						S.delete()
					
					del palanthir.getcv()[ "bulletinboard" ][ key ]
					return 0
	return 0
	
def onAddItemToCont( Container, Item ):
	if palanthir.getcv().has_key( "bulletinboard" ):
		for key in palanthir.getcv()[ "bulletinboard" ].keys():
			if int( key ) == Container.serial:
				SendMessageSummaryRequest( Container.serial, Item.serial )
				return 0
	return 0

def onRemoveItemFromCont( Container, Item ):
	if palanthir.getcv().has_key( "bulletinboard" ):
		for key in palanthir.getcv()[ "bulletinboard" ].keys():
			if int( key ) == Container.serial:
				BB = palanthir.getcv()[ "bulletinboard" ][ key ]
				
				for S in BB.cv[ "summaries" ]:
					if S.serial == Item.serial:
						S.delete()
	return 0
	
def OpenBulletinBoard( Packet ):
	serial = Packet.getlongword( 4 )
	title = Packet.getasciistring( 8, 22 )
	
	for i in range( 0, palanthir.getgumpcount() ):
		Gump = palanthir.getgump( i )
		if Gump and Gump.cv.has_key( "name" ) and Gump.cv[ "name" ] == "bulletinboard" and Gump.cv[ "serial" ] == serial:						
			BB.cv[ "title" ].text = title
			return 0

	BB = palanthir.newgump()
	BB.addimage( 0, 0, BACKGROUNDID, 0, 0 )
	BB.cv[ "scrollbar" ] = BB.addscrollbar( 357, 160, 0, 155, SIGNID, SIGNID, 1, 0 )
	BB.activepage = 1
	
	BB.cv[ "buttoncount" ] = 0
	BB.cv[ "name" ] = "bulletinboard"
	BB.cv[ "serial" ] = serial
	BB.cv[ "title" ] = BB.addcroppedtext( 160, 35, 160, 20, title, 0, 1, 0, 1, 0 )
	BB.cv[ "summaries" ] = []
	BB.cv[ "firstdrawnsummary" ] = 0
	
	if not palanthir.getcv().has_key( "bulletinboard" ):
		palanthir.getcv()[ "bulletinboard" ] = {}
	palanthir.getcv()[ "bulletinboard" ][ str( serial ) ] = BB
	
	BB.ondrawgump = onDraw
	BB.onbuttonclick = onButtonClick
	BB.onclickxy = onClickXY
	BB.ondblclickxy = onDblClickXY
	BB.onscrollbarchange = onScrollbarChange
	BB.show()

	BBItem = palanthir.world.getitem( serial )
	if BBItem:		
		for item in BBItem.content:
			SendMessageSummaryRequest( serial, item.serial )
			
	return 0

def GetMessageSummary( Packet ):
	boardserial = Packet.getlongword( 4 )
	serial = Packet.getlongword( 8 )
	parentserial = Packet.getlongword( 12 )
	posterlen = Packet.getbyte( 16 )
	poster = Packet.getasciistring( 17, posterlen )
	subjectlen = Packet.getbyte( 17 + posterlen )
	subject = Packet.getasciistring( 17 + posterlen + 1, subjectlen )
	timelen = Packet.getbyte( 17 + posterlen + 1 + subjectlen )
	time = Packet.getasciistring( 17 + posterlen + 1 + subjectlen + 1, timelen )	
	
	BB = 0
	if palanthir.getcv().has_key( "bulletinboard" ):
		for key in palanthir.getcv()[ "bulletinboard" ].keys():
			if int( key ) == boardserial:
				BB = palanthir.getcv()[ "bulletinboard" ][ key ]
				break			
				
	if not BB:
		return 0
		
	for S in BB.cv[ "summaries" ]:
		if S.serial == serial:
			if S.parentserial != parentserial:
				#delete from Old Parentsummary
				for OldParent in BB.cv[ "summaries" ]:
					if OldParent.serial == S.parentserial:
						for i in range( 0, len( OldParent.sons ) ):
							if OldParent.sons[i].serial == S.serial:
								del OldParent.sons[ i ]
								break
				
				S.parentserial = parentserial
				
				#add to New Parentsummary
				for NewParent in BB.cv[ "summaries" ]:
					if NewParent.serial == S.parentserial:
						NewParent.sons += [S]
			
			S.poster = poster
			S.subject = subject
			S.time = time
			S.update()
			return 0
	
	Summary = BBMessageSummary( BB, serial, parentserial, poster, subject, time )
	
	BB.cv[ "summaries" ] += [Summary]
	if parentserial != 0:
		for S in BB.cv[ "summaries" ]:
			if S.serial == parentserial:
				S.sons += [Summary]
				break
	
	return 0
	
def GetMessage( Packet ):
	boardserial = Packet.getlongword( 4 )
	messageserial = Packet.getlongword( 8 )
	posterlen = Packet.getbyte( 12 )
	poster = Packet.getasciistring( 13, posterlen )
	subjectlen = Packet.getbyte( 13 + posterlen )
	subject = Packet.getasciistring( 13 + posterlen + 1, subjectlen )
	timelen = Packet.getbyte( 13 + posterlen + 1 + subjectlen )
	time = Packet.getasciistring( 13 + posterlen + 1 + subjectlen + 1, timelen )
	
	pos = 13 + posterlen + 1 + subjectlen + 1 + timelen
	
	#body, bodycolor and equipment
	body = Packet.getword( pos )
	pos += 2
	color = Packet.getword( pos )
	pos += 2
	
	equipmentcount = Packet.getbyte( pos )
	pos += 1
	for i in range( 0, equipmentcount ):
		itemid = Packet.getword( pos )
		pos += 2
		itemcolor = Packet.getword( pos )
		pos += 2
	
	linecount = Packet.getbyte( pos )
	pos += 1
	lines = []
	
	for i in range( 0, linecount ):
		linelen = Packet.getbyte( pos )
		line = Packet.getasciistring( pos+1, linelen )
		pos += 1 + linelen
		lines += [line]
		
	OpenBBMessage( boardserial, messageserial, poster, subject, time, lines, 0 )
	
	return 0
	
def onDraw( Gump ):
	Gump.cv[ "VisibleSummariesList" ] = []	
	for Summary in Gump.cv[ "summaries" ]:
		if Summary.parentserial == 0:
			Summary.preparedraw( 110, 1 )
	
	Gump.cv[ "VisibleSummariesCount" ] = len( Gump.cv[ "VisibleSummariesList" ] )
	
	if Gump.cv[ "firstdrawnsummary" ] < 0:
		Gump.cv[ "firstdrawnsummary" ] = 0
	
	if Gump.cv[ "firstdrawnsummary" ] >= Gump.cv[ "VisibleSummariesCount" ]:
		Gump.cv[ "firstdrawnsummary" ] = Gump.cv[ "VisibleSummariesCount" ]-1
	
	return 0
	
def onButtonClick( Gump, ReturnNumber ):
	if ReturnNumber > 10000:		
		Button = Gump.getbutton( ReturnNumber )		
		if Button:
			Button.cv[ "summary" ].extended = ReturnNumber % 2
	
	return 0
	
def onClickXY( Gump, x, y ):
	if x >= 352 and y >= 138 and x <= 373 and y <= 158:
		if Gump.cv[ "firstdrawnsummary" ] > 0:		
			Gump.cv[ "firstdrawnsummary" ] -= 1
			Gump.cv[ "scrollbar" ].promille = min( max( 1000 * (Gump.cv[ "firstdrawnsummary" ] + Gump.cv[ "firstdrawnsummary" ] / 2) / max( Gump.cv[ "VisibleSummariesCount" ], 1 ), 0 ), 1000 )
	
	elif x >= 352 and y >= 313 and x <= 373 and y <= 333:
		if Gump.cv[ "firstdrawnsummary" ] < Gump.cv[ "VisibleSummariesCount" ]-1:
			Gump.cv[ "firstdrawnsummary" ] += 1
			Gump.cv[ "scrollbar" ].promille = min( max( 1000 * (Gump.cv[ "firstdrawnsummary" ] + Gump.cv[ "firstdrawnsummary" ] / 2) / max( Gump.cv[ "VisibleSummariesCount" ], 1 ), 0 ), 1000 )
			
	elif x >= 0 and y >= 155 and x <= 105 and y <= 255:
		OpenBBMessage( Gump.cv[ "serial" ], 0, palanthir.world.getplayer().name, "", "-/-", [], 1 )
		return 0
	return 0
	
def onDblClickXY( Gump, x, y ):
	if x >= 110 and y >= 160 and x <= 350 and y <= 322:
		index = Gump.cv[ "firstdrawnsummary" ] + (y - 160) / 18
		if index < len( Gump.cv[ "VisibleSummariesList" ] ):
			SendMessageRequest( Gump.cv[ "serial" ], Gump.cv[ "VisibleSummariesList" ][ index ].serial )
	return 0
	
def onScrollbarChange( Gump, Scrollbar ):
	Gump.cv[ "firstdrawnsummary" ] = (Gump.cv[ "VisibleSummariesCount" ]-1) * Scrollbar.promille / 1000
	return 0
	
def SendMessageRequest( BoardSerial, MessageSerial ):
	packet = palanthir.newpacket( 0x71, 12 )
	packet.setword( 1, 12 )
	packet.setbyte( 3, 3 )
	packet.setlongword( 4, BoardSerial )
	packet.setlongword( 8, MessageSerial )
	palanthir.sendpacket( packet )
	return 0
	
def SendMessageSummaryRequest( BoardSerial, MessageSerial ):
	packet = palanthir.newpacket( 0x71, 12 )
	packet.setword( 1, 12 )
	packet.setbyte( 3, 4 )
	packet.setlongword( 4, BoardSerial )
	packet.setlongword( 8, MessageSerial )
	palanthir.sendpacket( packet )
	return 0