import palanthir
from bulletinboardconsts import *

def OpenBBMessage( BoardSerial, MessageSerial, Poster, Subject, Time, Lines, Post ):
	Gump = palanthir.newgump()
	Gump.x = 20
	Gump.y = 20
	
	Gump.cv[ "BoardSerial" ] = BoardSerial
	Gump.cv[ "MessageSerial" ] = MessageSerial
	Gump.cv[ "Post" ] = Post
		
	height = 200
	
	Gump.cv[ "RoleUp" ] = Gump.addimage( 0, 23, MESSAGEBACKUPPERID, 0, 0 );
        Gump.cv[ "RoleDown" ] = Gump.addimage( 17, 60+height, MESSAGEBACKLOWERID, 0, 0 );       
        Gump.cv[ "RoleLeft" ] = Gump.addimage( 30, 59, DECORATION, 0, 0 );        
        
        Gump.cv[ "ScrollButtonUp" ] = Gump.addimage( 250, 135, UPID, 0, 0 );
        Gump.cv[ "ScrollButtonDown" ] = Gump.addimage( 250, 60+height-17, DOWNID, 0, 0 );
        Gump.cv[ "DecorationDown" ] = Gump.addimage( 30, 59+height-16, DECORATION, 0, 0 );

        Gump.cv[ "MoveButton" ] = Gump.addbutton( 137, 60+height+32, MOVEBUTTON, MOVEBUTTONPRESSED, 1, 1 );
	Gump.cv[ "Height" ] = height
	Gump.cv[ "MiddleList" ] = []
		
	Gump.addtext( 30, 70, "Author: " + Poster, 1, 1, 0, 0 )
	Gump.addtext( 30, 90, "Time: " + Time, 1, 1, 0, 0 )
	Gump.addtext( 30, 110, "Subject:", 1, 1, 0, 0 )
	Subject = Gump.addinputfield( 80, 110, 200, 20, Subject, 1, 1, 1, 0 )
	Subject.border = 0
	Gump.cv[ "Subject" ] = Subject
	
	if Post:
		Text = Gump.addinputfield( 40, 150, 210, 90, chr(10).join( Lines ), 1, 2, 1, 0, 0, 0, 1 )
		Text.border = 0
	else:
		Text = Gump.addcroppedtext( 40, 150, 210, 90, chr(10).join( Lines ), 1, 1, 0, len( Lines ), 0 )
	
	Gump.cv[ "Text" ] = Text
	
	Gump.addtiledimage( 30, 140, 210, 4, DIVISORID, 0, 0 )
	Gump.cv[ "ScrollBar" ] = Gump.addscrollbar( 255, 152, 0, height-110, SIGNID, SIGNID, 1, 0 )
	
	if Post:
		PostButton = Gump.addbutton( 35, 60+height+13, POSTID, POSTID, 2, 0, POSTID, 1 )
	else:
		PostButton = Gump.addbutton( 35, 60+height+13, REPLYID, REPLYID, 2, 0, REPLYID, 1 )
	Gump.cv[ "PostButton" ] = PostButton
	
	if not Post:
		Gump.cv[ "RemoveButton" ] = Gump.addbutton( 220, 60+height+13, REMOVEID, REMOVEID, 3, 0, REMOVEID, 1 ) 
	
	FixMiddle( Gump )
	Gump.onmovegump = onMoveGump
	Gump.onscrollbarchange = onScrollBarChange
	Gump.oninputfieldchange = onInputFieldChange
	Gump.onbuttonclick = onButtonClick
	Gump.show()
	
	return 0
	
def FixMiddle( Gump ):
	for Object in Gump.cv[ "MiddleList" ]:
		Gump.deleteobject( Object )
		
	Gump.cv[ "MiddleList" ] = []
	
	height = Gump.cv[ "Height" ]
	
	Gump.cv[ "RoleDown" ].y = 60+height
	Gump.cv[ "ScrollButtonDown" ].y = 60+height-17
	Gump.cv[ "DecorationDown" ].y = 59+height-16
	Gump.cv[ "MoveButton" ].y = 60+height+32
	Gump.cv[ "PostButton" ].y = 60+height+13
	if Gump.cv.has_key( "RemoveButton" ):
		Gump.cv[ "RemoveButton" ].y = 60+height+13
	
	for i in range( 0, height / 60 ):	
		if i % 2 == 0:
			image = Gump.addimage( 17, 60+i*60, MESSAGEBACKMIDDLEID1, 0, 0 )
			image.sendback()
			Gump.cv[ "MiddleList" ] += [image]
		else:
			image = Gump.addimage( 17, 60+i*60, MESSAGEBACKMIDDLEID2, 0, 0 )
			image.sendback()
			Gump.cv[ "MiddleList" ] += [image]
			
	image = Gump.addtiledimage( 17, 60+60*(height / 60), 262, height % 60, MESSAGEBACKMIDDLEID2, 0, 0 )
	image.sendback()
	Gump.cv[ "MiddleList" ] += [image]
	
	Gump.cv[ "ScrollBar" ].height = height - 110
	Gump.cv[ "ScrollBar" ].promille = min( max( Gump.cv[ "ScrollBar" ].promille, 0 ), 1000 )
	
	Gump.cv[ "Text" ].height = height - 110
		
	return 0
	
def onMoveGump( Gump, GumpObject ):
	if GumpObject == Gump.cv[ "MoveButton" ]:		
		height = Gump.cv[ "Height" ]
		
		TmpHeight = height - ( palanthir.mouse().my - palanthir.mouse().y )
		palanthir.mouse().my = palanthir.mouse().y
		palanthir.mouse().mx = palanthir.mouse().x
		
		if TmpHeight > 150 and TmpHeight < 700:
			Gump.cv[ "Height" ] = TmpHeight
			FixMiddle( Gump )
		
		return 1
	return 0

def onScrollBarChange( Gump, GumpObject ):
	Text = Gump.cv[ "Text" ]
	Text.miny = int( max( 0, (Text.textureheight-Text.height)*GumpObject.promille/1000 ) )
	return 0
	
def onInputFieldChange( Gump, InputField ):
	if InputField.selectedpos > len( InputField.text ):
		Gump.cv[ "ScrollBar" ].promille = 1000
	
	Text = Gump.cv[ "Text" ]
	Text.miny = int( max( 0, (Text.textureheight-Text.height)*Gump.cv[ "ScrollBar" ].promille/1000 ) )
	return 0
	
def onButtonClick( Gump, ReturnNumber ):
	if ReturnNumber == 2:
		if Gump.cv[ "Post" ]:
			PostMessage( Gump.cv[ "BoardSerial" ], Gump.cv[ "MessageSerial" ], Gump.cv[ "Subject" ].text, Gump.cv[ "Text" ].textlines )
		else:
			OpenBBMessage( Gump.cv[ "BoardSerial" ], Gump.cv[ "MessageSerial" ], palanthir.world.getplayer().name, "Re:" + Gump.cv[ "Subject" ].text, "-/-", [], 1 )
		Gump.delete()
		return 1
	elif ReturnNumber == 3:
		RemoveMessage( Gump.cv[ "BoardSerial" ], Gump.cv[ "MessageSerial" ] )
		Gump.delete()
		return 1
	return 0
	
def PostMessage( BoardSerial, MessageSerial, Subject, Lines ):
	Length = 4 + 9 + len( Subject ) + 1 + 1
	for Line in Lines:
		Length += 1 + len( Line ) + 1
	
	Packet = palanthir.newpacket( 0x71, Length )
	Packet.setword( 1, Length )
	Packet.setbyte( 3, 0x5 )
	Packet.setlongword( 4, BoardSerial )
	Packet.setlongword( 8, MessageSerial )
	Packet.setbyte( 12, len( Subject ) + 1 )
	Packet.setasciistring( 13, Subject, len( Subject )+1 )
	Pos = 13 + len( Subject ) + 1
	Packet.setbyte( Pos, len( Lines ) )
	Pos += 1
	
	for Line in Lines:
		Packet.setbyte( Pos, len( Line ) + 1 )
		Packet.setasciistring( Pos+1, Line, len( Line )+1 )
		Pos += 1 + len( Line ) + 1
		
	Packet.send()
	return 0
	
def RemoveMessage( BoardSerial, MessageSerial ):
	Packet = palanthir.newpacket( 0x71, 12 )
	Packet.setword( 1, 12 )
	Packet.setbyte( 3, 0x6 )
	Packet.setlongword( 4, BoardSerial )
	Packet.setlongword( 8, MessageSerial )
	Packet.send()
	return 0 