import palanthir

SUBMENUWIDTH = 130

def onClick( object ):
	if palanthir.getcv().has_key( "contextmenu" ):
		palanthir.getcv()[ "contextmenu" ].delete()
	
	if not (palanthir.config().getbool( "ContextMenuButtonNone" ) or (palanthir.config().getbool( "ContextMenuButtonCtrl" ) and palanthir.keyboard().ctrl) or (palanthir.config().getbool( "ContextMenuButtonAlt" ) and palanthir.keyboard().alt) or (palanthir.config().getbool( "ContextMenuButtonShift" ) and palanthir.keyboard().shift) ):
		return 0
	
	if object.isitem or object.ischar:
		Packet = palanthir.newpacket( 0xBF, 9 )
		Packet.setword( 1, 9 )
		Packet.setword( 3, 0x13 )
		Packet.setlongword( 5, object.serial )
		Packet.send()
	return 0

def onMove( Direction ):
	if palanthir.getcv().has_key( "contextmenu" ):
		palanthir.getcv()[ "contextmenu" ].delete()
	return 0

def onLoad():
	palanthir.registerpackethandler( 0xBF, onPacket )
	return 0

def onPacket( Packet ):
	if Packet.getword( 3 ) == 0x14:
		Gump = palanthir.newgump( palanthir.mouse().x, palanthir.mouse().y )
		Gump.cv[ "Serial" ] = Packet.getlongword( 7 )
		Gump.onmovegump = onMoveGump
		Gump.ondelete = onDelete
		Gump.ondrawgump = onDraw
		Gump.onbuttonclick = onButtonClick
		Gump.activepage = 7
		
		palanthir.getcv()[ "contextmenu" ] = Gump
		
		EntryCount = Packet.getbyte( 11 )
		BackGround = Gump.addresizegump( 0, 0, 200, 0, 0xA3C, 0, 0 )
		CheckerTrans = Gump.addcheckertrans( 5, 5, 190, 0, 0 )
		
		VisibleEntryCount = 0
		ButtonList = []
		SubBackGroundList = []
		SubCheckerTransList = []
		SubButtonList = []
		MaxWidth = 0
		Pos = 12
		for i in range( EntryCount ):
			Tag = Packet.getword( Pos )
			Pos += 2
			FileID = Packet.getword( Pos ) / 1000
			IntLocID = Packet.getword( Pos ) % 1000
			Pos += 2
			Flags = Packet.getword( Pos )
			Pos += 2
			
			if Flags & 0x20:
				Color = Packet.getword( Pos )
				Pos += 2
			else:
				Color = 0x481
			
			if Flags & 0x200:
				TextLen = Packet.getbyte( Pos )
				Pos += 1
				Text = Packet.getasciistring( Pos, TextLen )
				Pos += TextLen
			else:
				Text = palanthir.data.getintlocmessage( IntLocID, FileID )
			
			if Flags & 0x1:
				continue
			
			Button = Gump.addtextbutton( 10, 10+i*20, Tag, Text, 1, 0, 300, Color, Color, Color, 0, 0, 0, 0, 0x3CD, 0x3CD, 16, 0, 0, 0 )
			ButtonList += [Button]
			
			if Button.texturewidth > MaxWidth:
				MaxWidth = Button.texturewidth
			
			VisibleEntryCount += 1
			
			if Flags & 0x400:
				SubEntryCount = Packet.getbyte( Pos )
				Pos += 1			
				PX = 0
				for j in range( 0, SubEntryCount ):					
					if j % 10 == 0:
						if j > 0:
							SubBackGround.height = 20 + VisibleSubEntryCount*20
							SubCheckerTrans.height = 10 + VisibleSubEntryCount*20
							PX += SUBMENUWIDTH + 22
						VisibleSubEntryCount = 0						
						SubBackGround = Gump.addresizegump( PX, Button.y, SUBMENUWIDTH + 22, 0, 0xA3C, 0, Tag )
						SubBackGroundList += [SubBackGround]
						SubCheckerTrans = Gump.addcheckertrans( PX + 5, Button.y + 5, SUBMENUWIDTH + 12, 0, Tag )
						SubCheckerTransList += [SubCheckerTrans]
					SubTag = Packet.getword( Pos )
					Pos += 2
					SubFileID = Packet.getword( Pos ) / 1000
					SubIntLocID = Packet.getword( Pos ) % 1000
					Pos += 2
					SubFlags = Packet.getword( Pos )
					Pos += 2
					if SubFlags & 0x20:
						SubColor = Packet.getword( Pos )
						Pos += 2
					else:
						SubColor = 0x481
					if SubFlags & 0x200:
						TextLen = Packet.getbyte( Pos )
						Pos += 1
						SubText = Packet.getasciistring( Pos, TextLen )
						Pos += TextLen
					else:
						SubText = palanthir.data.getintlocmessage( SubIntLocID, SubFileID )
					if SubFlags & 0x1:
						continue
										
					SubButton = Gump.addtextbutton( PX + 10, Button.y + 10 + (j%10)*20, SubTag, SubText, 1, Tag, SUBMENUWIDTH, SubColor, SubColor, SubColor, 0, 0, 0, 0, 0x3CD, 0x3CD, 16, 0, 0, 0 )					
					SubButtonList += [SubButton]
					VisibleSubEntryCount += 1
				SubBackGround.height = 20 + VisibleSubEntryCount*20
				SubCheckerTrans.height = 10 + VisibleSubEntryCount*20
				
		for Button in ButtonList:
			Button.width = MaxWidth
		Gump.cv[ "buttonlist" ] = ButtonList
		
		BackGround.width = MaxWidth + 12 + 10
		CheckerTrans.width = MaxWidth + 2 + 10
		
		BackGround.height = 20 + VisibleEntryCount*20
		CheckerTrans.height = 10 + VisibleEntryCount*20
		
		for SubBackGround in SubBackGroundList:
			SubBackGround.x += MaxWidth + 22
		for SubCheckerTrans in SubCheckerTransList:
			SubCheckerTrans.x += MaxWidth + 22
		for SubButton in SubButtonList:
			SubButton.x += MaxWidth + 22
		
		Gump.show()
		
		if VisibleEntryCount == 0:
			Gump.delete()
		return 1		
	return 0

def onDraw( Gump ):
	for Button in Gump.cv[ "buttonlist" ]:
		if Button.mouseover:
			Gump.activepage = Button.returnnumber
			return 0
	return 0

def onMoveGump( Gump, GumpObject ):
	Gump.delete()
	return 1

def onDelete( Gump ):
	del palanthir.getcv()[ "contextmenu" ]
	return 0

def onButtonClick( Gump, ReturnNumber ):
	Packet = palanthir.newpacket( 0xBF, 11 )
	Packet.setword( 1, 11 )
	Packet.setword( 3, 0x15 )
	Packet.setlongword( 5, Gump.cv[ "Serial" ] )
	Packet.setword( 9, ReturnNumber )
	Packet.send()
	Gump.delete()
	return 0